
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalAncillaryServicesInformationDataGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="Quantity" minOccurs="0"/>
 *     &lt;xs:element type="xs:byte" name="SegmentNumber" minOccurs="0" maxOccurs="24"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="EquivalentPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="TTLPrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PortionOfTravelIndicator" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="OriginalBasePrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RefundIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CommisionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InterlineIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeApplicationIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerTypeCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BoardPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OffPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="TaxesIncluded" minOccurs="0"/>
 *     &lt;xs:element name="Taxes" minOccurs="0">
 *       &lt;!-- Reference to inner class Taxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="SoftMatchIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NoChargeNotAvailIndicator" minOccurs="0"/>
 *     &lt;xs:element name="TicketCouponNumberAssociation" minOccurs="0" maxOccurs="4">
 *       &lt;!-- Reference to inner class TicketCouponNumberAssociation -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="SimultaneousTicketIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FormOfRefund" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="FeeNotGuaranteedIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:short" name="FQTVTierLevel" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TourCodeSHC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravelDateEffective" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LatestTravelDatePermitted" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="PurchaseByDate" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="TotalOriginalBasePrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="TotalEquivalentPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="TotalTTLPrice" minOccurs="0"/>
 *     &lt;xs:element name="TotalTaxes" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalTaxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="TaxExemptIndicator" minOccurs="0"/>
 *     &lt;xs:element name="BagWeight" minOccurs="0">
 *       &lt;!-- Reference to inner class BagWeight -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class OptionalAncillaryServicesInformationDataGroup implements
    Serializable
{
    private BigInteger quantity;
    private List<Byte> segmentNumberList = new ArrayList<Byte>();
    private AncillaryPrice equivalentPrice;
    private AncillaryPrice TTLPrice;
    private String portionOfTravelIndicator;
    private AncillaryPrice originalBasePrice;
    private String refundIndicator;
    private String commisionIndicator;
    private String interlineIndicator;
    private String feeApplicationIndicator;
    private String passengerTypeCode;
    private String boardPoint;
    private String offPoint;
    private Boolean taxesIncluded;
    private Taxes taxes;
    private Boolean softMatchIndicator;
    private String noChargeNotAvailIndicator;
    private List<TicketCouponNumberAssociation> ticketCouponNumberAssociationList = new ArrayList<TicketCouponNumberAssociation>();
    private String simultaneousTicketIndicator;
    private String formOfRefund;
    private Boolean feeNotGuaranteedIndicator;
    private Short FQTVTierLevel;
    private String tourCodeSHC;
    private String travelDateEffective;
    private String latestTravelDatePermitted;
    private Date purchaseByDate;
    private AncillaryPrice totalOriginalBasePrice;
    private AncillaryPrice totalEquivalentPrice;
    private AncillaryPrice totalTTLPrice;
    private TotalTaxes totalTaxes;
    private String taxExemptIndicator;
    private BagWeight bagWeight;

    /** 
     * Get the 'Quantity' element value.
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' element value.
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the list of 'SegmentNumber' element items.
     * 
     * @return list
     */
    public List<Byte> getSegmentNumberList() {
        return segmentNumberList;
    }

    /** 
     * Set the list of 'SegmentNumber' element items.
     * 
     * @param list
     */
    public void setSegmentNumberList(List<Byte> list) {
        segmentNumberList = list;
    }

    /** 
     * Get the 'EquivalentPrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getEquivalentPrice() {
        return equivalentPrice;
    }

    /** 
     * Set the 'EquivalentPrice' element value.
     * 
     * @param equivalentPrice
     */
    public void setEquivalentPrice(AncillaryPrice equivalentPrice) {
        this.equivalentPrice = equivalentPrice;
    }

    /** 
     * Get the 'TTLPrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getTTLPrice() {
        return TTLPrice;
    }

    /** 
     * Set the 'TTLPrice' element value.
     * 
     * @param TTLPrice
     */
    public void setTTLPrice(AncillaryPrice TTLPrice) {
        this.TTLPrice = TTLPrice;
    }

    /** 
     * Get the 'PortionOfTravelIndicator' element value.
     * 
     * @return value
     */
    public String getPortionOfTravelIndicator() {
        return portionOfTravelIndicator;
    }

    /** 
     * Set the 'PortionOfTravelIndicator' element value.
     * 
     * @param portionOfTravelIndicator
     */
    public void setPortionOfTravelIndicator(String portionOfTravelIndicator) {
        this.portionOfTravelIndicator = portionOfTravelIndicator;
    }

    /** 
     * Get the 'OriginalBasePrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getOriginalBasePrice() {
        return originalBasePrice;
    }

    /** 
     * Set the 'OriginalBasePrice' element value.
     * 
     * @param originalBasePrice
     */
    public void setOriginalBasePrice(AncillaryPrice originalBasePrice) {
        this.originalBasePrice = originalBasePrice;
    }

    /** 
     * Get the 'RefundIndicator' element value.
     * 
     * @return value
     */
    public String getRefundIndicator() {
        return refundIndicator;
    }

    /** 
     * Set the 'RefundIndicator' element value.
     * 
     * @param refundIndicator
     */
    public void setRefundIndicator(String refundIndicator) {
        this.refundIndicator = refundIndicator;
    }

    /** 
     * Get the 'CommisionIndicator' element value.
     * 
     * @return value
     */
    public String getCommisionIndicator() {
        return commisionIndicator;
    }

    /** 
     * Set the 'CommisionIndicator' element value.
     * 
     * @param commisionIndicator
     */
    public void setCommisionIndicator(String commisionIndicator) {
        this.commisionIndicator = commisionIndicator;
    }

    /** 
     * Get the 'InterlineIndicator' element value.
     * 
     * @return value
     */
    public String getInterlineIndicator() {
        return interlineIndicator;
    }

    /** 
     * Set the 'InterlineIndicator' element value.
     * 
     * @param interlineIndicator
     */
    public void setInterlineIndicator(String interlineIndicator) {
        this.interlineIndicator = interlineIndicator;
    }

    /** 
     * Get the 'FeeApplicationIndicator' element value.
     * 
     * @return value
     */
    public String getFeeApplicationIndicator() {
        return feeApplicationIndicator;
    }

    /** 
     * Set the 'FeeApplicationIndicator' element value.
     * 
     * @param feeApplicationIndicator
     */
    public void setFeeApplicationIndicator(String feeApplicationIndicator) {
        this.feeApplicationIndicator = feeApplicationIndicator;
    }

    /** 
     * Get the 'PassengerTypeCode' element value.
     * 
     * @return value
     */
    public String getPassengerTypeCode() {
        return passengerTypeCode;
    }

    /** 
     * Set the 'PassengerTypeCode' element value.
     * 
     * @param passengerTypeCode
     */
    public void setPassengerTypeCode(String passengerTypeCode) {
        this.passengerTypeCode = passengerTypeCode;
    }

    /** 
     * Get the 'BoardPoint' element value.
     * 
     * @return value
     */
    public String getBoardPoint() {
        return boardPoint;
    }

    /** 
     * Set the 'BoardPoint' element value.
     * 
     * @param boardPoint
     */
    public void setBoardPoint(String boardPoint) {
        this.boardPoint = boardPoint;
    }

    /** 
     * Get the 'OffPoint' element value.
     * 
     * @return value
     */
    public String getOffPoint() {
        return offPoint;
    }

    /** 
     * Set the 'OffPoint' element value.
     * 
     * @param offPoint
     */
    public void setOffPoint(String offPoint) {
        this.offPoint = offPoint;
    }

    /** 
     * Get the 'TaxesIncluded' element value.
     * 
     * @return value
     */
    public Boolean getTaxesIncluded() {
        return taxesIncluded;
    }

    /** 
     * Set the 'TaxesIncluded' element value.
     * 
     * @param taxesIncluded
     */
    public void setTaxesIncluded(Boolean taxesIncluded) {
        this.taxesIncluded = taxesIncluded;
    }

    /** 
     * Get the 'Taxes' element value.
     * 
     * @return value
     */
    public Taxes getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value.
     * 
     * @param taxes
     */
    public void setTaxes(Taxes taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'SoftMatchIndicator' element value.
     * 
     * @return value
     */
    public Boolean getSoftMatchIndicator() {
        return softMatchIndicator;
    }

    /** 
     * Set the 'SoftMatchIndicator' element value.
     * 
     * @param softMatchIndicator
     */
    public void setSoftMatchIndicator(Boolean softMatchIndicator) {
        this.softMatchIndicator = softMatchIndicator;
    }

    /** 
     * Get the 'NoChargeNotAvailIndicator' element value.
     * 
     * @return value
     */
    public String getNoChargeNotAvailIndicator() {
        return noChargeNotAvailIndicator;
    }

    /** 
     * Set the 'NoChargeNotAvailIndicator' element value.
     * 
     * @param noChargeNotAvailIndicator
     */
    public void setNoChargeNotAvailIndicator(String noChargeNotAvailIndicator) {
        this.noChargeNotAvailIndicator = noChargeNotAvailIndicator;
    }

    /** 
     * Get the list of 'TicketCouponNumberAssociation' element items.
     * 
     * @return list
     */
    public List<TicketCouponNumberAssociation> getTicketCouponNumberAssociationList() {
        return ticketCouponNumberAssociationList;
    }

    /** 
     * Set the list of 'TicketCouponNumberAssociation' element items.
     * 
     * @param list
     */
    public void setTicketCouponNumberAssociationList(
            List<TicketCouponNumberAssociation> list) {
        ticketCouponNumberAssociationList = list;
    }

    /** 
     * Get the 'SimultaneousTicketIndicator' element value.
     * 
     * @return value
     */
    public String getSimultaneousTicketIndicator() {
        return simultaneousTicketIndicator;
    }

    /** 
     * Set the 'SimultaneousTicketIndicator' element value.
     * 
     * @param simultaneousTicketIndicator
     */
    public void setSimultaneousTicketIndicator(
            String simultaneousTicketIndicator) {
        this.simultaneousTicketIndicator = simultaneousTicketIndicator;
    }

    /** 
     * Get the 'FormOfRefund' element value.
     * 
     * @return value
     */
    public String getFormOfRefund() {
        return formOfRefund;
    }

    /** 
     * Set the 'FormOfRefund' element value.
     * 
     * @param formOfRefund
     */
    public void setFormOfRefund(String formOfRefund) {
        this.formOfRefund = formOfRefund;
    }

    /** 
     * Get the 'FeeNotGuaranteedIndicator' element value.
     * 
     * @return value
     */
    public Boolean getFeeNotGuaranteedIndicator() {
        return feeNotGuaranteedIndicator;
    }

    /** 
     * Set the 'FeeNotGuaranteedIndicator' element value.
     * 
     * @param feeNotGuaranteedIndicator
     */
    public void setFeeNotGuaranteedIndicator(Boolean feeNotGuaranteedIndicator) {
        this.feeNotGuaranteedIndicator = feeNotGuaranteedIndicator;
    }

    /** 
     * Get the 'FQTVTierLevel' element value.
     * 
     * @return value
     */
    public Short getFQTVTierLevel() {
        return FQTVTierLevel;
    }

    /** 
     * Set the 'FQTVTierLevel' element value.
     * 
     * @param FQTVTierLevel
     */
    public void setFQTVTierLevel(Short FQTVTierLevel) {
        this.FQTVTierLevel = FQTVTierLevel;
    }

    /** 
     * Get the 'TourCodeSHC' element value.
     * 
     * @return value
     */
    public String getTourCodeSHC() {
        return tourCodeSHC;
    }

    /** 
     * Set the 'TourCodeSHC' element value.
     * 
     * @param tourCodeSHC
     */
    public void setTourCodeSHC(String tourCodeSHC) {
        this.tourCodeSHC = tourCodeSHC;
    }

    /** 
     * Get the 'TravelDateEffective' element value.
     * 
     * @return value
     */
    public String getTravelDateEffective() {
        return travelDateEffective;
    }

    /** 
     * Set the 'TravelDateEffective' element value.
     * 
     * @param travelDateEffective
     */
    public void setTravelDateEffective(String travelDateEffective) {
        this.travelDateEffective = travelDateEffective;
    }

    /** 
     * Get the 'LatestTravelDatePermitted' element value.
     * 
     * @return value
     */
    public String getLatestTravelDatePermitted() {
        return latestTravelDatePermitted;
    }

    /** 
     * Set the 'LatestTravelDatePermitted' element value.
     * 
     * @param latestTravelDatePermitted
     */
    public void setLatestTravelDatePermitted(String latestTravelDatePermitted) {
        this.latestTravelDatePermitted = latestTravelDatePermitted;
    }

    /** 
     * Get the 'PurchaseByDate' element value.
     * 
     * @return value
     */
    public Date getPurchaseByDate() {
        return purchaseByDate;
    }

    /** 
     * Set the 'PurchaseByDate' element value.
     * 
     * @param purchaseByDate
     */
    public void setPurchaseByDate(Date purchaseByDate) {
        this.purchaseByDate = purchaseByDate;
    }

    /** 
     * Get the 'TotalOriginalBasePrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getTotalOriginalBasePrice() {
        return totalOriginalBasePrice;
    }

    /** 
     * Set the 'TotalOriginalBasePrice' element value.
     * 
     * @param totalOriginalBasePrice
     */
    public void setTotalOriginalBasePrice(AncillaryPrice totalOriginalBasePrice) {
        this.totalOriginalBasePrice = totalOriginalBasePrice;
    }

    /** 
     * Get the 'TotalEquivalentPrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getTotalEquivalentPrice() {
        return totalEquivalentPrice;
    }

    /** 
     * Set the 'TotalEquivalentPrice' element value.
     * 
     * @param totalEquivalentPrice
     */
    public void setTotalEquivalentPrice(AncillaryPrice totalEquivalentPrice) {
        this.totalEquivalentPrice = totalEquivalentPrice;
    }

    /** 
     * Get the 'TotalTTLPrice' element value.
     * 
     * @return value
     */
    public AncillaryPrice getTotalTTLPrice() {
        return totalTTLPrice;
    }

    /** 
     * Set the 'TotalTTLPrice' element value.
     * 
     * @param totalTTLPrice
     */
    public void setTotalTTLPrice(AncillaryPrice totalTTLPrice) {
        this.totalTTLPrice = totalTTLPrice;
    }

    /** 
     * Get the 'TotalTaxes' element value.
     * 
     * @return value
     */
    public TotalTaxes getTotalTaxes() {
        return totalTaxes;
    }

    /** 
     * Set the 'TotalTaxes' element value.
     * 
     * @param totalTaxes
     */
    public void setTotalTaxes(TotalTaxes totalTaxes) {
        this.totalTaxes = totalTaxes;
    }

    /** 
     * Get the 'TaxExemptIndicator' element value.
     * 
     * @return value
     */
    public String getTaxExemptIndicator() {
        return taxExemptIndicator;
    }

    /** 
     * Set the 'TaxExemptIndicator' element value.
     * 
     * @param taxExemptIndicator
     */
    public void setTaxExemptIndicator(String taxExemptIndicator) {
        this.taxExemptIndicator = taxExemptIndicator;
    }

    /** 
     * Get the 'BagWeight' element value.
     * 
     * @return value
     */
    public BagWeight getBagWeight() {
        return bagWeight;
    }

    /** 
     * Set the 'BagWeight' element value.
     * 
     * @param bagWeight
     */
    public void setBagWeight(BagWeight bagWeight) {
        this.bagWeight = bagWeight;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AncillaryTax" name="Tax" minOccurs="0" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Taxes implements Serializable
    {
        private List<AncillaryTax> taxList = new ArrayList<AncillaryTax>();

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<AncillaryTax> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<AncillaryTax> list) {
            taxList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketCouponNumberAssociation" minOccurs="0" maxOccurs="4">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:short" name="TicketCouponNumber" minOccurs="0" maxOccurs="16"/>
     *       &lt;xs:element type="xs:string" name="TicketReferenceNumber" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketCouponNumberAssociation implements Serializable
    {
        private List<Short> ticketCouponNumberList = new ArrayList<Short>();
        private String ticketReferenceNumber;
        private String ticketNumber;

        /** 
         * Get the list of 'TicketCouponNumber' element items.
         * 
         * @return list
         */
        public List<Short> getTicketCouponNumberList() {
            return ticketCouponNumberList;
        }

        /** 
         * Set the list of 'TicketCouponNumber' element items.
         * 
         * @param list
         */
        public void setTicketCouponNumberList(List<Short> list) {
            ticketCouponNumberList = list;
        }

        /** 
         * Get the 'TicketReferenceNumber' element value.
         * 
         * @return value
         */
        public String getTicketReferenceNumber() {
            return ticketReferenceNumber;
        }

        /** 
         * Set the 'TicketReferenceNumber' element value.
         * 
         * @param ticketReferenceNumber
         */
        public void setTicketReferenceNumber(String ticketReferenceNumber) {
            this.ticketReferenceNumber = ticketReferenceNumber;
        }

        /** 
         * Get the 'TicketNumber' element value.
         * 
         * @return value
         */
        public String getTicketNumber() {
            return ticketNumber;
        }

        /** 
         * Set the 'TicketNumber' element value.
         * 
         * @param ticketNumber
         */
        public void setTicketNumber(String ticketNumber) {
            this.ticketNumber = ticketNumber;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTaxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AncillaryTax" name="Tax" minOccurs="0" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalTaxes implements Serializable
    {
        private List<AncillaryTax> taxList = new ArrayList<AncillaryTax>();

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<AncillaryTax> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<AncillaryTax> list) {
            taxList = list;
        }
    }
    /** 
     * Used to hold the weight of the Bag for baggage ancillary types.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagWeight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:integer">
     *         &lt;xs:attribute type="xs:string" name="Unit"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagWeight implements Serializable
    {
        private BigInteger integer;
        private String unit;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigInteger getInteger() {
            return integer;
        }

        /** 
         * Set the extension value.
         * 
         * @param integer
         */
        public void setInteger(BigInteger integer) {
            this.integer = integer;
        }

        /** 
         * Get the 'Unit' attribute value.
         * 
         * @return value
         */
        public String getUnit() {
            return unit;
        }

        /** 
         * Set the 'Unit' attribute value.
         * 
         * @param unit
         */
        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
