
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardApproval">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="ManualApproval"/>
 *     &lt;xs:element type="xs:string" name="ResponseCode"/>
 *     &lt;xs:element type="xs:string" name="ApprovalCode"/>
 *     &lt;xs:element type="xs:dateTime" name="RequestTime"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpiryTime"/>
 *     &lt;xs:element type="xs:string" name="AirlineCode"/>
 *     &lt;xs:element type="ns:MoneyType" name="Amount"/>
 *     &lt;xs:element type="xs:string" name="Remarks" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SupplierTransID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PaymentRef" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSCMatched" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSCRemark" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExtendPayment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Acquirer" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" name="id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardApproval implements Serializable
{
    private boolean manualApproval;
    private String responseCode;
    private String approvalCode;
    private Date requestTime;
    private Date expiryTime;
    private String airlineCode;
    private MoneyType amount;
    private String remarks;
    private String supplierTransID;
    private String paymentRef;
    private String CSCMatched;
    private String CSCRemark;
    private String qualifier;
    private String extendPayment;
    private String acquirer;
    private Integer id;

    /** 
     * Get the 'ManualApproval' element value.
     * 
     * @return value
     */
    public boolean isManualApproval() {
        return manualApproval;
    }

    /** 
     * Set the 'ManualApproval' element value.
     * 
     * @param manualApproval
     */
    public void setManualApproval(boolean manualApproval) {
        this.manualApproval = manualApproval;
    }

    /** 
     * Get the 'ResponseCode' element value.
     * 
     * @return value
     */
    public String getResponseCode() {
        return responseCode;
    }

    /** 
     * Set the 'ResponseCode' element value.
     * 
     * @param responseCode
     */
    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    /** 
     * Get the 'ApprovalCode' element value.
     * 
     * @return value
     */
    public String getApprovalCode() {
        return approvalCode;
    }

    /** 
     * Set the 'ApprovalCode' element value.
     * 
     * @param approvalCode
     */
    public void setApprovalCode(String approvalCode) {
        this.approvalCode = approvalCode;
    }

    /** 
     * Get the 'RequestTime' element value. Approval request time
     * 
     * @return value
     */
    public Date getRequestTime() {
        return requestTime;
    }

    /** 
     * Set the 'RequestTime' element value. Approval request time
     * 
     * @param requestTime
     */
    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    /** 
     * Get the 'ExpiryTime' element value. Approval expiry time
     * 
     * @return value
     */
    public Date getExpiryTime() {
        return expiryTime;
    }

    /** 
     * Set the 'ExpiryTime' element value. Approval expiry time
     * 
     * @param expiryTime
     */
    public void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    /** 
     * Get the 'AirlineCode' element value.
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value.
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'Amount' element value.
     * 
     * @return value
     */
    public MoneyType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value.
     * 
     * @param amount
     */
    public void setAmount(MoneyType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public String getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'SupplierTransID' element value.
     * 
     * @return value
     */
    public String getSupplierTransID() {
        return supplierTransID;
    }

    /** 
     * Set the 'SupplierTransID' element value.
     * 
     * @param supplierTransID
     */
    public void setSupplierTransID(String supplierTransID) {
        this.supplierTransID = supplierTransID;
    }

    /** 
     * Get the 'PaymentRef' element value.
     * 
     * @return value
     */
    public String getPaymentRef() {
        return paymentRef;
    }

    /** 
     * Set the 'PaymentRef' element value.
     * 
     * @param paymentRef
     */
    public void setPaymentRef(String paymentRef) {
        this.paymentRef = paymentRef;
    }

    /** 
     * Get the 'CSCMatched' element value.
     * 
     * @return value
     */
    public String getCSCMatched() {
        return CSCMatched;
    }

    /** 
     * Set the 'CSCMatched' element value.
     * 
     * @param CSCMatched
     */
    public void setCSCMatched(String CSCMatched) {
        this.CSCMatched = CSCMatched;
    }

    /** 
     * Get the 'CSCRemark' element value.
     * 
     * @return value
     */
    public String getCSCRemark() {
        return CSCRemark;
    }

    /** 
     * Set the 'CSCRemark' element value.
     * 
     * @param CSCRemark
     */
    public void setCSCRemark(String CSCRemark) {
        this.CSCRemark = CSCRemark;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public String getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'ExtendPayment' element value. Number of months or installments.
     * 
     * @return value
     */
    public String getExtendPayment() {
        return extendPayment;
    }

    /** 
     * Set the 'ExtendPayment' element value. Number of months or installments.
     * 
     * @param extendPayment
     */
    public void setExtendPayment(String extendPayment) {
        this.extendPayment = extendPayment;
    }

    /** 
     * Get the 'Acquirer' element value. SabrePWS if Sabre Payment Web Services. User may enter any value for 3rd party acquirer.
     * 
     * @return value
     */
    public String getAcquirer() {
        return acquirer;
    }

    /** 
     * Set the 'Acquirer' element value. SabrePWS if Sabre Payment Web Services. User may enter any value for 3rd party acquirer.
     * 
     * @param acquirer
     */
    public void setAcquirer(String acquirer) {
        this.acquirer = acquirer;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public Integer getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }
}
