
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Credit card payment type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment.Credit">
 *   &lt;xs:attribute type="xs:string" name="vendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:string" name="expiryDate"/>
 *   &lt;xs:attribute type="xs:string" name="manualApprovalCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCredit implements Serializable
{
    private String vendorCode;
    private String number;
    private String expiryDate;
    private String manualApprovalCode;

    /** 
     * Get the 'vendorCode' attribute value. Credit Card vendor code
                      REF: DM0Z_B0_CVND
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'vendorCode' attribute value. Credit Card vendor code
                      REF: DM0Z_B0_CVND
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'number' attribute value. Credit Card number
                      REF: DM0Z_B0_CNBR
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. Credit Card number
                      REF: DM0Z_B0_CNBR
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'expiryDate' attribute value. Credit Card expiry date in MMYY format. E.g. 1217
                      REF: DM0Z_B0_CEXP
     * 
     * @return value
     */
    public String getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'expiryDate' attribute value. Credit Card expiry date in MMYY format. E.g. 1217
                      REF: DM0Z_B0_CEXP
     * 
     * @param expiryDate
     */
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'manualApprovalCode' attribute value. Manual approval code of credit card authorisation
                      REF: DM0Z_B0_AUTH
     * 
     * @return value
     */
    public String getManualApprovalCode() {
        return manualApprovalCode;
    }

    /** 
     * Set the 'manualApprovalCode' attribute value. Manual approval code of credit card authorisation
                      REF: DM0Z_B0_AUTH
     * 
     * @param manualApprovalCode
     */
    public void setManualApprovalCode(String manualApprovalCode) {
        this.manualApprovalCode = manualApprovalCode;
    }
}
