
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareDifference">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareDifference implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;

    /** 
     * Get the 'BaseFare' element value. Base Fare Difference
                          Ref: DM0Z_C0_BAMT		
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base Fare Difference
                          Ref: DM0Z_C0_BAMT		
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare Difference
                          Ref: DM0Z_C0_FAMT		
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare Difference
                          Ref: DM0Z_C0_FAMT		
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Total Tax Difference
                          Ref: DM0Z_C0_TTAX
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Total Tax Difference
                          Ref: DM0Z_C0_TTAX
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total Fare Difference
                          Ref: DM0Z_C0_TAMT
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total Fare Difference
                          Ref: DM0Z_C0_TAMT
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }
}
