
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.NewSellingFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsNewSellingFareInfo implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;

    /** 
     * Get the 'BaseFare' element value. Base fare per PQ type
                          Ref: DM0Z_84_BFAR		
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare per PQ type
                          Ref: DM0Z_84_BFAR		
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
                          Ref: DM0Z_84_EFAR
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
                          Ref: DM0Z_84_EFAR
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total per PQ type
                          Ref: DM0Z_84_TTAC		
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total per PQ type
                          Ref: DM0Z_84_TTAC		
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
                          Ref: DM0Z_84_TFAR			
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
                          Ref: DM0Z_84_TFAR			
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }
}
