
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.OptionalServiceInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ReasonForIssuanceSubCode"/>
 *     &lt;xs:element type="xs:string" name="GroupCode"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReasonForIssuanceCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="refundable"/>
 *   &lt;xs:attribute type="xs:boolean" name="exchangeable"/>
 *   &lt;xs:attribute type="xs:boolean" name="taxable"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsOptionalServiceInfo implements Serializable
{
    private String reasonForIssuanceSubCode;
    private String groupCode;
    private String description;
    private String reasonForIssuanceCode;
    private Boolean refundable;
    private Boolean exchangeable;
    private Boolean taxable;

    /** 
     * Get the 'ReasonForIssuanceSubCode' element value. Reason for issuance sub-code.
                          Ref: #DM0Z_38_RFISC
     * 
     * @return value
     */
    public String getReasonForIssuanceSubCode() {
        return reasonForIssuanceSubCode;
    }

    /** 
     * Set the 'ReasonForIssuanceSubCode' element value. Reason for issuance sub-code.
                          Ref: #DM0Z_38_RFISC
     * 
     * @param reasonForIssuanceSubCode
     */
    public void setReasonForIssuanceSubCode(String reasonForIssuanceSubCode) {
        this.reasonForIssuanceSubCode = reasonForIssuanceSubCode;
    }

    /** 
     * Get the 'GroupCode' element value. Reason for issuance group code.
                          Ref: #DM0Z_38_GROUP
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value. Reason for issuance group code.
                          Ref: #DM0Z_38_GROUP
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the 'Description' element value. Description of the purchased item or service.
                          Ref: #DM0Z_38_NAME
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description of the purchased item or service.
                          Ref: #DM0Z_38_NAME
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'ReasonForIssuanceCode' element value. A primary single character code associated to the reason for issuance as defined
                          by IATA
                          Ref: #DM0Z_38_RFIC

                          Possible values can be:
                          A - Air Transportation
                          B _ Surface Transportation
                          C - Baggage
                          D - Financial Impact
                          E - Airport Services
                          F - Merchandise
                      
     * 
     * @return value
     */
    public String getReasonForIssuanceCode() {
        return reasonForIssuanceCode;
    }

    /** 
     * Set the 'ReasonForIssuanceCode' element value. A primary single character code associated to the reason for issuance as defined
                          by IATA
                          Ref: #DM0Z_38_RFIC

                          Possible values can be:
                          A - Air Transportation
                          B _ Surface Transportation
                          C - Baggage
                          D - Financial Impact
                          E - Airport Services
                          F - Merchandise
                      
     * 
     * @param reasonForIssuanceCode
     */
    public void setReasonForIssuanceCode(String reasonForIssuanceCode) {
        this.reasonForIssuanceCode = reasonForIssuanceCode;
    }

    /** 
     * Get the 'refundable' attribute value. Ref: #DM0Z_38_IAT1
     * 
     * @return value
     */
    public Boolean getRefundable() {
        return refundable;
    }

    /** 
     * Set the 'refundable' attribute value. Ref: #DM0Z_38_IAT1
     * 
     * @param refundable
     */
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }

    /** 
     * Get the 'exchangeable' attribute value. Ref: #DM0Z_38_IAT1
     * 
     * @return value
     */
    public Boolean getExchangeable() {
        return exchangeable;
    }

    /** 
     * Set the 'exchangeable' attribute value. Ref: #DM0Z_38_IAT1
     * 
     * @param exchangeable
     */
    public void setExchangeable(Boolean exchangeable) {
        this.exchangeable = exchangeable;
    }

    /** 
     * Get the 'taxable' attribute value. Ref: #DM0Z_38_TAX
     * 
     * @return value
     */
    public Boolean getTaxable() {
        return taxable;
    }

    /** 
     * Set the 'taxable' attribute value. Ref: #DM0Z_38_TAX
     * 
     * @param taxable
     */
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }
}
