
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Price Quote information stored in single PNR

 Ticketing System can get more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
 and attempt to seach for Price Quotes in more than one PNR will result in error
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteInfo">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Reservation" minOccurs="0">
 *         &lt;!-- Reference to inner class Reservation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Summary">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="NameAssociation" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class NameAssociation -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="NoNameAssociation" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class NoNameAssociation -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="SummaryByPassengerType" minOccurs="0">
 *               &lt;!-- Reference to inner class SummaryByPassengerType -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:choice>
 *         &lt;xs:element name="Details" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CustomDetails" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class CustomDetails -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="MiscellaneousData" minOccurs="0">
 *         &lt;!-- Reference to inner class MiscellaneousData -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PriceQuoteInfo implements Serializable
{
    private Reservation reservation;
    private List<NameAssociation> nameAssociationList = new ArrayList<NameAssociation>();
    private List<NoNameAssociation> noNameAssociationList = new ArrayList<NoNameAssociation>();
    private SummaryByPassengerType summaryByPassengerType;
    private int choiceSelect = -1;
    private static final int DETAIL_LIST_CHOICE = 0;
    private static final int CUSTOM_DETAIL_LIST_CHOICE = 1;
    private List<Details> detailList = new ArrayList<Details>();
    private List<CustomDetails> customDetailList = new ArrayList<CustomDetails>();
    private MiscellaneousData miscellaneousData;

    /** 
     * Get the 'Reservation' element value.
     * 
     * @return value
     */
    public Reservation getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value.
     * 
     * @param reservation
     */
    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the list of 'NameAssociation' element items.
     * 
     * @return list
     */
    public List<NameAssociation> getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the list of 'NameAssociation' element items.
     * 
     * @param list
     */
    public void setNameAssociationList(List<NameAssociation> list) {
        nameAssociationList = list;
    }

    /** 
     * Get the list of 'NoNameAssociation' element items.
     * 
     * @return list
     */
    public List<NoNameAssociation> getNoNameAssociationList() {
        return noNameAssociationList;
    }

    /** 
     * Set the list of 'NoNameAssociation' element items.
     * 
     * @param list
     */
    public void setNoNameAssociationList(List<NoNameAssociation> list) {
        noNameAssociationList = list;
    }

    /** 
     * Get the 'SummaryByPassengerType' element value.
     * 
     * @return value
     */
    public SummaryByPassengerType getSummaryByPassengerType() {
        return summaryByPassengerType;
    }

    /** 
     * Set the 'SummaryByPassengerType' element value.
     * 
     * @param summaryByPassengerType
     */
    public void setSummaryByPassengerType(
            SummaryByPassengerType summaryByPassengerType) {
        this.summaryByPassengerType = summaryByPassengerType;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDetailList() {
        return choiceSelect == DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Details' element items.
     * 
     * @return list
     */
    public List<Details> getDetailList() {
        return detailList;
    }

    /** 
     * Set the list of 'Details' element items.
     * 
     * @param list
     */
    public void setDetailList(List<Details> list) {
        setChoiceSelect(DETAIL_LIST_CHOICE);
        detailList = list;
    }

    /** 
     * Check if CustomDetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDetailList() {
        return choiceSelect == CUSTOM_DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CustomDetails' element items.
     * 
     * @return list
     */
    public List<CustomDetails> getCustomDetailList() {
        return customDetailList;
    }

    /** 
     * Set the list of 'CustomDetails' element items.
     * 
     * @param list
     */
    public void setCustomDetailList(List<CustomDetails> list) {
        setChoiceSelect(CUSTOM_DETAIL_LIST_CHOICE);
        customDetailList = list;
    }

    /** 
     * Get the 'MiscellaneousData' element value.
     * 
     * @return value
     */
    public MiscellaneousData getMiscellaneousData() {
        return miscellaneousData;
    }

    /** 
     * Set the 'MiscellaneousData' element value.
     * 
     * @param miscellaneousData
     */
    public void setMiscellaneousData(MiscellaneousData miscellaneousData) {
        this.miscellaneousData = miscellaneousData;
    }
    /** 
     * Includes the PNR number
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:dateTime" name="createDate"/>
     *         &lt;xs:attribute type="xs:string" use="required" name="updateToken"/>
     *         &lt;xs:attribute type="xs:integer" name="activePqCount"/>
     *         &lt;xs:attribute type="xs:integer" name="deletedOrHistoricalPqCount"/>
     *         &lt;xs:attribute type="xs:integer" name="activePqrCount"/>
     *         &lt;xs:attribute type="xs:integer" name="deletedOrHistoricalPqrCount"/>
     *         &lt;xs:attribute type="xs:integer" name="otherStatusPqCount"/>
     *         &lt;xs:attribute type="xs:integer" name="otherStatusPqrCount"/>
     *         &lt;xs:attribute type="xs:boolean" name="retainedReissueExists"/>
     *         &lt;xs:attribute type="xs:boolean" name="ticketedReissueExists"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Reservation implements Serializable
    {
        private String string;
        private Date createDate;
        private String updateToken;
        private BigInteger activePqCount;
        private BigInteger deletedOrHistoricalPqCount;
        private BigInteger activePqrCount;
        private BigInteger deletedOrHistoricalPqrCount;
        private BigInteger otherStatusPqCount;
        private BigInteger otherStatusPqrCount;
        private Boolean retainedReissueExists;
        private Boolean ticketedReissueExists;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'createDate' attribute value. The date when the reservation has been made
         * 
         * @return value
         */
        public Date getCreateDate() {
            return createDate;
        }

        /** 
         * Set the 'createDate' attribute value. The date when the reservation has been made
         * 
         * @param createDate
         */
        public void setCreateDate(Date createDate) {
            this.createDate = createDate;
        }

        /** 
         * Get the 'updateToken' attribute value. Update token indicator which is required value to be passed in any update operation
         * 
         * @return value
         */
        public String getUpdateToken() {
            return updateToken;
        }

        /** 
         * Set the 'updateToken' attribute value. Update token indicator which is required value to be passed in any update operation
         * 
         * @param updateToken
         */
        public void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        /** 
         * Get the 'activePqCount' attribute value. Total count of of active PQs
         * 
         * @return value
         */
        public BigInteger getActivePqCount() {
            return activePqCount;
        }

        /** 
         * Set the 'activePqCount' attribute value. Total count of of active PQs
         * 
         * @param activePqCount
         */
        public void setActivePqCount(BigInteger activePqCount) {
            this.activePqCount = activePqCount;
        }

        /** 
         * Get the 'deletedOrHistoricalPqCount' attribute value. Total Count of delete/historical PQs
         * 
         * @return value
         */
        public BigInteger getDeletedOrHistoricalPqCount() {
            return deletedOrHistoricalPqCount;
        }

        /** 
         * Set the 'deletedOrHistoricalPqCount' attribute value. Total Count of delete/historical PQs
         * 
         * @param deletedOrHistoricalPqCount
         */
        public void setDeletedOrHistoricalPqCount(
                BigInteger deletedOrHistoricalPqCount) {
            this.deletedOrHistoricalPqCount = deletedOrHistoricalPqCount;
        }

        /** 
         * Get the 'activePqrCount' attribute value. Total count of active PQRs
         * 
         * @return value
         */
        public BigInteger getActivePqrCount() {
            return activePqrCount;
        }

        /** 
         * Set the 'activePqrCount' attribute value. Total count of active PQRs
         * 
         * @param activePqrCount
         */
        public void setActivePqrCount(BigInteger activePqrCount) {
            this.activePqrCount = activePqrCount;
        }

        /** 
         * Get the 'deletedOrHistoricalPqrCount' attribute value. Total count of delete/historical PQRs
         * 
         * @return value
         */
        public BigInteger getDeletedOrHistoricalPqrCount() {
            return deletedOrHistoricalPqrCount;
        }

        /** 
         * Set the 'deletedOrHistoricalPqrCount' attribute value. Total count of delete/historical PQRs
         * 
         * @param deletedOrHistoricalPqrCount
         */
        public void setDeletedOrHistoricalPqrCount(
                BigInteger deletedOrHistoricalPqrCount) {
            this.deletedOrHistoricalPqrCount = deletedOrHistoricalPqrCount;
        }

        /** 
         * Get the 'otherStatusPqCount' attribute value. Total count of other status PQs
         * 
         * @return value
         */
        public BigInteger getOtherStatusPqCount() {
            return otherStatusPqCount;
        }

        /** 
         * Set the 'otherStatusPqCount' attribute value. Total count of other status PQs
         * 
         * @param otherStatusPqCount
         */
        public void setOtherStatusPqCount(BigInteger otherStatusPqCount) {
            this.otherStatusPqCount = otherStatusPqCount;
        }

        /** 
         * Get the 'otherStatusPqrCount' attribute value. Total count of other status PQRs
         * 
         * @return value
         */
        public BigInteger getOtherStatusPqrCount() {
            return otherStatusPqrCount;
        }

        /** 
         * Set the 'otherStatusPqrCount' attribute value. Total count of other status PQRs
         * 
         * @param otherStatusPqrCount
         */
        public void setOtherStatusPqrCount(BigInteger otherStatusPqrCount) {
            this.otherStatusPqrCount = otherStatusPqrCount;
        }

        /** 
         * Get the 'retainedReissueExists' attribute value. If true, then price quote reissue record details exists.

                                                            Ref: SR06PQ_10_IN4,#SR06PQ_10_PQR_YES
         * 
         * @return value
         */
        public Boolean getRetainedReissueExists() {
            return retainedReissueExists;
        }

        /** 
         * Set the 'retainedReissueExists' attribute value. If true, then price quote reissue record details exists.

                                                            Ref: SR06PQ_10_IN4,#SR06PQ_10_PQR_YES
         * 
         * @param retainedReissueExists
         */
        public void setRetainedReissueExists(Boolean retainedReissueExists) {
            this.retainedReissueExists = retainedReissueExists;
        }

        /** 
         * Get the 'ticketedReissueExists' attribute value. If true, then price quote reissue record details used for ticket issuance exists.

                                                            Ref: SR06PQ_10_IN4,#SR06PQ_10_TPQR_YES
         * 
         * @return value
         */
        public Boolean getTicketedReissueExists() {
            return ticketedReissueExists;
        }

        /** 
         * Set the 'ticketedReissueExists' attribute value. If true, then price quote reissue record details used for ticket issuance exists.

                                                            Ref: SR06PQ_10_IN4,#SR06PQ_10_TPQR_YES
         * 
         * @param ticketedReissueExists
         */
        public void setTicketedReissueExists(Boolean ticketedReissueExists) {
            this.ticketedReissueExists = ticketedReissueExists;
        }
    }
    /** 
     * Defines association of a passenger to the Price Quote and the Price Quote items. This information is equivalent
                                                      to *PQS
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceQuote" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceQuote -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
     *     &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
     *     &lt;xs:attribute type="xs:string" name="firstName"/>
     *     &lt;xs:attribute type="xs:string" name="lastName"/>
     *     &lt;xs:attribute type="xs:string" name="manNumber"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NameAssociation implements Serializable
    {
        private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();
        private String nameNumber;
        private BigInteger nameId;
        private String firstName;
        private String lastName;
        private String manNumber;

        /** 
         * Get the list of 'PriceQuote' element items.
         * 
         * @return list
         */
        public List<PriceQuote> getPriceQuoteList() {
            return priceQuoteList;
        }

        /** 
         * Set the list of 'PriceQuote' element items.
         * 
         * @param list
         */
        public void setPriceQuoteList(List<PriceQuote> list) {
            priceQuoteList = list;
        }

        /** 
         * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
         * 
         * @return value
         */
        public String getNameNumber() {
            return nameNumber;
        }

        /** 
         * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
         * 
         * @param nameNumber
         */
        public void setNameNumber(String nameNumber) {
            this.nameNumber = nameNumber;
        }

        /** 
         * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
         * 
         * @return value
         */
        public BigInteger getNameId() {
            return nameId;
        }

        /** 
         * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
         * 
         * @param nameId
         */
        public void setNameId(BigInteger nameId) {
            this.nameId = nameId;
        }

        /** 
         * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
         * 
         * @return value
         */
        public String getFirstName() {
            return firstName;
        }

        /** 
         * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
         * 
         * @param firstName
         */
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        /** 
         * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
         * 
         * @return value
         */
        public String getLastName() {
            return lastName;
        }

        /** 
         * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
         * 
         * @param lastName
         */
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        /** 
         * Get the 'manNumber' attribute value. MAN Number
                                                                Ref: SR06_30_MAN
         * 
         * @return value
         */
        public String getManNumber() {
            return manNumber;
        }

        /** 
         * Set the 'manNumber' attribute value. MAN Number
                                                                Ref: SR06_30_MAN
         * 
         * @param manNumber
         */
        public void setManNumber(String manNumber) {
            this.manNumber = manNumber;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Indicators" minOccurs="0">
         *         &lt;!-- Reference to inner class Indicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passenger" minOccurs="0">
         *         &lt;!-- Reference to inner class Passenger -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Fee -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
         *       &lt;xs:element type="ns:Code.ValidatingCarrier" name="ValidatingCarrier" minOccurs="0"/>
         *       &lt;xs:element name="Amounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Amounts -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *       &lt;xs:element name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class MessageInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MiscellaneousData" minOccurs="0">
         *         &lt;!-- Reference to inner class MiscellaneousData -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
         *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
         *     &lt;xs:attribute type="xs:string" name="reissueType"/>
         *     &lt;xs:attribute type="xs:boolean" name="latestPQFlag"/>
         *     &lt;xs:attribute type="xs:boolean" name="viewershipRestricted"/>
         *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
         *     &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
         *     &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
         *     &lt;xs:attribute type="xs:string" name="pqOwner"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceQuote implements Serializable
        {
            private Indicators indicators;
            private Passenger passenger;
            private String itineraryType;
            private List<Fee> feeList = new ArrayList<Fee>();
            private List<String> ticketDesignatorList = new ArrayList<String>();
            private CodeValidatingCarrier validatingCarrier;
            private Amounts amounts;
            private Date localCreateDateTime;
            private List<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
            private MiscellaneousData miscellaneousData;
            private Type type;
            private BigInteger number;
            private String status;
            private String pricingType;
            private String pricingStatus;
            private String reissueType;
            private Boolean latestPQFlag;
            private Boolean viewershipRestricted;
            private Boolean lowCostCarrier;
            private Boolean incompletePQR;
            private Boolean createdByOrder;
            private String pqOwner;

            /** 
             * Get the 'Indicators' element value.
             * 
             * @return value
             */
            public Indicators getIndicators() {
                return indicators;
            }

            /** 
             * Set the 'Indicators' element value.
             * 
             * @param indicators
             */
            public void setIndicators(Indicators indicators) {
                this.indicators = indicators;
            }

            /** 
             * Get the 'Passenger' element value.
             * 
             * @return value
             */
            public Passenger getPassenger() {
                return passenger;
            }

            /** 
             * Set the 'Passenger' element value.
             * 
             * @param passenger
             */
            public void setPassenger(Passenger passenger) {
                this.passenger = passenger;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }

            /** 
             * Get the list of 'Fee' element items.
             * 
             * @return list
             */
            public List<Fee> getFeeList() {
                return feeList;
            }

            /** 
             * Set the list of 'Fee' element items.
             * 
             * @param list
             */
            public void setFeeList(List<Fee> list) {
                feeList = list;
            }

            /** 
             * Get the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @return list
             */
            public List<String> getTicketDesignatorList() {
                return ticketDesignatorList;
            }

            /** 
             * Set the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @param list
             */
            public void setTicketDesignatorList(List<String> list) {
                ticketDesignatorList = list;
            }

            /** 
             * Get the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @return value
             */
            public CodeValidatingCarrier getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(
                    CodeValidatingCarrier validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'Amounts' element value.
             * 
             * @return value
             */
            public Amounts getAmounts() {
                return amounts;
            }

            /** 
             * Set the 'Amounts' element value.
             * 
             * @param amounts
             */
            public void setAmounts(Amounts amounts) {
                this.amounts = amounts;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getLocalCreateDateTime() {
                return localCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param localCreateDateTime
             */
            public void setLocalCreateDateTime(Date localCreateDateTime) {
                this.localCreateDateTime = localCreateDateTime;
            }

            /** 
             * Get the list of 'MessageInfo' element items.
             * 
             * @return list
             */
            public List<MessageInfo> getMessageInfoList() {
                return messageInfoList;
            }

            /** 
             * Set the list of 'MessageInfo' element items.
             * 
             * @param list
             */
            public void setMessageInfoList(List<MessageInfo> list) {
                messageInfoList = list;
            }

            /** 
             * Get the 'MiscellaneousData' element value.
             * 
             * @return value
             */
            public MiscellaneousData getMiscellaneousData() {
                return miscellaneousData;
            }

            /** 
             * Set the 'MiscellaneousData' element value.
             * 
             * @param miscellaneousData
             */
            public void setMiscellaneousData(MiscellaneousData miscellaneousData) {
                this.miscellaneousData = miscellaneousData;
            }

            /** 
             * Get the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }

            /** 
             * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }

            /** 
             * Get the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @return value
             */
            public String getPricingType() {
                return pricingType;
            }

            /** 
             * Set the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @param pricingType
             */
            public void setPricingType(String pricingType) {
                this.pricingType = pricingType;
            }

            /** 
             * Get the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @return value
             */
            public String getPricingStatus() {
                return pricingStatus;
            }

            /** 
             * Set the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @param pricingStatus
             */
            public void setPricingStatus(String pricingStatus) {
                this.pricingStatus = pricingStatus;
            }

            /** 
             * Get the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @return value
             */
            public String getReissueType() {
                return reissueType;
            }

            /** 
             * Set the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @param reissueType
             */
            public void setReissueType(String reissueType) {
                this.reissueType = reissueType;
            }

            /** 
             * Get the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @return value
             */
            public Boolean getLatestPQFlag() {
                return latestPQFlag;
            }

            /** 
             * Set the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @param latestPQFlag
             */
            public void setLatestPQFlag(Boolean latestPQFlag) {
                this.latestPQFlag = latestPQFlag;
            }

            /** 
             * Get the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @return value
             */
            public Boolean getViewershipRestricted() {
                return viewershipRestricted;
            }

            /** 
             * Set the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @param viewershipRestricted
             */
            public void setViewershipRestricted(Boolean viewershipRestricted) {
                this.viewershipRestricted = viewershipRestricted;
            }

            /** 
             * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @return value
             */
            public Boolean getLowCostCarrier() {
                return lowCostCarrier;
            }

            /** 
             * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @param lowCostCarrier
             */
            public void setLowCostCarrier(Boolean lowCostCarrier) {
                this.lowCostCarrier = lowCostCarrier;
            }

            /** 
             * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                                              REF: #DM0Z_40_PQC 
             * 
             * @return value
             */
            public Boolean getIncompletePQR() {
                return incompletePQR;
            }

            /** 
             * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                                              REF: #DM0Z_40_PQC 
             * 
             * @param incompletePQR
             */
            public void setIncompletePQR(Boolean incompletePQR) {
                this.incompletePQR = incompletePQR;
            }

            /** 
             * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
             * 
             * @return value
             */
            public Boolean getCreatedByOrder() {
                return createdByOrder;
            }

            /** 
             * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
             * 
             * @param createdByOrder
             */
            public void setCreatedByOrder(Boolean createdByOrder) {
                this.createdByOrder = createdByOrder;
            }

            /** 
             * Get the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                                              Ref:  DM0Z_40_ROWN
             * 
             * @return value
             */
            public String getPqOwner() {
                return pqOwner;
            }

            /** 
             * Set the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                                              Ref:  DM0Z_40_ROWN
             * 
             * @param pqOwner
             */
            public void setPqOwner(String pqOwner) {
                this.pqOwner = pqOwner;
            }
            /** 
             * PQ indicators with boolen values; default to 'false'
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ViewershipCategory" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="segmentSelect"/>
             *     &lt;xs:attribute type="xs:boolean" name="ticketed"/>
             *     &lt;xs:attribute type="xs:boolean" name="override"/>
             *     &lt;xs:attribute type="xs:boolean" name="deleted"/>
             *     &lt;xs:attribute type="xs:boolean" name="itineraryChange"/>
             *     &lt;xs:attribute type="xs:boolean" name="isExpired"/>
             *     &lt;xs:attribute type="xs:boolean" name="exchange"/>
             *     &lt;xs:attribute type="xs:boolean" name="reissue"/>
             *     &lt;xs:attribute type="xs:string" name="reissueMethod"/>
             *     &lt;xs:attribute type="xs:boolean" name="married"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Indicators implements Serializable
            {
                private ManualPricing manualPricing;
                private List<String> viewershipCategoryList = new ArrayList<String>();
                private Boolean segmentSelect;
                private Boolean ticketed;
                private Boolean override;
                private Boolean deleted;
                private Boolean itineraryChange;
                private Boolean isExpired;
                private Boolean exchange;
                private Boolean reissue;
                private String reissueMethod;
                private Boolean married;

                /** 
                 * Get the 'ManualPricing' element value.
                 * 
                 * @return value
                 */
                public ManualPricing getManualPricing() {
                    return manualPricing;
                }

                /** 
                 * Set the 'ManualPricing' element value.
                 * 
                 * @param manualPricing
                 */
                public void setManualPricing(ManualPricing manualPricing) {
                    this.manualPricing = manualPricing;
                }

                /** 
                 * Get the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
                 * 
                 * @return list
                 */
                public List<String> getViewershipCategoryList() {
                    return viewershipCategoryList;
                }

                /** 
                 * Set the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
                 * 
                 * @param list
                 */
                public void setViewershipCategoryList(List<String> list) {
                    viewershipCategoryList = list;
                }

                /** 
                 * Get the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @return value
                 */
                public Boolean getSegmentSelect() {
                    return segmentSelect;
                }

                /** 
                 * Set the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @param segmentSelect
                 */
                public void setSegmentSelect(Boolean segmentSelect) {
                    this.segmentSelect = segmentSelect;
                }

                /** 
                 * Get the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @return value
                 */
                public Boolean getTicketed() {
                    return ticketed;
                }

                /** 
                 * Set the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @param ticketed
                 */
                public void setTicketed(Boolean ticketed) {
                    this.ticketed = ticketed;
                }

                /** 
                 * Get the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }

                /** 
                 * Get the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @return value
                 */
                public Boolean getDeleted() {
                    return deleted;
                }

                /** 
                 * Set the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @param deleted
                 */
                public void setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                }

                /** 
                 * Get the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @return value
                 */
                public Boolean getItineraryChange() {
                    return itineraryChange;
                }

                /** 
                 * Set the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @param itineraryChange
                 */
                public void setItineraryChange(Boolean itineraryChange) {
                    this.itineraryChange = itineraryChange;
                }

                /** 
                 * Get the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
                 * 
                 * @return value
                 */
                public Boolean getIsExpired() {
                    return isExpired;
                }

                /** 
                 * Set the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
                 * 
                 * @param isExpired
                 */
                public void setIsExpired(Boolean isExpired) {
                    this.isExpired = isExpired;
                }

                /** 
                 * Get the 'exchange' attribute value. Indicator to specify if exchange PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
                                                                                        
                 * 
                 * @return value
                 */
                public Boolean getExchange() {
                    return exchange;
                }

                /** 
                 * Set the 'exchange' attribute value. Indicator to specify if exchange PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
                                                                                        
                 * 
                 * @param exchange
                 */
                public void setExchange(Boolean exchange) {
                    this.exchange = exchange;
                }

                /** 
                 * Get the 'reissue' attribute value. Indicator to specify if reissue PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
                                                                                        
                 * 
                 * @return value
                 */
                public Boolean getReissue() {
                    return reissue;
                }

                /** 
                 * Set the 'reissue' attribute value. Indicator to specify if reissue PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
                                                                                        
                 * 
                 * @param reissue
                 */
                public void setReissue(Boolean reissue) {
                    this.reissue = reissue;
                }

                /** 
                 * Get the 'reissueMethod' attribute value. possible values -
                                                                                            - EXCH
                                                                                            - RFND
                                                                                            - AUTOREDIRECT
                                                                                            - AUTOEXCH
                                                                                            - AUTORFND
                 * 
                 * @return value
                 */
                public String getReissueMethod() {
                    return reissueMethod;
                }

                /** 
                 * Set the 'reissueMethod' attribute value. possible values -
                                                                                            - EXCH
                                                                                            - RFND
                                                                                            - AUTOREDIRECT
                                                                                            - AUTOEXCH
                                                                                            - AUTORFND
                 * 
                 * @param reissueMethod
                 */
                public void setReissueMethod(String reissueMethod) {
                    this.reissueMethod = reissueMethod;
                }

                /** 
                 * Get the 'married' attribute value. Indicates price quote has married segments.

                                                                                            Ref: DM0Z_40_FSCI
                                                                                            #DM0Z_40_MBRK
                 * 
                 * @return value
                 */
                public Boolean getMarried() {
                    return married;
                }

                /** 
                 * Set the 'married' attribute value. Indicates price quote has married segments.

                                                                                            Ref: DM0Z_40_FSCI
                                                                                            #DM0Z_40_MBRK
                 * 
                 * @param married
                 */
                public void setMarried(Boolean married) {
                    this.married = married;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="verifyFareCalculation"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private Boolean verifyFareCalculation;

                    /** 
                     * Get the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @return value
                     */
                    public Boolean getVerifyFareCalculation() {
                        return verifyFareCalculation;
                    }

                    /** 
                     * Set the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @param verifyFareCalculation
                     */
                    public void setVerifyFareCalculation(
                            Boolean verifyFareCalculation) {
                        this.verifyFareCalculation = verifyFareCalculation;
                    }
                }
            }
            /** 
             * Passenger data related to PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="requestedType"/>
             *     &lt;xs:attribute type="xs:string" name="pricedType"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCountAtPricing"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passenger implements Serializable
            {
                private String type;
                private String requestedType;
                private String pricedType;
                private Integer passengerTypeCount;
                private Integer passengerTypeCountAtPricing;

                /** 
                 * Get the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @return value
                 */
                public String getRequestedType() {
                    return requestedType;
                }

                /** 
                 * Set the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @param requestedType
                 */
                public void setRequestedType(String requestedType) {
                    this.requestedType = requestedType;
                }

                /** 
                 * Get the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @return value
                 */
                public String getPricedType() {
                    return pricedType;
                }

                /** 
                 * Set the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @param pricedType
                 */
                public void setPricedType(String pricedType) {
                    this.pricedType = pricedType;
                }

                /** 
                 * Get the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCount() {
                    return passengerTypeCount;
                }

                /** 
                 * Set the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @param passengerTypeCount
                 */
                public void setPassengerTypeCount(Integer passengerTypeCount) {
                    this.passengerTypeCount = passengerTypeCount;
                }

                /** 
                 * Get the 'passengerTypeCountAtPricing' attribute value. Total count of passengers type that are considered for pricing.

                                                                                            Ref: #DM0Z_40_PNBR
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCountAtPricing() {
                    return passengerTypeCountAtPricing;
                }

                /** 
                 * Set the 'passengerTypeCountAtPricing' attribute value. Total count of passengers type that are considered for pricing.

                                                                                            Ref: #DM0Z_40_PNBR
                 * 
                 * @param passengerTypeCountAtPricing
                 */
                public void setPassengerTypeCountAtPricing(
                        Integer passengerTypeCountAtPricing) {
                    this.passengerTypeCountAtPricing = passengerTypeCountAtPricing;
                }
            }
            /** 
             * Only 50 fee items can be stored per PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Waiver" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="BankIdentificationNumber" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String waiver;
                private String bankIdentificationNumber;
                private String type;
                private String code;
                private BigInteger itemId;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @return value
                 */
                public String getWaiver() {
                    return waiver;
                }

                /** 
                 * Set the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @param waiver
                 */
                public void setWaiver(String waiver) {
                    this.waiver = waiver;
                }

                /** 
                 * Get the 'BankIdentificationNumber' element value. Identifies the institution issues the payment card. applies only to F type ObFee 
                 * 
                 * @return value
                 */
                public String getBankIdentificationNumber() {
                    return bankIdentificationNumber;
                }

                /** 
                 * Set the 'BankIdentificationNumber' element value. Identifies the institution issues the payment card. applies only to F type ObFee 
                 * 
                 * @param bankIdentificationNumber
                 */
                public void setBankIdentificationNumber(
                        String bankIdentificationNumber) {
                    this.bankIdentificationNumber = bankIdentificationNumber;
                }

                /** 
                 * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @return value
                 */
                public BigInteger getItemId() {
                    return itemId;
                }

                /** 
                 * Set the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @param itemId
                 */
                public void setItemId(BigInteger itemId) {
                    this.itemId = itemId;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Total" minOccurs="0">
             *         &lt;!-- Reference to inner class Total -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ReissueDifference" minOccurs="0">
             *         &lt;!-- Reference to inner class ReissueDifference -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amounts implements Serializable
            {
                private Total total;
                private ReissueDifference reissueDifference;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public Total getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(Total total) {
                    this.total = total;
                }

                /** 
                 * Get the 'ReissueDifference' element value.
                 * 
                 * @return value
                 */
                public ReissueDifference getReissueDifference() {
                    return reissueDifference;
                }

                /** 
                 * Set the 'ReissueDifference' element value.
                 * 
                 * @param reissueDifference
                 */
                public void setReissueDifference(
                        ReissueDifference reissueDifference) {
                    this.reissueDifference = reissueDifference;
                }
                /** 
                 * Total fare inclusive taxes per PQ type
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Total implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Reissue  difference amount (for add collect, refund or even exchange)
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueDifference" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReissueDifference implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *         &lt;xs:attribute type="xs:string" name="subtype"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MessageInfo implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;
                private String subtype;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }

                /** 
                 * Get the 'subtype' attribute value. 
                                                                                                    Subtype for INFO messages

                                                                                                    Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                                    Possible values: Display, Private, NetRemit
                                                                                                
                 * 
                 * @return value
                 */
                public String getSubtype() {
                    return subtype;
                }

                /** 
                 * Set the 'subtype' attribute value. 
                                                                                                    Subtype for INFO messages

                                                                                                    Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                                    Possible values: Display, Private, NetRemit
                                                                                                
                 * 
                 * @param subtype
                 */
                public void setSubtype(String subtype) {
                    this.subtype = subtype;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscellaneousData" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:KeyValue.Value" name="Value" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiscellaneousData implements Serializable
            {
                private List<KeyValueValue> valueList = new ArrayList<KeyValueValue>();

                /** 
                 * Get the list of 'Value' element items. Data content :
                                                                                                Value in the key-value pair
                 * 
                 * @return list
                 */
                public List<KeyValueValue> getValueList() {
                    return valueList;
                }

                /** 
                 * Set the list of 'Value' element items. Data content :
                                                                                                Value in the key-value pair
                 * 
                 * @param list
                 */
                public void setValueList(List<KeyValueValue> list) {
                    valueList = list;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="PQ"/>
             *     &lt;xs:enumeration value="PQR"/>
             *     &lt;xs:enumeration value="PQRE"/>
             *     &lt;xs:enumeration value="PQRR"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                PQ, PQR, PQRE, PQRR
            }
        }
    }
    /** 
     * Defines Price Quotes that are not name associated in the summary (part of  equivalent *PQS)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoNameAssociation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceQuote" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceQuote -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NoNameAssociation implements Serializable
    {
        private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();

        /** 
         * Get the list of 'PriceQuote' element items.
         * 
         * @return list
         */
        public List<PriceQuote> getPriceQuoteList() {
            return priceQuoteList;
        }

        /** 
         * Set the list of 'PriceQuote' element items.
         * 
         * @param list
         */
        public void setPriceQuoteList(List<PriceQuote> list) {
            priceQuoteList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Indicators" minOccurs="0">
         *         &lt;!-- Reference to inner class Indicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passenger" minOccurs="0">
         *         &lt;!-- Reference to inner class Passenger -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Fee -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
         *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
         *         &lt;!-- Reference to inner class ValidatingCarrier -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Amounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Amounts -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *       &lt;xs:element name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class MessageInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MiscellaneousData" minOccurs="0">
         *         &lt;!-- Reference to inner class MiscellaneousData -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
         *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
         *     &lt;xs:attribute type="xs:string" name="reissueType"/>
         *     &lt;xs:attribute type="xs:boolean" name="latestPQFlag"/>
         *     &lt;xs:attribute type="xs:boolean" name="viewershipRestricted"/>
         *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
         *     &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
         *     &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
         *     &lt;xs:attribute type="xs:string" name="pqOwner"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceQuote implements Serializable
        {
            private Indicators indicators;
            private Passenger passenger;
            private String itineraryType;
            private List<Fee> feeList = new ArrayList<Fee>();
            private List<String> ticketDesignatorList = new ArrayList<String>();
            private ValidatingCarrier validatingCarrier;
            private Amounts amounts;
            private Date localCreateDateTime;
            private List<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
            private MiscellaneousData miscellaneousData;
            private Type type;
            private BigInteger number;
            private String status;
            private String pricingType;
            private String pricingStatus;
            private String reissueType;
            private Boolean latestPQFlag;
            private Boolean viewershipRestricted;
            private Boolean lowCostCarrier;
            private Boolean incompletePQR;
            private Boolean createdByOrder;
            private String pqOwner;

            /** 
             * Get the 'Indicators' element value.
             * 
             * @return value
             */
            public Indicators getIndicators() {
                return indicators;
            }

            /** 
             * Set the 'Indicators' element value.
             * 
             * @param indicators
             */
            public void setIndicators(Indicators indicators) {
                this.indicators = indicators;
            }

            /** 
             * Get the 'Passenger' element value.
             * 
             * @return value
             */
            public Passenger getPassenger() {
                return passenger;
            }

            /** 
             * Set the 'Passenger' element value.
             * 
             * @param passenger
             */
            public void setPassenger(Passenger passenger) {
                this.passenger = passenger;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }

            /** 
             * Get the list of 'Fee' element items.
             * 
             * @return list
             */
            public List<Fee> getFeeList() {
                return feeList;
            }

            /** 
             * Set the list of 'Fee' element items.
             * 
             * @param list
             */
            public void setFeeList(List<Fee> list) {
                feeList = list;
            }

            /** 
             * Get the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @return list
             */
            public List<String> getTicketDesignatorList() {
                return ticketDesignatorList;
            }

            /** 
             * Set the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @param list
             */
            public void setTicketDesignatorList(List<String> list) {
                ticketDesignatorList = list;
            }

            /** 
             * Get the 'ValidatingCarrier' element value.
             * 
             * @return value
             */
            public ValidatingCarrier getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value.
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'Amounts' element value.
             * 
             * @return value
             */
            public Amounts getAmounts() {
                return amounts;
            }

            /** 
             * Set the 'Amounts' element value.
             * 
             * @param amounts
             */
            public void setAmounts(Amounts amounts) {
                this.amounts = amounts;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getLocalCreateDateTime() {
                return localCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param localCreateDateTime
             */
            public void setLocalCreateDateTime(Date localCreateDateTime) {
                this.localCreateDateTime = localCreateDateTime;
            }

            /** 
             * Get the list of 'MessageInfo' element items.
             * 
             * @return list
             */
            public List<MessageInfo> getMessageInfoList() {
                return messageInfoList;
            }

            /** 
             * Set the list of 'MessageInfo' element items.
             * 
             * @param list
             */
            public void setMessageInfoList(List<MessageInfo> list) {
                messageInfoList = list;
            }

            /** 
             * Get the 'MiscellaneousData' element value.
             * 
             * @return value
             */
            public MiscellaneousData getMiscellaneousData() {
                return miscellaneousData;
            }

            /** 
             * Set the 'MiscellaneousData' element value.
             * 
             * @param miscellaneousData
             */
            public void setMiscellaneousData(MiscellaneousData miscellaneousData) {
                this.miscellaneousData = miscellaneousData;
            }

            /** 
             * Get the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }

            /** 
             * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }

            /** 
             * Get the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @return value
             */
            public String getPricingType() {
                return pricingType;
            }

            /** 
             * Set the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @param pricingType
             */
            public void setPricingType(String pricingType) {
                this.pricingType = pricingType;
            }

            /** 
             * Get the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @return value
             */
            public String getPricingStatus() {
                return pricingStatus;
            }

            /** 
             * Set the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @param pricingStatus
             */
            public void setPricingStatus(String pricingStatus) {
                this.pricingStatus = pricingStatus;
            }

            /** 
             * Get the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @return value
             */
            public String getReissueType() {
                return reissueType;
            }

            /** 
             * Set the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @param reissueType
             */
            public void setReissueType(String reissueType) {
                this.reissueType = reissueType;
            }

            /** 
             * Get the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @return value
             */
            public Boolean getLatestPQFlag() {
                return latestPQFlag;
            }

            /** 
             * Set the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @param latestPQFlag
             */
            public void setLatestPQFlag(Boolean latestPQFlag) {
                this.latestPQFlag = latestPQFlag;
            }

            /** 
             * Get the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @return value
             */
            public Boolean getViewershipRestricted() {
                return viewershipRestricted;
            }

            /** 
             * Set the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @param viewershipRestricted
             */
            public void setViewershipRestricted(Boolean viewershipRestricted) {
                this.viewershipRestricted = viewershipRestricted;
            }

            /** 
             * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @return value
             */
            public Boolean getLowCostCarrier() {
                return lowCostCarrier;
            }

            /** 
             * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @param lowCostCarrier
             */
            public void setLowCostCarrier(Boolean lowCostCarrier) {
                this.lowCostCarrier = lowCostCarrier;
            }

            /** 
             * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                                              REF: #DM0Z_40_PQC 
             * 
             * @return value
             */
            public Boolean getIncompletePQR() {
                return incompletePQR;
            }

            /** 
             * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                                              REF: #DM0Z_40_PQC 
             * 
             * @param incompletePQR
             */
            public void setIncompletePQR(Boolean incompletePQR) {
                this.incompletePQR = incompletePQR;
            }

            /** 
             * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
             * 
             * @return value
             */
            public Boolean getCreatedByOrder() {
                return createdByOrder;
            }

            /** 
             * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
             * 
             * @param createdByOrder
             */
            public void setCreatedByOrder(Boolean createdByOrder) {
                this.createdByOrder = createdByOrder;
            }

            /** 
             * Get the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                                              Ref:  DM0Z_40_ROWN
             * 
             * @return value
             */
            public String getPqOwner() {
                return pqOwner;
            }

            /** 
             * Set the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                                              Ref:  DM0Z_40_ROWN
             * 
             * @param pqOwner
             */
            public void setPqOwner(String pqOwner) {
                this.pqOwner = pqOwner;
            }
            /** 
             * PQ indicators with boolen values; default to 'false'
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ViewershipCategory" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="segmentSelect"/>
             *     &lt;xs:attribute type="xs:boolean" name="ticketed"/>
             *     &lt;xs:attribute type="xs:boolean" name="override"/>
             *     &lt;xs:attribute type="xs:boolean" name="deleted"/>
             *     &lt;xs:attribute type="xs:boolean" name="itineraryChange"/>
             *     &lt;xs:attribute type="xs:boolean" name="isExpired"/>
             *     &lt;xs:attribute type="xs:boolean" name="exchange"/>
             *     &lt;xs:attribute type="xs:boolean" name="reissue"/>
             *     &lt;xs:attribute type="xs:string" name="reissueMethod"/>
             *     &lt;xs:attribute type="xs:boolean" name="married"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Indicators implements Serializable
            {
                private ManualPricing manualPricing;
                private List<String> viewershipCategoryList = new ArrayList<String>();
                private Boolean segmentSelect;
                private Boolean ticketed;
                private Boolean override;
                private Boolean deleted;
                private Boolean itineraryChange;
                private Boolean isExpired;
                private Boolean exchange;
                private Boolean reissue;
                private String reissueMethod;
                private Boolean married;

                /** 
                 * Get the 'ManualPricing' element value.
                 * 
                 * @return value
                 */
                public ManualPricing getManualPricing() {
                    return manualPricing;
                }

                /** 
                 * Set the 'ManualPricing' element value.
                 * 
                 * @param manualPricing
                 */
                public void setManualPricing(ManualPricing manualPricing) {
                    this.manualPricing = manualPricing;
                }

                /** 
                 * Get the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
                 * 
                 * @return list
                 */
                public List<String> getViewershipCategoryList() {
                    return viewershipCategoryList;
                }

                /** 
                 * Set the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
                 * 
                 * @param list
                 */
                public void setViewershipCategoryList(List<String> list) {
                    viewershipCategoryList = list;
                }

                /** 
                 * Get the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @return value
                 */
                public Boolean getSegmentSelect() {
                    return segmentSelect;
                }

                /** 
                 * Set the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @param segmentSelect
                 */
                public void setSegmentSelect(Boolean segmentSelect) {
                    this.segmentSelect = segmentSelect;
                }

                /** 
                 * Get the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @return value
                 */
                public Boolean getTicketed() {
                    return ticketed;
                }

                /** 
                 * Set the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @param ticketed
                 */
                public void setTicketed(Boolean ticketed) {
                    this.ticketed = ticketed;
                }

                /** 
                 * Get the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }

                /** 
                 * Get the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @return value
                 */
                public Boolean getDeleted() {
                    return deleted;
                }

                /** 
                 * Set the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @param deleted
                 */
                public void setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                }

                /** 
                 * Get the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @return value
                 */
                public Boolean getItineraryChange() {
                    return itineraryChange;
                }

                /** 
                 * Set the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @param itineraryChange
                 */
                public void setItineraryChange(Boolean itineraryChange) {
                    this.itineraryChange = itineraryChange;
                }

                /** 
                 * Get the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
                 * 
                 * @return value
                 */
                public Boolean getIsExpired() {
                    return isExpired;
                }

                /** 
                 * Set the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
                 * 
                 * @param isExpired
                 */
                public void setIsExpired(Boolean isExpired) {
                    this.isExpired = isExpired;
                }

                /** 
                 * Get the 'exchange' attribute value. Indicator to specify if exchange PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
                                                                                        
                 * 
                 * @return value
                 */
                public Boolean getExchange() {
                    return exchange;
                }

                /** 
                 * Set the 'exchange' attribute value. Indicator to specify if exchange PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
                                                                                        
                 * 
                 * @param exchange
                 */
                public void setExchange(Boolean exchange) {
                    this.exchange = exchange;
                }

                /** 
                 * Get the 'reissue' attribute value. Indicator to specify if reissue PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
                                                                                        
                 * 
                 * @return value
                 */
                public Boolean getReissue() {
                    return reissue;
                }

                /** 
                 * Set the 'reissue' attribute value. Indicator to specify if reissue PQR
                                                                                            Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
                                                                                        
                 * 
                 * @param reissue
                 */
                public void setReissue(Boolean reissue) {
                    this.reissue = reissue;
                }

                /** 
                 * Get the 'reissueMethod' attribute value. possible values -
                                                                                            - EXCH
                                                                                            - RFND
                                                                                            - AUTOREDIRECT
                                                                                            - AUTOEXCH
                                                                                            - AUTORFND
                 * 
                 * @return value
                 */
                public String getReissueMethod() {
                    return reissueMethod;
                }

                /** 
                 * Set the 'reissueMethod' attribute value. possible values -
                                                                                            - EXCH
                                                                                            - RFND
                                                                                            - AUTOREDIRECT
                                                                                            - AUTOEXCH
                                                                                            - AUTORFND
                 * 
                 * @param reissueMethod
                 */
                public void setReissueMethod(String reissueMethod) {
                    this.reissueMethod = reissueMethod;
                }

                /** 
                 * Get the 'married' attribute value. Indicates price quote has married segments.

                                                                                            Ref: DM0Z_40_FSCI
                                                                                            #DM0Z_40_MBRK
                 * 
                 * @return value
                 */
                public Boolean getMarried() {
                    return married;
                }

                /** 
                 * Set the 'married' attribute value. Indicates price quote has married segments.

                                                                                            Ref: DM0Z_40_FSCI
                                                                                            #DM0Z_40_MBRK
                 * 
                 * @param married
                 */
                public void setMarried(Boolean married) {
                    this.married = married;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="verifyFareCalculation"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private Boolean verifyFareCalculation;

                    /** 
                     * Get the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @return value
                     */
                    public Boolean getVerifyFareCalculation() {
                        return verifyFareCalculation;
                    }

                    /** 
                     * Set the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @param verifyFareCalculation
                     */
                    public void setVerifyFareCalculation(
                            Boolean verifyFareCalculation) {
                        this.verifyFareCalculation = verifyFareCalculation;
                    }
                }
            }
            /** 
             * Passenger data related to PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="requestedType"/>
             *     &lt;xs:attribute type="xs:string" name="pricedType"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCountAtPricing"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passenger implements Serializable
            {
                private String type;
                private String requestedType;
                private String pricedType;
                private Integer passengerTypeCount;
                private Integer passengerTypeCountAtPricing;

                /** 
                 * Get the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @return value
                 */
                public String getRequestedType() {
                    return requestedType;
                }

                /** 
                 * Set the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @param requestedType
                 */
                public void setRequestedType(String requestedType) {
                    this.requestedType = requestedType;
                }

                /** 
                 * Get the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @return value
                 */
                public String getPricedType() {
                    return pricedType;
                }

                /** 
                 * Set the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @param pricedType
                 */
                public void setPricedType(String pricedType) {
                    this.pricedType = pricedType;
                }

                /** 
                 * Get the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCount() {
                    return passengerTypeCount;
                }

                /** 
                 * Set the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @param passengerTypeCount
                 */
                public void setPassengerTypeCount(Integer passengerTypeCount) {
                    this.passengerTypeCount = passengerTypeCount;
                }

                /** 
                 * Get the 'passengerTypeCountAtPricing' attribute value. Total count of passengers type that are considered for pricing.

                                                                                            Ref: #DM0Z_40_PNBR
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCountAtPricing() {
                    return passengerTypeCountAtPricing;
                }

                /** 
                 * Set the 'passengerTypeCountAtPricing' attribute value. Total count of passengers type that are considered for pricing.

                                                                                            Ref: #DM0Z_40_PNBR
                 * 
                 * @param passengerTypeCountAtPricing
                 */
                public void setPassengerTypeCountAtPricing(
                        Integer passengerTypeCountAtPricing) {
                    this.passengerTypeCountAtPricing = passengerTypeCountAtPricing;
                }
            }
            /** 
             * Only 50 fee items can be stored per PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Waiver" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="BankIdentificationNumber" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String waiver;
                private String bankIdentificationNumber;
                private String type;
                private String code;
                private BigInteger itemId;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @return value
                 */
                public String getWaiver() {
                    return waiver;
                }

                /** 
                 * Set the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @param waiver
                 */
                public void setWaiver(String waiver) {
                    this.waiver = waiver;
                }

                /** 
                 * Get the 'BankIdentificationNumber' element value. Identifies the institution issues the payment card. applies only to F type ObFee 
                 * 
                 * @return value
                 */
                public String getBankIdentificationNumber() {
                    return bankIdentificationNumber;
                }

                /** 
                 * Set the 'BankIdentificationNumber' element value. Identifies the institution issues the payment card. applies only to F type ObFee 
                 * 
                 * @param bankIdentificationNumber
                 */
                public void setBankIdentificationNumber(
                        String bankIdentificationNumber) {
                    this.bankIdentificationNumber = bankIdentificationNumber;
                }

                /** 
                 * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @return value
                 */
                public BigInteger getItemId() {
                    return itemId;
                }

                /** 
                 * Set the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @param itemId
                 */
                public void setItemId(BigInteger itemId) {
                    this.itemId = itemId;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:boolean" name="carrierAmended"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValidatingCarrier implements Serializable
            {
                private String string;
                private Boolean carrierAmended;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'carrierAmended' attribute value. Applicable only for GSA created/amended PQ for TN
                                                                                                    Ref: #DM0Z_E9_VCX_ACXR
                 * 
                 * @return value
                 */
                public Boolean getCarrierAmended() {
                    return carrierAmended;
                }

                /** 
                 * Set the 'carrierAmended' attribute value. Applicable only for GSA created/amended PQ for TN
                                                                                                    Ref: #DM0Z_E9_VCX_ACXR
                 * 
                 * @param carrierAmended
                 */
                public void setCarrierAmended(Boolean carrierAmended) {
                    this.carrierAmended = carrierAmended;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Total" minOccurs="0">
             *         &lt;!-- Reference to inner class Total -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ReissueDifference" minOccurs="0">
             *         &lt;!-- Reference to inner class ReissueDifference -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amounts implements Serializable
            {
                private Total total;
                private ReissueDifference reissueDifference;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public Total getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(Total total) {
                    this.total = total;
                }

                /** 
                 * Get the 'ReissueDifference' element value.
                 * 
                 * @return value
                 */
                public ReissueDifference getReissueDifference() {
                    return reissueDifference;
                }

                /** 
                 * Set the 'ReissueDifference' element value.
                 * 
                 * @param reissueDifference
                 */
                public void setReissueDifference(
                        ReissueDifference reissueDifference) {
                    this.reissueDifference = reissueDifference;
                }
                /** 
                 * Total fare inclusive taxes per PQ type
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Total implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Reissue  difference amount (for add collect, refund or even exchange)
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueDifference" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReissueDifference implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *         &lt;xs:attribute type="xs:string" name="subtype"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MessageInfo implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;
                private String subtype;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }

                /** 
                 * Get the 'subtype' attribute value. 
                                                                                                    Subtype for INFO messages

                                                                                                    Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                                    Possible values: Display, Private, NetRemit
                                                                                                
                 * 
                 * @return value
                 */
                public String getSubtype() {
                    return subtype;
                }

                /** 
                 * Set the 'subtype' attribute value. 
                                                                                                    Subtype for INFO messages

                                                                                                    Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                                    Possible values: Display, Private, NetRemit
                                                                                                
                 * 
                 * @param subtype
                 */
                public void setSubtype(String subtype) {
                    this.subtype = subtype;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscellaneousData" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:KeyValue.Value" name="Value" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiscellaneousData implements Serializable
            {
                private List<KeyValueValue> valueList = new ArrayList<KeyValueValue>();

                /** 
                 * Get the list of 'Value' element items. Data content :
                                                                                                Value in the key-value pair
                 * 
                 * @return list
                 */
                public List<KeyValueValue> getValueList() {
                    return valueList;
                }

                /** 
                 * Set the list of 'Value' element items. Data content :
                                                                                                Value in the key-value pair
                 * 
                 * @param list
                 */
                public void setValueList(List<KeyValueValue> list) {
                    valueList = list;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="PQ"/>
             *     &lt;xs:enumeration value="PQR"/>
             *     &lt;xs:enumeration value="PQRE"/>
             *     &lt;xs:enumeration value="PQRR"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                PQ, PQR, PQRE, PQRR
            }
        }
    }
    /** 
     * Price Quote Record :  This information is equivalent to *PQSB/*PQST
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SummaryByPassengerType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Total" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Total -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class MessageInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="nameOrSegmentWithoutPQExists"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SummaryByPassengerType implements Serializable
    {
        private List<FareInfo> fareInfoList = new ArrayList<FareInfo>();
        private List<Total> totalList = new ArrayList<Total>();
        private List<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
        private Boolean nameOrSegmentWithoutPQExists;

        /** 
         * Get the list of 'FareInfo' element items.
         * 
         * @return list
         */
        public List<FareInfo> getFareInfoList() {
            return fareInfoList;
        }

        /** 
         * Set the list of 'FareInfo' element items.
         * 
         * @param list
         */
        public void setFareInfoList(List<FareInfo> list) {
            fareInfoList = list;
        }

        /** 
         * Get the list of 'Total' element items.
         * 
         * @return list
         */
        public List<Total> getTotalList() {
            return totalList;
        }

        /** 
         * Set the list of 'Total' element items.
         * 
         * @param list
         */
        public void setTotalList(List<Total> list) {
            totalList = list;
        }

        /** 
         * Get the list of 'MessageInfo' element items.
         * 
         * @return list
         */
        public List<MessageInfo> getMessageInfoList() {
            return messageInfoList;
        }

        /** 
         * Set the list of 'MessageInfo' element items.
         * 
         * @param list
         */
        public void setMessageInfoList(List<MessageInfo> list) {
            messageInfoList = list;
        }

        /** 
         * Get the 'nameOrSegmentWithoutPQExists' attribute value. Not all Name or Segment in PNR has associated PQ
         * 
         * @return value
         */
        public Boolean getNameOrSegmentWithoutPQExists() {
            return nameOrSegmentWithoutPQExists;
        }

        /** 
         * Set the 'nameOrSegmentWithoutPQExists' attribute value. Not all Name or Segment in PNR has associated PQ
         * 
         * @param nameOrSegmentWithoutPQExists
         */
        public void setNameOrSegmentWithoutPQExists(
                Boolean nameOrSegmentWithoutPQExists) {
            this.nameOrSegmentWithoutPQExists = nameOrSegmentWithoutPQExists;
        }
        /** 
         * Fare details in the PriceQuote
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="passengerType"/>
         *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;
            private String passengerType;
            private Integer passengerTypeCount;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'passengerType' attribute value. Passenger Type - 			Ref: DM0Z_40_PTCD, DM0Z_40_TPTC
             * 
             * @return value
             */
            public String getPassengerType() {
                return passengerType;
            }

            /** 
             * Set the 'passengerType' attribute value. Passenger Type - 			Ref: DM0Z_40_PTCD, DM0Z_40_TPTC
             * 
             * @param passengerType
             */
            public void setPassengerType(String passengerType) {
                this.passengerType = passengerType;
            }

            /** 
             * Get the 'passengerTypeCount' attribute value. Number of passengers for a particular-
                                                                              passenger type, applicable only for PQST
             * 
             * @return value
             */
            public Integer getPassengerTypeCount() {
                return passengerTypeCount;
            }

            /** 
             * Set the 'passengerTypeCount' attribute value. Number of passengers for a particular-
                                                                              passenger type, applicable only for PQST
             * 
             * @param passengerTypeCount
             */
            public void setPassengerTypeCount(Integer passengerTypeCount) {
                this.passengerTypeCount = passengerTypeCount;
            }
            /** 
             * Base fare - passenger type
                                                                                  Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare - passenger type
                                                                                  Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total - passenger type
                                                                                  Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes -  passenger type
                                                                                  Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
        }
        /** 
         * Sum of price quote fares for all passenger types
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Total implements Serializable
        {
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }
            /** 
             * Base fare - passenger type
                                                                                  Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare - passenger type
                                                                                  Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total - passenger type
                                                                                  Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes -  passenger type
                                                                                  Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="type"/>
         *         &lt;xs:attribute type="xs:integer" name="number"/>
         *         &lt;xs:attribute type="xs:string" name="subtype"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MessageInfo implements Serializable
        {
            private String string;
            private String type;
            private BigInteger number;
            private String subtype;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'type' attribute value. ERROR
                                                                                      WARNING
                                                                                      INFO

                                                                                      Ref:  DM0Z_60_TYPE

                                                                                      x'0C,04,11,03,13
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. ERROR
                                                                                      WARNING
                                                                                      INFO

                                                                                      Ref:  DM0Z_60_TYPE

                                                                                      x'0C,04,11,03,13
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'number' attribute value. Message number

                                                                                      Ref: DM0Z_60_MNBR
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. Message number

                                                                                      Ref: DM0Z_60_MNBR
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'subtype' attribute value. 
                                                                                      Subtype for INFO messages

                                                                                      Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                      Possible values: Display, Private, NetRemit
                                                                                  
             * 
             * @return value
             */
            public String getSubtype() {
                return subtype;
            }

            /** 
             * Set the 'subtype' attribute value. 
                                                                                      Subtype for INFO messages

                                                                                      Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                      Possible values: Display, Private, NetRemit
                                                                                  
             * 
             * @param subtype
             */
            public void setSubtype(String subtype) {
                this.subtype = subtype;
            }
        }
    }
    /** 
     * Price Quote details. This information is equivalent to *PQ
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgentInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="HomeLocation"/>
     *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" name="sine"/>
     *           &lt;xs:attribute type="xs:string" name="duty"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="TransactionInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:dateTime" name="CreateDateTime"/>
     *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="ReissueMethod" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="ReissueResult" minOccurs="0"/>
     *             &lt;xs:element name="PricedLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class PricedLocation -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="TicketedLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class TicketedLocation -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="PricingQualifiers" minOccurs="0">
     *               &lt;!-- Reference to inner class PricingQualifiers -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="xs:dateTime" name="TicketByDate" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:boolean" name="taxModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="changeFeeModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="bagModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="simultaneousTicketForFare"/>
     *           &lt;xs:attribute type="xs:integer" name="pricingFailCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="OrderInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class OrderInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class NameAssociationInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentInfo" minOccurs="0" maxOccurs="30">
     *         &lt;!-- Reference to inner class SegmentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalFareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalFareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FeeInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscellaneousInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscellaneousInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInfo" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class PaymentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareComparisonSummary" minOccurs="0">
     *         &lt;!-- Reference to inner class FareComparisonSummary -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RefundInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class RefundInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ExchangeDocInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ExchangeDocInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AddCollectInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AddCollectInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ResidualInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class ResidualInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MessageInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MessageInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HistoryInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginalDocInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginalDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute use="required" name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
     *     &lt;xs:attribute type="xs:string" name="passengerType"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
     *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
     *     &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
     *     &lt;xs:attribute type="xs:string" name="reissueTransactionType"/>
     *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
     *     &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
     *     &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
     *     &lt;xs:attribute type="xs:boolean" name="ataFormat"/>
     *     &lt;xs:attribute type="xs:string" name="pqOwner"/>
     *     &lt;xs:attribute type="xs:string" name="previousStatus"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private String agentInfoHomeLocation;
        private String agentInfoWorkLocation;
        private String agentInfoSine;
        private String agentInfoDuty;
        private Date transactionInfoCreateDateTime;
        private Date transactionInfoUpdateDateTime;
        private Date transactionInfoLastDateToPurchase;
        private Date transactionInfoLocalCreateDateTime;
        private Date transactionInfoLocalUpdateDateTime;
        private Date transactionInfoExpiryDateTime;
        private String transactionInfoInputEntry;
        private String transactionInfoReissueMethod;
        private String transactionInfoReissueResult;
        private PricedLocation pricedLocation;
        private TicketedLocation ticketedLocation;
        private PricingQualifiers pricingQualifiers;
        private Date transactionInfoTicketByDate;
        private Boolean transactionInfoTaxModified;
        private Boolean transactionInfoChangeFeeModified;
        private Boolean transactionInfoBagModified;
        private Boolean transactionInfoSimultaneousTicketForFare;
        private BigInteger transactionInfoPricingFailCode;
        private OrderInfo orderInfo;
        private List<NameAssociationInfo> nameAssociationInfoList = new ArrayList<NameAssociationInfo>();
        private List<SegmentInfo> segmentInfoList = new ArrayList<SegmentInfo>();
        private FareInfo fareInfo;
        private AdditionalFareInfo additionalFareInfo;
        private List<FeeInfo> feeInfoList = new ArrayList<FeeInfo>();
        private MiscellaneousInfo miscellaneousInfo;
        private List<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        private FareComparisonSummary fareComparisonSummary;
        private RefundInfo refundInfo;
        private List<ExchangeDocInfo> exchangeDocInfoList = new ArrayList<ExchangeDocInfo>();
        private AddCollectInfo addCollectInfo;
        private ResidualInfo residualInfo;
        private MessageInfo messageInfo;
        private List<HistoryInfo> historyInfoList = new ArrayList<HistoryInfo>();
        private OriginalDocInfo originalDocInfo;
        private Type type;
        private BigInteger number;
        private String passengerType;
        private String status;
        private String pricingType;
        private String pricingStatus;
        private Boolean displayOnly;
        private String reissueTransactionType;
        private Boolean lowCostCarrier;
        private Boolean incompletePQR;
        private Boolean createdByOrder;
        private Boolean ataFormat;
        private String pqOwner;
        private String previousStatus;

        /** 
         * Get the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @return value
         */
        public String getAgentInfoHomeLocation() {
            return agentInfoHomeLocation;
        }

        /** 
         * Set the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @param agentInfoHomeLocation
         */
        public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
            this.agentInfoHomeLocation = agentInfoHomeLocation;
        }

        /** 
         * Get the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @return value
         */
        public String getAgentInfoWorkLocation() {
            return agentInfoWorkLocation;
        }

        /** 
         * Set the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @param agentInfoWorkLocation
         */
        public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
            this.agentInfoWorkLocation = agentInfoWorkLocation;
        }

        /** 
         * Get the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @return value
         */
        public String getAgentInfoSine() {
            return agentInfoSine;
        }

        /** 
         * Set the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @param agentInfoSine
         */
        public void setAgentInfoSine(String agentInfoSine) {
            this.agentInfoSine = agentInfoSine;
        }

        /** 
         * Get the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @return value
         */
        public String getAgentInfoDuty() {
            return agentInfoDuty;
        }

        /** 
         * Set the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @param agentInfoDuty
         */
        public void setAgentInfoDuty(String agentInfoDuty) {
            this.agentInfoDuty = agentInfoDuty;
        }

        /** 
         * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @return value
         */
        public Date getTransactionInfoCreateDateTime() {
            return transactionInfoCreateDateTime;
        }

        /** 
         * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @param transactionInfoCreateDateTime
         */
        public void setTransactionInfoCreateDateTime(
                Date transactionInfoCreateDateTime) {
            this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
        }

        /** 
         * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoUpdateDateTime() {
            return transactionInfoUpdateDateTime;
        }

        /** 
         * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @param transactionInfoUpdateDateTime
         */
        public void setTransactionInfoUpdateDateTime(
                Date transactionInfoUpdateDateTime) {
            this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
        }

        /** 
         * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @return value
         */
        public Date getTransactionInfoLastDateToPurchase() {
            return transactionInfoLastDateToPurchase;
        }

        /** 
         * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @param transactionInfoLastDateToPurchase
         */
        public void setTransactionInfoLastDateToPurchase(
                Date transactionInfoLastDateToPurchase) {
            this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
        }

        /** 
         * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @return value
         */
        public Date getTransactionInfoLocalCreateDateTime() {
            return transactionInfoLocalCreateDateTime;
        }

        /** 
         * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @param transactionInfoLocalCreateDateTime
         */
        public void setTransactionInfoLocalCreateDateTime(
                Date transactionInfoLocalCreateDateTime) {
            this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
        }

        /** 
         * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoLocalUpdateDateTime() {
            return transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @param transactionInfoLocalUpdateDateTime
         */
        public void setTransactionInfoLocalUpdateDateTime(
                Date transactionInfoLocalUpdateDateTime) {
            this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @return value
         */
        public Date getTransactionInfoExpiryDateTime() {
            return transactionInfoExpiryDateTime;
        }

        /** 
         * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @param transactionInfoExpiryDateTime
         */
        public void setTransactionInfoExpiryDateTime(
                Date transactionInfoExpiryDateTime) {
            this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
        }

        /** 
         * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @return value
         */
        public String getTransactionInfoInputEntry() {
            return transactionInfoInputEntry;
        }

        /** 
         * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @param transactionInfoInputEntry
         */
        public void setTransactionInfoInputEntry(
                String transactionInfoInputEntry) {
            this.transactionInfoInputEntry = transactionInfoInputEntry;
        }

        /** 
         * Get the 'ReissueMethod' element value. possible values -
                                                                        - EXCH
                                                                        - RFND
                                                                        - AUTOREDIRECT
                                                                        - AUTOEXCH
                                                                        - AUTORFND
         * 
         * @return value
         */
        public String getTransactionInfoReissueMethod() {
            return transactionInfoReissueMethod;
        }

        /** 
         * Set the 'ReissueMethod' element value. possible values -
                                                                        - EXCH
                                                                        - RFND
                                                                        - AUTOREDIRECT
                                                                        - AUTOEXCH
                                                                        - AUTORFND
         * 
         * @param transactionInfoReissueMethod
         */
        public void setTransactionInfoReissueMethod(
                String transactionInfoReissueMethod) {
            this.transactionInfoReissueMethod = transactionInfoReissueMethod;
        }

        /** 
         * Get the 'ReissueResult' element value. Result of the Reissue transaction
                                                                        Ex: EVEN, FEES or A/C, FEES
         * 
         * @return value
         */
        public String getTransactionInfoReissueResult() {
            return transactionInfoReissueResult;
        }

        /** 
         * Set the 'ReissueResult' element value. Result of the Reissue transaction
                                                                        Ex: EVEN, FEES or A/C, FEES
         * 
         * @param transactionInfoReissueResult
         */
        public void setTransactionInfoReissueResult(
                String transactionInfoReissueResult) {
            this.transactionInfoReissueResult = transactionInfoReissueResult;
        }

        /** 
         * Get the 'PricedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public PricedLocation getPricedLocation() {
            return pricedLocation;
        }

        /** 
         * Set the 'PricedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @param pricedLocation
         */
        public void setPricedLocation(PricedLocation pricedLocation) {
            this.pricedLocation = pricedLocation;
        }

        /** 
         * Get the 'TicketedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public TicketedLocation getTicketedLocation() {
            return ticketedLocation;
        }

        /** 
         * Set the 'TicketedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @param ticketedLocation
         */
        public void setTicketedLocation(TicketedLocation ticketedLocation) {
            this.ticketedLocation = ticketedLocation;
        }

        /** 
         * Get the 'PricingQualifiers' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public PricingQualifiers getPricingQualifiers() {
            return pricingQualifiers;
        }

        /** 
         * Set the 'PricingQualifiers' element value. Data at PQ transaction
                                                            level
         * 
         * @param pricingQualifiers
         */
        public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
            this.pricingQualifiers = pricingQualifiers;
        }

        /** 
         * Get the 'TicketByDate' element value. Ticket by date.

                                                                        Ref: DM0Z_40_TKDT
         * 
         * @return value
         */
        public Date getTransactionInfoTicketByDate() {
            return transactionInfoTicketByDate;
        }

        /** 
         * Set the 'TicketByDate' element value. Ticket by date.

                                                                        Ref: DM0Z_40_TKDT
         * 
         * @param transactionInfoTicketByDate
         */
        public void setTransactionInfoTicketByDate(
                Date transactionInfoTicketByDate) {
            this.transactionInfoTicketByDate = transactionInfoTicketByDate;
        }

        /** 
         * Get the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
                                                                    Tax modified - applicable only for CAT31
         * 
         * @return value
         */
        public Boolean getTransactionInfoTaxModified() {
            return transactionInfoTaxModified;
        }

        /** 
         * Set the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
                                                                    Tax modified - applicable only for CAT31
         * 
         * @param transactionInfoTaxModified
         */
        public void setTransactionInfoTaxModified(
                Boolean transactionInfoTaxModified) {
            this.transactionInfoTaxModified = transactionInfoTaxModified;
        }

        /** 
         * Get the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
                                                                    Change Fee modified - applicable only for CAT31
         * 
         * @return value
         */
        public Boolean getTransactionInfoChangeFeeModified() {
            return transactionInfoChangeFeeModified;
        }

        /** 
         * Set the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
                                                                    Change Fee modified - applicable only for CAT31
         * 
         * @param transactionInfoChangeFeeModified
         */
        public void setTransactionInfoChangeFeeModified(
                Boolean transactionInfoChangeFeeModified) {
            this.transactionInfoChangeFeeModified = transactionInfoChangeFeeModified;
        }

        /** 
         * Get the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
         * 
         * @return value
         */
        public Boolean getTransactionInfoBagModified() {
            return transactionInfoBagModified;
        }

        /** 
         * Set the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
         * 
         * @param transactionInfoBagModified
         */
        public void setTransactionInfoBagModified(
                Boolean transactionInfoBagModified) {
            this.transactionInfoBagModified = transactionInfoBagModified;
        }

        /** 
         * Get the 'simultaneousTicketForFare' attribute value. If true, then ticket has to be issued simultaneously after creating price quote for fare to be guaranteed.

                                                                    Ref: #DM0Z_40_TKDT
         * 
         * @return value
         */
        public Boolean getTransactionInfoSimultaneousTicketForFare() {
            return transactionInfoSimultaneousTicketForFare;
        }

        /** 
         * Set the 'simultaneousTicketForFare' attribute value. If true, then ticket has to be issued simultaneously after creating price quote for fare to be guaranteed.

                                                                    Ref: #DM0Z_40_TKDT
         * 
         * @param transactionInfoSimultaneousTicketForFare
         */
        public void setTransactionInfoSimultaneousTicketForFare(
                Boolean transactionInfoSimultaneousTicketForFare) {
            this.transactionInfoSimultaneousTicketForFare = transactionInfoSimultaneousTicketForFare;
        }

        /** 
         * Get the 'pricingFailCode' attribute value. Pricing failure code.
                                                                    Ref: #DM0Z_65_FAIL
         * 
         * @return value
         */
        public BigInteger getTransactionInfoPricingFailCode() {
            return transactionInfoPricingFailCode;
        }

        /** 
         * Set the 'pricingFailCode' attribute value. Pricing failure code.
                                                                    Ref: #DM0Z_65_FAIL
         * 
         * @param transactionInfoPricingFailCode
         */
        public void setTransactionInfoPricingFailCode(
                BigInteger transactionInfoPricingFailCode) {
            this.transactionInfoPricingFailCode = transactionInfoPricingFailCode;
        }

        /** 
         * Get the 'OrderInfo' element value.
         * 
         * @return value
         */
        public OrderInfo getOrderInfo() {
            return orderInfo;
        }

        /** 
         * Set the 'OrderInfo' element value.
         * 
         * @param orderInfo
         */
        public void setOrderInfo(OrderInfo orderInfo) {
            this.orderInfo = orderInfo;
        }

        /** 
         * Get the list of 'NameAssociationInfo' element items.
         * 
         * @return list
         */
        public List<NameAssociationInfo> getNameAssociationInfoList() {
            return nameAssociationInfoList;
        }

        /** 
         * Set the list of 'NameAssociationInfo' element items.
         * 
         * @param list
         */
        public void setNameAssociationInfoList(List<NameAssociationInfo> list) {
            nameAssociationInfoList = list;
        }

        /** 
         * Get the list of 'SegmentInfo' element items.
         * 
         * @return list
         */
        public List<SegmentInfo> getSegmentInfoList() {
            return segmentInfoList;
        }

        /** 
         * Set the list of 'SegmentInfo' element items.
         * 
         * @param list
         */
        public void setSegmentInfoList(List<SegmentInfo> list) {
            segmentInfoList = list;
        }

        /** 
         * Get the 'FareInfo' element value.
         * 
         * @return value
         */
        public FareInfo getFareInfo() {
            return fareInfo;
        }

        /** 
         * Set the 'FareInfo' element value.
         * 
         * @param fareInfo
         */
        public void setFareInfo(FareInfo fareInfo) {
            this.fareInfo = fareInfo;
        }

        /** 
         * Get the 'AdditionalFareInfo' element value.
         * 
         * @return value
         */
        public AdditionalFareInfo getAdditionalFareInfo() {
            return additionalFareInfo;
        }

        /** 
         * Set the 'AdditionalFareInfo' element value.
         * 
         * @param additionalFareInfo
         */
        public void setAdditionalFareInfo(AdditionalFareInfo additionalFareInfo) {
            this.additionalFareInfo = additionalFareInfo;
        }

        /** 
         * Get the list of 'FeeInfo' element items.
         * 
         * @return list
         */
        public List<FeeInfo> getFeeInfoList() {
            return feeInfoList;
        }

        /** 
         * Set the list of 'FeeInfo' element items.
         * 
         * @param list
         */
        public void setFeeInfoList(List<FeeInfo> list) {
            feeInfoList = list;
        }

        /** 
         * Get the 'MiscellaneousInfo' element value.
         * 
         * @return value
         */
        public MiscellaneousInfo getMiscellaneousInfo() {
            return miscellaneousInfo;
        }

        /** 
         * Set the 'MiscellaneousInfo' element value.
         * 
         * @param miscellaneousInfo
         */
        public void setMiscellaneousInfo(MiscellaneousInfo miscellaneousInfo) {
            this.miscellaneousInfo = miscellaneousInfo;
        }

        /** 
         * Get the list of 'PaymentInfo' element items.
         * 
         * @return list
         */
        public List<PaymentInfo> getPaymentInfoList() {
            return paymentInfoList;
        }

        /** 
         * Set the list of 'PaymentInfo' element items.
         * 
         * @param list
         */
        public void setPaymentInfoList(List<PaymentInfo> list) {
            paymentInfoList = list;
        }

        /** 
         * Get the 'FareComparisonSummary' element value.
         * 
         * @return value
         */
        public FareComparisonSummary getFareComparisonSummary() {
            return fareComparisonSummary;
        }

        /** 
         * Set the 'FareComparisonSummary' element value.
         * 
         * @param fareComparisonSummary
         */
        public void setFareComparisonSummary(
                FareComparisonSummary fareComparisonSummary) {
            this.fareComparisonSummary = fareComparisonSummary;
        }

        /** 
         * Get the 'RefundInfo' element value.
         * 
         * @return value
         */
        public RefundInfo getRefundInfo() {
            return refundInfo;
        }

        /** 
         * Set the 'RefundInfo' element value.
         * 
         * @param refundInfo
         */
        public void setRefundInfo(RefundInfo refundInfo) {
            this.refundInfo = refundInfo;
        }

        /** 
         * Get the list of 'ExchangeDocInfo' element items.
         * 
         * @return list
         */
        public List<ExchangeDocInfo> getExchangeDocInfoList() {
            return exchangeDocInfoList;
        }

        /** 
         * Set the list of 'ExchangeDocInfo' element items.
         * 
         * @param list
         */
        public void setExchangeDocInfoList(List<ExchangeDocInfo> list) {
            exchangeDocInfoList = list;
        }

        /** 
         * Get the 'AddCollectInfo' element value.
         * 
         * @return value
         */
        public AddCollectInfo getAddCollectInfo() {
            return addCollectInfo;
        }

        /** 
         * Set the 'AddCollectInfo' element value.
         * 
         * @param addCollectInfo
         */
        public void setAddCollectInfo(AddCollectInfo addCollectInfo) {
            this.addCollectInfo = addCollectInfo;
        }

        /** 
         * Get the 'ResidualInfo' element value.
         * 
         * @return value
         */
        public ResidualInfo getResidualInfo() {
            return residualInfo;
        }

        /** 
         * Set the 'ResidualInfo' element value.
         * 
         * @param residualInfo
         */
        public void setResidualInfo(ResidualInfo residualInfo) {
            this.residualInfo = residualInfo;
        }

        /** 
         * Get the 'MessageInfo' element value.
         * 
         * @return value
         */
        public MessageInfo getMessageInfo() {
            return messageInfo;
        }

        /** 
         * Set the 'MessageInfo' element value.
         * 
         * @param messageInfo
         */
        public void setMessageInfo(MessageInfo messageInfo) {
            this.messageInfo = messageInfo;
        }

        /** 
         * Get the list of 'HistoryInfo' element items.
         * 
         * @return list
         */
        public List<HistoryInfo> getHistoryInfoList() {
            return historyInfoList;
        }

        /** 
         * Set the list of 'HistoryInfo' element items.
         * 
         * @param list
         */
        public void setHistoryInfoList(List<HistoryInfo> list) {
            historyInfoList = list;
        }

        /** 
         * Get the 'OriginalDocInfo' element value.
         * 
         * @return value
         */
        public OriginalDocInfo getOriginalDocInfo() {
            return originalDocInfo;
        }

        /** 
         * Set the 'OriginalDocInfo' element value.
         * 
         * @param originalDocInfo
         */
        public void setOriginalDocInfo(OriginalDocInfo originalDocInfo) {
            this.originalDocInfo = originalDocInfo;
        }

        /** 
         * Get the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
                                                        PQRE - PQR Exchange
                                                        PQRR - RQR Refund
                                                        If not specified, it defaults to PQ and PQR
                                                    
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
                                                        PQRE - PQR Exchange
                                                        PQRR - RQR Refund
                                                        If not specified, it defaults to PQ and PQR
                                                    
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
                                                        Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
         * 
         * @return value
         */
        public String getPassengerType() {
            return passengerType;
        }

        /** 
         * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
                                                        Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
         * 
         * @param passengerType
         */
        public void setPassengerType(String passengerType) {
            this.passengerType = passengerType;
        }

        /** 
         * Get the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }

        /** 
         * Get the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @return value
         */
        public String getPricingType() {
            return pricingType;
        }

        /** 
         * Set the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @param pricingType
         */
        public void setPricingType(String pricingType) {
            this.pricingType = pricingType;
        }

        /** 
         * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @return value
         */
        public String getPricingStatus() {
            return pricingStatus;
        }

        /** 
         * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @param pricingStatus
         */
        public void setPricingStatus(String pricingStatus) {
            this.pricingStatus = pricingStatus;
        }

        /** 
         * Get the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @return value
         */
        public Boolean getDisplayOnly() {
            return displayOnly;
        }

        /** 
         * Set the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @param displayOnly
         */
        public void setDisplayOnly(Boolean displayOnly) {
            this.displayOnly = displayOnly;
        }

        /** 
         * Get the 'reissueTransactionType' attribute value. EXCH or RFND transaction
         * 
         * @return value
         */
        public String getReissueTransactionType() {
            return reissueTransactionType;
        }

        /** 
         * Set the 'reissueTransactionType' attribute value. EXCH or RFND transaction
         * 
         * @param reissueTransactionType
         */
        public void setReissueTransactionType(String reissueTransactionType) {
            this.reissueTransactionType = reissueTransactionType;
        }

        /** 
         * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                        Ref: #DM0Z_40_HCPQ
                                                        Value is false if attribute not present. 
         * 
         * @return value
         */
        public Boolean getLowCostCarrier() {
            return lowCostCarrier;
        }

        /** 
         * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                        Ref: #DM0Z_40_HCPQ
                                                        Value is false if attribute not present. 
         * 
         * @param lowCostCarrier
         */
        public void setLowCostCarrier(Boolean lowCostCarrier) {
            this.lowCostCarrier = lowCostCarrier;
        }

        /** 
         * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                        REF: #DM0Z_40_PQC 
         * 
         * @return value
         */
        public Boolean getIncompletePQR() {
            return incompletePQR;
        }

        /** 
         * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                        REF: #DM0Z_40_PQC 
         * 
         * @param incompletePQR
         */
        public void setIncompletePQR(Boolean incompletePQR) {
            this.incompletePQR = incompletePQR;
        }

        /** 
         * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
         * 
         * @return value
         */
        public Boolean getCreatedByOrder() {
            return createdByOrder;
        }

        /** 
         * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
         * 
         * @param createdByOrder
         */
        public void setCreatedByOrder(Boolean createdByOrder) {
            this.createdByOrder = createdByOrder;
        }

        /** 
         * Get the 'ataFormat' attribute value. ATA format for display or prints
                                                        Ref: #DM0Z_65_PAT
         * 
         * @return value
         */
        public Boolean getAtaFormat() {
            return ataFormat;
        }

        /** 
         * Set the 'ataFormat' attribute value. ATA format for display or prints
                                                        Ref: #DM0Z_65_PAT
         * 
         * @param ataFormat
         */
        public void setAtaFormat(Boolean ataFormat) {
            this.ataFormat = ataFormat;
        }

        /** 
         * Get the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                        Ref:  DM0Z_40_ROWN
         * 
         * @return value
         */
        public String getPqOwner() {
            return pqOwner;
        }

        /** 
         * Set the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                        Ref:  DM0Z_40_ROWN
         * 
         * @param pqOwner
         */
        public void setPqOwner(String pqOwner) {
            this.pqOwner = pqOwner;
        }

        /** 
         * Get the 'previousStatus' attribute value. Previous status of PQ or PQR
                                                        Ref: DM0Z_40_HRST
         * 
         * @return value
         */
        public String getPreviousStatus() {
            return previousStatus;
        }

        /** 
         * Set the 'previousStatus' attribute value. Previous status of PQ or PQR
                                                        Ref: DM0Z_40_HRST
         * 
         * @param previousStatus
         */
        public void setPreviousStatus(String previousStatus) {
            this.previousStatus = previousStatus;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="countryCode"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedLocation implements Serializable
        {
            private String string;
            private String countryCode;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'countryCode' attribute value. Country code
                                                                                      
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'countryCode' attribute value. Country code
                                                                                      
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketedLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="countryCode"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketedLocation implements Serializable
        {
            private String string;
            private String countryCode;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'countryCode' attribute value. Country code
                                                                                      
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'countryCode' attribute value. Country code
                                                                                      
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Qualifier" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Qualifier -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingQualifiers implements Serializable
        {
            private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

            /** 
             * Get the list of 'Qualifier' element items.
             * 
             * @return list
             */
            public List<Qualifier> getQualifierList() {
                return qualifierList;
            }

            /** 
             * Set the list of 'Qualifier' element items.
             * 
             * @param list
             */
            public void setQualifierList(List<Qualifier> list) {
                qualifierList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Data" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="mergeAllowed"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Qualifier implements Serializable
            {
                private String actionCode;
                private String data;
                private Boolean mergeAllowed;

                /** 
                 * Get the 'ActionCode' element value. Primary action code/Secondary action code

                                                                                                    Ref: DM0Z_62_PSAC
                 * 
                 * @return value
                 */
                public String getActionCode() {
                    return actionCode;
                }

                /** 
                 * Set the 'ActionCode' element value. Primary action code/Secondary action code

                                                                                                    Ref: DM0Z_62_PSAC
                 * 
                 * @param actionCode
                 */
                public void setActionCode(String actionCode) {
                    this.actionCode = actionCode;
                }

                /** 
                 * Get the 'Data' element value. Data associated to action code.

                                                                                                    Ref: DM0Z_62_DATA
                 * 
                 * @return value
                 */
                public String getData() {
                    return data;
                }

                /** 
                 * Set the 'Data' element value. Data associated to action code.

                                                                                                    Ref: DM0Z_62_DATA
                 * 
                 * @param data
                 */
                public void setData(String data) {
                    this.data = data;
                }

                /** 
                 * Get the 'mergeAllowed' attribute value. Indicates that the secondary action code is allowed to merge when true.

                                                                                                Ref: DM0Z_62_IND2
                                                                                                #DM0Z_62_MER
                                                                                            
                 * 
                 * @return value
                 */
                public Boolean getMergeAllowed() {
                    return mergeAllowed;
                }

                /** 
                 * Set the 'mergeAllowed' attribute value. Indicates that the secondary action code is allowed to merge when true.

                                                                                                Ref: DM0Z_62_IND2
                                                                                                #DM0Z_62_MER
                                                                                            
                 * 
                 * @param mergeAllowed
                 */
                public void setMergeAllowed(Boolean mergeAllowed) {
                    this.mergeAllowed = mergeAllowed;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Identifier.NDC" name="SabreOrderID" minOccurs="0"/>
         *       &lt;xs:element type="ns:Identifier.NDC" name="OtherOrderID" minOccurs="0"/>
         *       &lt;xs:element type="ns:Identifier.NDC" name="SabreOrderItemID" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OrderInfo implements Serializable
        {
            private IdentifierNDC sabreOrderID;
            private IdentifierNDC otherOrderID;
            private IdentifierNDC sabreOrderItemID;

            /** 
             * Get the 'SabreOrderID' element value. Order Management System Order Unique Identifier
                                                                      
             * 
             * @return value
             */
            public IdentifierNDC getSabreOrderID() {
                return sabreOrderID;
            }

            /** 
             * Set the 'SabreOrderID' element value. Order Management System Order Unique Identifier
                                                                      
             * 
             * @param sabreOrderID
             */
            public void setSabreOrderID(IdentifierNDC sabreOrderID) {
                this.sabreOrderID = sabreOrderID;
            }

            /** 
             * Get the 'OtherOrderID' element value. Other Order Management System Order Unique Identifier
                                                                      
             * 
             * @return value
             */
            public IdentifierNDC getOtherOrderID() {
                return otherOrderID;
            }

            /** 
             * Set the 'OtherOrderID' element value. Other Order Management System Order Unique Identifier
                                                                      
             * 
             * @param otherOrderID
             */
            public void setOtherOrderID(IdentifierNDC otherOrderID) {
                this.otherOrderID = otherOrderID;
            }

            /** 
             * Get the 'SabreOrderItemID' element value. Other Order Management System Order Unique Identifier
                                                                      
             * 
             * @return value
             */
            public IdentifierNDC getSabreOrderItemID() {
                return sabreOrderItemID;
            }

            /** 
             * Set the 'SabreOrderItemID' element value. Other Order Management System Order Unique Identifier
                                                                      
             * 
             * @param sabreOrderItemID
             */
            public void setSabreOrderItemID(IdentifierNDC sabreOrderItemID) {
                this.sabreOrderItemID = sabreOrderItemID;
            }
        }
        /** 
         * List of associated traveler names
                                                            for this PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
         *     &lt;xs:attribute type="xs:string" name="firstName"/>
         *     &lt;xs:attribute type="xs:string" name="lastName"/>
         *     &lt;xs:attribute type="xs:string" name="manNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NameAssociationInfo implements Serializable
        {
            private String nameNumber;
            private BigInteger nameId;
            private String firstName;
            private String lastName;
            private String manNumber;

            /** 
             * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }

            /** 
             * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @return value
             */
            public BigInteger getNameId() {
                return nameId;
            }

            /** 
             * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @param nameId
             */
            public void setNameId(BigInteger nameId) {
                this.nameId = nameId;
            }

            /** 
             * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @return value
             */
            public String getFirstName() {
                return firstName;
            }

            /** 
             * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @param firstName
             */
            public void setFirstName(String firstName) {
                this.firstName = firstName;
            }

            /** 
             * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @return value
             */
            public String getLastName() {
                return lastName;
            }

            /** 
             * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @param lastName
             */
            public void setLastName(String lastName) {
                this.lastName = lastName;
            }

            /** 
             * Get the 'manNumber' attribute value. MAN Number
                                                                      Ref: SR06_30_MAN
             * 
             * @return value
             */
            public String getManNumber() {
                return manNumber;
            }

            /** 
             * Set the 'manNumber' attribute value. MAN Number
                                                                      Ref: SR06_30_MAN
             * 
             * @param manNumber
             */
            public void setManNumber(String manNumber) {
                this.manNumber = manNumber;
            }
        }
        /** 
         * Data associated to the segments priced within the PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentInfo" minOccurs="0" maxOccurs="30">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" minOccurs="0">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidBefore" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidAfter" minOccurs="0"/>
         *       &lt;xs:element name="Baggage" minOccurs="0">
         *         &lt;!-- Reference to inner class Baggage -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:integer" name="FareComponentNumber" minOccurs="0"/>
         *       &lt;xs:element name="BrandedFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BrandedFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="number"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="segmentStatus"/>
         *     &lt;xs:attribute type="xs:string" name="flown"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="segNumber"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="segID"/>
         *     &lt;xs:attribute type="xs:string" name="bookingStatus"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentInfo implements Serializable
        {
            private Flight flight;
            private String fareBasis;
            private java.sql.Date notValidBefore;
            private java.sql.Date notValidAfter;
            private Baggage baggage;
            private BigInteger fareComponentNumber;
            private BrandedFare brandedFare;
            private BigInteger number;
            private String type;
            private String segmentStatus;
            private String flown;
            private String segNumber;
            private String segID;
            private String bookingStatus;

            /** 
             * Get the 'Flight' element value.
             * 
             * @return value
             */
            public Flight getFlight() {
                return flight;
            }

            /** 
             * Set the 'Flight' element value.
             * 
             * @param flight
             */
            public void setFlight(Flight flight) {
                this.flight = flight;
            }

            /** 
             * Get the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @return value
             */
            public String getFareBasis() {
                return fareBasis;
            }

            /** 
             * Set the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @param fareBasis
             */
            public void setFareBasis(String fareBasis) {
                this.fareBasis = fareBasis;
            }

            /** 
             * Get the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @return value
             */
            public java.sql.Date getNotValidBefore() {
                return notValidBefore;
            }

            /** 
             * Set the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @param notValidBefore
             */
            public void setNotValidBefore(java.sql.Date notValidBefore) {
                this.notValidBefore = notValidBefore;
            }

            /** 
             * Get the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @return value
             */
            public java.sql.Date getNotValidAfter() {
                return notValidAfter;
            }

            /** 
             * Set the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @param notValidAfter
             */
            public void setNotValidAfter(java.sql.Date notValidAfter) {
                this.notValidAfter = notValidAfter;
            }

            /** 
             * Get the 'Baggage' element value.
             * 
             * @return value
             */
            public Baggage getBaggage() {
                return baggage;
            }

            /** 
             * Set the 'Baggage' element value.
             * 
             * @param baggage
             */
            public void setBaggage(Baggage baggage) {
                this.baggage = baggage;
            }

            /** 
             * Get the 'FareComponentNumber' element value. Display number of fare component stored in PQ

                                                                          Ref: -  DM0Z_75_FCNR
             * 
             * @return value
             */
            public BigInteger getFareComponentNumber() {
                return fareComponentNumber;
            }

            /** 
             * Set the 'FareComponentNumber' element value. Display number of fare component stored in PQ

                                                                          Ref: -  DM0Z_75_FCNR
             * 
             * @param fareComponentNumber
             */
            public void setFareComponentNumber(BigInteger fareComponentNumber) {
                this.fareComponentNumber = fareComponentNumber;
            }

            /** 
             * Get the 'BrandedFare' element value.
             * 
             * @return value
             */
            public BrandedFare getBrandedFare() {
                return brandedFare;
            }

            /** 
             * Set the 'BrandedFare' element value.
             * 
             * @param brandedFare
             */
            public void setBrandedFare(BrandedFare brandedFare) {
                this.brandedFare = brandedFare;
            }

            /** 
             * Get the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @return value
             */
            public String getSegmentStatus() {
                return segmentStatus;
            }

            /** 
             * Set the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @param segmentStatus
             */
            public void setSegmentStatus(String segmentStatus) {
                this.segmentStatus = segmentStatus;
            }

            /** 
             * Get the 'flown' attribute value. Flown segment
                                                                      Ref: DM0Z_70_FLID
             * 
             * @return value
             */
            public String getFlown() {
                return flown;
            }

            /** 
             * Set the 'flown' attribute value. Flown segment
                                                                      Ref: DM0Z_70_FLID
             * 
             * @param flown
             */
            public void setFlown(String flown) {
                this.flown = flown;
            }

            /** 
             * Get the 'segNumber' attribute value. PNR Segment number at time of PQ/PQR create
                                                                      Ref: DM0Z_70_SEGN
             * 
             * @return value
             */
            public String getSegNumber() {
                return segNumber;
            }

            /** 
             * Set the 'segNumber' attribute value. PNR Segment number at time of PQ/PQR create
                                                                      Ref: DM0Z_70_SEGN
             * 
             * @param segNumber
             */
            public void setSegNumber(String segNumber) {
                this.segNumber = segNumber;
            }

            /** 
             * Get the 'segID' attribute value. PNR segment ID
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @return value
             */
            public String getSegID() {
                return segID;
            }

            /** 
             * Set the 'segID' attribute value. PNR segment ID
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @param segID
             */
            public void setSegID(String segID) {
                this.segID = segID;
            }

            /** 
             * Get the 'bookingStatus' attribute value. PNR segment booking status

                                                                      Ref: DM0Z_70_RESCD
             * 
             * @return value
             */
            public String getBookingStatus() {
                return bookingStatus;
            }

            /** 
             * Set the 'bookingStatus' attribute value. PNR segment booking status

                                                                      Ref: DM0Z_70_RESCD
             * 
             * @param bookingStatus
             */
            public void setBookingStatus(String bookingStatus) {
                this.bookingStatus = bookingStatus;
            }
            /** 
             * FlightInfo
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MarketingFlight" minOccurs="0">
             *         &lt;!-- Reference to inner class MarketingFlight -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
             *       &lt;xs:element name="Departure" minOccurs="0">
             *         &lt;!-- Reference to inner class Departure -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Arrival" minOccurs="0">
             *         &lt;!-- Reference to inner class Arrival -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Identifier.Flight" name="OperatingFlight" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="connectionIndicator"/>
             *     &lt;xs:attribute type="xs:boolean" name="stopOverConnOverride"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private MarketingFlight marketingFlight;
                private String classOfService;
                private Departure departure;
                private Arrival arrival;
                private IdentifierFlight operatingFlight;
                private String connectionIndicator;
                private Boolean stopOverConnOverride;

                /** 
                 * Get the 'MarketingFlight' element value.
                 * 
                 * @return value
                 */
                public MarketingFlight getMarketingFlight() {
                    return marketingFlight;
                }

                /** 
                 * Set the 'MarketingFlight' element value.
                 * 
                 * @param marketingFlight
                 */
                public void setMarketingFlight(MarketingFlight marketingFlight) {
                    this.marketingFlight = marketingFlight;
                }

                /** 
                 * Get the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @return value
                 */
                public String getClassOfService() {
                    return classOfService;
                }

                /** 
                 * Set the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @param classOfService
                 */
                public void setClassOfService(String classOfService) {
                    this.classOfService = classOfService;
                }

                /** 
                 * Get the 'Departure' element value.
                 * 
                 * @return value
                 */
                public Departure getDeparture() {
                    return departure;
                }

                /** 
                 * Set the 'Departure' element value.
                 * 
                 * @param departure
                 */
                public void setDeparture(Departure departure) {
                    this.departure = departure;
                }

                /** 
                 * Get the 'Arrival' element value.
                 * 
                 * @return value
                 */
                public Arrival getArrival() {
                    return arrival;
                }

                /** 
                 * Set the 'Arrival' element value.
                 * 
                 * @param arrival
                 */
                public void setArrival(Arrival arrival) {
                    this.arrival = arrival;
                }

                /** 
                 * Get the 'OperatingFlight' element value. Operating Flight Info

                                                                                        Carrier Code
                                                                                        Ref: DM0Z_70_CXRO
                                                                                        Flight number
                                                                                        Ref: DM0Z_70_FLTO
                                                                                        Carrier name DM0Z_70_CXNO
                 * 
                 * @return value
                 */
                public IdentifierFlight getOperatingFlight() {
                    return operatingFlight;
                }

                /** 
                 * Set the 'OperatingFlight' element value. Operating Flight Info

                                                                                        Carrier Code
                                                                                        Ref: DM0Z_70_CXRO
                                                                                        Flight number
                                                                                        Ref: DM0Z_70_FLTO
                                                                                        Carrier name DM0Z_70_CXNO
                 * 
                 * @param operatingFlight
                 */
                public void setOperatingFlight(IdentifierFlight operatingFlight) {
                    this.operatingFlight = operatingFlight;
                }

                /** 
                 * Get the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @return value
                 */
                public String getConnectionIndicator() {
                    return connectionIndicator;
                }

                /** 
                 * Set the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @param connectionIndicator
                 */
                public void setConnectionIndicator(String connectionIndicator) {
                    this.connectionIndicator = connectionIndicator;
                }

                /** 
                 * Get the 'stopOverConnOverride' attribute value. Stopover connection override
                                                                                    Ref: DM0Z_70_FARI #DM0Z_70_FSN
                 * 
                 * @return value
                 */
                public Boolean getStopOverConnOverride() {
                    return stopOverConnOverride;
                }

                /** 
                 * Set the 'stopOverConnOverride' attribute value. Stopover connection override
                                                                                    Ref: DM0Z_70_FARI #DM0Z_70_FSN
                 * 
                 * @param stopOverConnOverride
                 */
                public void setStopOverConnOverride(Boolean stopOverConnOverride) {
                    this.stopOverConnOverride = stopOverConnOverride;
                }
                /** 
                 * Marketing Flight Info

                                                                                        Carrier Code
                                                                                        Ref: DM0Z_70_CXRM
                                                                                        Flight number
                                                                                        Ref: DM0Z_70_FLTM
                                                                                        Carrier name DM0Z_70_CXNM
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingFlight" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="number"/>
                 *         &lt;xs:attribute type="xs:string" name="name"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarketingFlight implements Serializable
                {
                    private String string;
                    private String number;
                    private String name;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'number' attribute value. Flight  Number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'number' attribute value. Flight  Number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'name' attribute value. Carrier Name
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'name' attribute value. Carrier Name
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * Departure Info

                                                                                        Departure DateTime
                                                                                        Ref: DM0Z_70_FDDB
                                                                                        Ref:DM0Z_70_FDTB
                                                                                        Departure CityCode
                                                                                        Ref: DM0Z_70_DCTY
                                                                                        Departure City name
                                                                                        Ref: DM0Z_70_DCTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Departure implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
                /** 
                 * Arrival Info

                                                                                        Arrival DateTime
                                                                                        Ref: DM0Z_70_FADB
                                                                                        Ref:DM0Z_70_FATB
                                                                                        Arrival CityCode
                                                                                        Ref: DM0Z_70_ACTY
                                                                                        Arrival City name
                                                                                        Ref:DM0Z_70_ACTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Arrival implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
            }
            /** 
             * Baggage information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="allowance"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Baggage implements Serializable
            {
                private String type;
                private String allowance;

                /** 
                 * Get the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @return value
                 */
                public String getAllowance() {
                    return allowance;
                }

                /** 
                 * Set the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @param allowance
                 */
                public void setAllowance(String allowance) {
                    this.allowance = allowance;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *     &lt;xs:attribute type="xs:string" name="description"/>
             *     &lt;xs:attribute type="xs:string" name="brandCarrier"/>
             *     &lt;xs:attribute type="xs:string" name="programCode"/>
             *     &lt;xs:attribute type="xs:string" name="programDescription"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BrandedFare implements Serializable
            {
                private String code;
                private String description;
                private String brandCarrier;
                private String programCode;
                private String programDescription;

                /** 
                 * Get the 'code' attribute value. Brand Code
                                                                                    Ref: DM0Z_70_BRCD	
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Brand Code
                                                                                    Ref: DM0Z_70_BRCD	
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'description' attribute value. Brand Description Name
                                                                                    Ref: DM0Z_70_BRNM	
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'description' attribute value. Brand Description Name
                                                                                    Ref: DM0Z_70_BRNM	
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'brandCarrier' attribute value. Brand Carrier
                                                                                    Ref: DM0Z_70_BRCR	
                 * 
                 * @return value
                 */
                public String getBrandCarrier() {
                    return brandCarrier;
                }

                /** 
                 * Set the 'brandCarrier' attribute value. Brand Carrier
                                                                                    Ref: DM0Z_70_BRCR	
                 * 
                 * @param brandCarrier
                 */
                public void setBrandCarrier(String brandCarrier) {
                    this.brandCarrier = brandCarrier;
                }

                /** 
                 * Get the 'programCode' attribute value. Program Code
                                                                                    Ref: DM0Z_76_BR_SC0	
                 * 
                 * @return value
                 */
                public String getProgramCode() {
                    return programCode;
                }

                /** 
                 * Set the 'programCode' attribute value. Program Code
                                                                                    Ref: DM0Z_76_BR_SC0	
                 * 
                 * @param programCode
                 */
                public void setProgramCode(String programCode) {
                    this.programCode = programCode;
                }

                /** 
                 * Get the 'programDescription' attribute value. Program Description
                                                                                    Ref: DM0Z_76_BR_SC2	
                 * 
                 * @return value
                 */
                public String getProgramDescription() {
                    return programDescription;
                }

                /** 
                 * Set the 'programDescription' attribute value. Program Description
                                                                                    Ref: DM0Z_76_BR_SC2	
                 * 
                 * @param programDescription
                 */
                public void setProgramDescription(String programDescription) {
                    this.programDescription = programDescription;
                }
            }
        }
        /** 
         * Fare details associated to the selling fare equivalent *PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FareIndicators" minOccurs="0">
         *         &lt;!-- Reference to inner class FareIndicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:Amount.Pattern" name="BaseFare" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="EquivalentFare" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="TotalTax" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="TotalFare" minOccurs="0"/>
         *       &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
         *       &lt;xs:element name="FareCalculation" minOccurs="0">
         *         &lt;!-- Reference to inner class FareCalculation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CurrencyConversion" minOccurs="0">
         *         &lt;!-- Reference to inner class CurrencyConversion -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HandlingFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OptionalServiceInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareComponent" minOccurs="0" maxOccurs="30">
         *         &lt;!-- Reference to inner class FareComponent -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="WaiverInfo" minOccurs="0"/>
         *       &lt;xs:element type="xs:integer" name="BaggageDisclosureInd" minOccurs="0"/>
         *       &lt;xs:element type="xs:dateTime" name="CommencementDate" minOccurs="0"/>
         *       &lt;xs:element name="StopoverOrTransferCharge" minOccurs="0" maxOccurs="2">
         *         &lt;!-- Reference to inner class StopoverOrTransferCharge -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="source"/>
         *     &lt;xs:attribute type="xs:string" name="multiEquivCurrency1"/>
         *     &lt;xs:attribute type="xs:string" name="multiEquivCurrency2"/>
         *     &lt;xs:attribute type="xs:boolean" name="usedFare"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private FareIndicators fareIndicators;
            private AmountPattern baseFare;
            private AmountPattern equivalentFare;
            private AmountPattern totalTax;
            private AmountPattern totalFare;
            private FareTaxInfo taxInfo;
            private FareCalculation fareCalculation;
            private CurrencyConversion currencyConversion;
            private Commission commission;
            private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();
            private List<OptionalServiceInfo> optionalServiceInfoList = new ArrayList<OptionalServiceInfo>();
            private List<FareComponent> fareComponentList = new ArrayList<FareComponent>();
            private String waiverInfo;
            private BigInteger baggageDisclosureInd;
            private Date commencementDate;
            private List<StopoverOrTransferCharge> stopoverOrTransferChargeList = new ArrayList<StopoverOrTransferCharge>();
            private String type;
            private String source;
            private String multiEquivCurrency1;
            private String multiEquivCurrency2;
            private Boolean usedFare;

            /** 
             * Get the 'FareIndicators' element value.
             * 
             * @return value
             */
            public FareIndicators getFareIndicators() {
                return fareIndicators;
            }

            /** 
             * Set the 'FareIndicators' element value.
             * 
             * @param fareIndicators
             */
            public void setFareIndicators(FareIndicators fareIndicators) {
                this.fareIndicators = fareIndicators;
            }

            /** 
             * Get the 'BaseFare' element value. Base fare per PQ type
                                                                          Ref: DM0Z_85_BFAR		       DM0Z_CA_BFAR
                                                                      
             * 
             * @return value
             */
            public AmountPattern getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value. Base fare per PQ type
                                                                          Ref: DM0Z_85_BFAR		       DM0Z_CA_BFAR
                                                                      
             * 
             * @param baseFare
             */
            public void setBaseFare(AmountPattern baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
                                                                          Ref: DM0Z_85_EFAR
                                                                          DM0Z_CA_EFAR
             * 
             * @return value
             */
            public AmountPattern getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
                                                                          Ref: DM0Z_85_EFAR
                                                                          DM0Z_CA_EFAR
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(AmountPattern equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value. Tax Total per PQ type
                                                                          Ref: DM0Z_85_TTAC
                                                                          DM0Z_CA_TTAC	
             * 
             * @return value
             */
            public AmountPattern getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value. Tax Total per PQ type
                                                                          Ref: DM0Z_85_TTAC
                                                                          DM0Z_CA_TTAC	
             * 
             * @param totalTax
             */
            public void setTotalTax(AmountPattern totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
                                                                          Ref: DM0Z_85_TFAR
                                                                          DM0Z_CA_TFAR		
             * 
             * @return value
             */
            public AmountPattern getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
                                                                          Ref: DM0Z_85_TFAR
                                                                          DM0Z_CA_TFAR		
             * 
             * @param totalFare
             */
            public void setTotalFare(AmountPattern totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'TaxInfo' element value.
             * 
             * @return value
             */
            public FareTaxInfo getTaxInfo() {
                return taxInfo;
            }

            /** 
             * Set the 'TaxInfo' element value.
             * 
             * @param taxInfo
             */
            public void setTaxInfo(FareTaxInfo taxInfo) {
                this.taxInfo = taxInfo;
            }

            /** 
             * Get the 'FareCalculation' element value.
             * 
             * @return value
             */
            public FareCalculation getFareCalculation() {
                return fareCalculation;
            }

            /** 
             * Set the 'FareCalculation' element value.
             * 
             * @param fareCalculation
             */
            public void setFareCalculation(FareCalculation fareCalculation) {
                this.fareCalculation = fareCalculation;
            }

            /** 
             * Get the 'CurrencyConversion' element value.
             * 
             * @return value
             */
            public CurrencyConversion getCurrencyConversion() {
                return currencyConversion;
            }

            /** 
             * Set the 'CurrencyConversion' element value.
             * 
             * @param currencyConversion
             */
            public void setCurrencyConversion(
                    CurrencyConversion currencyConversion) {
                this.currencyConversion = currencyConversion;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the list of 'HandlingFee' element items.
             * 
             * @return list
             */
            public List<HandlingFee> getHandlingFeeList() {
                return handlingFeeList;
            }

            /** 
             * Set the list of 'HandlingFee' element items.
             * 
             * @param list
             */
            public void setHandlingFeeList(List<HandlingFee> list) {
                handlingFeeList = list;
            }

            /** 
             * Get the list of 'OptionalServiceInfo' element items.
             * 
             * @return list
             */
            public List<OptionalServiceInfo> getOptionalServiceInfoList() {
                return optionalServiceInfoList;
            }

            /** 
             * Set the list of 'OptionalServiceInfo' element items.
             * 
             * @param list
             */
            public void setOptionalServiceInfoList(
                    List<OptionalServiceInfo> list) {
                optionalServiceInfoList = list;
            }

            /** 
             * Get the list of 'FareComponent' element items.
             * 
             * @return list
             */
            public List<FareComponent> getFareComponentList() {
                return fareComponentList;
            }

            /** 
             * Set the list of 'FareComponent' element items.
             * 
             * @param list
             */
            public void setFareComponentList(List<FareComponent> list) {
                fareComponentList = list;
            }

            /** 
             * Get the 'WaiverInfo' element value. ref:DM0Z_62_DATA

                                                                          Waiver details applicable as returned from pricing
             * 
             * @return value
             */
            public String getWaiverInfo() {
                return waiverInfo;
            }

            /** 
             * Set the 'WaiverInfo' element value. ref:DM0Z_62_DATA

                                                                          Waiver details applicable as returned from pricing
             * 
             * @param waiverInfo
             */
            public void setWaiverInfo(String waiverInfo) {
                this.waiverInfo = waiverInfo;
            }

            /** 
             * Get the 'BaggageDisclosureInd' element value. ref:DM0Z_85_BAG_DIS

                                                                          #DM0Z_85_TOFM_US
                                                                          #DM0Z_85_TOFM_CA
                                                                          #DM0Z_85_WTHN_US
                                                                          #DM0Z_85_WTHN_CA
                                                                          #DM0Z_85_BN_CAUS
                                                                          #DM0Z_85_OTHERS
                                                                          Baggage disclosure indicator
             * 
             * @return value
             */
            public BigInteger getBaggageDisclosureInd() {
                return baggageDisclosureInd;
            }

            /** 
             * Set the 'BaggageDisclosureInd' element value. ref:DM0Z_85_BAG_DIS

                                                                          #DM0Z_85_TOFM_US
                                                                          #DM0Z_85_TOFM_CA
                                                                          #DM0Z_85_WTHN_US
                                                                          #DM0Z_85_WTHN_CA
                                                                          #DM0Z_85_BN_CAUS
                                                                          #DM0Z_85_OTHERS
                                                                          Baggage disclosure indicator
             * 
             * @param baggageDisclosureInd
             */
            public void setBaggageDisclosureInd(BigInteger baggageDisclosureInd) {
                this.baggageDisclosureInd = baggageDisclosureInd;
            }

            /** 
             * Get the 'CommencementDate' element value. TRavel Commencement Date

                                                                          Ref:DM0Z_66_TCDT
             * 
             * @return value
             */
            public Date getCommencementDate() {
                return commencementDate;
            }

            /** 
             * Set the 'CommencementDate' element value. TRavel Commencement Date

                                                                          Ref:DM0Z_66_TCDT
             * 
             * @param commencementDate
             */
            public void setCommencementDate(Date commencementDate) {
                this.commencementDate = commencementDate;
            }

            /** 
             * Get the list of 'StopoverOrTransferCharge' element items.
             * 
             * @return list
             */
            public List<StopoverOrTransferCharge> getStopoverOrTransferChargeList() {
                return stopoverOrTransferChargeList;
            }

            /** 
             * Set the list of 'StopoverOrTransferCharge' element items.
             * 
             * @param list
             */
            public void setStopoverOrTransferChargeList(
                    List<StopoverOrTransferCharge> list) {
                stopoverOrTransferChargeList = list;
            }

            /** 
             * Get the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }

            /** 
             * Get the 'multiEquivCurrency1' attribute value. Multi equivalent currency 1
                                                                      REF: DM0Z_85_BSCU 
             * 
             * @return value
             */
            public String getMultiEquivCurrency1() {
                return multiEquivCurrency1;
            }

            /** 
             * Set the 'multiEquivCurrency1' attribute value. Multi equivalent currency 1
                                                                      REF: DM0Z_85_BSCU 
             * 
             * @param multiEquivCurrency1
             */
            public void setMultiEquivCurrency1(String multiEquivCurrency1) {
                this.multiEquivCurrency1 = multiEquivCurrency1;
            }

            /** 
             * Get the 'multiEquivCurrency2' attribute value. Multi equivalent currency 2
                                                                      REF: DM0Z_85_BSCU
             * 
             * @return value
             */
            public String getMultiEquivCurrency2() {
                return multiEquivCurrency2;
            }

            /** 
             * Set the 'multiEquivCurrency2' attribute value. Multi equivalent currency 2
                                                                      REF: DM0Z_85_BSCU
             * 
             * @param multiEquivCurrency2
             */
            public void setMultiEquivCurrency2(String multiEquivCurrency2) {
                this.multiEquivCurrency2 = multiEquivCurrency2;
            }

            /** 
             * Get the 'usedFare' attribute value. Set to 'true' for partial refund -
                                                                      If 'true', FareInfo will show used fare information
             * 
             * @return value
             */
            public Boolean getUsedFare() {
                return usedFare;
            }

            /** 
             * Set the 'usedFare' attribute value. Set to 'true' for partial refund -
                                                                      If 'true', FareInfo will show used fare information
             * 
             * @param usedFare
             */
            public void setUsedFare(Boolean usedFare) {
                this.usedFare = usedFare;
            }
            /** 
             * Fare level Indicators
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" name="governmentApproval"/>
             *     &lt;xs:attribute type="xs:boolean" name="negotiatedFare"/>
             *     &lt;xs:attribute type="xs:string" name="privateFareType"/>
             *     &lt;xs:attribute type="xs:boolean" name="NUC_Suppression"/>
             *     &lt;xs:attribute type="xs:boolean" name="netValues"/>
             *     &lt;xs:attribute type="xs:boolean" name="cat35Fare"/>
             *     &lt;xs:attribute type="xs:boolean" name="commissionOverride"/>
             *     &lt;xs:attribute type="xs:boolean" name="cat35DataOverwrite"/>
             *     &lt;xs:attribute type="xs:boolean" name="netFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="itBTFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="displayOnlyNetFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="inclusiveTourFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="bulkTourFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="nonITBTFare"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareIndicators implements Serializable
            {
                private Boolean governmentApproval;
                private Boolean negotiatedFare;
                private String privateFareType;
                private Boolean NUCSuppression;
                private Boolean netValues;
                private Boolean cat35Fare;
                private Boolean commissionOverride;
                private Boolean cat35DataOverwrite;
                private Boolean netFare;
                private Boolean itBTFare;
                private Boolean displayOnlyNetFare;
                private Boolean inclusiveTourFare;
                private Boolean bulkTourFare;
                private Boolean nonITBTFare;

                /** 
                 * Get the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                                                                                
                 * 
                 * @return value
                 */
                public Boolean getGovernmentApproval() {
                    return governmentApproval;
                }

                /** 
                 * Set the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                                                                                
                 * 
                 * @param governmentApproval
                 */
                public void setGovernmentApproval(Boolean governmentApproval) {
                    this.governmentApproval = governmentApproval;
                }

                /** 
                 * Get the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @return value
                 */
                public Boolean getNegotiatedFare() {
                    return negotiatedFare;
                }

                /** 
                 * Set the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @param negotiatedFare
                 */
                public void setNegotiatedFare(Boolean negotiatedFare) {
                    this.negotiatedFare = negotiatedFare;
                }

                /** 
                 * Get the 'privateFareType' attribute value. private fare indicator

                                                                                    Ref: DM0Z_85_PVT_FAR
                 * 
                 * @return value
                 */
                public String getPrivateFareType() {
                    return privateFareType;
                }

                /** 
                 * Set the 'privateFareType' attribute value. private fare indicator

                                                                                    Ref: DM0Z_85_PVT_FAR
                 * 
                 * @param privateFareType
                 */
                public void setPrivateFareType(String privateFareType) {
                    this.privateFareType = privateFareType;
                }

                /** 
                 * Get the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC 
                 * 
                 * @return value
                 */
                public Boolean getNUCSuppression() {
                    return NUCSuppression;
                }

                /** 
                 * Set the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC 
                 * 
                 * @param NUCSuppression
                 */
                public void setNUCSuppression(Boolean NUCSuppression) {
                    this.NUCSuppression = NUCSuppression;
                }

                /** 
                 * Get the 'netValues' attribute value. Identies both old and new fares are at Net Amounts
                                                                                    REF: #DM0Z_85_NETF
                 * 
                 * @return value
                 */
                public Boolean getNetValues() {
                    return netValues;
                }

                /** 
                 * Set the 'netValues' attribute value. Identies both old and new fares are at Net Amounts
                                                                                    REF: #DM0Z_85_NETF
                 * 
                 * @param netValues
                 */
                public void setNetValues(Boolean netValues) {
                    this.netValues = netValues;
                }

                /** 
                 * Get the 'cat35Fare' attribute value. Cat35 fare present.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_BCAT
                 * 
                 * @return value
                 */
                public Boolean getCat35Fare() {
                    return cat35Fare;
                }

                /** 
                 * Set the 'cat35Fare' attribute value. Cat35 fare present.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_BCAT
                 * 
                 * @param cat35Fare
                 */
                public void setCat35Fare(Boolean cat35Fare) {
                    this.cat35Fare = cat35Fare;
                }

                /** 
                 * Get the 'commissionOverride' attribute value. Cat35 commission override.

                                                                                    Ref: Cat35 fare present.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_CCOV
                 * 
                 * @return value
                 */
                public Boolean getCommissionOverride() {
                    return commissionOverride;
                }

                /** 
                 * Set the 'commissionOverride' attribute value. Cat35 commission override.

                                                                                    Ref: Cat35 fare present.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_CCOV
                 * 
                 * @param commissionOverride
                 */
                public void setCommissionOverride(Boolean commissionOverride) {
                    this.commissionOverride = commissionOverride;
                }

                /** 
                 * Get the 'cat35DataOverwrite' attribute value. Cat35 data overwrite.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_CCDO
                 * 
                 * @return value
                 */
                public Boolean getCat35DataOverwrite() {
                    return cat35DataOverwrite;
                }

                /** 
                 * Set the 'cat35DataOverwrite' attribute value. Cat35 data overwrite.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_CCDO
                 * 
                 * @param cat35DataOverwrite
                 */
                public void setCat35DataOverwrite(Boolean cat35DataOverwrite) {
                    this.cat35DataOverwrite = cat35DataOverwrite;
                }

                /** 
                 * Get the 'netFare' attribute value. Net fare pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_NTP
                 * 
                 * @return value
                 */
                public Boolean getNetFare() {
                    return netFare;
                }

                /** 
                 * Set the 'netFare' attribute value. Net fare pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_NTP
                 * 
                 * @param netFare
                 */
                public void setNetFare(Boolean netFare) {
                    this.netFare = netFare;
                }

                /** 
                 * Get the 'itBTFare' attribute value. IT/BT fare pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITB
                 * 
                 * @return value
                 */
                public Boolean getItBTFare() {
                    return itBTFare;
                }

                /** 
                 * Set the 'itBTFare' attribute value. IT/BT fare pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITB
                 * 
                 * @param itBTFare
                 */
                public void setItBTFare(Boolean itBTFare) {
                    this.itBTFare = itBTFare;
                }

                /** 
                 * Get the 'displayOnlyNetFare' attribute value. Net fare display only pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_DOP
                 * 
                 * @return value
                 */
                public Boolean getDisplayOnlyNetFare() {
                    return displayOnlyNetFare;
                }

                /** 
                 * Set the 'displayOnlyNetFare' attribute value. Net fare display only pq.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_DOP
                 * 
                 * @param displayOnlyNetFare
                 */
                public void setDisplayOnlyNetFare(Boolean displayOnlyNetFare) {
                    this.displayOnlyNetFare = displayOnlyNetFare;
                }

                /** 
                 * Get the 'inclusiveTourFare' attribute value. Inclusive tour fare.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITT
                 * 
                 * @return value
                 */
                public Boolean getInclusiveTourFare() {
                    return inclusiveTourFare;
                }

                /** 
                 * Set the 'inclusiveTourFare' attribute value. Inclusive tour fare.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITT
                 * 
                 * @param inclusiveTourFare
                 */
                public void setInclusiveTourFare(Boolean inclusiveTourFare) {
                    this.inclusiveTourFare = inclusiveTourFare;
                }

                /** 
                 * Get the 'bulkTourFare' attribute value. Bulk tour fare.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITT
                 * 
                 * @return value
                 */
                public Boolean getBulkTourFare() {
                    return bulkTourFare;
                }

                /** 
                 * Set the 'bulkTourFare' attribute value. Bulk tour fare.

                                                                                    Ref: DM0Z_85_BC35 #DM0Z_85_ITT
                 * 
                 * @param bulkTourFare
                 */
                public void setBulkTourFare(Boolean bulkTourFare) {
                    this.bulkTourFare = bulkTourFare;
                }

                /** 
                 * Get the 'nonITBTFare' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getNonITBTFare() {
                    return nonITBTFare;
                }

                /** 
                 * Set the 'nonITBTFare' attribute value.
                 * 
                 * @param nonITBTFare
                 */
                public void setNonITBTFare(Boolean nonITBTFare) {
                    this.nonITBTFare = nonITBTFare;
                }
            }
            /** 
             * FareCalc line free Text

                                                                          Ref: DM0Z_A5_DATA
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="rateOfExchange"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareCalculation implements Serializable
            {
                private String text;
                private AmountPattern amount;
                private String rateOfExchange;

                /** 
                 * Get the 'Text' element value. FareCalc line free Text
                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. FareCalc line free Text
                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Amount' element value. Farecalc amount

                                                                                        Ref: amount: DM0Z_85_TNAT
                                                                                        decimal place: DM0Z_85_TNDP
                                                                                        currency code: DM0Z_85_TNCC
                 * 
                 * @return value
                 */
                public AmountPattern getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Farecalc amount

                                                                                        Ref: amount: DM0Z_85_TNAT
                                                                                        decimal place: DM0Z_85_TNDP
                                                                                        currency code: DM0Z_85_TNCC
                 * 
                 * @param amount
                 */
                public void setAmount(AmountPattern amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                    NUC conversion
                 * 
                 * @return value
                 */
                public String getRateOfExchange() {
                    return rateOfExchange;
                }

                /** 
                 * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                    NUC conversion
                 * 
                 * @param rateOfExchange
                 */
                public void setRateOfExchange(String rateOfExchange) {
                    this.rateOfExchange = rateOfExchange;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversion" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="fromCurrency"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="toCurrency"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="rateOfExchange"/>
             *     &lt;xs:attribute name="rateOfExchangeType">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class RateOfExchangeType -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:boolean" name="rateOfExchangeOverride"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CurrencyConversion implements Serializable
            {
                private String fromCurrency;
                private String toCurrency;
                private String rateOfExchange;
                private RateOfExchangeType rateOfExchangeType;
                private Boolean rateOfExchangeOverride;

                /** 
                 * Get the 'fromCurrency' attribute value. Ref: DM0Z_85_BCUR
                                                                                    Base currency
                 * 
                 * @return value
                 */
                public String getFromCurrency() {
                    return fromCurrency;
                }

                /** 
                 * Set the 'fromCurrency' attribute value. Ref: DM0Z_85_BCUR
                                                                                    Base currency
                 * 
                 * @param fromCurrency
                 */
                public void setFromCurrency(String fromCurrency) {
                    this.fromCurrency = fromCurrency;
                }

                /** 
                 * Get the 'toCurrency' attribute value. Ref: DM0Z_85_ECUR
                                                                                    Equivalent currency
                 * 
                 * @return value
                 */
                public String getToCurrency() {
                    return toCurrency;
                }

                /** 
                 * Set the 'toCurrency' attribute value. Ref: DM0Z_85_ECUR
                                                                                    Equivalent currency
                 * 
                 * @param toCurrency
                 */
                public void setToCurrency(String toCurrency) {
                    this.toCurrency = toCurrency;
                }

                /** 
                 * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CCVN
                                                                                    Rate Of Exchange
                 * 
                 * @return value
                 */
                public String getRateOfExchange() {
                    return rateOfExchange;
                }

                /** 
                 * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CCVN
                                                                                    Rate Of Exchange
                 * 
                 * @param rateOfExchange
                 */
                public void setRateOfExchange(String rateOfExchange) {
                    this.rateOfExchange = rateOfExchange;
                }

                /** 
                 * Get the 'rateOfExchangeType' attribute value. Ref: DM0Z_85_CNVI
                                                                                    Possible values:
                                                                                    - Fixed
                                                                                    - BSR
                                                                                    - BBR
                                                                                    - ICH
                 * 
                 * @return value
                 */
                public RateOfExchangeType getRateOfExchangeType() {
                    return rateOfExchangeType;
                }

                /** 
                 * Set the 'rateOfExchangeType' attribute value. Ref: DM0Z_85_CNVI
                                                                                    Possible values:
                                                                                    - Fixed
                                                                                    - BSR
                                                                                    - BBR
                                                                                    - ICH
                 * 
                 * @param rateOfExchangeType
                 */
                public void setRateOfExchangeType(
                        RateOfExchangeType rateOfExchangeType) {
                    this.rateOfExchangeType = rateOfExchangeType;
                }

                /** 
                 * Get the 'rateOfExchangeOverride' attribute value. Ref: #DM0Z_85_COV
                                                                                    ROE override
                 * 
                 * @return value
                 */
                public Boolean getRateOfExchangeOverride() {
                    return rateOfExchangeOverride;
                }

                /** 
                 * Set the 'rateOfExchangeOverride' attribute value. Ref: #DM0Z_85_COV
                                                                                    ROE override
                 * 
                 * @param rateOfExchangeOverride
                 */
                public void setRateOfExchangeOverride(
                        Boolean rateOfExchangeOverride) {
                    this.rateOfExchangeOverride = rateOfExchangeOverride;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Fixed"/>
                 *     &lt;xs:enumeration value="ICH"/>
                 *     &lt;xs:enumeration value="BBR"/>
                 *     &lt;xs:enumeration value="BSR"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum RateOfExchangeType implements Serializable {
                    FIXED("Fixed"), ICH("ICH"), BBR("BBR"), BSR("BSR");
                    private final String value;

                    private RateOfExchangeType(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static RateOfExchangeType convert(String value) {
                        for (RateOfExchangeType inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Commission at Farelevel
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount" minOccurs="0">
             *         &lt;!-- Reference to inner class Amount -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
             *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherCommission -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Amount.Pattern" name="NewTicketFullCommission" minOccurs="0" maxOccurs="1"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="source"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private Amount amount;
                private BigDecimal percentage;
                private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                private AmountPattern newTicketFullCommission;
                private String source;
                private String type;

                /** 
                 * Get the 'Amount' element value.
                 * 
                 * @return value
                 */
                public Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value.
                 * 
                 * @param amount
                 */
                public void setAmount(Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' element value. Commision percentage
                 * 
                 * @return value
                 */
                public BigDecimal getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' element value. Commision percentage
                 * 
                 * @param percentage
                 */
                public void setPercentage(BigDecimal percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the list of 'OtherCommission' element items.
                 * 
                 * @return list
                 */
                public List<OtherCommission> getOtherCommissionList() {
                    return otherCommissionList;
                }

                /** 
                 * Set the list of 'OtherCommission' element items.
                 * 
                 * @param list
                 */
                public void setOtherCommissionList(List<OtherCommission> list) {
                    otherCommissionList = list;
                }

                /** 
                 * Get the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                        Ref: DM0Z_85_COMT
                                                                                    
                 * 
                 * @return value
                 */
                public AmountPattern getNewTicketFullCommission() {
                    return newTicketFullCommission;
                }

                /** 
                 * Set the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                        Ref: DM0Z_85_COMT
                                                                                    
                 * 
                 * @param newTicketFullCommission
                 */
                public void setNewTicketFullCommission(
                        AmountPattern newTicketFullCommission) {
                    this.newTicketFullCommission = newTicketFullCommission;
                }

                /** 
                 * Get the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Commision amount/penalty
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                 *         &lt;!-- Reference to inner class CommissionVerification -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="provider"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherCommission implements Serializable
                {
                    private Amount amount;
                    private CommissionVerification commissionVerification;
                    private String source;
                    private String provider;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CommissionVerification' element value.
                     * 
                     * @return value
                     */
                    public CommissionVerification getCommissionVerification() {
                        return commissionVerification;
                    }

                    /** 
                     * Set the 'CommissionVerification' element value.
                     * 
                     * @param commissionVerification
                     */
                    public void setCommissionVerification(
                            CommissionVerification commissionVerification) {
                        this.commissionVerification = commissionVerification;
                    }

                    /** 
                     * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'provider' attribute value.
                     * 
                     * @return value
                     */
                    public String getProvider() {
                        return provider;
                    }

                    /** 
                     * Set the 'provider' attribute value.
                     * 
                     * @param provider
                     */
                    public void setProvider(String provider) {
                        this.provider = provider;
                    }
                    /** 
                     * Commision amount based on type
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="type"/>
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String type;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                     *       &lt;xs:element name="Hierarchy" minOccurs="0">
                     *         &lt;!-- Reference to inner class Hierarchy -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="placement"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CommissionVerification implements
                        Serializable
                    {
                        private String controlQualifier;
                        private Hierarchy hierarchy;
                        private String verificationCode;
                        private String endorsement;
                        private String placement;

                        /** 
                         * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @return value
                         */
                        public String getControlQualifier() {
                            return controlQualifier;
                        }

                        /** 
                         * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @param controlQualifier
                         */
                        public void setControlQualifier(String controlQualifier) {
                            this.controlQualifier = controlQualifier;
                        }

                        /** 
                         * Get the 'Hierarchy' element value.
                         * 
                         * @return value
                         */
                        public Hierarchy getHierarchy() {
                            return hierarchy;
                        }

                        /** 
                         * Set the 'Hierarchy' element value.
                         * 
                         * @param hierarchy
                         */
                        public void setHierarchy(Hierarchy hierarchy) {
                            this.hierarchy = hierarchy;
                        }

                        /** 
                         * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @return value
                         */
                        public String getVerificationCode() {
                            return verificationCode;
                        }

                        /** 
                         * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @param verificationCode
                         */
                        public void setVerificationCode(String verificationCode) {
                            this.verificationCode = verificationCode;
                        }

                        /** 
                         * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @return value
                         */
                        public String getEndorsement() {
                            return endorsement;
                        }

                        /** 
                         * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @param endorsement
                         */
                        public void setEndorsement(String endorsement) {
                            this.endorsement = endorsement;
                        }

                        /** 
                         * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @return value
                         */
                        public String getPlacement() {
                            return placement;
                        }

                        /** 
                         * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @param placement
                         */
                        public void setPlacement(String placement) {
                            this.placement = placement;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Hierarchy implements Serializable
                        {
                            private BigInteger ticketDesignator;
                            private BigInteger tourNumber;
                            private BigInteger endorsement;

                            /** 
                             * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @return value
                             */
                            public BigInteger getTicketDesignator() {
                                return ticketDesignator;
                            }

                            /** 
                             * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @param ticketDesignator
                             */
                            public void setTicketDesignator(
                                    BigInteger ticketDesignator) {
                                this.ticketDesignator = ticketDesignator;
                            }

                            /** 
                             * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @return value
                             */
                            public BigInteger getTourNumber() {
                                return tourNumber;
                            }

                            /** 
                             * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @param tourNumber
                             */
                            public void setTourNumber(BigInteger tourNumber) {
                                this.tourNumber = tourNumber;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @return value
                             */
                            public BigInteger getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(BigInteger endorsement) {
                                this.endorsement = endorsement;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HandlingFee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private boolean description;
                private String code;
                private String type;
                private Boolean hidden;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Check if the 'Description' element is present.
                 * 
                 * @return <code>true</code> if present, <code>false</code> if not
                 */
                public boolean ifDescriptionPresent() {
                    return description;
                }

                /** 
                 * Set flag for 'Description' element present.
                 * 
                 * @param description
                 */
                public void flagDescriptionPresent(boolean description) {
                    this.description = description;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @return value
                 */
                public Boolean getHidden() {
                    return hidden;
                }

                /** 
                 * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @param hidden
                 */
                public void setHidden(Boolean hidden) {
                    this.hidden = hidden;
                }
            }
            /** 
             * Optional services bundled with the fare
                                                                          Ref: DM0Z_E7_...
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="quantity"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OptionalServiceInfo implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String description;
                private String type;
                private BigInteger quantity;
                private String code;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @return value
                 */
                public BigInteger getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @param quantity
                 */
                public void setQuantity(BigInteger quantity) {
                    this.quantity = quantity;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" minOccurs="0" maxOccurs="30">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FlightSegmentNumbers" minOccurs="0">
             *         &lt;!-- Reference to inner class FlightSegmentNumbers -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PriceQuote.Details.FareComponent.FlightSegment" name="FlightSegment" minOccurs="0" maxOccurs="30"/>
             *       &lt;xs:element name="FareDirectionality" minOccurs="0">
             *         &lt;!-- Reference to inner class FareDirectionality -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Details.OrigDest" name="Departure" minOccurs="0"/>
             *       &lt;xs:element type="ns:Details.OrigDest" name="Arrival" minOccurs="0"/>
             *       &lt;xs:element name="Amount" minOccurs="0">
             *         &lt;!-- Reference to inner class Amount -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="GoverningCarrier" minOccurs="0">
             *         &lt;!-- Reference to inner class GoverningCarrier -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
             *       &lt;xs:element name="RetailerRuleQualifier" minOccurs="0">
             *         &lt;!-- Reference to inner class RetailerRuleQualifier -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="CorpIdOrAcctCd" minOccurs="0"/>
             *       &lt;xs:element name="BrandInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class BrandInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Rules" minOccurs="0">
             *         &lt;!-- Reference to inner class Rules -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Amount.Discount" name="Discount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ContractNumber" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount" name="Plusup" minOccurs="0"/>
             *       &lt;xs:element name="CommissionDetail" minOccurs="0">
             *         &lt;!-- Reference to inner class CommissionDetail -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HighestIntermediatePoint" minOccurs="0">
             *         &lt;!-- Reference to inner class HighestIntermediatePoint -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareIndicators" minOccurs="0">
             *         &lt;!-- Reference to inner class FareIndicators -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Mileage" minOccurs="0">
             *         &lt;!-- Reference to inner class Mileage -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="DynamicPricingId" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="typeBitmap"/>
             *     &lt;xs:attribute type="xs:int" name="number"/>
             *     &lt;xs:attribute type="xs:string" name="fareBasisCode"/>
             *     &lt;xs:attribute type="xs:string" name="primaryGoverningCarrier"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareComponent implements Serializable
            {
                private FlightSegmentNumbers flightSegmentNumbers;
                private List<PriceQuoteDetailsFareComponentFlightSegment> flightSegmentList = new ArrayList<PriceQuoteDetailsFareComponentFlightSegment>();
                private FareDirectionality fareDirectionality;
                private DetailsOrigDest departure;
                private DetailsOrigDest arrival;
                private Amount amount;
                private GoverningCarrier governingCarrier;
                private List<String> ticketDesignatorList = new ArrayList<String>();
                private RetailerRuleQualifier retailerRuleQualifier;
                private String corpIdOrAcctCd;
                private BrandInfo brandInfo;
                private Rules rules;
                private AmountDiscount discount;
                private String contractNumber;
                private com.sabre.services.sp.pd.v35.Amount plusup;
                private CommissionDetail commissionDetail;
                private HighestIntermediatePoint highestIntermediatePoint;
                private FareIndicators fareIndicators;
                private Mileage mileage;
                private String dynamicPricingId;
                private String type;
                private String typeBitmap;
                private Integer number;
                private String fareBasisCode;
                private String primaryGoverningCarrier;

                /** 
                 * Get the 'FlightSegmentNumbers' element value.
                 * 
                 * @return value
                 */
                public FlightSegmentNumbers getFlightSegmentNumbers() {
                    return flightSegmentNumbers;
                }

                /** 
                 * Set the 'FlightSegmentNumbers' element value.
                 * 
                 * @param flightSegmentNumbers
                 */
                public void setFlightSegmentNumbers(
                        FlightSegmentNumbers flightSegmentNumbers) {
                    this.flightSegmentNumbers = flightSegmentNumbers;
                }

                /** 
                 * Get the list of 'FlightSegment' element items. Display flight segments number covered by this particular fare component.

                                                                                        Ref: DM0Z_70_SEGN
                 * 
                 * @return list
                 */
                public List<PriceQuoteDetailsFareComponentFlightSegment> getFlightSegmentList() {
                    return flightSegmentList;
                }

                /** 
                 * Set the list of 'FlightSegment' element items. Display flight segments number covered by this particular fare component.

                                                                                        Ref: DM0Z_70_SEGN
                 * 
                 * @param list
                 */
                public void setFlightSegmentList(
                        List<PriceQuoteDetailsFareComponentFlightSegment> list) {
                    flightSegmentList = list;
                }

                /** 
                 * Get the 'FareDirectionality' element value.
                 * 
                 * @return value
                 */
                public FareDirectionality getFareDirectionality() {
                    return fareDirectionality;
                }

                /** 
                 * Set the 'FareDirectionality' element value.
                 * 
                 * @param fareDirectionality
                 */
                public void setFareDirectionality(
                        FareDirectionality fareDirectionality) {
                    this.fareDirectionality = fareDirectionality;
                }

                /** 
                 * Get the 'Departure' element value. Ref: DM0Z_75_1CTY
                 * 
                 * @return value
                 */
                public DetailsOrigDest getDeparture() {
                    return departure;
                }

                /** 
                 * Set the 'Departure' element value. Ref: DM0Z_75_1CTY
                 * 
                 * @param departure
                 */
                public void setDeparture(DetailsOrigDest departure) {
                    this.departure = departure;
                }

                /** 
                 * Get the 'Arrival' element value. Ref: DM0Z_75_2CTY
                 * 
                 * @return value
                 */
                public DetailsOrigDest getArrival() {
                    return arrival;
                }

                /** 
                 * Set the 'Arrival' element value. Ref: DM0Z_75_2CTY
                 * 
                 * @param arrival
                 */
                public void setArrival(DetailsOrigDest arrival) {
                    this.arrival = arrival;
                }

                /** 
                 * Get the 'Amount' element value.
                 * 
                 * @return value
                 */
                public Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value.
                 * 
                 * @param amount
                 */
                public void setAmount(Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'GoverningCarrier' element value.
                 * 
                 * @return value
                 */
                public GoverningCarrier getGoverningCarrier() {
                    return governingCarrier;
                }

                /** 
                 * Set the 'GoverningCarrier' element value.
                 * 
                 * @param governingCarrier
                 */
                public void setGoverningCarrier(
                        GoverningCarrier governingCarrier) {
                    this.governingCarrier = governingCarrier;
                }

                /** 
                 * Get the list of 'TicketDesignator' element items. Return Ticket Designator Code attached to Fare Basis Code

                                                                                        Ref: DM0Z_75_TDSG
                 * 
                 * @return list
                 */
                public List<String> getTicketDesignatorList() {
                    return ticketDesignatorList;
                }

                /** 
                 * Set the list of 'TicketDesignator' element items. Return Ticket Designator Code attached to Fare Basis Code

                                                                                        Ref: DM0Z_75_TDSG
                 * 
                 * @param list
                 */
                public void setTicketDesignatorList(List<String> list) {
                    ticketDesignatorList = list;
                }

                /** 
                 * Get the 'RetailerRuleQualifier' element value.
                 * 
                 * @return value
                 */
                public RetailerRuleQualifier getRetailerRuleQualifier() {
                    return retailerRuleQualifier;
                }

                /** 
                 * Set the 'RetailerRuleQualifier' element value.
                 * 
                 * @param retailerRuleQualifier
                 */
                public void setRetailerRuleQualifier(
                        RetailerRuleQualifier retailerRuleQualifier) {
                    this.retailerRuleQualifier = retailerRuleQualifier;
                }

                /** 
                 * Get the 'CorpIdOrAcctCd' element value. Ref: DM0Z_75_CRID
                                                                                    
                 * 
                 * @return value
                 */
                public String getCorpIdOrAcctCd() {
                    return corpIdOrAcctCd;
                }

                /** 
                 * Set the 'CorpIdOrAcctCd' element value. Ref: DM0Z_75_CRID
                                                                                    
                 * 
                 * @param corpIdOrAcctCd
                 */
                public void setCorpIdOrAcctCd(String corpIdOrAcctCd) {
                    this.corpIdOrAcctCd = corpIdOrAcctCd;
                }

                /** 
                 * Get the 'BrandInfo' element value.
                 * 
                 * @return value
                 */
                public BrandInfo getBrandInfo() {
                    return brandInfo;
                }

                /** 
                 * Set the 'BrandInfo' element value.
                 * 
                 * @param brandInfo
                 */
                public void setBrandInfo(BrandInfo brandInfo) {
                    this.brandInfo = brandInfo;
                }

                /** 
                 * Get the 'Rules' element value.
                 * 
                 * @return value
                 */
                public Rules getRules() {
                    return rules;
                }

                /** 
                 * Set the 'Rules' element value.
                 * 
                 * @param rules
                 */
                public void setRules(Rules rules) {
                    this.rules = rules;
                }

                /** 
                 * Get the 'Discount' element value. Discount applied
                 * 
                 * @return value
                 */
                public AmountDiscount getDiscount() {
                    return discount;
                }

                /** 
                 * Set the 'Discount' element value. Discount applied
                 * 
                 * @param discount
                 */
                public void setDiscount(AmountDiscount discount) {
                    this.discount = discount;
                }

                /** 
                 * Get the 'ContractNumber' element value. Contract Number
                                                                                        Ref: DM0Z_75_CTNR
                 * 
                 * @return value
                 */
                public String getContractNumber() {
                    return contractNumber;
                }

                /** 
                 * Set the 'ContractNumber' element value. Contract Number
                                                                                        Ref: DM0Z_75_CTNR
                 * 
                 * @param contractNumber
                 */
                public void setContractNumber(String contractNumber) {
                    this.contractNumber = contractNumber;
                }

                /** 
                 * Get the 'Plusup' element value. Plusup Amount

                                                                                        Ref: DM0Z_A0_AMNT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getPlusup() {
                    return plusup;
                }

                /** 
                 * Set the 'Plusup' element value. Plusup Amount

                                                                                        Ref: DM0Z_A0_AMNT
                 * 
                 * @param plusup
                 */
                public void setPlusup(com.sabre.services.sp.pd.v35.Amount plusup) {
                    this.plusup = plusup;
                }

                /** 
                 * Get the 'CommissionDetail' element value.
                 * 
                 * @return value
                 */
                public CommissionDetail getCommissionDetail() {
                    return commissionDetail;
                }

                /** 
                 * Set the 'CommissionDetail' element value.
                 * 
                 * @param commissionDetail
                 */
                public void setCommissionDetail(
                        CommissionDetail commissionDetail) {
                    this.commissionDetail = commissionDetail;
                }

                /** 
                 * Get the 'HighestIntermediatePoint' element value.
                 * 
                 * @return value
                 */
                public HighestIntermediatePoint getHighestIntermediatePoint() {
                    return highestIntermediatePoint;
                }

                /** 
                 * Set the 'HighestIntermediatePoint' element value.
                 * 
                 * @param highestIntermediatePoint
                 */
                public void setHighestIntermediatePoint(
                        HighestIntermediatePoint highestIntermediatePoint) {
                    this.highestIntermediatePoint = highestIntermediatePoint;
                }

                /** 
                 * Get the 'FareIndicators' element value.
                 * 
                 * @return value
                 */
                public FareIndicators getFareIndicators() {
                    return fareIndicators;
                }

                /** 
                 * Set the 'FareIndicators' element value.
                 * 
                 * @param fareIndicators
                 */
                public void setFareIndicators(FareIndicators fareIndicators) {
                    this.fareIndicators = fareIndicators;
                }

                /** 
                 * Get the 'Mileage' element value.
                 * 
                 * @return value
                 */
                public Mileage getMileage() {
                    return mileage;
                }

                /** 
                 * Set the 'Mileage' element value.
                 * 
                 * @param mileage
                 */
                public void setMileage(Mileage mileage) {
                    this.mileage = mileage;
                }

                /** 
                 * Get the 'DynamicPricingId' element value. Dynamic Pricing Id
                                                                                        Ref: DM0Z_A9_DPID
                 * 
                 * @return value
                 */
                public String getDynamicPricingId() {
                    return dynamicPricingId;
                }

                /** 
                 * Set the 'DynamicPricingId' element value. Dynamic Pricing Id
                                                                                        Ref: DM0Z_A9_DPID
                 * 
                 * @param dynamicPricingId
                 */
                public void setDynamicPricingId(String dynamicPricingId) {
                    this.dynamicPricingId = dynamicPricingId;
                }

                /** 
                 * Get the 'type' attribute value. Fare Type
                                                                                    Ref: DM0Z_75_FATY
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Fare Type
                                                                                    Ref: DM0Z_75_FATY
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'typeBitmap' attribute value. Fare Type Bitmap
                                                                                    Ref: DM0Z_75_FATP
                 * 
                 * @return value
                 */
                public String getTypeBitmap() {
                    return typeBitmap;
                }

                /** 
                 * Set the 'typeBitmap' attribute value. Fare Type Bitmap
                                                                                    Ref: DM0Z_75_FATP
                 * 
                 * @param typeBitmap
                 */
                public void setTypeBitmap(String typeBitmap) {
                    this.typeBitmap = typeBitmap;
                }

                /** 
                 * Get the 'number' attribute value. Display number of fare component stored in PQ
                                                                                    Ref: DM0Z_75_FCNR
                 * 
                 * @return value
                 */
                public Integer getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Display number of fare component stored in PQ
                                                                                    Ref: DM0Z_75_FCNR
                 * 
                 * @param number
                 */
                public void setNumber(Integer number) {
                    this.number = number;
                }

                /** 
                 * Get the 'fareBasisCode' attribute value. Fare Basis Code for particular Fare Component

                                                                                    Ref: DM0Z_75_FBCD
                 * 
                 * @return value
                 */
                public String getFareBasisCode() {
                    return fareBasisCode;
                }

                /** 
                 * Set the 'fareBasisCode' attribute value. Fare Basis Code for particular Fare Component

                                                                                    Ref: DM0Z_75_FBCD
                 * 
                 * @param fareBasisCode
                 */
                public void setFareBasisCode(String fareBasisCode) {
                    this.fareBasisCode = fareBasisCode;
                }

                /** 
                 * Get the 'primaryGoverningCarrier' attribute value. Ref: DM0Z_75_GCR1
                 * 
                 * @return value
                 */
                public String getPrimaryGoverningCarrier() {
                    return primaryGoverningCarrier;
                }

                /** 
                 * Set the 'primaryGoverningCarrier' attribute value. Ref: DM0Z_75_GCR1
                 * 
                 * @param primaryGoverningCarrier
                 */
                public void setPrimaryGoverningCarrier(
                        String primaryGoverningCarrier) {
                    this.primaryGoverningCarrier = primaryGoverningCarrier;
                }
                /** 
                 * Display flight segments number covered by this particular fare component.

                                                                                        Ref: DM0Z_70_SEGN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentNumbers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:integer" name="SegmentNumber" minOccurs="1" maxOccurs="30"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlightSegmentNumbers implements
                    Serializable
                {
                    private List<BigInteger> segmentNumberList = new ArrayList<BigInteger>();

                    /** 
                     * Get the list of 'SegmentNumber' element items.
                     * 
                     * @return list
                     */
                    public List<BigInteger> getSegmentNumberList() {
                        return segmentNumberList;
                    }

                    /** 
                     * Set the list of 'SegmentNumber' element items.
                     * 
                     * @param list
                     */
                    public void setSegmentNumberList(List<BigInteger> list) {
                        segmentNumberList = list;
                    }
                }
                /** 
                 * Directionality of the fare Possible values:
                                                                                        Round trip
                                                                                        One way
                                                                                        One way directional
                                                                                        Inbound
                                                                                        Ref: DM0Z_75_IND1
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDirectionality" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="roundTrip"/>
                 *     &lt;xs:attribute type="xs:boolean" name="oneWay"/>
                 *     &lt;xs:attribute type="xs:boolean" name="oneWayDirectional"/>
                 *     &lt;xs:attribute type="xs:boolean" name="inbound"/>
                 *     &lt;xs:attribute type="xs:string" name="globalDirection"/>
                 *     &lt;xs:attribute type="xs:boolean" name="extraMileageAllowanceInd"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareDirectionality implements Serializable
                {
                    private Boolean roundTrip;
                    private Boolean oneWay;
                    private Boolean oneWayDirectional;
                    private Boolean inbound;
                    private String globalDirection;
                    private Boolean extraMileageAllowanceInd;

                    /** 
                     * Get the 'roundTrip' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_RFR   X'80'   eRound trip fare
                                                                                              
                     * 
                     * @return value
                     */
                    public Boolean getRoundTrip() {
                        return roundTrip;
                    }

                    /** 
                     * Set the 'roundTrip' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_RFR   X'80'   eRound trip fare
                                                                                              
                     * 
                     * @param roundTrip
                     */
                    public void setRoundTrip(Boolean roundTrip) {
                        this.roundTrip = roundTrip;
                    }

                    /** 
                     * Get the 'oneWay' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_OWF   EQU X'40'   eOne way fare
                                                                                              
                     * 
                     * @return value
                     */
                    public Boolean getOneWay() {
                        return oneWay;
                    }

                    /** 
                     * Set the 'oneWay' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_OWF   EQU X'40'   eOne way fare
                                                                                              
                     * 
                     * @param oneWay
                     */
                    public void setOneWay(Boolean oneWay) {
                        this.oneWay = oneWay;
                    }

                    /** 
                     * Get the 'oneWayDirectional' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_OWD    EQU X'20'   eOne way directional fare
                                                                                              
                     * 
                     * @return value
                     */
                    public Boolean getOneWayDirectional() {
                        return oneWayDirectional;
                    }

                    /** 
                     * Set the 'oneWayDirectional' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_OWD    EQU X'20'   eOne way directional fare
                                                                                              
                     * 
                     * @param oneWayDirectional
                     */
                    public void setOneWayDirectional(Boolean oneWayDirectional) {
                        this.oneWayDirectional = oneWayDirectional;
                    }

                    /** 
                     * Get the 'inbound' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_IFR    EQU X'02'   eInbound fare
                     * 
                     * @return value
                     */
                    public Boolean getInbound() {
                        return inbound;
                    }

                    /** 
                     * Set the 'inbound' attribute value. DM0Z_75_IND1
                                                                                                  #DM0Z_75_IFR    EQU X'02'   eInbound fare
                     * 
                     * @param inbound
                     */
                    public void setInbound(Boolean inbound) {
                        this.inbound = inbound;
                    }

                    /** 
                     * Get the 'globalDirection' attribute value. Global Direction
                                                                                                  Ref: DM0Z_70_GBLI
                     * 
                     * @return value
                     */
                    public String getGlobalDirection() {
                        return globalDirection;
                    }

                    /** 
                     * Set the 'globalDirection' attribute value. Global Direction
                                                                                                  Ref: DM0Z_70_GBLI
                     * 
                     * @param globalDirection
                     */
                    public void setGlobalDirection(String globalDirection) {
                        this.globalDirection = globalDirection;
                    }

                    /** 
                     * Get the 'extraMileageAllowanceInd' attribute value. Extra mileage allowance indicator

                                                                                                  Ref:
                                                                                                  DM0Z_75_IND1
                                                                                                  ##DM0Z_75_EML EQU X'10'
                     * 
                     * @return value
                     */
                    public Boolean getExtraMileageAllowanceInd() {
                        return extraMileageAllowanceInd;
                    }

                    /** 
                     * Set the 'extraMileageAllowanceInd' attribute value. Extra mileage allowance indicator

                                                                                                  Ref:
                                                                                                  DM0Z_75_IND1
                                                                                                  ##DM0Z_75_EML EQU X'10'
                     * 
                     * @param extraMileageAllowanceInd
                     */
                    public void setExtraMileageAllowanceInd(
                            Boolean extraMileageAllowanceInd) {
                        this.extraMileageAllowanceInd = extraMileageAllowanceInd;
                    }
                }
                /** 
                 * Return NUC amount for particular Fare Component

                                                                                        Ref:  DM0Z_75_FAMT
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:unsignedInt" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private String decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public String getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(String decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Return Governing Carrier Code
                                                                                        Ref: DM0Z_75_GCR1
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GoverningCarrier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:anySimpleType" name="type"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GoverningCarrier implements Serializable
                {
                    private String string;
                    private String type;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'type' attribute value. Possible values:
                                                                                                          primary
                                                                                                          secondary
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Possible values:
                                                                                                          primary
                                                                                                          secondary
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
                /** 
                 * Qualifier used across fare quote, pricing, shopping and ticketing.

                                                                                        Ref: DM0Z_76_TIDX x'C4
                                                                                        DM0Z_76_RC1
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRuleQualifier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RetailerRuleQualifier implements
                    Serializable
                {
                    private String code;

                    /** 
                     * Get the 'code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Brand information at the fare component level

                                                                                        Ref: DM0Z_76_BR
                                                                                    
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="brandCode"/>
                 *     &lt;xs:attribute type="xs:string" name="brandDescription"/>
                 *     &lt;xs:attribute type="xs:string" name="programCode"/>
                 *     &lt;xs:attribute type="xs:string" name="programDescription"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BrandInfo implements Serializable
                {
                    private String brandCode;
                    private String brandDescription;
                    private String programCode;
                    private String programDescription;

                    /** 
                     * Get the 'brandCode' attribute value. Brand Code
                                                                                                  Ref: DM0Z_76_BR_SB2	
                     * 
                     * @return value
                     */
                    public String getBrandCode() {
                        return brandCode;
                    }

                    /** 
                     * Set the 'brandCode' attribute value. Brand Code
                                                                                                  Ref: DM0Z_76_BR_SB2	
                     * 
                     * @param brandCode
                     */
                    public void setBrandCode(String brandCode) {
                        this.brandCode = brandCode;
                    }

                    /** 
                     * Get the 'brandDescription' attribute value. Brand Description
                                                                                                  Ref: DM0Z_76_BR_SB3	
                     * 
                     * @return value
                     */
                    public String getBrandDescription() {
                        return brandDescription;
                    }

                    /** 
                     * Set the 'brandDescription' attribute value. Brand Description
                                                                                                  Ref: DM0Z_76_BR_SB3	
                     * 
                     * @param brandDescription
                     */
                    public void setBrandDescription(String brandDescription) {
                        this.brandDescription = brandDescription;
                    }

                    /** 
                     * Get the 'programCode' attribute value. Program Code
                                                                                                  Ref: DM0Z_76_BR_SC0	
                     * 
                     * @return value
                     */
                    public String getProgramCode() {
                        return programCode;
                    }

                    /** 
                     * Set the 'programCode' attribute value. Program Code
                                                                                                  Ref: DM0Z_76_BR_SC0	
                     * 
                     * @param programCode
                     */
                    public void setProgramCode(String programCode) {
                        this.programCode = programCode;
                    }

                    /** 
                     * Get the 'programDescription' attribute value. Program Description
                                                                                                  Ref: DM0Z_76_BR_SC2	
                     * 
                     * @return value
                     */
                    public String getProgramDescription() {
                        return programDescription;
                    }

                    /** 
                     * Set the 'programDescription' attribute value. Program Description
                                                                                                  Ref: DM0Z_76_BR_SC2	
                     * 
                     * @param programDescription
                     */
                    public void setProgramDescription(String programDescription) {
                        this.programDescription = programDescription;
                    }
                }
                /** 
                 * Fare Rules
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rules" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="vendor"/>
                 *     &lt;xs:attribute type="xs:string" name="carrier"/>
                 *     &lt;xs:attribute type="xs:string" name="tariff"/>
                 *     &lt;xs:attribute type="xs:string" name="rule"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Rules implements Serializable
                {
                    private String vendor;
                    private String carrier;
                    private String tariff;
                    private String rule;

                    /** 
                     * Get the 'vendor' attribute value. Vendor Code
                                                                                                  Ref: DM0Z_70_VCDE
                     * 
                     * @return value
                     */
                    public String getVendor() {
                        return vendor;
                    }

                    /** 
                     * Set the 'vendor' attribute value. Vendor Code
                                                                                                  Ref: DM0Z_70_VCDE
                     * 
                     * @param vendor
                     */
                    public void setVendor(String vendor) {
                        this.vendor = vendor;
                    }

                    /** 
                     * Get the 'carrier' attribute value. Governing Carrier
                                                                                                  Ref: DM0Z_70_GCR1
                     * 
                     * @return value
                     */
                    public String getCarrier() {
                        return carrier;
                    }

                    /** 
                     * Set the 'carrier' attribute value. Governing Carrier
                                                                                                  Ref: DM0Z_70_GCR1
                     * 
                     * @param carrier
                     */
                    public void setCarrier(String carrier) {
                        this.carrier = carrier;
                    }

                    /** 
                     * Get the 'tariff' attribute value. Tariff Number
                                                                                                  Ref: DM0Z_70_TARN
                     * 
                     * @return value
                     */
                    public String getTariff() {
                        return tariff;
                    }

                    /** 
                     * Set the 'tariff' attribute value. Tariff Number
                                                                                                  Ref: DM0Z_70_TARN
                     * 
                     * @param tariff
                     */
                    public void setTariff(String tariff) {
                        this.tariff = tariff;
                    }

                    /** 
                     * Get the 'rule' attribute value. Rule Category
                                                                                                  Ref:DM0Z_70_RCAT
                     * 
                     * @return value
                     */
                    public String getRule() {
                        return rule;
                    }

                    /** 
                     * Set the 'rule' attribute value. Rule Category
                                                                                                  Ref:DM0Z_70_RCAT
                     * 
                     * @param rule
                     */
                    public void setRule(String rule) {
                        this.rule = rule;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionDetail" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="MethodId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RuleId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ContractId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RuleFamilyId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ContractFamilyId" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CommissionDetail implements Serializable
                {
                    private String methodId;
                    private String ruleId;
                    private String contractId;
                    private String ruleFamilyId;
                    private String contractFamilyId;

                    /** 
                     * Get the 'MethodId' element value. Method Id

                                                                                                      Ref: DM0Z_76_C3R_RULE
                     * 
                     * @return value
                     */
                    public String getMethodId() {
                        return methodId;
                    }

                    /** 
                     * Set the 'MethodId' element value. Method Id

                                                                                                      Ref: DM0Z_76_C3R_RULE
                     * 
                     * @param methodId
                     */
                    public void setMethodId(String methodId) {
                        this.methodId = methodId;
                    }

                    /** 
                     * Get the 'RuleId' element value. Rule Id

                                                                                                      Ref: DM0Z_76_C3P_PRGM
                     * 
                     * @return value
                     */
                    public String getRuleId() {
                        return ruleId;
                    }

                    /** 
                     * Set the 'RuleId' element value. Rule Id

                                                                                                      Ref: DM0Z_76_C3P_PRGM
                     * 
                     * @param ruleId
                     */
                    public void setRuleId(String ruleId) {
                        this.ruleId = ruleId;
                    }

                    /** 
                     * Get the 'ContractId' element value. Contract Id

                                                                                                      Ref: DM0Z_76_C3C_CNTR
                     * 
                     * @return value
                     */
                    public String getContractId() {
                        return contractId;
                    }

                    /** 
                     * Set the 'ContractId' element value. Contract Id

                                                                                                      Ref: DM0Z_76_C3C_CNTR
                     * 
                     * @param contractId
                     */
                    public void setContractId(String contractId) {
                        this.contractId = contractId;
                    }

                    /** 
                     * Get the 'RuleFamilyId' element value. Rule Family Id

                                                                                                      Ref: DM0Z_76_C4P_FMID
                     * 
                     * @return value
                     */
                    public String getRuleFamilyId() {
                        return ruleFamilyId;
                    }

                    /** 
                     * Set the 'RuleFamilyId' element value. Rule Family Id

                                                                                                      Ref: DM0Z_76_C4P_FMID
                     * 
                     * @param ruleFamilyId
                     */
                    public void setRuleFamilyId(String ruleFamilyId) {
                        this.ruleFamilyId = ruleFamilyId;
                    }

                    /** 
                     * Get the 'ContractFamilyId' element value. Contract Family Id

                                                                                                      Ref: DM0Z_76_C4C_FMID
                     * 
                     * @return value
                     */
                    public String getContractFamilyId() {
                        return contractFamilyId;
                    }

                    /** 
                     * Set the 'ContractFamilyId' element value. Contract Family Id

                                                                                                      Ref: DM0Z_76_C4C_FMID
                     * 
                     * @param contractFamilyId
                     */
                    public void setContractFamilyId(String contractFamilyId) {
                        this.contractFamilyId = contractFamilyId;
                    }
                }
                /** 
                 * Highest intermediate point
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HighestIntermediatePoint" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:Extended.CityCode" name="OriginCity" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Extended.CityCode" name="DestinationCity" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
                 *       &lt;xs:element type="xs:decimal" name="MileageSurchargePercent" minOccurs="0"/>
                 *       &lt;xs:element name="ClassDifferential" minOccurs="0" maxOccurs="2">
                 *         &lt;!-- Reference to inner class ClassDifferential -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HighestIntermediatePoint implements
                    Serializable
                {
                    private ExtendedCityCode originCity;
                    private ExtendedCityCode destinationCity;
                    private com.sabre.services.sp.pd.v35.Amount amount;
                    private BigDecimal mileageSurchargePercent;
                    private List<ClassDifferential> classDifferentialList = new ArrayList<ClassDifferential>();

                    /** 
                     * Get the 'OriginCity' element value. Origin city

                                                                                                      Ref:
                                                                                                      DM0Z_A0_CTY1
                                                                                                  
                     * 
                     * @return value
                     */
                    public ExtendedCityCode getOriginCity() {
                        return originCity;
                    }

                    /** 
                     * Set the 'OriginCity' element value. Origin city

                                                                                                      Ref:
                                                                                                      DM0Z_A0_CTY1
                                                                                                  
                     * 
                     * @param originCity
                     */
                    public void setOriginCity(ExtendedCityCode originCity) {
                        this.originCity = originCity;
                    }

                    /** 
                     * Get the 'DestinationCity' element value. Destination city

                                                                                                      Ref:
                                                                                                      DM0Z_A0_CTY2
                                                                                                  
                     * 
                     * @return value
                     */
                    public ExtendedCityCode getDestinationCity() {
                        return destinationCity;
                    }

                    /** 
                     * Set the 'DestinationCity' element value. Destination city

                                                                                                      Ref:
                                                                                                      DM0Z_A0_CTY2
                                                                                                  
                     * 
                     * @param destinationCity
                     */
                    public void setDestinationCity(
                            ExtendedCityCode destinationCity) {
                        this.destinationCity = destinationCity;
                    }

                    /** 
                     * Get the 'Amount' element value. Plusup/Surcharge amount

                                                                                                      Ref: DM0Z_A0_AMNT
                     * 
                     * @return value
                     */
                    public com.sabre.services.sp.pd.v35.Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Plusup/Surcharge amount

                                                                                                      Ref: DM0Z_A0_AMNT
                     * 
                     * @param amount
                     */
                    public void setAmount(
                            com.sabre.services.sp.pd.v35.Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'MileageSurchargePercent' element value. Surcharge description

                                                                                                      Ref: DM0Z_A0_MSUR
                     * 
                     * @return value
                     */
                    public BigDecimal getMileageSurchargePercent() {
                        return mileageSurchargePercent;
                    }

                    /** 
                     * Set the 'MileageSurchargePercent' element value. Surcharge description

                                                                                                      Ref: DM0Z_A0_MSUR
                     * 
                     * @param mileageSurchargePercent
                     */
                    public void setMileageSurchargePercent(
                            BigDecimal mileageSurchargePercent) {
                        this.mileageSurchargePercent = mileageSurchargePercent;
                    }

                    /** 
                     * Get the list of 'ClassDifferential' element items.
                     * 
                     * @return list
                     */
                    public List<ClassDifferential> getClassDifferentialList() {
                        return classDifferentialList;
                    }

                    /** 
                     * Set the list of 'ClassDifferential' element items.
                     * 
                     * @param list
                     */
                    public void setClassDifferentialList(
                            List<ClassDifferential> list) {
                        classDifferentialList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClassDifferential" minOccurs="0" maxOccurs="2">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="ns:Extended.CityCode" name="OriginCity" minOccurs="0"/>
                     *       &lt;xs:element type="ns:Extended.CityCode" name="DestinationCity" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="ns:Code.DifferentialType" name="hipType"/>
                     *     &lt;xs:attribute type="xs:string" name="cabin"/>
                     *     &lt;xs:attribute type="xs:string" name="fareBasisCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ClassDifferential implements
                        Serializable
                    {
                        private ExtendedCityCode originCity;
                        private ExtendedCityCode destinationCity;
                        private CodeDifferentialType hipType;
                        private String cabin;
                        private String fareBasisCode;

                        /** 
                         * Get the 'OriginCity' element value. Ref:
                                                                                                                    DM0Z_A0_CTY1  
                         * 
                         * @return value
                         */
                        public ExtendedCityCode getOriginCity() {
                            return originCity;
                        }

                        /** 
                         * Set the 'OriginCity' element value. Ref:
                                                                                                                    DM0Z_A0_CTY1  
                         * 
                         * @param originCity
                         */
                        public void setOriginCity(ExtendedCityCode originCity) {
                            this.originCity = originCity;
                        }

                        /** 
                         * Get the 'DestinationCity' element value. Ref:
                                                                                                                    DM0Z_A0_CTY2
                         * 
                         * @return value
                         */
                        public ExtendedCityCode getDestinationCity() {
                            return destinationCity;
                        }

                        /** 
                         * Set the 'DestinationCity' element value. Ref:
                                                                                                                    DM0Z_A0_CTY2
                         * 
                         * @param destinationCity
                         */
                        public void setDestinationCity(
                                ExtendedCityCode destinationCity) {
                            this.destinationCity = destinationCity;
                        }

                        /** 
                         * Get the 'hipType' attribute value. Possible values:
                                                                                                                - Low
                                                                                                                - High
                         * 
                         * @return value
                         */
                        public CodeDifferentialType getHipType() {
                            return hipType;
                        }

                        /** 
                         * Set the 'hipType' attribute value. Possible values:
                                                                                                                - Low
                                                                                                                - High
                         * 
                         * @param hipType
                         */
                        public void setHipType(CodeDifferentialType hipType) {
                            this.hipType = hipType;
                        }

                        /** 
                         * Get the 'cabin' attribute value. Ref: DM0Z_A0_CODE
                         * 
                         * @return value
                         */
                        public String getCabin() {
                            return cabin;
                        }

                        /** 
                         * Set the 'cabin' attribute value. Ref: DM0Z_A0_CODE
                         * 
                         * @param cabin
                         */
                        public void setCabin(String cabin) {
                            this.cabin = cabin;
                        }

                        /** 
                         * Get the 'fareBasisCode' attribute value. Ref: DM0Z_A0_2ND_FBCN/DM0Z_A0_FBCD
                         * 
                         * @return value
                         */
                        public String getFareBasisCode() {
                            return fareBasisCode;
                        }

                        /** 
                         * Set the 'fareBasisCode' attribute value. Ref: DM0Z_A0_2ND_FBCN/DM0Z_A0_FBCD
                         * 
                         * @param fareBasisCode
                         */
                        public void setFareBasisCode(String fareBasisCode) {
                            this.fareBasisCode = fareBasisCode;
                        }
                    }
                }
                /** 
                 * Fare indicators

                                                                                        Ref: DM0Z_75_FTYP
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicators" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="publishedFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="negotiatedFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="btsFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="zeroFlatFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="seamanFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="spouseFare"/>
                 *     &lt;xs:attribute type="xs:boolean" name="mileageFare"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareIndicators implements Serializable
                {
                    private Boolean publishedFare;
                    private Boolean negotiatedFare;
                    private Boolean btsFare;
                    private Boolean zeroFlatFare;
                    private Boolean seamanFare;
                    private Boolean spouseFare;
                    private Boolean mileageFare;

                    /** 
                     * Get the 'publishedFare' attribute value. Published fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_PUB
                     * 
                     * @return value
                     */
                    public Boolean getPublishedFare() {
                        return publishedFare;
                    }

                    /** 
                     * Set the 'publishedFare' attribute value. Published fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_PUB
                     * 
                     * @param publishedFare
                     */
                    public void setPublishedFare(Boolean publishedFare) {
                        this.publishedFare = publishedFare;
                    }

                    /** 
                     * Get the 'negotiatedFare' attribute value. Negotiaed fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_NEG
                     * 
                     * @return value
                     */
                    public Boolean getNegotiatedFare() {
                        return negotiatedFare;
                    }

                    /** 
                     * Set the 'negotiatedFare' attribute value. Negotiaed fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_NEG
                     * 
                     * @param negotiatedFare
                     */
                    public void setNegotiatedFare(Boolean negotiatedFare) {
                        this.negotiatedFare = negotiatedFare;
                    }

                    /** 
                     * Get the 'btsFare' attribute value. BTS fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_BTS
                     * 
                     * @return value
                     */
                    public Boolean getBtsFare() {
                        return btsFare;
                    }

                    /** 
                     * Set the 'btsFare' attribute value. BTS fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_BTS
                     * 
                     * @param btsFare
                     */
                    public void setBtsFare(Boolean btsFare) {
                        this.btsFare = btsFare;
                    }

                    /** 
                     * Get the 'zeroFlatFare' attribute value. Zero flat fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_ZFF
                     * 
                     * @return value
                     */
                    public Boolean getZeroFlatFare() {
                        return zeroFlatFare;
                    }

                    /** 
                     * Set the 'zeroFlatFare' attribute value. Zero flat fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_ZFF
                     * 
                     * @param zeroFlatFare
                     */
                    public void setZeroFlatFare(Boolean zeroFlatFare) {
                        this.zeroFlatFare = zeroFlatFare;
                    }

                    /** 
                     * Get the 'seamanFare' attribute value. Seaman fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_SEA
                     * 
                     * @return value
                     */
                    public Boolean getSeamanFare() {
                        return seamanFare;
                    }

                    /** 
                     * Set the 'seamanFare' attribute value. Seaman fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_SEA
                     * 
                     * @param seamanFare
                     */
                    public void setSeamanFare(Boolean seamanFare) {
                        this.seamanFare = seamanFare;
                    }

                    /** 
                     * Get the 'spouseFare' attribute value.  Spouse fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_SPH
                     * 
                     * @return value
                     */
                    public Boolean getSpouseFare() {
                        return spouseFare;
                    }

                    /** 
                     * Set the 'spouseFare' attribute value.  Spouse fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_SPH
                     * 
                     * @param spouseFare
                     */
                    public void setSpouseFare(Boolean spouseFare) {
                        this.spouseFare = spouseFare;
                    }

                    /** 
                     * Get the 'mileageFare' attribute value. Mileage fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_MIL
                     * 
                     * @return value
                     */
                    public Boolean getMileageFare() {
                        return mileageFare;
                    }

                    /** 
                     * Set the 'mileageFare' attribute value. Mileage fare indicator

                                                                                                  Ref: DM0Z_75_FTYP
                                                                                                  #DM0Z_75_MIL
                     * 
                     * @param mileageFare
                     */
                    public void setMileageFare(Boolean mileageFare) {
                        this.mileageFare = mileageFare;
                    }
                }
                /** 
                 * Mileage data
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:decimal" name="SurchargePercentage" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="EqualizationPointCity" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ExtraMileAllowCity" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Mileage implements Serializable
                {
                    private BigDecimal surchargePercentage;
                    private String equalizationPointCity;
                    private String extraMileAllowCity;

                    /** 
                     * Get the 'SurchargePercentage' element value. Mileage surcharge percentage

                                                                                                      Ref: DM0Z_75_MSUR
                     * 
                     * @return value
                     */
                    public BigDecimal getSurchargePercentage() {
                        return surchargePercentage;
                    }

                    /** 
                     * Set the 'SurchargePercentage' element value. Mileage surcharge percentage

                                                                                                      Ref: DM0Z_75_MSUR
                     * 
                     * @param surchargePercentage
                     */
                    public void setSurchargePercentage(
                            BigDecimal surchargePercentage) {
                        this.surchargePercentage = surchargePercentage;
                    }

                    /** 
                     * Get the 'EqualizationPointCity' element value. Mileage equalization point

                                                                                                      Ref: DM0Z_75_MEQU
                     * 
                     * @return value
                     */
                    public String getEqualizationPointCity() {
                        return equalizationPointCity;
                    }

                    /** 
                     * Set the 'EqualizationPointCity' element value. Mileage equalization point

                                                                                                      Ref: DM0Z_75_MEQU
                     * 
                     * @param equalizationPointCity
                     */
                    public void setEqualizationPointCity(
                            String equalizationPointCity) {
                        this.equalizationPointCity = equalizationPointCity;
                    }

                    /** 
                     * Get the 'ExtraMileAllowCity' element value. Extra mile allow city

                                                                                                      Ref: DM0Z_75_EMAC
                     * 
                     * @return value
                     */
                    public String getExtraMileAllowCity() {
                        return extraMileAllowCity;
                    }

                    /** 
                     * Set the 'ExtraMileAllowCity' element value. Extra mile allow city

                                                                                                      Ref: DM0Z_75_EMAC
                     * 
                     * @param extraMileAllowCity
                     */
                    public void setExtraMileAllowCity(String extraMileAllowCity) {
                        this.extraMileAllowCity = extraMileAllowCity;
                    }
                }
            }
            /** 
             * Stopover charge or Transfer charge
                                                                          to be populated only
                                                                          if DM0Z_A0_SKEY=x'58'
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopoverOrTransferCharge" minOccurs="0" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="Amount"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" name="count"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class StopoverOrTransferCharge implements
                Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount amount;
                private Integer count;

                /** 
                 * Get the 'Amount' element value. Stopover or transfer amount

                                                                                        Ref:
                                                                                        if DM0Z_A0_SKEY=x'58'
                                                                                        DM0Z_A0_AMNT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Stopover or transfer amount

                                                                                        Ref:
                                                                                        if DM0Z_A0_SKEY=x'58'
                                                                                        DM0Z_A0_AMNT
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'count' attribute value. Stopover or transfer count. The numeric part of the data to be considered only

                                                                                    e.g. - for  "2S" only "2" needs to be populated

                                                                                    Ref:
                                                                                    if DM0Z_A0_SKEY=x'58'
                                                                                    DM0Z_A0_SCDE
                 * 
                 * @return value
                 */
                public Integer getCount() {
                    return count;
                }

                /** 
                 * Set the 'count' attribute value. Stopover or transfer count. The numeric part of the data to be considered only

                                                                                    e.g. - for  "2S" only "2" needs to be populated

                                                                                    Ref:
                                                                                    if DM0Z_A0_SKEY=x'58'
                                                                                    DM0Z_A0_SCDE
                 * 
                 * @param count
                 */
                public void setCount(Integer count) {
                    this.count = count;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalFareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OriginalSellingFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginalSellingFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PublishedFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PublishedFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RetailerFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class RetailerFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemitInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemitInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PriceQuote.Details.NewSellingFareInfo" name="NewSellingFareinfo" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalFareInfo implements Serializable
        {
            private OriginalSellingFareInfo originalSellingFareInfo;
            private PublishedFareInfo publishedFareInfo;
            private RetailerFareInfo retailerFareInfo;
            private NetFareInfo netFareInfo;
            private NetRemitInfo netRemitInfo;
            private PriceQuoteDetailsNewSellingFareInfo newSellingFareinfo;

            /** 
             * Get the 'OriginalSellingFareInfo' element value.
             * 
             * @return value
             */
            public OriginalSellingFareInfo getOriginalSellingFareInfo() {
                return originalSellingFareInfo;
            }

            /** 
             * Set the 'OriginalSellingFareInfo' element value.
             * 
             * @param originalSellingFareInfo
             */
            public void setOriginalSellingFareInfo(
                    OriginalSellingFareInfo originalSellingFareInfo) {
                this.originalSellingFareInfo = originalSellingFareInfo;
            }

            /** 
             * Get the 'PublishedFareInfo' element value.
             * 
             * @return value
             */
            public PublishedFareInfo getPublishedFareInfo() {
                return publishedFareInfo;
            }

            /** 
             * Set the 'PublishedFareInfo' element value.
             * 
             * @param publishedFareInfo
             */
            public void setPublishedFareInfo(PublishedFareInfo publishedFareInfo) {
                this.publishedFareInfo = publishedFareInfo;
            }

            /** 
             * Get the 'RetailerFareInfo' element value.
             * 
             * @return value
             */
            public RetailerFareInfo getRetailerFareInfo() {
                return retailerFareInfo;
            }

            /** 
             * Set the 'RetailerFareInfo' element value.
             * 
             * @param retailerFareInfo
             */
            public void setRetailerFareInfo(RetailerFareInfo retailerFareInfo) {
                this.retailerFareInfo = retailerFareInfo;
            }

            /** 
             * Get the 'NetFareInfo' element value.
             * 
             * @return value
             */
            public NetFareInfo getNetFareInfo() {
                return netFareInfo;
            }

            /** 
             * Set the 'NetFareInfo' element value.
             * 
             * @param netFareInfo
             */
            public void setNetFareInfo(NetFareInfo netFareInfo) {
                this.netFareInfo = netFareInfo;
            }

            /** 
             * Get the 'NetRemitInfo' element value.
             * 
             * @return value
             */
            public NetRemitInfo getNetRemitInfo() {
                return netRemitInfo;
            }

            /** 
             * Set the 'NetRemitInfo' element value.
             * 
             * @param netRemitInfo
             */
            public void setNetRemitInfo(NetRemitInfo netRemitInfo) {
                this.netRemitInfo = netRemitInfo;
            }

            /** 
             * Get the 'NewSellingFareinfo' element value. New Selling Fare - applicable only for exchanages
             * 
             * @return value
             */
            public PriceQuoteDetailsNewSellingFareInfo getNewSellingFareinfo() {
                return newSellingFareinfo;
            }

            /** 
             * Set the 'NewSellingFareinfo' element value. New Selling Fare - applicable only for exchanages
             * 
             * @param newSellingFareinfo
             */
            public void setNewSellingFareinfo(
                    PriceQuoteDetailsNewSellingFareInfo newSellingFareinfo) {
                this.newSellingFareinfo = newSellingFareinfo;
            }
            /** 
             * Original selling fare is returned when the user is authorized to view it
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalSellingFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AdjustedAmount" minOccurs="0">
             *         &lt;!-- Reference to inner class AdjustedAmount -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginalSellingFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private FareTaxInfo taxInfo;
                private FareCalculation fareCalculation;
                private Commission commission;
                private AdjustedAmount adjustedAmount;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public FareTaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(FareTaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'AdjustedAmount' element value.
                 * 
                 * @return value
                 */
                public AdjustedAmount getAdjustedAmount() {
                    return adjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' element value.
                 * 
                 * @param adjustedAmount
                 */
                public void setAdjustedAmount(AdjustedAmount adjustedAmount) {
                    this.adjustedAmount = adjustedAmount;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="rateOfExchange"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String text;
                    private AmountPattern amount;
                    private String rateOfExchange;

                    /** 
                     * Get the 'Text' element value. FareCalc line free Text
                                                                                                      Ref: DM0Z_A5_DATA
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. FareCalc line free Text
                                                                                                      Ref: DM0Z_A5_DATA
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'Amount' element value. Farecalc amount

                                                                                                      Ref: amount: DM0Z_85_TNAT
                                                                                                      decimal place: DM0Z_85_TNDP
                                                                                                      currency code: DM0Z_85_TNCC
                     * 
                     * @return value
                     */
                    public AmountPattern getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Farecalc amount

                                                                                                      Ref: amount: DM0Z_85_TNAT
                                                                                                      decimal place: DM0Z_85_TNDP
                                                                                                      currency code: DM0Z_85_TNCC
                     * 
                     * @param amount
                     */
                    public void setAmount(AmountPattern amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                  NUC conversion
                     * 
                     * @return value
                     */
                    public String getRateOfExchange() {
                        return rateOfExchange;
                    }

                    /** 
                     * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                  NUC conversion
                     * 
                     * @param rateOfExchange
                     */
                    public void setRateOfExchange(String rateOfExchange) {
                        this.rateOfExchange = rateOfExchange;
                    }
                }
                /** 
                 * Holds commission associated to Orginal fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="ns:Amount.Pattern" name="NewTicketFullCommission" minOccurs="0" maxOccurs="1"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private AmountPattern newTicketFullCommission;
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                                      Ref: DM0Z_85_COMT
                                                                                                  
                     * 
                     * @return value
                     */
                    public AmountPattern getNewTicketFullCommission() {
                        return newTicketFullCommission;
                    }

                    /** 
                     * Set the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                                      Ref: DM0Z_85_COMT
                                                                                                  
                     * 
                     * @param newTicketFullCommission
                     */
                    public void setNewTicketFullCommission(
                            AmountPattern newTicketFullCommission) {
                        this.newTicketFullCommission = newTicketFullCommission;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
                /** 
                 * The amount by which the original selling fare was adjusted
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdjustedAmount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:Amount" name="Amount"/>
                 *       &lt;xs:element name="GSTTax" minOccurs="0" maxOccurs="4">
                 *         &lt;!-- Reference to inner class GSTTax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AdjustedAmount implements Serializable
                {
                    private com.sabre.services.sp.pd.v35.Amount amount;
                    private List<GSTTax> GSTTaxList = new ArrayList<GSTTax>();

                    /** 
                     * Get the 'Amount' element value. Adjusted Amount
                     * 
                     * @return value
                     */
                    public com.sabre.services.sp.pd.v35.Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Adjusted Amount
                     * 
                     * @param amount
                     */
                    public void setAmount(
                            com.sabre.services.sp.pd.v35.Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the list of 'GSTTax' element items.
                     * 
                     * @return list
                     */
                    public List<GSTTax> getGSTTaxList() {
                        return GSTTaxList;
                    }

                    /** 
                     * Set the list of 'GSTTax' element items.
                     * 
                     * @param list
                     */
                    public void setGSTTaxList(List<GSTTax> list) {
                        GSTTaxList = list;
                    }
                    /** 
                     * GST Taxes
                                                                                                  
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GSTTax" minOccurs="0" maxOccurs="4">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="ns:Amount" name="Amount"/>
                     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class GSTTax implements Serializable
                    {
                        private com.sabre.services.sp.pd.v35.Amount amount;
                        private String description;

                        /** 
                         * Get the 'Amount' element value. 
                                                                                                                    Ref: DM0Z_CF_HND_AMNT
                                                                                                                
                         * 
                         * @return value
                         */
                        public com.sabre.services.sp.pd.v35.Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value. 
                                                                                                                    Ref: DM0Z_CF_HND_AMNT
                                                                                                                
                         * 
                         * @param amount
                         */
                        public void setAmount(
                                com.sabre.services.sp.pd.v35.Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Description' element value. 
                                                                                                                    Ref: DM0Z_CF_HND_DESC
                                                                                                                
                         * 
                         * @return value
                         */
                        public String getDescription() {
                            return description;
                        }

                        /** 
                         * Set the 'Description' element value. 
                                                                                                                    Ref: DM0Z_CF_HND_DESC
                                                                                                                
                         * 
                         * @param description
                         */
                        public void setDescription(String description) {
                            this.description = description;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingFee implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private boolean description;
                    private String code;
                    private String type;
                    private Boolean hidden;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Check if the 'Description' element is present.
                     * 
                     * @return <code>true</code> if present, <code>false</code> if not
                     */
                    public boolean ifDescriptionPresent() {
                        return description;
                    }

                    /** 
                     * Set flag for 'Description' element present.
                     * 
                     * @param description
                     */
                    public void flagDescriptionPresent(boolean description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @return value
                     */
                    public Boolean getHidden() {
                        return hidden;
                    }

                    /** 
                     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @param hidden
                     */
                    public void setHidden(Boolean hidden) {
                        this.hidden = hidden;
                    }
                }
            }
            /** 
             * Equivalent to *PQP

                                                                          Ref: DM0Z_85_PUB 'x 01
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublishedFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PublishedFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private FareTaxInfo taxInfo;
                private FareCalculation fareCalculation;
                private Commission commission;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public FareTaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(FareTaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="rateOfExchange"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String text;
                    private AmountPattern amount;
                    private String rateOfExchange;

                    /** 
                     * Get the 'Text' element value. FareCalc line free Text
                                                                                                      Ref: DM0Z_A5_DATA
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. FareCalc line free Text
                                                                                                      Ref: DM0Z_A5_DATA
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'Amount' element value. Farecalc amount

                                                                                                      Ref: amount: DM0Z_85_TNAT
                                                                                                      decimal place: DM0Z_85_TNDP
                                                                                                      currency code: DM0Z_85_TNCC
                     * 
                     * @return value
                     */
                    public AmountPattern getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Farecalc amount

                                                                                                      Ref: amount: DM0Z_85_TNAT
                                                                                                      decimal place: DM0Z_85_TNDP
                                                                                                      currency code: DM0Z_85_TNCC
                     * 
                     * @param amount
                     */
                    public void setAmount(AmountPattern amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                  NUC conversion
                     * 
                     * @return value
                     */
                    public String getRateOfExchange() {
                        return rateOfExchange;
                    }

                    /** 
                     * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                  NUC conversion
                     * 
                     * @param rateOfExchange
                     */
                    public void setRateOfExchange(String rateOfExchange) {
                        this.rateOfExchange = rateOfExchange;
                    }
                }
                /** 
                 * Holds commission associated to Orginal fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="ns:Amount.Pattern" name="NewTicketFullCommission" minOccurs="0" maxOccurs="1"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private AmountPattern newTicketFullCommission;
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                                      Ref: DM0Z_85_COMT
                                                                                                  
                     * 
                     * @return value
                     */
                    public AmountPattern getNewTicketFullCommission() {
                        return newTicketFullCommission;
                    }

                    /** 
                     * Set the 'NewTicketFullCommission' element value. NEW TKT FULL COMMISSION AMOUNT
                                                                                                      Ref: DM0Z_85_COMT
                                                                                                  
                     * 
                     * @param newTicketFullCommission
                     */
                    public void setNewTicketFullCommission(
                            AmountPattern newTicketFullCommission) {
                        this.newTicketFullCommission = newTicketFullCommission;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
            }
            /** 
             * Maps to *PQ#R
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PriceQuote.Fare.AdjustedAmount" name="AdjustedAmount" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetailerFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private Commission commission;
                private FareTaxInfo taxInfo;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();
                private PriceQuoteFareAdjustedAmount adjustedAmount;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public FareTaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(FareTaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }

                /** 
                 * Get the 'AdjustedAmount' element value. The amount by which the retailer selling fare was adjusted
                 * 
                 * @return value
                 */
                public PriceQuoteFareAdjustedAmount getAdjustedAmount() {
                    return adjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' element value. The amount by which the retailer selling fare was adjusted
                 * 
                 * @param adjustedAmount
                 */
                public void setAdjustedAmount(
                        PriceQuoteFareAdjustedAmount adjustedAmount) {
                    this.adjustedAmount = adjustedAmount;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                                                                                        DM0Z_CA_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                                                                                        DM0Z_CA_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                                                                                        DM0Z_CA_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                                                                                        DM0Z_CA_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                 *         &lt;!-- Reference to inner class CommissionVerification -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="provider"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private CommissionVerification commissionVerification;
                    private String source;
                    private String provider;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CommissionVerification' element value.
                     * 
                     * @return value
                     */
                    public CommissionVerification getCommissionVerification() {
                        return commissionVerification;
                    }

                    /** 
                     * Set the 'CommissionVerification' element value.
                     * 
                     * @param commissionVerification
                     */
                    public void setCommissionVerification(
                            CommissionVerification commissionVerification) {
                        this.commissionVerification = commissionVerification;
                    }

                    /** 
                     * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'provider' attribute value.
                     * 
                     * @return value
                     */
                    public String getProvider() {
                        return provider;
                    }

                    /** 
                     * Set the 'provider' attribute value.
                     * 
                     * @param provider
                     */
                    public void setProvider(String provider) {
                        this.provider = provider;
                    }
                    /** 
                     * Commision amount based on type
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="type"/>
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String type;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                     *       &lt;xs:element name="Hierarchy" minOccurs="0">
                     *         &lt;!-- Reference to inner class Hierarchy -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="placement"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CommissionVerification implements
                        Serializable
                    {
                        private String controlQualifier;
                        private Hierarchy hierarchy;
                        private String verificationCode;
                        private String endorsement;
                        private String placement;

                        /** 
                         * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @return value
                         */
                        public String getControlQualifier() {
                            return controlQualifier;
                        }

                        /** 
                         * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @param controlQualifier
                         */
                        public void setControlQualifier(String controlQualifier) {
                            this.controlQualifier = controlQualifier;
                        }

                        /** 
                         * Get the 'Hierarchy' element value.
                         * 
                         * @return value
                         */
                        public Hierarchy getHierarchy() {
                            return hierarchy;
                        }

                        /** 
                         * Set the 'Hierarchy' element value.
                         * 
                         * @param hierarchy
                         */
                        public void setHierarchy(Hierarchy hierarchy) {
                            this.hierarchy = hierarchy;
                        }

                        /** 
                         * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @return value
                         */
                        public String getVerificationCode() {
                            return verificationCode;
                        }

                        /** 
                         * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @param verificationCode
                         */
                        public void setVerificationCode(String verificationCode) {
                            this.verificationCode = verificationCode;
                        }

                        /** 
                         * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @return value
                         */
                        public String getEndorsement() {
                            return endorsement;
                        }

                        /** 
                         * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @param endorsement
                         */
                        public void setEndorsement(String endorsement) {
                            this.endorsement = endorsement;
                        }

                        /** 
                         * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @return value
                         */
                        public String getPlacement() {
                            return placement;
                        }

                        /** 
                         * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @param placement
                         */
                        public void setPlacement(String placement) {
                            this.placement = placement;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Hierarchy implements Serializable
                        {
                            private BigInteger ticketDesignator;
                            private BigInteger tourNumber;
                            private BigInteger endorsement;

                            /** 
                             * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @return value
                             */
                            public BigInteger getTicketDesignator() {
                                return ticketDesignator;
                            }

                            /** 
                             * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @param ticketDesignator
                             */
                            public void setTicketDesignator(
                                    BigInteger ticketDesignator) {
                                this.ticketDesignator = ticketDesignator;
                            }

                            /** 
                             * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @return value
                             */
                            public BigInteger getTourNumber() {
                                return tourNumber;
                            }

                            /** 
                             * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @param tourNumber
                             */
                            public void setTourNumber(BigInteger tourNumber) {
                                this.tourNumber = tourNumber;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @return value
                             */
                            public BigInteger getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(BigInteger endorsement) {
                                this.endorsement = endorsement;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingFee implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private boolean description;
                    private String code;
                    private String type;
                    private Boolean hidden;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Check if the 'Description' element is present.
                     * 
                     * @return <code>true</code> if present, <code>false</code> if not
                     */
                    public boolean ifDescriptionPresent() {
                        return description;
                    }

                    /** 
                     * Set flag for 'Description' element present.
                     * 
                     * @param description
                     */
                    public void flagDescriptionPresent(boolean description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @return value
                     */
                    public Boolean getHidden() {
                        return hidden;
                    }

                    /** 
                     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @param hidden
                     */
                    public void setHidden(Boolean hidden) {
                        this.hidden = hidden;
                    }
                }
            }
            /** 
             * Net fare data
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MarkUp" minOccurs="0">
             *         &lt;!-- Reference to inner class MarkUp -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="tourTicket"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private FareTaxInfo taxInfo;
                private FareCalculation fareCalculation;
                private Commission commission;
                private MarkUp markUp;
                private Boolean tourTicket;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public FareTaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(FareTaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'MarkUp' element value.
                 * 
                 * @return value
                 */
                public MarkUp getMarkUp() {
                    return markUp;
                }

                /** 
                 * Set the 'MarkUp' element value.
                 * 
                 * @param markUp
                 */
                public void setMarkUp(MarkUp markUp) {
                    this.markUp = markUp;
                }

                /** 
                 * Get the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_ITBT
                 * 
                 * @return value
                 */
                public Boolean getTourTicket() {
                    return tourTicket;
                }

                /** 
                 * Set the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_ITBT
                 * 
                 * @param tourTicket
                 */
                public void setTourTicket(Boolean tourTicket) {
                    this.tourTicket = tourTicket;
                }
                /** 
                 * Base amount for NetFare. Ref: DM0Z_86_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent amount for NetFare.
                                                                                        Ref: DM0Z_86_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total tax amount for NetFare.
                                                                                        Ref: DM0Z_86_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total amount for NetFare. Ref: DM0Z_86_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="rateOfExchange"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String string;
                    private String rateOfExchange;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                          NUC conversion
                     * 
                     * @return value
                     */
                    public String getRateOfExchange() {
                        return rateOfExchange;
                    }

                    /** 
                     * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                                          NUC conversion
                     * 
                     * @param rateOfExchange
                     */
                    public void setRateOfExchange(String rateOfExchange) {
                        this.rateOfExchange = rateOfExchange;
                    }
                }
                /** 
                 * Holds commission associated to NetFare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Difference between selling fare and net fare

                                                                                        Ref: DM0Z_C9_MKU_AMNT
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarkUp" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarkUp implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Global Net remit
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NetFare" minOccurs="0">
             *         &lt;!-- Reference to inner class NetFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SellingFare" minOccurs="0">
             *         &lt;!-- Reference to inner class SellingFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Discount" minOccurs="0">
             *         &lt;!-- Reference to inner class Discount -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="TourCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="FareText" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="FareSource" minOccurs="0"/>
             *       &lt;xs:element name="FareType" minOccurs="0">
             *         &lt;!-- Reference to inner class FareType -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="BillingInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class BillingInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:Amount" name="CommissionBaseAmount" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="method"/>
             *     &lt;xs:attribute type="xs:string" name="valueCode"/>
             *     &lt;xs:attribute type="xs:string" name="commissionTypeIndicator"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemitInfo implements Serializable
            {
                private NetFare netFare;
                private SellingFare sellingFare;
                private Discount discount;
                private String tourCode;
                private String fareText;
                private String fareSource;
                private FareType fareType;
                private BillingInfo billingInfo;
                private com.sabre.services.sp.pd.v35.Amount commissionBaseAmount;
                private String method;
                private String valueCode;
                private String commissionTypeIndicator;

                /** 
                 * Get the 'NetFare' element value.
                 * 
                 * @return value
                 */
                public NetFare getNetFare() {
                    return netFare;
                }

                /** 
                 * Set the 'NetFare' element value.
                 * 
                 * @param netFare
                 */
                public void setNetFare(NetFare netFare) {
                    this.netFare = netFare;
                }

                /** 
                 * Get the 'SellingFare' element value.
                 * 
                 * @return value
                 */
                public SellingFare getSellingFare() {
                    return sellingFare;
                }

                /** 
                 * Set the 'SellingFare' element value.
                 * 
                 * @param sellingFare
                 */
                public void setSellingFare(SellingFare sellingFare) {
                    this.sellingFare = sellingFare;
                }

                /** 
                 * Get the 'Discount' element value.
                 * 
                 * @return value
                 */
                public Discount getDiscount() {
                    return discount;
                }

                /** 
                 * Set the 'Discount' element value.
                 * 
                 * @param discount
                 */
                public void setDiscount(Discount discount) {
                    this.discount = discount;
                }

                /** 
                 * Get the 'TourCode' element value. Cat35 tour code

                                                                                        Ref: DM0Z_E8_TOUR_CDE
                 * 
                 * @return value
                 */
                public String getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' element value. Cat35 tour code

                                                                                        Ref: DM0Z_E8_TOUR_CDE
                 * 
                 * @param tourCode
                 */
                public void setTourCode(String tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'FareText' element value. Cat35 text box.

                                                                                        Ref: DM0Z_E8_TEXT_BOX
                 * 
                 * @return value
                 */
                public String getFareText() {
                    return fareText;
                }

                /** 
                 * Set the 'FareText' element value. Cat35 text box.

                                                                                        Ref: DM0Z_E8_TEXT_BOX
                 * 
                 * @param fareText
                 */
                public void setFareText(String fareText) {
                    this.fareText = fareText;
                }

                /** 
                 * Get the 'FareSource' element value. Cat35 fare source.

                                                                                        Ref: E8_FAR_SRCE
                 * 
                 * @return value
                 */
                public String getFareSource() {
                    return fareSource;
                }

                /** 
                 * Set the 'FareSource' element value. Cat35 fare source.

                                                                                        Ref: E8_FAR_SRCE
                 * 
                 * @param fareSource
                 */
                public void setFareSource(String fareSource) {
                    this.fareSource = fareSource;
                }

                /** 
                 * Get the 'FareType' element value.
                 * 
                 * @return value
                 */
                public FareType getFareType() {
                    return fareType;
                }

                /** 
                 * Set the 'FareType' element value.
                 * 
                 * @param fareType
                 */
                public void setFareType(FareType fareType) {
                    this.fareType = fareType;
                }

                /** 
                 * Get the 'BillingInfo' element value.
                 * 
                 * @return value
                 */
                public BillingInfo getBillingInfo() {
                    return billingInfo;
                }

                /** 
                 * Set the 'BillingInfo' element value.
                 * 
                 * @param billingInfo
                 */
                public void setBillingInfo(BillingInfo billingInfo) {
                    this.billingInfo = billingInfo;
                }

                /** 
                 * Get the 'CommissionBaseAmount' element value. Commission Base Amount

                                                                                        Ref: DM0Z_E8_CBAS_AMT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getCommissionBaseAmount() {
                    return commissionBaseAmount;
                }

                /** 
                 * Set the 'CommissionBaseAmount' element value. Commission Base Amount

                                                                                        Ref: DM0Z_E8_CBAS_AMT
                 * 
                 * @param commissionBaseAmount
                 */
                public void setCommissionBaseAmount(
                        com.sabre.services.sp.pd.v35.Amount commissionBaseAmount) {
                    this.commissionBaseAmount = commissionBaseAmount;
                }

                /** 
                 * Get the 'method' attribute value. CAT35 Method Type
                                                                                    Ref: DM0Z_E8_RMT_TYPE
                 * 
                 * @return value
                 */
                public String getMethod() {
                    return method;
                }

                /** 
                 * Set the 'method' attribute value. CAT35 Method Type
                                                                                    Ref: DM0Z_E8_RMT_TYPE
                 * 
                 * @param method
                 */
                public void setMethod(String method) {
                    this.method = method;
                }

                /** 
                 * Get the 'valueCode' attribute value. CAT35 Net Remit Value Code
                                                                                    Ref: DM0Z_E8_REMT_CDE
                 * 
                 * @return value
                 */
                public String getValueCode() {
                    return valueCode;
                }

                /** 
                 * Set the 'valueCode' attribute value. CAT35 Net Remit Value Code
                                                                                    Ref: DM0Z_E8_REMT_CDE
                 * 
                 * @param valueCode
                 */
                public void setValueCode(String valueCode) {
                    this.valueCode = valueCode;
                }

                /** 
                 * Get the 'commissionTypeIndicator' attribute value. Cat35 Gross or Net indicator.

                                                                                    Ref: DM0Z_E8_NET_GROS
                 * 
                 * @return value
                 */
                public String getCommissionTypeIndicator() {
                    return commissionTypeIndicator;
                }

                /** 
                 * Set the 'commissionTypeIndicator' attribute value. Cat35 Gross or Net indicator.

                                                                                    Ref: DM0Z_E8_NET_GROS
                 * 
                 * @param commissionTypeIndicator
                 */
                public void setCommissionTypeIndicator(
                        String commissionTypeIndicator) {
                    this.commissionTypeIndicator = commissionTypeIndicator;
                }
                /** 
                 * Net fare details
                                                                                        Ref: DM0Z_E8_NET...
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivalentFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivalentFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalTax" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NetFare implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivalentFare equivalentFare;
                    private TotalTax totalTax;
                    private TotalFare totalFare;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivalentFare' element value.
                     * 
                     * @return value
                     */
                    public EquivalentFare getEquivalentFare() {
                        return equivalentFare;
                    }

                    /** 
                     * Set the 'EquivalentFare' element value.
                     * 
                     * @param equivalentFare
                     */
                    public void setEquivalentFare(EquivalentFare equivalentFare) {
                        this.equivalentFare = equivalentFare;
                    }

                    /** 
                     * Get the 'TotalTax' element value.
                     * 
                     * @return value
                     */
                    public TotalTax getTotalTax() {
                        return totalTax;
                    }

                    /** 
                     * Set the 'TotalTax' element value.
                     * 
                     * @param totalTax
                     */
                    public void setTotalTax(TotalTax totalTax) {
                        this.totalTax = totalTax;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }
                    /** 
                     * Base fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Equivalent fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivalentFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total tax amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalTax implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Selling fare details
                                                                                        Ref: DM0Z_E8_SEL_...
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivalentFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivalentFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalTax" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SellingFare implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivalentFare equivalentFare;
                    private TotalTax totalTax;
                    private TotalFare totalFare;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivalentFare' element value.
                     * 
                     * @return value
                     */
                    public EquivalentFare getEquivalentFare() {
                        return equivalentFare;
                    }

                    /** 
                     * Set the 'EquivalentFare' element value.
                     * 
                     * @param equivalentFare
                     */
                    public void setEquivalentFare(EquivalentFare equivalentFare) {
                        this.equivalentFare = equivalentFare;
                    }

                    /** 
                     * Get the 'TotalTax' element value.
                     * 
                     * @return value
                     */
                    public TotalTax getTotalTax() {
                        return totalTax;
                    }

                    /** 
                     * Set the 'TotalTax' element value.
                     * 
                     * @param totalTax
                     */
                    public void setTotalTax(TotalTax totalTax) {
                        this.totalTax = totalTax;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }
                    /** 
                     * Base fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Equivalent fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivalentFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total tax amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalTax implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Discount Amount if applicable
                                                                                        Ref: DM0Z_E8_DISCOUNT
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Discount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Cat35 fare type indicator
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="netRemit"/>
                 *     &lt;xs:attribute type="xs:boolean" name="security"/>
                 *     &lt;xs:attribute type="xs:boolean" name="netTicket"/>
                 *     &lt;xs:attribute type="xs:boolean" name="netSell"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareType implements Serializable
                {
                    private Boolean netRemit;
                    private Boolean security;
                    private Boolean netTicket;
                    private Boolean netSell;

                    /** 
                     * Get the 'netRemit' attribute value. Net remit fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_NRF
                     * 
                     * @return value
                     */
                    public Boolean getNetRemit() {
                        return netRemit;
                    }

                    /** 
                     * Set the 'netRemit' attribute value. Net remit fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_NRF
                     * 
                     * @param netRemit
                     */
                    public void setNetRemit(Boolean netRemit) {
                        this.netRemit = netRemit;
                    }

                    /** 
                     * Get the 'security' attribute value. Security fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_SFR
                     * 
                     * @return value
                     */
                    public Boolean getSecurity() {
                        return security;
                    }

                    /** 
                     * Set the 'security' attribute value. Security fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_SFR
                     * 
                     * @param security
                     */
                    public void setSecurity(Boolean security) {
                        this.security = security;
                    }

                    /** 
                     * Get the 'netTicket' attribute value. Net ticket fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_NTF
                     * 
                     * @return value
                     */
                    public Boolean getNetTicket() {
                        return netTicket;
                    }

                    /** 
                     * Set the 'netTicket' attribute value. Net ticket fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_NTF
                     * 
                     * @param netTicket
                     */
                    public void setNetTicket(Boolean netTicket) {
                        this.netTicket = netTicket;
                    }

                    /** 
                     * Get the 'netSell' attribute value. Net ticketing fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_SFR
                     * 
                     * @return value
                     */
                    public Boolean getNetSell() {
                        return netSell;
                    }

                    /** 
                     * Set the 'netSell' attribute value. Net ticketing fare

                                                                                                  Ref: DM0Z_E8_TKT_NTYP
                                                                                                  #DM0Z_E8_TKT_SFR
                     * 
                     * @param netSell
                     */
                    public void setNetSell(Boolean netSell) {
                        this.netSell = netSell;
                    }
                }
                /** 
                 * Net remit billing info
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BillingInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="RuleId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:date" name="ContractIssueDate" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ContractNumber" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TariffNumber" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Identifier.Flight" name="FareSourceCarrier" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FareSourcePCC" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Extended.CityCode" name="FareOrigin" minOccurs="0"/>
                 *       &lt;xs:element type="ns:Extended.CityCode" name="FareDestination" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BillingInfo implements Serializable
                {
                    private String ruleId;
                    private java.sql.Date contractIssueDate;
                    private String contractNumber;
                    private String tariffNumber;
                    private IdentifierFlight fareSourceCarrier;
                    private String fareSourcePCC;
                    private ExtendedCityCode fareOrigin;
                    private ExtendedCityCode fareDestination;
                    private String fareBasis;

                    /** 
                     * Get the 'RuleId' element value. Rule id for Cat35.

                                                                                                      Ref: DM0Z_E8_RUID
                     * 
                     * @return value
                     */
                    public String getRuleId() {
                        return ruleId;
                    }

                    /** 
                     * Set the 'RuleId' element value. Rule id for Cat35.

                                                                                                      Ref: DM0Z_E8_RUID
                     * 
                     * @param ruleId
                     */
                    public void setRuleId(String ruleId) {
                        this.ruleId = ruleId;
                    }

                    /** 
                     * Get the 'ContractIssueDate' element value. Contract issue date.

                                                                                                      Ref: DM0Z_E8_ISS_DATE
                     * 
                     * @return value
                     */
                    public java.sql.Date getContractIssueDate() {
                        return contractIssueDate;
                    }

                    /** 
                     * Set the 'ContractIssueDate' element value. Contract issue date.

                                                                                                      Ref: DM0Z_E8_ISS_DATE
                     * 
                     * @param contractIssueDate
                     */
                    public void setContractIssueDate(
                            java.sql.Date contractIssueDate) {
                        this.contractIssueDate = contractIssueDate;
                    }

                    /** 
                     * Get the 'ContractNumber' element value. Contract number.

                                                                                                      Ref: DM0Z_E8_CNT_NBR
                     * 
                     * @return value
                     */
                    public String getContractNumber() {
                        return contractNumber;
                    }

                    /** 
                     * Set the 'ContractNumber' element value. Contract number.

                                                                                                      Ref: DM0Z_E8_CNT_NBR
                     * 
                     * @param contractNumber
                     */
                    public void setContractNumber(String contractNumber) {
                        this.contractNumber = contractNumber;
                    }

                    /** 
                     * Get the 'TariffNumber' element value. Tariff number.

                                                                                                      Ref: Contract number.

                                                                                                      Ref: DM0Z_E8_TAR_NBR
                     * 
                     * @return value
                     */
                    public String getTariffNumber() {
                        return tariffNumber;
                    }

                    /** 
                     * Set the 'TariffNumber' element value. Tariff number.

                                                                                                      Ref: Contract number.

                                                                                                      Ref: DM0Z_E8_TAR_NBR
                     * 
                     * @param tariffNumber
                     */
                    public void setTariffNumber(String tariffNumber) {
                        this.tariffNumber = tariffNumber;
                    }

                    /** 
                     * Get the 'FareSourceCarrier' element value. Fare source carrier.

                                                                                                      Ref: DM0Z_E8_FS_CXR
                     * 
                     * @return value
                     */
                    public IdentifierFlight getFareSourceCarrier() {
                        return fareSourceCarrier;
                    }

                    /** 
                     * Set the 'FareSourceCarrier' element value. Fare source carrier.

                                                                                                      Ref: DM0Z_E8_FS_CXR
                     * 
                     * @param fareSourceCarrier
                     */
                    public void setFareSourceCarrier(
                            IdentifierFlight fareSourceCarrier) {
                        this.fareSourceCarrier = fareSourceCarrier;
                    }

                    /** 
                     * Get the 'FareSourcePCC' element value. Fare source pcc.

                                                                                                      Ref: DM0Z_E8_FS_PCC
                     * 
                     * @return value
                     */
                    public String getFareSourcePCC() {
                        return fareSourcePCC;
                    }

                    /** 
                     * Set the 'FareSourcePCC' element value. Fare source pcc.

                                                                                                      Ref: DM0Z_E8_FS_PCC
                     * 
                     * @param fareSourcePCC
                     */
                    public void setFareSourcePCC(String fareSourcePCC) {
                        this.fareSourcePCC = fareSourcePCC;
                    }

                    /** 
                     * Get the 'FareOrigin' element value. Fare origin.

                                                                                                      Ref: DM0Z_E8_FAR_ORI
                     * 
                     * @return value
                     */
                    public ExtendedCityCode getFareOrigin() {
                        return fareOrigin;
                    }

                    /** 
                     * Set the 'FareOrigin' element value. Fare origin.

                                                                                                      Ref: DM0Z_E8_FAR_ORI
                     * 
                     * @param fareOrigin
                     */
                    public void setFareOrigin(ExtendedCityCode fareOrigin) {
                        this.fareOrigin = fareOrigin;
                    }

                    /** 
                     * Get the 'FareDestination' element value. Fare destination.

                                                                                                      Ref: DM0Z_E8_FAR_DES
                     * 
                     * @return value
                     */
                    public ExtendedCityCode getFareDestination() {
                        return fareDestination;
                    }

                    /** 
                     * Set the 'FareDestination' element value. Fare destination.

                                                                                                      Ref: DM0Z_E8_FAR_DES
                     * 
                     * @param fareDestination
                     */
                    public void setFareDestination(
                            ExtendedCityCode fareDestination) {
                        this.fareDestination = fareDestination;
                    }

                    /** 
                     * Get the 'FareBasis' element value. Fare basis.

                                                                                                      Ref: DM0Z_E8_FBCD
                     * 
                     * @return value
                     */
                    public String getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value. Fare basis.

                                                                                                      Ref: DM0Z_E8_FBCD
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(String fareBasis) {
                        this.fareBasis = fareBasis;
                    }
                }
            }
        }
        /** 
         * Fee details defined in Price Quote
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OBFee" minOccurs="0" maxOccurs="50">
         *         &lt;!-- Reference to inner class OBFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ChangeFee" minOccurs="0">
         *         &lt;!-- Reference to inner class ChangeFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OtherFee" minOccurs="0">
         *         &lt;!-- Reference to inner class OtherFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0" maxOccurs="3">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FeeTotal" minOccurs="0">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="ns:Amount.Pattern" name="Amount"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FeeInfo implements Serializable
        {
            private List<OBFee> OBFeeList = new ArrayList<OBFee>();
            private ChangeFee changeFee;
            private OtherFee otherFee;
            private List<Commission> commissionList = new ArrayList<Commission>();
            private AmountPattern feeTotal;

            /** 
             * Get the list of 'OBFee' element items.
             * 
             * @return list
             */
            public List<OBFee> getOBFeeList() {
                return OBFeeList;
            }

            /** 
             * Set the list of 'OBFee' element items.
             * 
             * @param list
             */
            public void setOBFeeList(List<OBFee> list) {
                OBFeeList = list;
            }

            /** 
             * Get the 'ChangeFee' element value.
             * 
             * @return value
             */
            public ChangeFee getChangeFee() {
                return changeFee;
            }

            /** 
             * Set the 'ChangeFee' element value.
             * 
             * @param changeFee
             */
            public void setChangeFee(ChangeFee changeFee) {
                this.changeFee = changeFee;
            }

            /** 
             * Get the 'OtherFee' element value.
             * 
             * @return value
             */
            public OtherFee getOtherFee() {
                return otherFee;
            }

            /** 
             * Set the 'OtherFee' element value.
             * 
             * @param otherFee
             */
            public void setOtherFee(OtherFee otherFee) {
                this.otherFee = otherFee;
            }

            /** 
             * Get the list of 'Commission' element items.
             * 
             * @return list
             */
            public List<Commission> getCommissionList() {
                return commissionList;
            }

            /** 
             * Set the list of 'Commission' element items.
             * 
             * @param list
             */
            public void setCommissionList(List<Commission> list) {
                commissionList = list;
            }

            /** 
             * Get the 'Amount' element value. Derived value: Total of Change Fee, Other Fee and Fee taxes
             * 
             * @return value
             */
            public AmountPattern getFeeTotal() {
                return feeTotal;
            }

            /** 
             * Set the 'Amount' element value. Derived value: Total of Change Fee, Other Fee and Fee taxes
             * 
             * @param feeTotal
             */
            public void setFeeTotal(AmountPattern feeTotal) {
                this.feeTotal = feeTotal;
            }
            /** 
             * Fee details defined in Price Quote
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OBFee" minOccurs="0" maxOccurs="50">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:choice>
             *         &lt;xs:element type="ns:Amount" name="Amount"/>
             *         &lt;xs:element type="ns:Amount" name="MaxAmount"/>
             *       &lt;/xs:choice>
             *       &lt;xs:element type="ns:Amount" name="Total" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="BankIdentificationNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="GoverningCarrierCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="CommissionPercentage" minOccurs="0"/>
             *       &lt;xs:element name="IataIndicators" minOccurs="0">
             *         &lt;!-- Reference to inner class IataIndicators -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="PricedBankIdentificationNumber" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *     &lt;xs:attribute type="xs:string" name="noChargeIndicator"/>
             *     &lt;xs:attribute type="xs:string" name="systemOrManual"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OBFee implements Serializable
            {
                private int choiceSelect = -1;
                private static final int AMOUNT_CHOICE = 0;
                private static final int MAX_AMOUNT_CHOICE = 1;
                private com.sabre.services.sp.pd.v35.Amount amount;
                private com.sabre.services.sp.pd.v35.Amount maxAmount;
                private com.sabre.services.sp.pd.v35.Amount total;
                private String description;
                private String bankIdentificationNumber;
                private String governingCarrierCode;
                private BigDecimal commissionPercentage;
                private IataIndicators iataIndicators;
                private String pricedBankIdentificationNumber;
                private String type;
                private String code;
                private String noChargeIndicator;
                private String systemOrManual;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if Amount is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAmount() {
                    return choiceSelect == AMOUNT_CHOICE;
                }

                /** 
                 * Get the 'Amount' element value. OB Fee Amount
                                                                                            Ref: DM0Z_E1_OB_FAMT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. OB Fee Amount
                                                                                            Ref: DM0Z_E1_OB_FAMT
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    setChoiceSelect(AMOUNT_CHOICE);
                    this.amount = amount;
                }

                /** 
                 * Check if MaxAmount is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifMaxAmount() {
                    return choiceSelect == MAX_AMOUNT_CHOICE;
                }

                /** 
                 * Get the 'MaxAmount' element value. Max Fee Amount
                                                                                            Ref: DM0Z_E1_OB_MCHA
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getMaxAmount() {
                    return maxAmount;
                }

                /** 
                 * Set the 'MaxAmount' element value. Max Fee Amount
                                                                                            Ref: DM0Z_E1_OB_MCHA
                 * 
                 * @param maxAmount
                 */
                public void setMaxAmount(
                        com.sabre.services.sp.pd.v35.Amount maxAmount) {
                    setChoiceSelect(MAX_AMOUNT_CHOICE);
                    this.maxAmount = maxAmount;
                }

                /** 
                 * Get the 'Total' element value. Total Fee Amount
                                                                                        Ref:
                                                                                        DM0ZAA_E1_TAMT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value. Total Fee Amount
                                                                                        Ref:
                                                                                        DM0ZAA_E1_TAMT
                 * 
                 * @param total
                 */
                public void setTotal(com.sabre.services.sp.pd.v35.Amount total) {
                    this.total = total;
                }

                /** 
                 * Get the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E1_OB_DESP
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E1_OB_DESP
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'BankIdentificationNumber' element value. 
                                                                                        Ref: DM0Z_E1_OB_BIN
                 * 
                 * @return value
                 */
                public String getBankIdentificationNumber() {
                    return bankIdentificationNumber;
                }

                /** 
                 * Set the 'BankIdentificationNumber' element value. 
                                                                                        Ref: DM0Z_E1_OB_BIN
                 * 
                 * @param bankIdentificationNumber
                 */
                public void setBankIdentificationNumber(
                        String bankIdentificationNumber) {
                    this.bankIdentificationNumber = bankIdentificationNumber;
                }

                /** 
                 * Get the 'GoverningCarrierCode' element value. Governing carrier code

                                                                                        Ref: DM0Z_E1_OBF_GCAR
                 * 
                 * @return value
                 */
                public String getGoverningCarrierCode() {
                    return governingCarrierCode;
                }

                /** 
                 * Set the 'GoverningCarrierCode' element value. Governing carrier code

                                                                                        Ref: DM0Z_E1_OBF_GCAR
                 * 
                 * @param governingCarrierCode
                 */
                public void setGoverningCarrierCode(String governingCarrierCode) {
                    this.governingCarrierCode = governingCarrierCode;
                }

                /** 
                 * Get the 'CommissionPercentage' element value. Commission percentage

                                                                                        Ref: DM0Z_E1_OB_COMP
                 * 
                 * @return value
                 */
                public BigDecimal getCommissionPercentage() {
                    return commissionPercentage;
                }

                /** 
                 * Set the 'CommissionPercentage' element value. Commission percentage

                                                                                        Ref: DM0Z_E1_OB_COMP
                 * 
                 * @param commissionPercentage
                 */
                public void setCommissionPercentage(
                        BigDecimal commissionPercentage) {
                    this.commissionPercentage = commissionPercentage;
                }

                /** 
                 * Get the 'IataIndicators' element value.
                 * 
                 * @return value
                 */
                public IataIndicators getIataIndicators() {
                    return iataIndicators;
                }

                /** 
                 * Set the 'IataIndicators' element value.
                 * 
                 * @param iataIndicators
                 */
                public void setIataIndicators(IataIndicators iataIndicators) {
                    this.iataIndicators = iataIndicators;
                }

                /** 
                 * Get the 'PricedBankIdentificationNumber' element value. BIN of credit card form of payment used during pricing.

                                                                                        Ref: DM0Z_E1_OB_WBIN
                 * 
                 * @return value
                 */
                public String getPricedBankIdentificationNumber() {
                    return pricedBankIdentificationNumber;
                }

                /** 
                 * Set the 'PricedBankIdentificationNumber' element value. BIN of credit card form of payment used during pricing.

                                                                                        Ref: DM0Z_E1_OB_WBIN
                 * 
                 * @param pricedBankIdentificationNumber
                 */
                public void setPricedBankIdentificationNumber(
                        String pricedBankIdentificationNumber) {
                    this.pricedBankIdentificationNumber = pricedBankIdentificationNumber;
                }

                /** 
                 * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                                    Possible Values:
                                                                                    OB
                                                                                
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                                    Possible Values:
                                                                                    OB
                                                                                
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the fee.

                                                                                    Possible values:
                                                                                    R01
                                                                                    R02-R12
                                                                                    T01
                                                                                    T02-T20
                                                                                    FCA, FD0, FC1, FDA
                                                                                
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the fee.

                                                                                    Possible values:
                                                                                    R01
                                                                                    R02-R12
                                                                                    T01
                                                                                    T02-T20
                                                                                    FCA, FD0, FC1, FDA
                                                                                
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'noChargeIndicator' attribute value. Possible Values:
                                                                                    X
                                                                                    Y
                                                                                    0
                                                                                    Ref: DM0Z_E1_OB_NCHR
                 * 
                 * @return value
                 */
                public String getNoChargeIndicator() {
                    return noChargeIndicator;
                }

                /** 
                 * Set the 'noChargeIndicator' attribute value. Possible Values:
                                                                                    X
                                                                                    Y
                                                                                    0
                                                                                    Ref: DM0Z_E1_OB_NCHR
                 * 
                 * @param noChargeIndicator
                 */
                public void setNoChargeIndicator(String noChargeIndicator) {
                    this.noChargeIndicator = noChargeIndicator;
                }

                /** 
                 * Get the 'systemOrManual' attribute value. System/Manual ObFee

                                                                                    Possible values:
                                                                                    S - System
                                                                                    M - Manual

                                                                                    Ref: DM0Z_E1_OB_SYS
                 * 
                 * @return value
                 */
                public String getSystemOrManual() {
                    return systemOrManual;
                }

                /** 
                 * Set the 'systemOrManual' attribute value. System/Manual ObFee

                                                                                    Possible values:
                                                                                    S - System
                                                                                    M - Manual

                                                                                    Ref: DM0Z_E1_OB_SYS
                 * 
                 * @param systemOrManual
                 */
                public void setSystemOrManual(String systemOrManual) {
                    this.systemOrManual = systemOrManual;
                }
                /** 
                 * Iata indicators
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IataIndicators" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="reissueOrRefund"/>
                 *     &lt;xs:attribute type="xs:boolean" name="commissionApplicable"/>
                 *     &lt;xs:attribute type="xs:boolean" name="interline"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class IataIndicators implements Serializable
                {
                    private Boolean reissueOrRefund;
                    private Boolean commissionApplicable;
                    private Boolean interline;

                    /** 
                     * Get the 'reissueOrRefund' attribute value. Reissue/Refund

                                                                                                  Ref: DM0Z_E1_OB_IAP1
                     * 
                     * @return value
                     */
                    public Boolean getReissueOrRefund() {
                        return reissueOrRefund;
                    }

                    /** 
                     * Set the 'reissueOrRefund' attribute value. Reissue/Refund

                                                                                                  Ref: DM0Z_E1_OB_IAP1
                     * 
                     * @param reissueOrRefund
                     */
                    public void setReissueOrRefund(Boolean reissueOrRefund) {
                        this.reissueOrRefund = reissueOrRefund;
                    }

                    /** 
                     * Get the 'commissionApplicable' attribute value. Commission

                                                                                                  Ref: DM0Z_E1_OB_IAP2
                     * 
                     * @return value
                     */
                    public Boolean getCommissionApplicable() {
                        return commissionApplicable;
                    }

                    /** 
                     * Set the 'commissionApplicable' attribute value. Commission

                                                                                                  Ref: DM0Z_E1_OB_IAP2
                     * 
                     * @param commissionApplicable
                     */
                    public void setCommissionApplicable(
                            Boolean commissionApplicable) {
                        this.commissionApplicable = commissionApplicable;
                    }

                    /** 
                     * Get the 'interline' attribute value. Interline

                                                                                                  Ref: DM0Z_E1_OB_IAP3
                     * 
                     * @return value
                     */
                    public Boolean getInterline() {
                        return interline;
                    }

                    /** 
                     * Set the 'interline' attribute value. Interline

                                                                                                  Ref: DM0Z_E1_OB_IAP3
                     * 
                     * @param interline
                     */
                    public void setInterline(Boolean interline) {
                        this.interline = interline;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeFee" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
             *       &lt;xs:element name="FeeTax" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class FeeTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="WaiverCode" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount" name="AmountCollected" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="waived"/>
             *     &lt;xs:attribute name="collectionMethod">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class CollectionMethod -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ChangeFee implements Serializable
            {
                private AmountPattern amount;
                private List<FeeTax> feeTaxList = new ArrayList<FeeTax>();
                private String waiverCode;
                private com.sabre.services.sp.pd.v35.Amount amountCollected;
                private Boolean waived;
                private CollectionMethod collectionMethod;
                private String code;

                /** 
                 * Get the 'Amount' element value. Ref: DM0Z_C0_CFMT
                 * 
                 * @return value
                 */
                public AmountPattern getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Ref: DM0Z_C0_CFMT
                 * 
                 * @param amount
                 */
                public void setAmount(AmountPattern amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the list of 'FeeTax' element items.
                 * 
                 * @return list
                 */
                public List<FeeTax> getFeeTaxList() {
                    return feeTaxList;
                }

                /** 
                 * Set the list of 'FeeTax' element items.
                 * 
                 * @param list
                 */
                public void setFeeTaxList(List<FeeTax> list) {
                    feeTaxList = list;
                }

                /** 
                 * Get the 'WaiverCode' element value.
                 * 
                 * @return value
                 */
                public String getWaiverCode() {
                    return waiverCode;
                }

                /** 
                 * Set the 'WaiverCode' element value.
                 * 
                 * @param waiverCode
                 */
                public void setWaiverCode(String waiverCode) {
                    this.waiverCode = waiverCode;
                }

                /** 
                 * Get the 'AmountCollected' element value. Applicable for TN
                                                                                        and when collectionMethod
                                                                                        is EMD or OtherDoc
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmountCollected() {
                    return amountCollected;
                }

                /** 
                 * Set the 'AmountCollected' element value. Applicable for TN
                                                                                        and when collectionMethod
                                                                                        is EMD or OtherDoc
                 * 
                 * @param amountCollected
                 */
                public void setAmountCollected(
                        com.sabre.services.sp.pd.v35.Amount amountCollected) {
                    this.amountCollected = amountCollected;
                }

                /** 
                 * Get the 'waived' attribute value. Indicates if change fee waived
                 * 
                 * @return value
                 */
                public Boolean getWaived() {
                    return waived;
                }

                /** 
                 * Set the 'waived' attribute value. Indicates if change fee waived
                 * 
                 * @param waived
                 */
                public void setWaived(Boolean waived) {
                    this.waived = waived;
                }

                /** 
                 * Get the 'collectionMethod' attribute value. - Tax
                                                                                    - EMD
                                                                                    - OtherDoc
                                                                                    - InTotal
                                                                                    Ref: DM0Z_40_QRXP
                                                                                    DM0Z_B9_CIND
                 * 
                 * @return value
                 */
                public CollectionMethod getCollectionMethod() {
                    return collectionMethod;
                }

                /** 
                 * Set the 'collectionMethod' attribute value. - Tax
                                                                                    - EMD
                                                                                    - OtherDoc
                                                                                    - InTotal
                                                                                    Ref: DM0Z_40_QRXP
                                                                                    DM0Z_B9_CIND
                 * 
                 * @param collectionMethod
                 */
                public void setCollectionMethod(
                        CollectionMethod collectionMethod) {
                    this.collectionMethod = collectionMethod;
                }

                /** 
                 * Get the 'code' attribute value. Applicable for TN when collectedMethod is Tax
                                                                                    Ref: #DM0Z_C5_CFAT
                                                                                    DM0Z_C5_TIDE
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Applicable for TN when collectedMethod is Tax
                                                                                    Ref: #DM0Z_C5_CFAT
                                                                                    DM0Z_C5_TIDE
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeTax" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:Amount" name="Amount"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FeeTax implements Serializable
                {
                    private com.sabre.services.sp.pd.v35.Amount amount;
                    private String code;

                    /** 
                     * Get the 'Amount' element value. Ref: DM0Z_C5_CAMT
                     * 
                     * @return value
                     */
                    public com.sabre.services.sp.pd.v35.Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Ref: DM0Z_C5_CAMT
                     * 
                     * @param amount
                     */
                    public void setAmount(
                            com.sabre.services.sp.pd.v35.Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'code' attribute value. Ref: DM0Z_C5_TXID
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Ref: DM0Z_C5_TXID
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Tax"/>
                 *     &lt;xs:enumeration value="EMD"/>
                 *     &lt;xs:enumeration value="OtherDoc"/>
                 *     &lt;xs:enumeration value="InTotal"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum CollectionMethod implements Serializable {
                    TAX("Tax"), EMD("EMD"), OTHER_DOC("OtherDoc"), IN_TOTAL(
                            "InTotal");
                    private final String value;

                    private CollectionMethod(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static CollectionMethod convert(String value) {
                        for (CollectionMethod inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherFee" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *     &lt;xs:attribute type="xs:boolean" name="waived"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OtherFee implements Serializable
            {
                private AmountPattern amount;
                private String code;
                private Boolean waived;

                /** 
                 * Get the 'Amount' element value. Ref:
                                                                                        TN - DM0Z_C0_TFTA
                                                                                        AS -  DM0Z_C0_LFMT
                 * 
                 * @return value
                 */
                public AmountPattern getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Ref:
                                                                                        TN - DM0Z_C0_TFTA
                                                                                        AS -  DM0Z_C0_LFMT
                 * 
                 * @param amount
                 */
                public void setAmount(AmountPattern amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'code' attribute value. Applicable for both TN and AS
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Applicable for both TN and AS
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'waived' attribute value. Ref:
                                                                                    AS -DM0Z_C0_LIND
                 * 
                 * @return value
                 */
                public Boolean getWaived() {
                    return waived;
                }

                /** 
                 * Set the 'waived' attribute value. Ref:
                                                                                    AS -DM0Z_C0_LIND
                 * 
                 * @param waived
                 */
                public void setWaived(Boolean waived) {
                    this.waived = waived;
                }
            }
            /** 
             * Commission at Farelevel
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0" maxOccurs="3">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:anySimpleType" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount amount;
                private BigDecimal percentage;
                private String type;

                /** 
                 * Get the 'Amount' element value. Commision amount/penalty
                                                                                        Ref: DM0Z_85_COMA
                                                                                        DM0Z_85_NAMC
                                                                                        DM0Z_85_TAMC				
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Commision amount/penalty
                                                                                        Ref: DM0Z_85_COMA
                                                                                        DM0Z_85_NAMC
                                                                                        DM0Z_85_TAMC				
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' element value. Commision percentage
                                                                                        Ref: DM0Z_85_KXPA
                                                                                    
                 * 
                 * @return value
                 */
                public BigDecimal getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' element value. Commision percentage
                                                                                        Ref: DM0Z_85_KXPA
                                                                                    
                 * 
                 * @param percentage
                 */
                public void setPercentage(BigDecimal percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
        }
        /** 
         * Miscellaneous details pertaining to this PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscellaneousInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Code.ValidatingCarrier" name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:Code.ValidatingCarrier" name="AlternateValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element name="TourNumber" minOccurs="0">
         *         &lt;!-- Reference to inner class TourNumber -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *       &lt;xs:element name="CorpIdOrAcctCd" minOccurs="0" maxOccurs="4">
         *         &lt;!-- Reference to inner class CorpIdOrAcctCd -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="JourneyType" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="HemisphereOrDestCode" minOccurs="0"/>
         *       &lt;xs:element name="MiscellaneousData" minOccurs="0">
         *         &lt;!-- Reference to inner class MiscellaneousData -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscellaneousInfo implements Serializable
        {
            private List<CodeValidatingCarrier> validatingCarrierList = new ArrayList<CodeValidatingCarrier>();
            private List<CodeValidatingCarrier> alternateValidatingCarrierList = new ArrayList<CodeValidatingCarrier>();
            private TourNumber tourNumber;
            private String itineraryType;
            private List<CorpIdOrAcctCd> corpIdOrAcctCdList = new ArrayList<CorpIdOrAcctCd>();
            private String journeyType;
            private String hemisphereOrDestCode;
            private MiscellaneousData miscellaneousData;

            /** 
             * Get the list of 'ValidatingCarrier' element items. Validating Carrier.
                                                                          Ref: DM0Z_65_CRXC
             * 
             * @return list
             */
            public List<CodeValidatingCarrier> getValidatingCarrierList() {
                return validatingCarrierList;
            }

            /** 
             * Set the list of 'ValidatingCarrier' element items. Validating Carrier.
                                                                          Ref: DM0Z_65_CRXC
             * 
             * @param list
             */
            public void setValidatingCarrierList(
                    List<CodeValidatingCarrier> list) {
                validatingCarrierList = list;
            }

            /** 
             * Get the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
             * 
             * @return list
             */
            public List<CodeValidatingCarrier> getAlternateValidatingCarrierList() {
                return alternateValidatingCarrierList;
            }

            /** 
             * Set the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
             * 
             * @param list
             */
            public void setAlternateValidatingCarrierList(
                    List<CodeValidatingCarrier> list) {
                alternateValidatingCarrierList = list;
            }

            /** 
             * Get the 'TourNumber' element value.
             * 
             * @return value
             */
            public TourNumber getTourNumber() {
                return tourNumber;
            }

            /** 
             * Set the 'TourNumber' element value.
             * 
             * @param tourNumber
             */
            public void setTourNumber(TourNumber tourNumber) {
                this.tourNumber = tourNumber;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                          I - International
                                                                          D- Domestic

                                                                          Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                          I - International
                                                                          D- Domestic

                                                                          Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }

            /** 
             * Get the list of 'CorpIdOrAcctCd' element items.
             * 
             * @return list
             */
            public List<CorpIdOrAcctCd> getCorpIdOrAcctCdList() {
                return corpIdOrAcctCdList;
            }

            /** 
             * Set the list of 'CorpIdOrAcctCd' element items.
             * 
             * @param list
             */
            public void setCorpIdOrAcctCdList(List<CorpIdOrAcctCd> list) {
                corpIdOrAcctCdList = list;
            }

            /** 
             * Get the 'JourneyType' element value. ref:DM0Z_65_TKCT
                                                                          Possible values:
                                                                          Business
                                                                          Pleasure
                                                                          Selected Charters
             * 
             * @return value
             */
            public String getJourneyType() {
                return journeyType;
            }

            /** 
             * Set the 'JourneyType' element value. ref:DM0Z_65_TKCT
                                                                          Possible values:
                                                                          Business
                                                                          Pleasure
                                                                          Selected Charters
             * 
             * @param journeyType
             */
            public void setJourneyType(String journeyType) {
                this.journeyType = journeyType;
            }

            /** 
             * Get the 'HemisphereOrDestCode' element value. ref:DM0Z_65_TKCD
                                                                          Client Destination - continents
             * 
             * @return value
             */
            public String getHemisphereOrDestCode() {
                return hemisphereOrDestCode;
            }

            /** 
             * Set the 'HemisphereOrDestCode' element value. ref:DM0Z_65_TKCD
                                                                          Client Destination - continents
             * 
             * @param hemisphereOrDestCode
             */
            public void setHemisphereOrDestCode(String hemisphereOrDestCode) {
                this.hemisphereOrDestCode = hemisphereOrDestCode;
            }

            /** 
             * Get the 'MiscellaneousData' element value.
             * 
             * @return value
             */
            public MiscellaneousData getMiscellaneousData() {
                return miscellaneousData;
            }

            /** 
             * Set the 'MiscellaneousData' element value.
             * 
             * @param miscellaneousData
             */
            public void setMiscellaneousData(MiscellaneousData miscellaneousData) {
                this.miscellaneousData = miscellaneousData;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourNumber" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="code"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TourNumber implements Serializable
            {
                private String string;
                private String code;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'code' attribute value. Code type associated to the tour number
                                                                                            Possible values:
                                                                                            IT = inclusive tour
                                                                                            BT = bulk tour


                                                                                            Ref: DM0Z_65_ID02
                                                                                            #DM0Z_65_TOUI
                                                                                            #DM0Z_65_TOUB
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code type associated to the tour number
                                                                                            Possible values:
                                                                                            IT = inclusive tour
                                                                                            BT = bulk tour


                                                                                            Ref: DM0Z_65_ID02
                                                                                            #DM0Z_65_TOUI
                                                                                            #DM0Z_65_TOUB
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Ref: DM0Z_66_CORP
                                                                      
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorpIdOrAcctCd" minOccurs="0" maxOccurs="4">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:boolean" name="isCorpId"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CorpIdOrAcctCd implements Serializable
            {
                private String string;
                private Boolean isCorpId;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'isCorpId' attribute value. Corporate Id Indicator. True means corp id and false means account code.

                                                                                            Ref: DM0Z_66_IND1
                 * 
                 * @return value
                 */
                public Boolean getIsCorpId() {
                    return isCorpId;
                }

                /** 
                 * Set the 'isCorpId' attribute value. Corporate Id Indicator. True means corp id and false means account code.

                                                                                            Ref: DM0Z_66_IND1
                 * 
                 * @param isCorpId
                 */
                public void setIsCorpId(Boolean isCorpId) {
                    this.isCorpId = isCorpId;
                }
            }
            /** 
             * Key value pair for Miscellaneous Data
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscellaneousData" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:KeyValue.Value" name="Value" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiscellaneousData implements Serializable
            {
                private List<KeyValueValue> valueList = new ArrayList<KeyValueValue>();

                /** 
                 * Get the list of 'Value' element items. Data content :
                                                                                        Value in the key-value pair
                 * 
                 * @return list
                 */
                public List<KeyValueValue> getValueList() {
                    return valueList;
                }

                /** 
                 * Set the list of 'Value' element items. Data content :
                                                                                        Value in the key-value pair
                 * 
                 * @param list
                 */
                public void setValueList(List<KeyValueValue> list) {
                    valueList = list;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfo" minOccurs="0" maxOccurs="2">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Amount">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:decimal">
         *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
         *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:choice minOccurs="0">
         *         &lt;!-- Reference to inner class Choice -->
         *       &lt;/xs:choice>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="sequence"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentInfo implements Serializable
        {
            private BigDecimal amountDecimal;
            private String amountCurrencyCode;
            private BigInteger amountDecimalPlace;
            private Choice choice;
            private BigInteger sequence;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public BigDecimal getAmountDecimal() {
                return amountDecimal;
            }

            /** 
             * Set the extension value.
             * 
             * @param amountDecimal
             */
            public void setAmountDecimal(BigDecimal amountDecimal) {
                this.amountDecimal = amountDecimal;
            }

            /** 
             * Get the 'currencyCode' attribute value.
             * 
             * @return value
             */
            public String getAmountCurrencyCode() {
                return amountCurrencyCode;
            }

            /** 
             * Set the 'currencyCode' attribute value.
             * 
             * @param amountCurrencyCode
             */
            public void setAmountCurrencyCode(String amountCurrencyCode) {
                this.amountCurrencyCode = amountCurrencyCode;
            }

            /** 
             * Get the 'decimalPlace' attribute value.
             * 
             * @return value
             */
            public BigInteger getAmountDecimalPlace() {
                return amountDecimalPlace;
            }

            /** 
             * Set the 'decimalPlace' attribute value.
             * 
             * @param amountDecimalPlace
             */
            public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                this.amountDecimalPlace = amountDecimalPlace;
            }

            /** 
             * Get the choice value.
             * 
             * @return value
             */
            public Choice getChoice() {
                return choice;
            }

            /** 
             * Set the choice value.
             * 
             * @param choice
             */
            public void setChoice(Choice choice) {
                this.choice = choice;
            }

            /** 
             * Get the 'sequence' attribute value. Serial number of the FOP
                                                                      1,2
                                                                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
             * 
             * @return value
             */
            public BigInteger getSequence() {
                return sequence;
            }

            /** 
             * Set the 'sequence' attribute value. Serial number of the FOP
                                                                      1,2
                                                                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
             * 
             * @param sequence
             */
            public void setSequence(BigInteger sequence) {
                this.sequence = sequence;
            }

            /** 
             * Get the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
             *   &lt;xs:element type="xs:string" name="Virtual"/>
             *   &lt;xs:element type="ns:Payment.Credit" name="Card"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class Choice implements Serializable
            {
                private int choiceSelect = -1;
                private static final int VIRTUAL_CHOICE = 0;
                private static final int CARD_CHOICE = 1;
                private String virtual;
                private PaymentCredit card;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if Virtual is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifVirtual() {
                    return choiceSelect == VIRTUAL_CHOICE;
                }

                /** 
                 * Get the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
                 * 
                 * @return value
                 */
                public String getVirtual() {
                    return virtual;
                }

                /** 
                 * Set the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
                 * 
                 * @param virtual
                 */
                public void setVirtual(String virtual) {
                    setChoiceSelect(VIRTUAL_CHOICE);
                    this.virtual = virtual;
                }

                /** 
                 * Check if Card is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCard() {
                    return choiceSelect == CARD_CHOICE;
                }

                /** 
                 * Get the 'Card' element value.
                 * 
                 * @return value
                 */
                public PaymentCredit getCard() {
                    return card;
                }

                /** 
                 * Set the 'Card' element value.
                 * 
                 * @param card
                 */
                public void setCard(PaymentCredit card) {
                    setChoiceSelect(CARD_CHOICE);
                    this.card = card;
                }
            }
        }
        /** 
         * Comparison Summary
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComparisonSummary" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceQuote.Details.FareDifference" name="FareDifference" minOccurs="0"/>
         *       &lt;xs:element name="NonRefundableFare" minOccurs="0">
         *         &lt;!-- Reference to inner class NonRefundableFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareComparisonSummary implements Serializable
        {
            private PriceQuoteDetailsFareDifference fareDifference;
            private NonRefundableFare nonRefundableFare;

            /** 
             * Get the 'FareDifference' element value. Fare difference between new fare and fares from exchange document(s).
             * 
             * @return value
             */
            public PriceQuoteDetailsFareDifference getFareDifference() {
                return fareDifference;
            }

            /** 
             * Set the 'FareDifference' element value. Fare difference between new fare and fares from exchange document(s).
             * 
             * @param fareDifference
             */
            public void setFareDifference(
                    PriceQuoteDetailsFareDifference fareDifference) {
                this.fareDifference = fareDifference;
            }

            /** 
             * Get the 'NonRefundableFare' element value.
             * 
             * @return value
             */
            public NonRefundableFare getNonRefundableFare() {
                return nonRefundableFare;
            }

            /** 
             * Set the 'NonRefundableFare' element value.
             * 
             * @param nonRefundableFare
             */
            public void setNonRefundableFare(NonRefundableFare nonRefundableFare) {
                this.nonRefundableFare = nonRefundableFare;
            }
            /** 
             * Non refundable fare
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonRefundableFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="Amount"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="override"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NonRefundableFare implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount amount;
                private Boolean override;

                /** 
                 * Get the 'Amount' element value. Ref:DM0Z_C0_NRAA
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Ref:DM0Z_C0_NRAA
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'override' attribute value. Override Applied
                                                                                    Ref: #DM0Z_C0_NRFO
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'override' attribute value. Override Applied
                                                                                    Ref: #DM0Z_C0_NRFO
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }
            }
        }
        /** 
         * Refund due information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Amount" name="TotalRefund"/>
         *       &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
         *       &lt;xs:element name="NetRemit" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemit -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0" maxOccurs="3">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:RefundFare.TaxInfo" name="TaxInfo" minOccurs="0"/>
         *       &lt;xs:element name="FareCalculation" minOccurs="0">
         *         &lt;!-- Reference to inner class FareCalculation -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="WaiverCode" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="TotalFare" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="multiEquivCurrencyExists"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RefundInfo implements Serializable
        {
            private com.sabre.services.sp.pd.v35.Amount totalRefund;
            private com.sabre.services.sp.pd.v35.Amount baseFare;
            private com.sabre.services.sp.pd.v35.Amount equivalentFare;
            private com.sabre.services.sp.pd.v35.Amount totalTax;
            private NetRemit netRemit;
            private List<Commission> commissionList = new ArrayList<Commission>();
            private RefundFareTaxInfo taxInfo;
            private FareCalculation fareCalculation;
            private String waiverCode;
            private AmountPattern totalFare;
            private Boolean multiEquivCurrencyExists;

            /** 
             * Get the 'TotalRefund' element value. Exchange Amount
                                                                          Ref: DM0Z_36_TAMT
                                                                          Ref: DM0Z_38_BCAM
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getTotalRefund() {
                return totalRefund;
            }

            /** 
             * Set the 'TotalRefund' element value. Exchange Amount
                                                                          Ref: DM0Z_36_TAMT
                                                                          Ref: DM0Z_38_BCAM
             * 
             * @param totalRefund
             */
            public void setTotalRefund(
                    com.sabre.services.sp.pd.v35.Amount totalRefund) {
                this.totalRefund = totalRefund;
            }

            /** 
             * Get the 'BaseFare' element value. Base fare per PQ type
                                                                          Ref: DM0Z_84_BFAR		
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value. Base fare per PQ type
                                                                          Ref: DM0Z_84_BFAR		
             * 
             * @param baseFare
             */
            public void setBaseFare(com.sabre.services.sp.pd.v35.Amount baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
                                                                          Ref: DM0Z_84_EFAR
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
                                                                          Ref: DM0Z_84_EFAR
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(
                    com.sabre.services.sp.pd.v35.Amount equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value. Tax Total per PQ type
                                                                          Ref: DM0Z_84_TTAC		
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value. Tax Total per PQ type
                                                                          Ref: DM0Z_84_TTAC		
             * 
             * @param totalTax
             */
            public void setTotalTax(com.sabre.services.sp.pd.v35.Amount totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'NetRemit' element value.
             * 
             * @return value
             */
            public NetRemit getNetRemit() {
                return netRemit;
            }

            /** 
             * Set the 'NetRemit' element value.
             * 
             * @param netRemit
             */
            public void setNetRemit(NetRemit netRemit) {
                this.netRemit = netRemit;
            }

            /** 
             * Get the list of 'Commission' element items.
             * 
             * @return list
             */
            public List<Commission> getCommissionList() {
                return commissionList;
            }

            /** 
             * Set the list of 'Commission' element items.
             * 
             * @param list
             */
            public void setCommissionList(List<Commission> list) {
                commissionList = list;
            }

            /** 
             * Get the 'TaxInfo' element value.
             * 
             * @return value
             */
            public RefundFareTaxInfo getTaxInfo() {
                return taxInfo;
            }

            /** 
             * Set the 'TaxInfo' element value.
             * 
             * @param taxInfo
             */
            public void setTaxInfo(RefundFareTaxInfo taxInfo) {
                this.taxInfo = taxInfo;
            }

            /** 
             * Get the 'FareCalculation' element value.
             * 
             * @return value
             */
            public FareCalculation getFareCalculation() {
                return fareCalculation;
            }

            /** 
             * Set the 'FareCalculation' element value.
             * 
             * @param fareCalculation
             */
            public void setFareCalculation(FareCalculation fareCalculation) {
                this.fareCalculation = fareCalculation;
            }

            /** 
             * Get the 'WaiverCode' element value. ref:DM0Z_D8_QWCB
             * 
             * @return value
             */
            public String getWaiverCode() {
                return waiverCode;
            }

            /** 
             * Set the 'WaiverCode' element value. ref:DM0Z_D8_QWCB
             * 
             * @param waiverCode
             */
            public void setWaiverCode(String waiverCode) {
                this.waiverCode = waiverCode;
            }

            /** 
             * Get the 'TotalFare' element value. Total Fare not including fee
                                                                          Ref: DM0Z_C0_TAMT
                                                                          DM0Z_85_TAMS
             * 
             * @return value
             */
            public AmountPattern getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value. Total Fare not including fee
                                                                          Ref: DM0Z_C0_TAMT
                                                                          DM0Z_85_TAMS
             * 
             * @param totalFare
             */
            public void setTotalFare(AmountPattern totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'multiEquivCurrencyExists' attribute value. Indicate if Multi equivalent currency exists
                                                                      Ref: DM0Z_20_MI05,#DM0Z_20_MEC
                                                                  
             * 
             * @return value
             */
            public Boolean getMultiEquivCurrencyExists() {
                return multiEquivCurrencyExists;
            }

            /** 
             * Set the 'multiEquivCurrencyExists' attribute value. Indicate if Multi equivalent currency exists
                                                                      Ref: DM0Z_20_MI05,#DM0Z_20_MEC
                                                                  
             * 
             * @param multiEquivCurrencyExists
             */
            public void setMultiEquivCurrencyExists(
                    Boolean multiEquivCurrencyExists) {
                this.multiEquivCurrencyExists = multiEquivCurrencyExists;
            }
            /** 
             * Net Remit applied
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="NetFare" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount" name="NetFareUsed" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount" name="SellingFare" minOccurs="0"/>
             *       &lt;xs:element type="ns:Amount" name="RefundToCC" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemit implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount netFare;
                private com.sabre.services.sp.pd.v35.Amount netFareUsed;
                private com.sabre.services.sp.pd.v35.Amount sellingFare;
                private com.sabre.services.sp.pd.v35.Amount refundToCC;

                /** 
                 * Get the 'NetFare' element value. Ref: DM0Z_D8_NFARXC
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getNetFare() {
                    return netFare;
                }

                /** 
                 * Set the 'NetFare' element value. Ref: DM0Z_D8_NFARXC
                 * 
                 * @param netFare
                 */
                public void setNetFare(
                        com.sabre.services.sp.pd.v35.Amount netFare) {
                    this.netFare = netFare;
                }

                /** 
                 * Get the 'NetFareUsed' element value. Ref: DM0Z_D8_NFUXC
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getNetFareUsed() {
                    return netFareUsed;
                }

                /** 
                 * Set the 'NetFareUsed' element value. Ref: DM0Z_D8_NFUXC
                 * 
                 * @param netFareUsed
                 */
                public void setNetFareUsed(
                        com.sabre.services.sp.pd.v35.Amount netFareUsed) {
                    this.netFareUsed = netFareUsed;
                }

                /** 
                 * Get the 'SellingFare' element value. Ref: DM0Z_D8_SFARXC
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getSellingFare() {
                    return sellingFare;
                }

                /** 
                 * Set the 'SellingFare' element value. Ref: DM0Z_D8_SFARXC
                 * 
                 * @param sellingFare
                 */
                public void setSellingFare(
                        com.sabre.services.sp.pd.v35.Amount sellingFare) {
                    this.sellingFare = sellingFare;
                }

                /** 
                 * Get the 'RefundToCC' element value. Ref: DM0Z_D8_NCCAXC
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getRefundToCC() {
                    return refundToCC;
                }

                /** 
                 * Set the 'RefundToCC' element value. Ref: DM0Z_D8_NCCAXC
                 * 
                 * @param refundToCC
                 */
                public void setRefundToCC(
                        com.sabre.services.sp.pd.v35.Amount refundToCC) {
                    this.refundToCC = refundToCC;
                }
            }
            /** 
             * Commission at Farelevel
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0" maxOccurs="3">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="source"/>
             *     &lt;xs:attribute type="xs:anySimpleType" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount amount;
                private BigDecimal percentage;
                private String source;
                private String type;

                /** 
                 * Get the 'Amount' element value. Commision amount/penalty
                                                                                        Ref: DM0Z_85_COMA
                                                                                    
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Commision amount/penalty
                                                                                        Ref: DM0Z_85_COMA
                                                                                    
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' element value. Commision percentage
                                                                                        Ref: DM0Z_85_KXPA
                                                                                    
                 * 
                 * @return value
                 */
                public BigDecimal getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' element value. Commision percentage
                                                                                        Ref: DM0Z_85_KXPA
                                                                                    
                 * 
                 * @param percentage
                 */
                public void setPercentage(BigDecimal percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the 'source' attribute value. AGT - Agent-entered Commission
                                                                                
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'source' attribute value. AGT - Agent-entered Commission
                                                                                
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * FareCalc line free Text
                                                                          Ref: DM0Z_A5_DATA
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="rateOfExchange"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareCalculation implements Serializable
            {
                private String string;
                private String rateOfExchange;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                            NUC conversion
                 * 
                 * @return value
                 */
                public String getRateOfExchange() {
                    return rateOfExchange;
                }

                /** 
                 * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CROE
                                                                                            NUC conversion
                 * 
                 * @param rateOfExchange
                 */
                public void setRateOfExchange(String rateOfExchange) {
                    this.rateOfExchange = rateOfExchange;
                }
            }
        }
        /** 
         * Old or Exchange Doc
                                                            Information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeDocInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PassengerName" minOccurs="0">
         *         &lt;!-- Reference to inner class PassengerName -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:Amount.Pattern" name="Base" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="Equivalent" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="TotalTax" minOccurs="0"/>
         *       &lt;xs:element type="ns:Amount.Pattern" name="Total" minOccurs="0"/>
         *       &lt;xs:element type="ns:PriceQuote.Details.NewSellingFareInfo" name="SellingFareinfo" minOccurs="0"/>
         *       &lt;xs:element name="Payment" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Payment -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OptionalServiceInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class OptionalServiceInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="nonFlightDoc"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:int" name="conjunctive"/>
         *     &lt;xs:attribute type="xs:string" name="formType"/>
         *     &lt;xs:attribute type="xs:int" name="multiDocGroupId"/>
         *     &lt;xs:attribute type="xs:date" name="expirationDate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExchangeDocInfo implements Serializable
        {
            private PassengerName passengerName;
            private AmountPattern base;
            private AmountPattern equivalent;
            private AmountPattern totalTax;
            private AmountPattern total;
            private PriceQuoteDetailsNewSellingFareInfo sellingFareinfo;
            private List<Payment> paymentList = new ArrayList<Payment>();
            private OptionalServiceInfo optionalServiceInfo;
            private Boolean nonFlightDoc;
            private String number;
            private Integer conjunctive;
            private String formType;
            private Integer multiDocGroupId;
            private java.sql.Date expirationDate;

            /** 
             * Get the 'PassengerName' element value.
             * 
             * @return value
             */
            public PassengerName getPassengerName() {
                return passengerName;
            }

            /** 
             * Set the 'PassengerName' element value.
             * 
             * @param passengerName
             */
            public void setPassengerName(PassengerName passengerName) {
                this.passengerName = passengerName;
            }

            /** 
             * Get the 'Base' element value. Exchange Document Base Amount
                                                                          Ref: DM0Z_36_BFAR
                                                                      
             * 
             * @return value
             */
            public AmountPattern getBase() {
                return base;
            }

            /** 
             * Set the 'Base' element value. Exchange Document Base Amount
                                                                          Ref: DM0Z_36_BFAR
                                                                      
             * 
             * @param base
             */
            public void setBase(AmountPattern base) {
                this.base = base;
            }

            /** 
             * Get the 'Equivalent' element value. Exchange Document Equivalent Amount
                                                                          Ref: DM0Z_36_EFAR
             * 
             * @return value
             */
            public AmountPattern getEquivalent() {
                return equivalent;
            }

            /** 
             * Set the 'Equivalent' element value. Exchange Document Equivalent Amount
                                                                          Ref: DM0Z_36_EFAR
             * 
             * @param equivalent
             */
            public void setEquivalent(AmountPattern equivalent) {
                this.equivalent = equivalent;
            }

            /** 
             * Get the 'TotalTax' element value. Exchange Document Total Tax Amount
                                                                          Ref: DM0Z_36_TTXA
             * 
             * @return value
             */
            public AmountPattern getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value. Exchange Document Total Tax Amount
                                                                          Ref: DM0Z_36_TTXA
             * 
             * @param totalTax
             */
            public void setTotalTax(AmountPattern totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'Total' element value. Exchange Document Total  Amount
                                                                          Ref: DM0Z_36_TFAR
             * 
             * @return value
             */
            public AmountPattern getTotal() {
                return total;
            }

            /** 
             * Set the 'Total' element value. Exchange Document Total  Amount
                                                                          Ref: DM0Z_36_TFAR
             * 
             * @param total
             */
            public void setTotal(AmountPattern total) {
                this.total = total;
            }

            /** 
             * Get the 'SellingFareinfo' element value. Selling Fare
             * 
             * @return value
             */
            public PriceQuoteDetailsNewSellingFareInfo getSellingFareinfo() {
                return sellingFareinfo;
            }

            /** 
             * Set the 'SellingFareinfo' element value. Selling Fare
             * 
             * @param sellingFareinfo
             */
            public void setSellingFareinfo(
                    PriceQuoteDetailsNewSellingFareInfo sellingFareinfo) {
                this.sellingFareinfo = sellingFareinfo;
            }

            /** 
             * Get the list of 'Payment' element items.
             * 
             * @return list
             */
            public List<Payment> getPaymentList() {
                return paymentList;
            }

            /** 
             * Set the list of 'Payment' element items.
             * 
             * @param list
             */
            public void setPaymentList(List<Payment> list) {
                paymentList = list;
            }

            /** 
             * Get the 'OptionalServiceInfo' element value.
             * 
             * @return value
             */
            public OptionalServiceInfo getOptionalServiceInfo() {
                return optionalServiceInfo;
            }

            /** 
             * Set the 'OptionalServiceInfo' element value.
             * 
             * @param optionalServiceInfo
             */
            public void setOptionalServiceInfo(
                    OptionalServiceInfo optionalServiceInfo) {
                this.optionalServiceInfo = optionalServiceInfo;
            }

            /** 
             * Get the 'nonFlightDoc' attribute value. True: for Non-Flight Doc, False: for Flight Doc;
                                                                      default ie Flight Doc
                                                                      Ref: DM0Z_38_DOCI 
             * 
             * @return value
             */
            public Boolean getNonFlightDoc() {
                return nonFlightDoc;
            }

            /** 
             * Set the 'nonFlightDoc' attribute value. True: for Non-Flight Doc, False: for Flight Doc;
                                                                      default ie Flight Doc
                                                                      Ref: DM0Z_38_DOCI 
             * 
             * @param nonFlightDoc
             */
            public void setNonFlightDoc(Boolean nonFlightDoc) {
                this.nonFlightDoc = nonFlightDoc;
            }

            /** 
             * Get the 'number' attribute value.  Document Number
                                                                      Ref: DM0Z_38_DOCN 
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value.  Document Number
                                                                      Ref: DM0Z_38_DOCN 
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'conjunctive' attribute value. Conjunctive range
                                                                      Ref: DM0Z_38_CONJ 
             * 
             * @return value
             */
            public Integer getConjunctive() {
                return conjunctive;
            }

            /** 
             * Set the 'conjunctive' attribute value. Conjunctive range
                                                                      Ref: DM0Z_38_CONJ 
             * 
             * @param conjunctive
             */
            public void setConjunctive(Integer conjunctive) {
                this.conjunctive = conjunctive;
            }

            /** 
             * Get the 'formType' attribute value. Ref: DM0Z_38_TYPE

                                                                      Form type
             * 
             * @return value
             */
            public String getFormType() {
                return formType;
            }

            /** 
             * Set the 'formType' attribute value. Ref: DM0Z_38_TYPE

                                                                      Form type
             * 
             * @param formType
             */
            public void setFormType(String formType) {
                this.formType = formType;
            }

            /** 
             * Get the 'multiDocGroupId' attribute value. Ref:                    Airlines - SR06_PQ_IK4 used to link all the ExchangeDocuments associated to a passenger
             * 
             * @return value
             */
            public Integer getMultiDocGroupId() {
                return multiDocGroupId;
            }

            /** 
             * Set the 'multiDocGroupId' attribute value. Ref:                    Airlines - SR06_PQ_IK4 used to link all the ExchangeDocuments associated to a passenger
             * 
             * @param multiDocGroupId
             */
            public void setMultiDocGroupId(Integer multiDocGroupId) {
                this.multiDocGroupId = multiDocGroupId;
            }

            /** 
             * Get the 'expirationDate' attribute value. The date when ticketing document will expire
                                                                      Ref: #DM0Z_38_EXPR
             * 
             * @return value
             */
            public java.sql.Date getExpirationDate() {
                return expirationDate;
            }

            /** 
             * Set the 'expirationDate' attribute value. The date when ticketing document will expire
                                                                      Ref: #DM0Z_38_EXPR
             * 
             * @param expirationDate
             */
            public void setExpirationDate(java.sql.Date expirationDate) {
                this.expirationDate = expirationDate;
            }
            /** 
             * Passenger Name
                                                                          Ref: DM0Z_68_VNAM
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="firstName"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="lastName"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PassengerName implements Serializable
            {
                private String firstName;
                private String lastName;

                /** 
                 * Get the 'firstName' attribute value. First Name Ref: DM0Z_68_VNAM
                                                                                
                 * 
                 * @return value
                 */
                public String getFirstName() {
                    return firstName;
                }

                /** 
                 * Set the 'firstName' attribute value. First Name Ref: DM0Z_68_VNAM
                                                                                
                 * 
                 * @param firstName
                 */
                public void setFirstName(String firstName) {
                    this.firstName = firstName;
                }

                /** 
                 * Get the 'lastName' attribute value. Last Name Ref: DM0Z_68_VNAM
                                                                                
                 * 
                 * @return value
                 */
                public String getLastName() {
                    return lastName;
                }

                /** 
                 * Set the 'lastName' attribute value. Last Name Ref: DM0Z_68_VNAM
                                                                                
                 * 
                 * @param lastName
                 */
                public void setLastName(String lastName) {
                    this.lastName = lastName;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
             *       &lt;xs:choice minOccurs="0">
             *         &lt;!-- Reference to inner class Choice -->
             *       &lt;/xs:choice>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" name="sequence"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Payment implements Serializable
            {
                private AmountPattern amount;
                private Choice choice;
                private BigInteger sequence;
                private String type;

                /** 
                 * Get the 'Amount' element value. Amount associated to FOP	Ref: DM0Z_B0_FAMT for Exchange
                                                                                    
                 * 
                 * @return value
                 */
                public AmountPattern getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Amount associated to FOP	Ref: DM0Z_B0_FAMT for Exchange
                                                                                    
                 * 
                 * @param amount
                 */
                public void setAmount(AmountPattern amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the choice value.
                 * 
                 * @return value
                 */
                public Choice getChoice() {
                    return choice;
                }

                /** 
                 * Set the choice value.
                 * 
                 * @param choice
                 */
                public void setChoice(Choice choice) {
                    this.choice = choice;
                }

                /** 
                 * Get the 'sequence' attribute value. Serial number of the FOP
                                                                                    1,2
                                                                                    Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
                                                                                
                 * 
                 * @return value
                 */
                public BigInteger getSequence() {
                    return sequence;
                }

                /** 
                 * Set the 'sequence' attribute value. Serial number of the FOP
                                                                                    1,2
                                                                                    Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
                                                                                
                 * 
                 * @param sequence
                 */
                public void setSequence(BigInteger sequence) {
                    this.sequence = sequence;
                }

                /** 
                 * Get the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                                    Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
                                                                                
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                                    Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
                                                                                
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:choice xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
                 *   &lt;xs:element type="xs:string" name="Virtual"/>
                 *   &lt;xs:element type="ns:Payment.Credit" name="Card"/>
                 *   &lt;xs:element type="xs:string" name="NumberOrDetail"/>
                 * &lt;/xs:choice>
                 * </pre>
                 */
                public static class Choice implements Serializable
                {
                    private int choiceSelect = -1;
                    private static final int VIRTUAL_CHOICE = 0;
                    private static final int CARD_CHOICE = 1;
                    private static final int NUMBER_OR_DETAIL_CHOICE = 2;
                    private String virtual;
                    private PaymentCredit card;
                    private String numberOrDetail;

                    private void setChoiceSelect(int choice) {
                        if (choiceSelect == -1) {
                            choiceSelect = choice;
                        } else if (choiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearChoiceSelect() {
                        choiceSelect = -1;
                    }

                    /** 
                     * Check if Virtual is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifVirtual() {
                        return choiceSelect == VIRTUAL_CHOICE;
                    }

                    /** 
                     * Get the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
                     * 
                     * @return value
                     */
                    public String getVirtual() {
                        return virtual;
                    }

                    /** 
                     * Set the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
                     * 
                     * @param virtual
                     */
                    public void setVirtual(String virtual) {
                        setChoiceSelect(VIRTUAL_CHOICE);
                        this.virtual = virtual;
                    }

                    /** 
                     * Check if Card is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifCard() {
                        return choiceSelect == CARD_CHOICE;
                    }

                    /** 
                     * Get the 'Card' element value.
                     * 
                     * @return value
                     */
                    public PaymentCredit getCard() {
                        return card;
                    }

                    /** 
                     * Set the 'Card' element value.
                     * 
                     * @param card
                     */
                    public void setCard(PaymentCredit card) {
                        setChoiceSelect(CARD_CHOICE);
                        this.card = card;
                    }

                    /** 
                     * Check if NumberOrDetail is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifNumberOrDetail() {
                        return choiceSelect == NUMBER_OR_DETAIL_CHOICE;
                    }

                    /** 
                     * Get the 'NumberOrDetail' element value.
                     * 
                     * @return value
                     */
                    public String getNumberOrDetail() {
                        return numberOrDetail;
                    }

                    /** 
                     * Set the 'NumberOrDetail' element value.
                     * 
                     * @param numberOrDetail
                     */
                    public void setNumberOrDetail(String numberOrDetail) {
                        setChoiceSelect(NUMBER_OR_DETAIL_CHOICE);
                        this.numberOrDetail = numberOrDetail;
                    }
                }
            }
            /** 
             * Exchange Document EMD-S Info
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalServiceInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ReasonForIssuanceSubCode"/>
             *       &lt;xs:element type="xs:string" name="GroupCode"/>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ReasonForIssuanceCode" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="refundable"/>
             *     &lt;xs:attribute type="xs:boolean" name="exchangeable"/>
             *     &lt;xs:attribute type="xs:boolean" name="taxable"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OptionalServiceInfo implements Serializable
            {
                private String reasonForIssuanceSubCode;
                private String groupCode;
                private String description;
                private String reasonForIssuanceCode;
                private Boolean refundable;
                private Boolean exchangeable;
                private Boolean taxable;

                /** 
                 * Get the 'ReasonForIssuanceSubCode' element value. Reason for issuance sub-code.
                                                                                        Ref: #DM0Z_38_RFISC
                 * 
                 * @return value
                 */
                public String getReasonForIssuanceSubCode() {
                    return reasonForIssuanceSubCode;
                }

                /** 
                 * Set the 'ReasonForIssuanceSubCode' element value. Reason for issuance sub-code.
                                                                                        Ref: #DM0Z_38_RFISC
                 * 
                 * @param reasonForIssuanceSubCode
                 */
                public void setReasonForIssuanceSubCode(
                        String reasonForIssuanceSubCode) {
                    this.reasonForIssuanceSubCode = reasonForIssuanceSubCode;
                }

                /** 
                 * Get the 'GroupCode' element value. Reason for issuance group code.
                                                                                        Ref: #DM0Z_38_GROUP
                 * 
                 * @return value
                 */
                public String getGroupCode() {
                    return groupCode;
                }

                /** 
                 * Set the 'GroupCode' element value. Reason for issuance group code.
                                                                                        Ref: #DM0Z_38_GROUP
                 * 
                 * @param groupCode
                 */
                public void setGroupCode(String groupCode) {
                    this.groupCode = groupCode;
                }

                /** 
                 * Get the 'Description' element value. Description of the purchased item or service.
                                                                                        Ref: #DM0Z_38_NAME
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value. Description of the purchased item or service.
                                                                                        Ref: #DM0Z_38_NAME
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'ReasonForIssuanceCode' element value. A primary single character code associated to the reason for issuance as defined
                                                                                        by IATA
                                                                                        Ref: #DM0Z_38_RFIC

                                                                                        Possible values can be:
                                                                                        A - Air Transportation
                                                                                        B _ Surface Transportation
                                                                                        C - Baggage
                                                                                        D - Financial Impact
                                                                                        E - Airport Services
                                                                                        F - Merchandise
                                                                                    
                 * 
                 * @return value
                 */
                public String getReasonForIssuanceCode() {
                    return reasonForIssuanceCode;
                }

                /** 
                 * Set the 'ReasonForIssuanceCode' element value. A primary single character code associated to the reason for issuance as defined
                                                                                        by IATA
                                                                                        Ref: #DM0Z_38_RFIC

                                                                                        Possible values can be:
                                                                                        A - Air Transportation
                                                                                        B _ Surface Transportation
                                                                                        C - Baggage
                                                                                        D - Financial Impact
                                                                                        E - Airport Services
                                                                                        F - Merchandise
                                                                                    
                 * 
                 * @param reasonForIssuanceCode
                 */
                public void setReasonForIssuanceCode(
                        String reasonForIssuanceCode) {
                    this.reasonForIssuanceCode = reasonForIssuanceCode;
                }

                /** 
                 * Get the 'refundable' attribute value. Ref: #DM0Z_38_IAT1
                 * 
                 * @return value
                 */
                public Boolean getRefundable() {
                    return refundable;
                }

                /** 
                 * Set the 'refundable' attribute value. Ref: #DM0Z_38_IAT1
                 * 
                 * @param refundable
                 */
                public void setRefundable(Boolean refundable) {
                    this.refundable = refundable;
                }

                /** 
                 * Get the 'exchangeable' attribute value. Ref: #DM0Z_38_IAT1
                 * 
                 * @return value
                 */
                public Boolean getExchangeable() {
                    return exchangeable;
                }

                /** 
                 * Set the 'exchangeable' attribute value. Ref: #DM0Z_38_IAT1
                 * 
                 * @param exchangeable
                 */
                public void setExchangeable(Boolean exchangeable) {
                    this.exchangeable = exchangeable;
                }

                /** 
                 * Get the 'taxable' attribute value. Ref: #DM0Z_38_TAX
                 * 
                 * @return value
                 */
                public Boolean getTaxable() {
                    return taxable;
                }

                /** 
                 * Set the 'taxable' attribute value. Ref: #DM0Z_38_TAX
                 * 
                 * @param taxable
                 */
                public void setTaxable(Boolean taxable) {
                    this.taxable = taxable;
                }
            }
        }
        /** 
         * Additional Collection
                                                            for this Transaction
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddCollectInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Amount" name="TotalAmount" minOccurs="0"/>
         *       &lt;xs:element name="Taxes" minOccurs="0" maxOccurs="99">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AddCollectInfo implements Serializable
        {
            private com.sabre.services.sp.pd.v35.Amount totalAmount;
            private List<Taxes> taxeList = new ArrayList<Taxes>();

            /** 
             * Get the 'TotalAmount' element value. Total amount collected
                                                                          this transaction
                                                                          For TN: Fare Diff + Ticket Fee tax
                                                                          Ref: DM0Z_C0_TAMT + C0_TFTB
                                                                          For AS: Fare Diff + Change Fee
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getTotalAmount() {
                return totalAmount;
            }

            /** 
             * Set the 'TotalAmount' element value. Total amount collected
                                                                          this transaction
                                                                          For TN: Fare Diff + Ticket Fee tax
                                                                          Ref: DM0Z_C0_TAMT + C0_TFTB
                                                                          For AS: Fare Diff + Change Fee
             * 
             * @param totalAmount
             */
            public void setTotalAmount(
                    com.sabre.services.sp.pd.v35.Amount totalAmount) {
                this.totalAmount = totalAmount;
            }

            /** 
             * Get the list of 'Taxes' element items.
             * 
             * @return list
             */
            public List<Taxes> getTaxeList() {
                return taxeList;
            }

            /** 
             * Set the list of 'Taxes' element items.
             * 
             * @param list
             */
            public void setTaxeList(List<Taxes> list) {
                taxeList = list;
            }
            /** 
             * Add collect taxes
                                                                          applicable only for TN
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="Amount"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount amount;
                private String code;

                /** 
                 * Get the 'Amount' element value. Ref:DM0Z_C6_UAMT
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Ref:DM0Z_C6_UAMT
                 * 
                 * @param amount
                 */
                public void setAmount(com.sabre.services.sp.pd.v35.Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'code' attribute value. Tax box identifier
                                                                                    Ref: DM0Z_C6_TIDE			
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Tax box identifier
                                                                                    Ref: DM0Z_C6_TIDE			
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Residual information
                                                            on exchange
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResidualInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Amount" name="TotalAmount" minOccurs="0"/>
         *       &lt;xs:element name="RefundableDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class RefundableDetails -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:Amount" name="ForfeitedAmount" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ResidualInfo implements Serializable
        {
            private com.sabre.services.sp.pd.v35.Amount totalAmount;
            private RefundableDetails refundableDetails;
            private com.sabre.services.sp.pd.v35.Amount forfeitedAmount;

            /** 
             * Get the 'TotalAmount' element value. Residual applied to penalty per rule
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getTotalAmount() {
                return totalAmount;
            }

            /** 
             * Set the 'TotalAmount' element value. Residual applied to penalty per rule
             * 
             * @param totalAmount
             */
            public void setTotalAmount(
                    com.sabre.services.sp.pd.v35.Amount totalAmount) {
                this.totalAmount = totalAmount;
            }

            /** 
             * Get the 'RefundableDetails' element value.
             * 
             * @return value
             */
            public RefundableDetails getRefundableDetails() {
                return refundableDetails;
            }

            /** 
             * Set the 'RefundableDetails' element value.
             * 
             * @param refundableDetails
             */
            public void setRefundableDetails(RefundableDetails refundableDetails) {
                this.refundableDetails = refundableDetails;
            }

            /** 
             * Get the 'ForfeitedAmount' element value. Forfeited amount
             * 
             * @return value
             */
            public com.sabre.services.sp.pd.v35.Amount getForfeitedAmount() {
                return forfeitedAmount;
            }

            /** 
             * Set the 'ForfeitedAmount' element value. Forfeited amount
             * 
             * @param forfeitedAmount
             */
            public void setForfeitedAmount(
                    com.sabre.services.sp.pd.v35.Amount forfeitedAmount) {
                this.forfeitedAmount = forfeitedAmount;
            }
            /** 
             * Refundable Amount
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundableDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:Amount" name="AdjustedAmount" minOccurs="0"/>
             *       &lt;xs:element type="ns:Residual.Tax" name="Taxes" minOccurs="0" maxOccurs="99"/>
             *       &lt;xs:element type="ns:Amount" name="AmountIssuedOnEMD" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RefundableDetails implements Serializable
            {
                private com.sabre.services.sp.pd.v35.Amount adjustedAmount;
                private List<ResidualTax> taxeList = new ArrayList<ResidualTax>();
                private com.sabre.services.sp.pd.v35.Amount amountIssuedOnEMD;

                /** 
                 * Get the 'AdjustedAmount' element value. Residual amount refundable per rule - Adjusted when penalty is applicable
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAdjustedAmount() {
                    return adjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' element value. Residual amount refundable per rule - Adjusted when penalty is applicable
                 * 
                 * @param adjustedAmount
                 */
                public void setAdjustedAmount(
                        com.sabre.services.sp.pd.v35.Amount adjustedAmount) {
                    this.adjustedAmount = adjustedAmount;
                }

                /** 
                 * Get the list of 'Taxes' element items.
                 * 
                 * @return list
                 */
                public List<ResidualTax> getTaxeList() {
                    return taxeList;
                }

                /** 
                 * Set the list of 'Taxes' element items.
                 * 
                 * @param list
                 */
                public void setTaxeList(List<ResidualTax> list) {
                    taxeList = list;
                }

                /** 
                 * Get the 'AmountIssuedOnEMD' element value. Residual amount issued as EMD
                                                                                        Ref: #DM0Z_B9_RFBAL
                                                                                        DM0Z_B9_RB_AMTC
                 * 
                 * @return value
                 */
                public com.sabre.services.sp.pd.v35.Amount getAmountIssuedOnEMD() {
                    return amountIssuedOnEMD;
                }

                /** 
                 * Set the 'AmountIssuedOnEMD' element value. Residual amount issued as EMD
                                                                                        Ref: #DM0Z_B9_RFBAL
                                                                                        DM0Z_B9_RB_AMTC
                 * 
                 * @param amountIssuedOnEMD
                 */
                public void setAmountIssuedOnEMD(
                        com.sabre.services.sp.pd.v35.Amount amountIssuedOnEMD) {
                    this.amountIssuedOnEMD = amountIssuedOnEMD;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Message" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Message -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Remarks" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Remarks -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="PricingParameters" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ManualInputMessage" minOccurs="0"/>
         *       &lt;xs:element name="BaggageDisclosure" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageDisclosure -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MessageInfo implements Serializable
        {
            private List<Message> messageList = new ArrayList<Message>();
            private List<Remarks> remarkList = new ArrayList<Remarks>();
            private String pricingParameters;
            private String manualInputMessage;
            private List<BaggageDisclosure> baggageDisclosureList = new ArrayList<BaggageDisclosure>();

            /** 
             * Get the list of 'Message' element items.
             * 
             * @return list
             */
            public List<Message> getMessageList() {
                return messageList;
            }

            /** 
             * Set the list of 'Message' element items.
             * 
             * @param list
             */
            public void setMessageList(List<Message> list) {
                messageList = list;
            }

            /** 
             * Get the list of 'Remarks' element items.
             * 
             * @return list
             */
            public List<Remarks> getRemarkList() {
                return remarkList;
            }

            /** 
             * Set the list of 'Remarks' element items.
             * 
             * @param list
             */
            public void setRemarkList(List<Remarks> list) {
                remarkList = list;
            }

            /** 
             * Get the 'PricingParameters' element value. Pricing parameter used to price PQ

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_PRI
             * 
             * @return value
             */
            public String getPricingParameters() {
                return pricingParameters;
            }

            /** 
             * Set the 'PricingParameters' element value. Pricing parameter used to price PQ

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_PRI
             * 
             * @param pricingParameters
             */
            public void setPricingParameters(String pricingParameters) {
                this.pricingParameters = pricingParameters;
            }

            /** 
             * Get the 'ManualInputMessage' element value. Manual input free Text

                                                                          Ref:
                                                                          DM0Z_60_TYPE
                                                                          #DM0Z_60_MAN
             * 
             * @return value
             */
            public String getManualInputMessage() {
                return manualInputMessage;
            }

            /** 
             * Set the 'ManualInputMessage' element value. Manual input free Text

                                                                          Ref:
                                                                          DM0Z_60_TYPE
                                                                          #DM0Z_60_MAN
             * 
             * @param manualInputMessage
             */
            public void setManualInputMessage(String manualInputMessage) {
                this.manualInputMessage = manualInputMessage;
            }

            /** 
             * Get the list of 'BaggageDisclosure' element items.
             * 
             * @return list
             */
            public List<BaggageDisclosure> getBaggageDisclosureList() {
                return baggageDisclosureList;
            }

            /** 
             * Set the list of 'BaggageDisclosure' element items.
             * 
             * @param list
             */
            public void setBaggageDisclosureList(List<BaggageDisclosure> list) {
                baggageDisclosureList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Message" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *         &lt;xs:attribute type="xs:string" name="subtype"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Message implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;
                private String subtype;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                            WARNING
                                                                                            INFO

                                                                                            Ref:  DM0Z_60_TYPE

                                                                                            x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                            WARNING
                                                                                            INFO

                                                                                            Ref:  DM0Z_60_TYPE

                                                                                            x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                            Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                            Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }

                /** 
                 * Get the 'subtype' attribute value. 
                                                                                            Subtype for INFO messages

                                                                                            Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                            Possible values: Display, Private, NetRemit
                                                                                        
                 * 
                 * @return value
                 */
                public String getSubtype() {
                    return subtype;
                }

                /** 
                 * Set the 'subtype' attribute value. 
                                                                                            Subtype for INFO messages

                                                                                            Ref:  DM0Z_60_TYPE x'03,11,13
                                                                                            Possible values: Display, Private, NetRemit
                                                                                        
                 * 
                 * @param subtype
                 */
                public void setSubtype(String subtype) {
                    this.subtype = subtype;
                }
            }
            /** 
             * Remarks applicable on the ticket display
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute use="required" name="type">
             *           &lt;xs:simpleType>
             *             &lt;!-- Reference to inner class Type -->
             *           &lt;/xs:simpleType>
             *         &lt;/xs:attribute>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remarks implements Serializable
            {
                private String string;
                private Type type;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ENS - System-generated endorsement
                                                                                            END - Agent-generated endorsement
                                                                                            ENO - Endorsement override
                                                                                            EO1 - Endorsement override 1
                                                                                            EO2 -  Endorsement override 2
                                                                                            EOD  - Endorsement override with ED
                                                                                            RES -  System-generated restriction
                                                                                            RTE -  Reissue-type endorsement
                                                                                            MSK - Mask-entered endorsement
                                                                                            RMK - Mask-entered remark
                                                                                            Ref:  DM0Z_60_TYPE -
                                                                                            x' 05 - x'0F
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ENS - System-generated endorsement
                                                                                            END - Agent-generated endorsement
                                                                                            ENO - Endorsement override
                                                                                            EO1 - Endorsement override 1
                                                                                            EO2 -  Endorsement override 2
                                                                                            EOD  - Endorsement override with ED
                                                                                            RES -  System-generated restriction
                                                                                            RTE -  Reissue-type endorsement
                                                                                            MSK - Mask-entered endorsement
                                                                                            RMK - Mask-entered remark
                                                                                            Ref:  DM0Z_60_TYPE -
                                                                                            x' 05 - x'0F
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="ENS"/>
                 *     &lt;xs:enumeration value="END"/>
                 *     &lt;xs:enumeration value="ENO"/>
                 *     &lt;xs:enumeration value="EO1"/>
                 *     &lt;xs:enumeration value="EO2"/>
                 *     &lt;xs:enumeration value="EOD"/>
                 *     &lt;xs:enumeration value="RES"/>
                 *     &lt;xs:enumeration value="ERR"/>
                 *     &lt;xs:enumeration value="RTE"/>
                 *     &lt;xs:enumeration value="MSK"/>
                 *     &lt;xs:enumeration value="RMK"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    ENS("ENS"), END("END"), ENO("ENO"), E_O1("EO1"), E_O2("EO2"), EOD(
                            "EOD"), RES("RES"), ERR("ERR"), RTE("RTE"), MSK(
                            "MSK"), RMK("RMK");
                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Type convert(String value) {
                        for (Type inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Baggage disclosure free text
                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_BAG
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDisclosure" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageDisclosure implements Serializable
            {
                private String string;
                private String type;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. Type of Baggage Allowance  / disclosure at PQ level.
                                                                                            Ref: DM0Z_60_TYPB
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Type of Baggage Allowance  / disclosure at PQ level.
                                                                                            Ref: DM0Z_60_TYPB
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AgentInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:all>
         *             &lt;xs:element type="xs:string" name="HomeLocation"/>
         *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
         *           &lt;/xs:all>
         *           &lt;xs:attribute type="xs:string" name="sine"/>
         *           &lt;xs:attribute type="xs:string" name="duty"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="TransactionInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:dateTime" name="SystemDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="CreateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LocalDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="ModificationDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class ModificationDetails -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="sequence"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HistoryInfo implements Serializable
        {
            private String agentInfoHomeLocation;
            private String agentInfoWorkLocation;
            private String agentInfoSine;
            private String agentInfoDuty;
            private Date transactionInfoSystemDateTime;
            private Date transactionInfoCreateDateTime;
            private Date transactionInfoUpdateDateTime;
            private Date transactionInfoLastDateToPurchase;
            private Date transactionInfoLocalDateTime;
            private Date transactionInfoLocalCreateDateTime;
            private Date transactionInfoLocalUpdateDateTime;
            private Date transactionInfoExpiryDateTime;
            private String transactionInfoInputEntry;
            private ModificationDetails modificationDetails;
            private BigInteger sequence;
            private String type;

            /** 
             * Get the 'HomeLocation' element value. Agent home city code
                                                                                      Ref: DM0Z_65_CHOM
                                                                                      Ref: DM0Z_E0_CHOM for history
             * 
             * @return value
             */
            public String getAgentInfoHomeLocation() {
                return agentInfoHomeLocation;
            }

            /** 
             * Set the 'HomeLocation' element value. Agent home city code
                                                                                      Ref: DM0Z_65_CHOM
                                                                                      Ref: DM0Z_E0_CHOM for history
             * 
             * @param agentInfoHomeLocation
             */
            public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
                this.agentInfoHomeLocation = agentInfoHomeLocation;
            }

            /** 
             * Get the 'WorkLocation' element value. Pseudo City Code
                                                                                      Ref: DM0Z_65_CCTY
                                                                                      Ref: DM0Z_E0_CCTY for history
             * 
             * @return value
             */
            public String getAgentInfoWorkLocation() {
                return agentInfoWorkLocation;
            }

            /** 
             * Set the 'WorkLocation' element value. Pseudo City Code
                                                                                      Ref: DM0Z_65_CCTY
                                                                                      Ref: DM0Z_E0_CCTY for history
             * 
             * @param agentInfoWorkLocation
             */
            public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
                this.agentInfoWorkLocation = agentInfoWorkLocation;
            }

            /** 
             * Get the 'sine' attribute value. Agent sine-in code
                                                                                  Ref: DM0Z_65_CSIN
                                                                                  Ref: DM0Z_E0_CSIN for history
             * 
             * @return value
             */
            public String getAgentInfoSine() {
                return agentInfoSine;
            }

            /** 
             * Set the 'sine' attribute value. Agent sine-in code
                                                                                  Ref: DM0Z_65_CSIN
                                                                                  Ref: DM0Z_E0_CSIN for history
             * 
             * @param agentInfoSine
             */
            public void setAgentInfoSine(String agentInfoSine) {
                this.agentInfoSine = agentInfoSine;
            }

            /** 
             * Get the 'duty' attribute value. Agent duty code.
                                                                                  Ref: DM0Z_65_CDTY
                                                                                  Ref: DM0Z_E0_CDTY for history
             * 
             * @return value
             */
            public String getAgentInfoDuty() {
                return agentInfoDuty;
            }

            /** 
             * Set the 'duty' attribute value. Agent duty code.
                                                                                  Ref: DM0Z_65_CDTY
                                                                                  Ref: DM0Z_E0_CDTY for history
             * 
             * @param agentInfoDuty
             */
            public void setAgentInfoDuty(String agentInfoDuty) {
                this.agentInfoDuty = agentInfoDuty;
            }

            /** 
             * Get the 'SystemDateTime' element value. System Date/time the PQ was created
                                                                                          Ref: DM0Z_65_CLDB and
                                                                                          DM0Z_65_CLTB
                                                                                          DM0Z_65_ULDB
                                                                                          DM0Z_65_ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoSystemDateTime() {
                return transactionInfoSystemDateTime;
            }

            /** 
             * Set the 'SystemDateTime' element value. System Date/time the PQ was created
                                                                                          Ref: DM0Z_65_CLDB and
                                                                                          DM0Z_65_CLTB
                                                                                          DM0Z_65_ULDB
                                                                                          DM0Z_65_ULTB
             * 
             * @param transactionInfoSystemDateTime
             */
            public void setTransactionInfoSystemDateTime(
                    Date transactionInfoSystemDateTime) {
                this.transactionInfoSystemDateTime = transactionInfoSystemDateTime;
            }

            /** 
             * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                                          Ref: DM0Z_65_CLDB and
                                                                                          DM0Z_65_CLTB
             * 
             * @return value
             */
            public Date getTransactionInfoCreateDateTime() {
                return transactionInfoCreateDateTime;
            }

            /** 
             * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                                          Ref: DM0Z_65_CLDB and
                                                                                          DM0Z_65_CLTB
             * 
             * @param transactionInfoCreateDateTime
             */
            public void setTransactionInfoCreateDateTime(
                    Date transactionInfoCreateDateTime) {
                this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
            }

            /** 
             * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                                          Ref: DM0Z_65_ULDB and
                                                                                          DM0Z_65_ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoUpdateDateTime() {
                return transactionInfoUpdateDateTime;
            }

            /** 
             * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                                          Ref: DM0Z_65_ULDB and
                                                                                          DM0Z_65_ULTB
             * 
             * @param transactionInfoUpdateDateTime
             */
            public void setTransactionInfoUpdateDateTime(
                    Date transactionInfoUpdateDateTime) {
                this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
            }

            /** 
             * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
             * 
             * @return value
             */
            public Date getTransactionInfoLastDateToPurchase() {
                return transactionInfoLastDateToPurchase;
            }

            /** 
             * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
             * 
             * @param transactionInfoLastDateToPurchase
             */
            public void setTransactionInfoLastDateToPurchase(
                    Date transactionInfoLastDateToPurchase) {
                this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
            }

            /** 
             * Get the 'LocalDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_CLDB/CTIM
                                                                                          SR06PQ-20_ULDB/ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoLocalDateTime() {
                return transactionInfoLocalDateTime;
            }

            /** 
             * Set the 'LocalDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_CLDB/CTIM
                                                                                          SR06PQ-20_ULDB/ULTB
             * 
             * @param transactionInfoLocalDateTime
             */
            public void setTransactionInfoLocalDateTime(
                    Date transactionInfoLocalDateTime) {
                this.transactionInfoLocalDateTime = transactionInfoLocalDateTime;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getTransactionInfoLocalCreateDateTime() {
                return transactionInfoLocalCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param transactionInfoLocalCreateDateTime
             */
            public void setTransactionInfoLocalCreateDateTime(
                    Date transactionInfoLocalCreateDateTime) {
                this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
            }

            /** 
             * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_ULDB/ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoLocalUpdateDateTime() {
                return transactionInfoLocalUpdateDateTime;
            }

            /** 
             * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                                          Ref: SR06PQ-20_ULDB/ULTB
             * 
             * @param transactionInfoLocalUpdateDateTime
             */
            public void setTransactionInfoLocalUpdateDateTime(
                    Date transactionInfoLocalUpdateDateTime) {
                this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
            }

            /** 
             * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
             * 
             * @return value
             */
            public Date getTransactionInfoExpiryDateTime() {
                return transactionInfoExpiryDateTime;
            }

            /** 
             * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
             * 
             * @param transactionInfoExpiryDateTime
             */
            public void setTransactionInfoExpiryDateTime(
                    Date transactionInfoExpiryDateTime) {
                this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
            }

            /** 
             * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                                          Ref: DM0Z_E0_IMGE
             * 
             * @return value
             */
            public String getTransactionInfoInputEntry() {
                return transactionInfoInputEntry;
            }

            /** 
             * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                                          Ref: DM0Z_E0_IMGE
             * 
             * @param transactionInfoInputEntry
             */
            public void setTransactionInfoInputEntry(
                    String transactionInfoInputEntry) {
                this.transactionInfoInputEntry = transactionInfoInputEntry;
            }

            /** 
             * Get the 'ModificationDetails' element value.
             * 
             * @return value
             */
            public ModificationDetails getModificationDetails() {
                return modificationDetails;
            }

            /** 
             * Set the 'ModificationDetails' element value.
             * 
             * @param modificationDetails
             */
            public void setModificationDetails(
                    ModificationDetails modificationDetails) {
                this.modificationDetails = modificationDetails;
            }

            /** 
             * Get the 'sequence' attribute value.
             * 
             * @return value
             */
            public BigInteger getSequence() {
                return sequence;
            }

            /** 
             * Set the 'sequence' attribute value.
             * 
             * @param sequence
             */
            public void setSequence(BigInteger sequence) {
                this.sequence = sequence;
            }

            /** 
             * Get the 'type' attribute value. History type

                                                                      Possible values:
                                                                      Create
                                                                      Update
                                                                      Delete
                                                                  
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. History type

                                                                      Possible values:
                                                                      Create
                                                                      Update
                                                                      Delete
                                                                  
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
            /** 
             * Details of the updates made to the price quote.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModificationDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ModificationDetails implements Serializable
            {
                private List<ManualPricing> manualPricingList = new ArrayList<ManualPricing>();

                /** 
                 * Get the list of 'ManualPricing' element items.
                 * 
                 * @return list
                 */
                public List<ManualPricing> getManualPricingList() {
                    return manualPricingList;
                }

                /** 
                 * Set the list of 'ManualPricing' element items.
                 * 
                 * @param list
                 */
                public void setManualPricingList(List<ManualPricing> list) {
                    manualPricingList = list;
                }
                /** 
                 * Ref: DM0Z_E0_HTYP=#DM0Z_E0_WIC (history type x'0B')
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private String message;
                    private String type;

                    /** 
                     * Get the 'Message' element value. Message
                                                                                                      Ref: DM0Z_E0_ICMG
                     * 
                     * @return value
                     */
                    public String getMessage() {
                        return message;
                    }

                    /** 
                     * Set the 'Message' element value. Message
                                                                                                      Ref: DM0Z_E0_ICMG
                     * 
                     * @param message
                     */
                    public void setMessage(String message) {
                        this.message = message;
                    }

                    /** 
                     * Get the 'type' attribute value. UpdateType

                                                                                                  Possible values:
                                                                                                  XPQ
                                                                                                  MPQ
                                                                                                  APQ

                                                                                                  Ref: DM0Z_E0_HPQS
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. UpdateType

                                                                                                  Possible values:
                                                                                                  XPQ
                                                                                                  MPQ
                                                                                                  APQ

                                                                                                  Ref: DM0Z_E0_HPQS
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalDocInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceQuote.RelatedDoc.Payment" name="Payment" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:PriceQuote.Details.OptionalServiceInfo" name="OptionalServiceInfo" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:dateTime" name="issueDate"/>
         *     &lt;xs:attribute type="xs:string" name="issueCity"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginalDocInfo implements Serializable
        {
            private List<PriceQuoteRelatedDocPayment> paymentList = new ArrayList<PriceQuoteRelatedDocPayment>();
            private PriceQuoteDetailsOptionalServiceInfo optionalServiceInfo;
            private String number;
            private Date issueDate;
            private String issueCity;

            /** 
             * Get the list of 'Payment' element items.
             * 
             * @return list
             */
            public List<PriceQuoteRelatedDocPayment> getPaymentList() {
                return paymentList;
            }

            /** 
             * Set the list of 'Payment' element items.
             * 
             * @param list
             */
            public void setPaymentList(List<PriceQuoteRelatedDocPayment> list) {
                paymentList = list;
            }

            /** 
             * Get the 'OptionalServiceInfo' element value. New Document EMD-S Info
             * 
             * @return value
             */
            public PriceQuoteDetailsOptionalServiceInfo getOptionalServiceInfo() {
                return optionalServiceInfo;
            }

            /** 
             * Set the 'OptionalServiceInfo' element value. New Document EMD-S Info
             * 
             * @param optionalServiceInfo
             */
            public void setOptionalServiceInfo(
                    PriceQuoteDetailsOptionalServiceInfo optionalServiceInfo) {
                this.optionalServiceInfo = optionalServiceInfo;
            }

            /** 
             * Get the 'number' attribute value.  Document Number
                                                                      Ref: DM0Z_B8_OTKN 
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value.  Document Number
                                                                      Ref: DM0Z_B8_OTKN 
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'issueDate' attribute value. Original doc issue date
                                                                      Ref: DM0Z_B8_ODTE
             * 
             * @return value
             */
            public Date getIssueDate() {
                return issueDate;
            }

            /** 
             * Set the 'issueDate' attribute value. Original doc issue date
                                                                      Ref: DM0Z_B8_ODTE
             * 
             * @param issueDate
             */
            public void setIssueDate(Date issueDate) {
                this.issueDate = issueDate;
            }

            /** 
             * Get the 'issueCity' attribute value. Original doc place of issuance
                                                                      Ref: DM0Z_B8_OCTY
             * 
             * @return value
             */
            public String getIssueCity() {
                return issueCity;
            }

            /** 
             * Set the 'issueCity' attribute value. Original doc place of issuance
                                                                      Ref: DM0Z_B8_OCTY
             * 
             * @param issueCity
             */
            public void setIssueCity(String issueCity) {
                this.issueCity = issueCity;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="PQ"/>
         *     &lt;xs:enumeration value="PQR"/>
         *     &lt;xs:enumeration value="PQRE"/>
         *     &lt;xs:enumeration value="PQRR"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            PQ, PQR, PQRE, PQRR
        }
    }
    /** 
     * Price Quote Custom details. This information is equivalent to *PQ
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomDetails" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgentInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="HomeLocation"/>
     *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" name="sine"/>
     *           &lt;xs:attribute type="xs:string" name="duty"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="TransactionInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:dateTime" name="CreateDateTime"/>
     *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="ReissueMethod" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="ReissueResult" minOccurs="0"/>
     *             &lt;xs:element name="PricedLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class PricedLocation -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="TicketedLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class TicketedLocation -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="PricingQualifiers" minOccurs="0">
     *               &lt;!-- Reference to inner class PricingQualifiers -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="xs:dateTime" name="TicketByDate" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:boolean" name="taxModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="changeFeeModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="bagModified"/>
     *           &lt;xs:attribute type="xs:boolean" name="simultaneousTicketForFare"/>
     *           &lt;xs:attribute type="xs:integer" name="pricingFailCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="OrderInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class OrderInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class NameAssociationInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SegmentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalFareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalFareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FeeInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscellaneousInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscellaneousInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInfo" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class PaymentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareComparisonSummary" minOccurs="0">
     *         &lt;!-- Reference to inner class FareComparisonSummary -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RefundInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class RefundInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ExchangeDocInfo" minOccurs="0" maxOccurs="10">
     *         &lt;!-- Reference to inner class ExchangeDocInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ResidualInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class ResidualInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AddCollectInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AddCollectInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MessageInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MessageInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HistoryInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginalDocInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginalDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute use="required" name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
     *     &lt;xs:attribute type="xs:string" name="passengerType"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
     *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
     *     &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
     *     &lt;xs:attribute type="xs:anySimpleType" name="reissueTransactionType"/>
     *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
     *     &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
     *     &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
     *     &lt;xs:attribute type="xs:boolean" name="ataFormat"/>
     *     &lt;xs:attribute type="xs:string" name="pqOwner"/>
     *     &lt;xs:attribute type="xs:string" name="previousStatus"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CustomDetails implements Serializable
    {
        private String agentInfoHomeLocation;
        private String agentInfoWorkLocation;
        private String agentInfoSine;
        private String agentInfoDuty;
        private Date transactionInfoCreateDateTime;
        private Date transactionInfoUpdateDateTime;
        private Date transactionInfoLastDateToPurchase;
        private Date transactionInfoLocalCreateDateTime;
        private Date transactionInfoLocalUpdateDateTime;
        private Date transactionInfoExpiryDateTime;
        private String transactionInfoInputEntry;
        private String transactionInfoReissueMethod;
        private String transactionInfoReissueResult;
        private PricedLocation pricedLocation;
        private TicketedLocation ticketedLocation;
        private PricingQualifiers pricingQualifiers;
        private Date transactionInfoTicketByDate;
        private Boolean transactionInfoTaxModified;
        private Boolean transactionInfoChangeFeeModified;
        private Boolean transactionInfoBagModified;
        private Boolean transactionInfoSimultaneousTicketForFare;
        private BigInteger transactionInfoPricingFailCode;
        private OrderInfo orderInfo;
        private List<NameAssociationInfo> nameAssociationInfoList = new ArrayList<NameAssociationInfo>();
        private List<SegmentInfo> segmentInfoList = new ArrayList<SegmentInfo>();
        private FareInfo fareInfo;
        private AdditionalFareInfo additionalFareInfo;
        private List<FeeInfo> feeInfoList = new ArrayList<FeeInfo>();
        private MiscellaneousInfo miscellaneousInfo;
        private List<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        private FareComparisonSummary fareComparisonSummary;
        private RefundInfo refundInfo;
        private List<ExchangeDocInfo> exchangeDocInfoList = new ArrayList<ExchangeDocInfo>();
        private ResidualInfo residualInfo;
        private AddCollectInfo addCollectInfo;
        private MessageInfo messageInfo;
        private List<HistoryInfo> historyInfoList = new ArrayList<HistoryInfo>();
        private OriginalDocInfo originalDocInfo;
        private Type type;
        private BigInteger number;
        private String passengerType;
        private String status;
        private String pricingType;
        private String pricingStatus;
        private Boolean displayOnly;
        private String reissueTransactionType;
        private Boolean lowCostCarrier;
        private Boolean incompletePQR;
        private Boolean createdByOrder;
        private Boolean ataFormat;
        private String pqOwner;
        private String previousStatus;

        /** 
         * Get the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @return value
         */
        public String getAgentInfoHomeLocation() {
            return agentInfoHomeLocation;
        }

        /** 
         * Set the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @param agentInfoHomeLocation
         */
        public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
            this.agentInfoHomeLocation = agentInfoHomeLocation;
        }

        /** 
         * Get the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @return value
         */
        public String getAgentInfoWorkLocation() {
            return agentInfoWorkLocation;
        }

        /** 
         * Set the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @param agentInfoWorkLocation
         */
        public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
            this.agentInfoWorkLocation = agentInfoWorkLocation;
        }

        /** 
         * Get the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @return value
         */
        public String getAgentInfoSine() {
            return agentInfoSine;
        }

        /** 
         * Set the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @param agentInfoSine
         */
        public void setAgentInfoSine(String agentInfoSine) {
            this.agentInfoSine = agentInfoSine;
        }

        /** 
         * Get the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @return value
         */
        public String getAgentInfoDuty() {
            return agentInfoDuty;
        }

        /** 
         * Set the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @param agentInfoDuty
         */
        public void setAgentInfoDuty(String agentInfoDuty) {
            this.agentInfoDuty = agentInfoDuty;
        }

        /** 
         * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @return value
         */
        public Date getTransactionInfoCreateDateTime() {
            return transactionInfoCreateDateTime;
        }

        /** 
         * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @param transactionInfoCreateDateTime
         */
        public void setTransactionInfoCreateDateTime(
                Date transactionInfoCreateDateTime) {
            this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
        }

        /** 
         * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoUpdateDateTime() {
            return transactionInfoUpdateDateTime;
        }

        /** 
         * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @param transactionInfoUpdateDateTime
         */
        public void setTransactionInfoUpdateDateTime(
                Date transactionInfoUpdateDateTime) {
            this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
        }

        /** 
         * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @return value
         */
        public Date getTransactionInfoLastDateToPurchase() {
            return transactionInfoLastDateToPurchase;
        }

        /** 
         * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @param transactionInfoLastDateToPurchase
         */
        public void setTransactionInfoLastDateToPurchase(
                Date transactionInfoLastDateToPurchase) {
            this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
        }

        /** 
         * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @return value
         */
        public Date getTransactionInfoLocalCreateDateTime() {
            return transactionInfoLocalCreateDateTime;
        }

        /** 
         * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @param transactionInfoLocalCreateDateTime
         */
        public void setTransactionInfoLocalCreateDateTime(
                Date transactionInfoLocalCreateDateTime) {
            this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
        }

        /** 
         * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoLocalUpdateDateTime() {
            return transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @param transactionInfoLocalUpdateDateTime
         */
        public void setTransactionInfoLocalUpdateDateTime(
                Date transactionInfoLocalUpdateDateTime) {
            this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @return value
         */
        public Date getTransactionInfoExpiryDateTime() {
            return transactionInfoExpiryDateTime;
        }

        /** 
         * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @param transactionInfoExpiryDateTime
         */
        public void setTransactionInfoExpiryDateTime(
                Date transactionInfoExpiryDateTime) {
            this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
        }

        /** 
         * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @return value
         */
        public String getTransactionInfoInputEntry() {
            return transactionInfoInputEntry;
        }

        /** 
         * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @param transactionInfoInputEntry
         */
        public void setTransactionInfoInputEntry(
                String transactionInfoInputEntry) {
            this.transactionInfoInputEntry = transactionInfoInputEntry;
        }

        /** 
         * Get the 'ReissueMethod' element value. possible values -
                                                                        - EXCH
                                                                        - RFND
                                                                        - AUTOREDIRECT
                                                                        - AUTOEXCH
                                                                        - AUTORFND
         * 
         * @return value
         */
        public String getTransactionInfoReissueMethod() {
            return transactionInfoReissueMethod;
        }

        /** 
         * Set the 'ReissueMethod' element value. possible values -
                                                                        - EXCH
                                                                        - RFND
                                                                        - AUTOREDIRECT
                                                                        - AUTOEXCH
                                                                        - AUTORFND
         * 
         * @param transactionInfoReissueMethod
         */
        public void setTransactionInfoReissueMethod(
                String transactionInfoReissueMethod) {
            this.transactionInfoReissueMethod = transactionInfoReissueMethod;
        }

        /** 
         * Get the 'ReissueResult' element value. Result of the Reissue transaction
                                                                        Ex: EVEN, FEES or A/C, FEES
         * 
         * @return value
         */
        public String getTransactionInfoReissueResult() {
            return transactionInfoReissueResult;
        }

        /** 
         * Set the 'ReissueResult' element value. Result of the Reissue transaction
                                                                        Ex: EVEN, FEES or A/C, FEES
         * 
         * @param transactionInfoReissueResult
         */
        public void setTransactionInfoReissueResult(
                String transactionInfoReissueResult) {
            this.transactionInfoReissueResult = transactionInfoReissueResult;
        }

        /** 
         * Get the 'PricedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public PricedLocation getPricedLocation() {
            return pricedLocation;
        }

        /** 
         * Set the 'PricedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @param pricedLocation
         */
        public void setPricedLocation(PricedLocation pricedLocation) {
            this.pricedLocation = pricedLocation;
        }

        /** 
         * Get the 'TicketedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public TicketedLocation getTicketedLocation() {
            return ticketedLocation;
        }

        /** 
         * Set the 'TicketedLocation' element value. Data at PQ transaction
                                                            level
         * 
         * @param ticketedLocation
         */
        public void setTicketedLocation(TicketedLocation ticketedLocation) {
            this.ticketedLocation = ticketedLocation;
        }

        /** 
         * Get the 'PricingQualifiers' element value. Data at PQ transaction
                                                            level
         * 
         * @return value
         */
        public PricingQualifiers getPricingQualifiers() {
            return pricingQualifiers;
        }

        /** 
         * Set the 'PricingQualifiers' element value. Data at PQ transaction
                                                            level
         * 
         * @param pricingQualifiers
         */
        public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
            this.pricingQualifiers = pricingQualifiers;
        }

        /** 
         * Get the 'TicketByDate' element value. Ticket by date.

                                                                        Ref: DM0Z_40_TKDT
         * 
         * @return value
         */
        public Date getTransactionInfoTicketByDate() {
            return transactionInfoTicketByDate;
        }

        /** 
         * Set the 'TicketByDate' element value. Ticket by date.

                                                                        Ref: DM0Z_40_TKDT
         * 
         * @param transactionInfoTicketByDate
         */
        public void setTransactionInfoTicketByDate(
                Date transactionInfoTicketByDate) {
            this.transactionInfoTicketByDate = transactionInfoTicketByDate;
        }

        /** 
         * Get the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
                                                                    Tax modified - applicable only for CAT31
         * 
         * @return value
         */
        public Boolean getTransactionInfoTaxModified() {
            return transactionInfoTaxModified;
        }

        /** 
         * Set the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
                                                                    Tax modified - applicable only for CAT31
         * 
         * @param transactionInfoTaxModified
         */
        public void setTransactionInfoTaxModified(
                Boolean transactionInfoTaxModified) {
            this.transactionInfoTaxModified = transactionInfoTaxModified;
        }

        /** 
         * Get the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
                                                                    Change Fee modified - applicable only for CAT31
         * 
         * @return value
         */
        public Boolean getTransactionInfoChangeFeeModified() {
            return transactionInfoChangeFeeModified;
        }

        /** 
         * Set the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
                                                                    Change Fee modified - applicable only for CAT31
         * 
         * @param transactionInfoChangeFeeModified
         */
        public void setTransactionInfoChangeFeeModified(
                Boolean transactionInfoChangeFeeModified) {
            this.transactionInfoChangeFeeModified = transactionInfoChangeFeeModified;
        }

        /** 
         * Get the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
         * 
         * @return value
         */
        public Boolean getTransactionInfoBagModified() {
            return transactionInfoBagModified;
        }

        /** 
         * Set the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
         * 
         * @param transactionInfoBagModified
         */
        public void setTransactionInfoBagModified(
                Boolean transactionInfoBagModified) {
            this.transactionInfoBagModified = transactionInfoBagModified;
        }

        /** 
         * Get the 'simultaneousTicketForFare' attribute value. If true, then ticket has to be issued simultaneously after creating price quote for fare to be guaranteed.

                                                                    Ref: #DM0Z_40_TKDT
         * 
         * @return value
         */
        public Boolean getTransactionInfoSimultaneousTicketForFare() {
            return transactionInfoSimultaneousTicketForFare;
        }

        /** 
         * Set the 'simultaneousTicketForFare' attribute value. If true, then ticket has to be issued simultaneously after creating price quote for fare to be guaranteed.

                                                                    Ref: #DM0Z_40_TKDT
         * 
         * @param transactionInfoSimultaneousTicketForFare
         */
        public void setTransactionInfoSimultaneousTicketForFare(
                Boolean transactionInfoSimultaneousTicketForFare) {
            this.transactionInfoSimultaneousTicketForFare = transactionInfoSimultaneousTicketForFare;
        }

        /** 
         * Get the 'pricingFailCode' attribute value. Pricing failure code.
                                                                    Ref: #DM0Z_65_FAIL
         * 
         * @return value
         */
        public BigInteger getTransactionInfoPricingFailCode() {
            return transactionInfoPricingFailCode;
        }

        /** 
         * Set the 'pricingFailCode' attribute value. Pricing failure code.
                                                                    Ref: #DM0Z_65_FAIL
         * 
         * @param transactionInfoPricingFailCode
         */
        public void setTransactionInfoPricingFailCode(
                BigInteger transactionInfoPricingFailCode) {
            this.transactionInfoPricingFailCode = transactionInfoPricingFailCode;
        }

        /** 
         * Get the 'OrderInfo' element value.
         * 
         * @return value
         */
        public OrderInfo getOrderInfo() {
            return orderInfo;
        }

        /** 
         * Set the 'OrderInfo' element value.
         * 
         * @param orderInfo
         */
        public void setOrderInfo(OrderInfo orderInfo) {
            this.orderInfo = orderInfo;
        }

        /** 
         * Get the list of 'NameAssociationInfo' element items.
         * 
         * @return list
         */
        public List<NameAssociationInfo> getNameAssociationInfoList() {
            return nameAssociationInfoList;
        }

        /** 
         * Set the list of 'NameAssociationInfo' element items.
         * 
         * @param list
         */
        public void setNameAssociationInfoList(List<NameAssociationInfo> list) {
            nameAssociationInfoList = list;
        }

        /** 
         * Get the list of 'SegmentInfo' element items.
         * 
         * @return list
         */
        public List<SegmentInfo> getSegmentInfoList() {
            return segmentInfoList;
        }

        /** 
         * Set the list of 'SegmentInfo' element items.
         * 
         * @param list
         */
        public void setSegmentInfoList(List<SegmentInfo> list) {
            segmentInfoList = list;
        }

        /** 
         * Get the 'FareInfo' element value.
         * 
         * @return value
         */
        public FareInfo getFareInfo() {
            return fareInfo;
        }

        /** 
         * Set the 'FareInfo' element value.
         * 
         * @param fareInfo
         */
        public void setFareInfo(FareInfo fareInfo) {
            this.fareInfo = fareInfo;
        }

        /** 
         * Get the 'AdditionalFareInfo' element value.
         * 
         * @return value
         */
        public AdditionalFareInfo getAdditionalFareInfo() {
            return additionalFareInfo;
        }

        /** 
         * Set the 'AdditionalFareInfo' element value.
         * 
         * @param additionalFareInfo
         */
        public void setAdditionalFareInfo(AdditionalFareInfo additionalFareInfo) {
            this.additionalFareInfo = additionalFareInfo;
        }

        /** 
         * Get the list of 'FeeInfo' element items.
         * 
         * @return list
         */
        public List<FeeInfo> getFeeInfoList() {
            return feeInfoList;
        }

        /** 
         * Set the list of 'FeeInfo' element items.
         * 
         * @param list
         */
        public void setFeeInfoList(List<FeeInfo> list) {
            feeInfoList = list;
        }

        /** 
         * Get the 'MiscellaneousInfo' element value.
         * 
         * @return value
         */
        public MiscellaneousInfo getMiscellaneousInfo() {
            return miscellaneousInfo;
        }

        /** 
         * Set the 'MiscellaneousInfo' element value.
         * 
         * @param miscellaneousInfo
         */
        public void setMiscellaneousInfo(MiscellaneousInfo miscellaneousInfo) {
            this.miscellaneousInfo = miscellaneousInfo;
        }

        /** 
         * Get the list of 'PaymentInfo' element items.
         * 
         * @return list
         */
        public List<PaymentInfo> getPaymentInfoList() {
            return paymentInfoList;
        }

        /** 
         * Set the list of 'PaymentInfo' element items.
         * 
         * @param list
         */
        public void setPaymentInfoList(List<PaymentInfo> list) {
            paymentInfoList = list;
        }

        /** 
         * Get the 'FareComparisonSummary' element value.
         * 
         * @return value
         */
        public FareComparisonSummary getFareComparisonSummary() {
            return fareComparisonSummary;
        }

        /** 
         * Set the 'FareComparisonSummary' element value.
         * 
         * @param fareComparisonSummary
         */
        public void setFareComparisonSummary(
                FareComparisonSummary fareComparisonSummary) {
            this.fareComparisonSummary = fareComparisonSummary;
        }

        /** 
         * Get the 'RefundInfo' element value.
         * 
         * @return value
         */
        public RefundInfo getRefundInfo() {
            return refundInfo;
        }

        /** 
         * Set the 'RefundInfo' element value.
         * 
         * @param refundInfo
         */
        public void setRefundInfo(RefundInfo refundInfo) {
            this.refundInfo = refundInfo;
        }

        /** 
         * Get the list of 'ExchangeDocInfo' element items.
         * 
         * @return list
         */
        public List<ExchangeDocInfo> getExchangeDocInfoList() {
            return exchangeDocInfoList;
        }

        /** 
         * Set the list of 'ExchangeDocInfo' element items.
         * 
         * @param list
         */
        public void setExchangeDocInfoList(List<ExchangeDocInfo> list) {
            exchangeDocInfoList = list;
        }

        /** 
         * Get the 'ResidualInfo' element value.
         * 
         * @return value
         */
        public ResidualInfo getResidualInfo() {
            return residualInfo;
        }

        /** 
         * Set the 'ResidualInfo' element value.
         * 
         * @param residualInfo
         */
        public void setResidualInfo(ResidualInfo residualInfo) {
            this.residualInfo = residualInfo;
        }

        /** 
         * Get the 'AddCollectInfo' element value.
         * 
         * @return value
         */
        public AddCollectInfo getAddCollectInfo() {
            return addCollectInfo;
        }

        /** 
         * Set the 'AddCollectInfo' element value.
         * 
         * @param addCollectInfo
         */
        public void setAddCollectInfo(AddCollectInfo addCollectInfo) {
            this.addCollectInfo = addCollectInfo;
        }

        /** 
         * Get the 'MessageInfo' element value.
         * 
         * @return value
         */
        public MessageInfo getMessageInfo() {
            return messageInfo;
        }

        /** 
         * Set the 'MessageInfo' element value.
         * 
         * @param messageInfo
         */
        public void setMessageInfo(MessageInfo messageInfo) {
            this.messageInfo = messageInfo;
        }

        /** 
         * Get the list of 'HistoryInfo' element items.
         * 
         * @return list
         */
        public List<HistoryInfo> getHistoryInfoList() {
            return historyInfoList;
        }

        /** 
         * Set the list of 'HistoryInfo' element items.
         * 
         * @param list
         */
        public void setHistoryInfoList(List<HistoryInfo> list) {
            historyInfoList = list;
        }

        /** 
         * Get the 'OriginalDocInfo' element value.
         * 
         * @return value
         */
        public OriginalDocInfo getOriginalDocInfo() {
            return originalDocInfo;
        }

        /** 
         * Set the 'OriginalDocInfo' element value.
         * 
         * @param originalDocInfo
         */
        public void setOriginalDocInfo(OriginalDocInfo originalDocInfo) {
            this.originalDocInfo = originalDocInfo;
        }

        /** 
         * Get the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
                                                        PQRE - PQR Exchange
                                                        PQRR - RQR Refund
                                                        If not specified, it defaults to PQ and PQR
                                                    
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
                                                        PQRE - PQR Exchange
                                                        PQRR - RQR Refund
                                                        If not specified, it defaults to PQ and PQR
                                                    
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
         * 
         * @return value
         */
        public String getPassengerType() {
            return passengerType;
        }

        /** 
         * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
         * 
         * @param passengerType
         */
        public void setPassengerType(String passengerType) {
            this.passengerType = passengerType;
        }

        /** 
         * Get the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }

        /** 
         * Get the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @return value
         */
        public String getPricingType() {
            return pricingType;
        }

        /** 
         * Set the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @param pricingType
         */
        public void setPricingType(String pricingType) {
            this.pricingType = pricingType;
        }

        /** 
         * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @return value
         */
        public String getPricingStatus() {
            return pricingStatus;
        }

        /** 
         * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @param pricingStatus
         */
        public void setPricingStatus(String pricingStatus) {
            this.pricingStatus = pricingStatus;
        }

        /** 
         * Get the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @return value
         */
        public Boolean getDisplayOnly() {
            return displayOnly;
        }

        /** 
         * Set the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @param displayOnly
         */
        public void setDisplayOnly(Boolean displayOnly) {
            this.displayOnly = displayOnly;
        }

        /** 
         * Get the 'reissueTransactionType' attribute value. EXCH or RFND transaction
         * 
         * @return value
         */
        public String getReissueTransactionType() {
            return reissueTransactionType;
        }

        /** 
         * Set the 'reissueTransactionType' attribute value. EXCH or RFND transaction
         * 
         * @param reissueTransactionType
         */
        public void setReissueTransactionType(String reissueTransactionType) {
            this.reissueTransactionType = reissueTransactionType;
        }

        /** 
         * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                        Ref: #DM0Z_40_HCPQ
                                                        Value is false if attribute not present. 
         * 
         * @return value
         */
        public Boolean getLowCostCarrier() {
            return lowCostCarrier;
        }

        /** 
         * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                        Ref: #DM0Z_40_HCPQ
                                                        Value is false if attribute not present. 
         * 
         * @param lowCostCarrier
         */
        public void setLowCostCarrier(Boolean lowCostCarrier) {
            this.lowCostCarrier = lowCostCarrier;
        }

        /** 
         * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                        REF: #DM0Z_40_PQC 
         * 
         * @return value
         */
        public Boolean getIncompletePQR() {
            return incompletePQR;
        }

        /** 
         * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

                                                        REF: #DM0Z_40_PQC 
         * 
         * @param incompletePQR
         */
        public void setIncompletePQR(Boolean incompletePQR) {
            this.incompletePQR = incompletePQR;
        }

        /** 
         * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
         * 
         * @return value
         */
        public Boolean getCreatedByOrder() {
            return createdByOrder;
        }

        /** 
         * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
         * 
         * @param createdByOrder
         */
        public void setCreatedByOrder(Boolean createdByOrder) {
            this.createdByOrder = createdByOrder;
        }

        /** 
         * Get the 'ataFormat' attribute value. ATA format for display or prints
                                                        Ref: #DM0Z_65_PAT
         * 
         * @return value
         */
        public Boolean getAtaFormat() {
            return ataFormat;
        }

        /** 
         * Set the 'ataFormat' attribute value. ATA format for display or prints
                                                        Ref: #DM0Z_65_PAT
         * 
         * @param ataFormat
         */
        public void setAtaFormat(Boolean ataFormat) {
            this.ataFormat = ataFormat;
        }

        /** 
         * Get the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                        Ref:  DM0Z_40_ROWN
         * 
         * @return value
         */
        public String getPqOwner() {
            return pqOwner;
        }

        /** 
         * Set the 'pqOwner' attribute value. PQ created by Airline or TN - 1S, 1B, 1F.
                                                        Ref:  DM0Z_40_ROWN
         * 
         * @param pqOwner
         */
        public void setPqOwner(String pqOwner) {
            this.pqOwner = pqOwner;
        }

        /** 
         * Get the 'previousStatus' attribute value. Previous status of PQ or PQR
                                                        Ref: DM0Z_40_HRST
         * 
         * @return value
         */
        public String getPreviousStatus() {
            return previousStatus;
        }

        /** 
         * Set the 'previousStatus' attribute value. Previous status of PQ or PQR
                                                        Ref: DM0Z_40_HRST
         * 
         * @param previousStatus
         */
        public void setPreviousStatus(String previousStatus) {
            this.previousStatus = previousStatus;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
       