
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Attribute collection used to describe a price request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestAttributes">
 *   &lt;xs:attribute type="xs:string" name="fareQualifier"/>
 *   &lt;xs:attribute type="xs:boolean" name="negotiatedFaresOnly"/>
 *   &lt;xs:attribute type="xs:string" name="currencyCode"/>
 *   &lt;xs:attribute type="ns:RequestPricingSourceType" name="pricingSource"/>
 *   &lt;xs:attribute type="xs:boolean" name="reprice"/>
 *   &lt;xs:attribute type="xs:boolean" name="processThruFaresOnly"/>
 *   &lt;xs:attribute type="xs:date" name="purchaseDate"/>
 *   &lt;xs:attribute type="xs:string" name="purchaseTime"/>
 *   &lt;xs:attribute type="xs:boolean" name="netFaresUsed"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PriceRequestAttributes implements Serializable
{
    private String fareQualifier;
    private Boolean negotiatedFaresOnly;
    private String currencyCode;
    private RequestPricingSourceType pricingSource;
    private Boolean reprice;
    private Boolean processThruFaresOnly;
    private Date purchaseDate;
    private String purchaseTime;
    private Boolean netFaresUsed;

    /** 
     * Get the 'fareQualifier' attribute value. Fare Type is specific to a specific fare and this is a request for a set of fares based on these qualifiers.
     * 
     * @return value
     */
    public String getFareQualifier() {
        return fareQualifier;
    }

    /** 
     * Set the 'fareQualifier' attribute value. Fare Type is specific to a specific fare and this is a request for a set of fares based on these qualifiers.
     * 
     * @param fareQualifier
     */
    public void setFareQualifier(String fareQualifier) {
        this.fareQualifier = fareQualifier;
    }

    /** 
     * Get the 'negotiatedFaresOnly' attribute value. If set to true then returned fares need to match requested AcccountCode/CorpID on all fare components
     * 
     * @return value
     */
    public Boolean getNegotiatedFaresOnly() {
        return negotiatedFaresOnly;
    }

    /** 
     * Set the 'negotiatedFaresOnly' attribute value. If set to true then returned fares need to match requested AcccountCode/CorpID on all fare components
     * 
     * @param negotiatedFaresOnly
     */
    public void setNegotiatedFaresOnly(Boolean negotiatedFaresOnly) {
        this.negotiatedFaresOnly = negotiatedFaresOnly;
    }

    /** 
     * Get the 'currencyCode' attribute value. Type of funds preferred for reviewing monetary values, in ISO 4217 codes.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value. Type of funds preferred for reviewing monetary values, in ISO 4217 codes.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'pricingSource' attribute value. It can be used to indicate whether the fare is public or private.
     * 
     * @return value
     */
    public RequestPricingSourceType getPricingSource() {
        return pricingSource;
    }

    /** 
     * Set the 'pricingSource' attribute value. It can be used to indicate whether the fare is public or private.
     * 
     * @param pricingSource
     */
    public void setPricingSource(RequestPricingSourceType pricingSource) {
        this.pricingSource = pricingSource;
    }

    /** 
     * Get the 'reprice' attribute value.
     * 
     * @return value
     */
    public Boolean getReprice() {
        return reprice;
    }

    /** 
     * Set the 'reprice' attribute value.
     * 
     * @param reprice
     */
    public void setReprice(Boolean reprice) {
        this.reprice = reprice;
    }

    /** 
     * Get the 'processThruFaresOnly' attribute value. Activates processing of thru fares only.
     * 
     * @return value
     */
    public Boolean getProcessThruFaresOnly() {
        return processThruFaresOnly;
    }

    /** 
     * Set the 'processThruFaresOnly' attribute value. Activates processing of thru fares only.
     * 
     * @param processThruFaresOnly
     */
    public void setProcessThruFaresOnly(Boolean processThruFaresOnly) {
        this.processThruFaresOnly = processThruFaresOnly;
    }

    /** 
     * Get the 'purchaseDate' attribute value. Specify purchase date. Fares returned will be based on the purchase date.
     * 
     * @return value
     */
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    /** 
     * Set the 'purchaseDate' attribute value. Specify purchase date. Fares returned will be based on the purchase date.
     * 
     * @param purchaseDate
     */
    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    /** 
     * Get the 'purchaseTime' attribute value. Specify purchase time. Fares returned will be based on the purchase time.
     * 
     * @return value
     */
    public String getPurchaseTime() {
        return purchaseTime;
    }

    /** 
     * Set the 'purchaseTime' attribute value. Specify purchase time. Fares returned will be based on the purchase time.
     * 
     * @param purchaseTime
     */
    public void setPurchaseTime(String purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    /** 
     * Get the 'netFaresUsed' attribute value. Set to true when exchange ticket uses net fare.
     * 
     * @return value
     */
    public Boolean getNetFaresUsed() {
        return netFaresUsed;
    }

    /** 
     * Set the 'netFaresUsed' attribute value. Set to true when exchange ticket uses net fare.
     * 
     * @param netFaresUsed
     */
    public void setNetFaresUsed(Boolean netFaresUsed) {
        this.netFaresUsed = netFaresUsed;
    }
}
