
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Defines the number of travelers of a specific type
 (e.g. a driver type can be either one of: Adult, YoungDriver, YoungerDriver, or it may be a code that is acceptable to both Trading Partners).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerCountType">
 *   &lt;xs:attribute type="xs:string" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="codeContext"/>
 *   &lt;xs:attribute type="xs:string" name="URI"/>
 *   &lt;xs:attribute type="xs:int" name="quantity"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerCountType implements Serializable
{
    private String code;
    private String codeContext;
    private String URI;
    private Integer quantity;

    /** 
     * Get the 'code' attribute value. Specify traveler type code.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Specify traveler type code.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'codeContext' attribute value. Identifies the source authority for the code.
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'codeContext' attribute value. Identifies the source authority for the code.
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'URI' attribute value. Identifies the location of the code table
     * 
     * @return value
     */
    public String getURI() {
        return URI;
    }

    /** 
     * Set the 'URI' attribute value. Identifies the location of the code table
     * 
     * @param URI
     */
    public void setURI(String URI) {
        this.URI = URI;
    }

    /** 
     * Get the 'quantity' attribute value. Specifies the number of travelers.
     * 
     * @return value
     */
    public Integer getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' attribute value. Specifies the number of travelers.
     * 
     * @param quantity
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}
