
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies charges and/or penalties associated with making ticket changes after purchase.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoluntaryChangesSMPType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Penalty" minOccurs="0" maxOccurs="2">
 *       &lt;!-- Reference to inner class Penalty -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute name="match">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Match -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VoluntaryChangesSMPType implements Serializable
{
    private List<Penalty> penaltyList = new ArrayList<Penalty>();
    private Match match;

    /** 
     * Get the list of 'Penalty' element items.
     * 
     * @return list
     */
    public List<Penalty> getPenaltyList() {
        return penaltyList;
    }

    /** 
     * Set the list of 'Penalty' element items.
     * 
     * @param list
     */
    public void setPenaltyList(List<Penalty> list) {
        penaltyList = list;
    }

    /** 
     * Get the 'match' attribute value. Indicates relation between conditions.
     * 
     * @return value
     */
    public Match getMatch() {
        return match;
    }

    /** 
     * Set the 'match' attribute value. Indicates relation between conditions.
     * 
     * @param match
     */
    public void setMatch(Match match) {
        this.match = match;
    }
    /** 
     * Specifies penalty charges as either a currency amount or a percentage of the fare.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Penalty" minOccurs="0" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:boolean" name="exclude"/>
     *     &lt;xs:attribute name="application">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Application -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Penalty implements Serializable
    {
        private Type type;
        private Boolean exclude;
        private Application application;
        private CurrencyAmountGroup currencyAmountGroup;

        /** 
         * Get the 'type' attribute value. Indicates the type (Refund or Exchange) of penalty involved in the search or response.
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Indicates the type (Refund or Exchange) of penalty involved in the search or response.
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'exclude' attribute value. Indicate that specific penalty type should be excluded from the response.
         * 
         * @return value
         */
        public Boolean getExclude() {
            return exclude;
        }

        /** 
         * Set the 'exclude' attribute value. Indicate that specific penalty type should be excluded from the response.
         * 
         * @param exclude
         */
        public void setExclude(Boolean exclude) {
            this.exclude = exclude;
        }

        /** 
         * Get the 'application' attribute value. Identifier used to indicate whether the change occurs before or after departure from the origin city.
         * 
         * @return value
         */
        public Application getApplication() {
            return application;
        }

        /** 
         * Set the 'application' attribute value. Identifier used to indicate whether the change occurs before or after departure from the origin city.
         * 
         * @param application
         */
        public void setApplication(Application application) {
            this.application = application;
        }

        /** 
         * Get the 'CurrencyAmountGroup' attributeGroup value. The penalty charge defined a fee in terms of its amount, currency and decimal laces.
         * 
         * @return value
         */
        public CurrencyAmountGroup getCurrencyAmountGroup() {
            return currencyAmountGroup;
        }

        /** 
         * Set the 'CurrencyAmountGroup' attributeGroup value. The penalty charge defined a fee in terms of its amount, currency and decimal laces.
         * 
         * @param currencyAmountGroup
         */
        public void setCurrencyAmountGroup(
                CurrencyAmountGroup currencyAmountGroup) {
            this.currencyAmountGroup = currencyAmountGroup;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Refund"/>
         *     &lt;xs:enumeration value="Exchange"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            REFUND("Refund"), EXCHANGE("Exchange");
            private final String value;

            private Type(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Type convert(String value) {
                for (Type inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="After"/>
         *     &lt;xs:enumeration value="Before"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Application implements Serializable {
            AFTER("After"), BEFORE("Before");
            private final String value;

            private Application(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Application convert(String value) {
                for (Application inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="All"/>
     *     &lt;xs:enumeration value="Any"/>
     *     &lt;xs:enumeration value="Info"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Match implements Serializable {
        /** 
         * Conditions are joined by logical conjunction - fare needs to fulfill all the conditions to be returned in response.
         */
        ALL("All"), /** 
                     * Conditions are joined by logical disjunction - fare needs to fulfill at least one of the conditions to be returned in response.
                     */
        ANY("Any"), /** 
                     * Return penalty information
                     */
        INFO("Info");
        private final String value;

        private Match(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Match convert(String value) {
            for (Match inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
