
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingTransactionItem">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AccountingTransactionSource" name="Source"/>
 *     &lt;xs:element type="ns:AccountingTransactionAmountWithRule" name="Price" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Tax -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Promotion" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Promotion -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AccountingTransactionAmount" name="AppliedAmount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:NameAssociationTag" name="Passenger" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingTransactionItem implements Serializable
{
    private AccountingTransactionSource source;
    private List<AccountingTransactionAmountWithRule> priceList = new ArrayList<AccountingTransactionAmountWithRule>();
    private List<Tax> taxList = new ArrayList<Tax>();
    private List<Promotion> promotionList = new ArrayList<Promotion>();
    private List<AccountingTransactionAmount> appliedAmountList = new ArrayList<AccountingTransactionAmount>();
    private List<NameAssociationTag> passengerList = new ArrayList<NameAssociationTag>();

    /** 
     * Get the 'Source' element value.
     * 
     * @return value
     */
    public AccountingTransactionSource getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value.
     * 
     * @param source
     */
    public void setSource(AccountingTransactionSource source) {
        this.source = source;
    }

    /** 
     * Get the list of 'Price' element items.
     * 
     * @return list
     */
    public List<AccountingTransactionAmountWithRule> getPriceList() {
        return priceList;
    }

    /** 
     * Set the list of 'Price' element items.
     * 
     * @param list
     */
    public void setPriceList(List<AccountingTransactionAmountWithRule> list) {
        priceList = list;
    }

    /** 
     * Get the list of 'Tax' element items.
     * 
     * @return list
     */
    public List<Tax> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items.
     * 
     * @param list
     */
    public void setTaxList(List<Tax> list) {
        taxList = list;
    }

    /** 
     * Get the list of 'Promotion' element items.
     * 
     * @return list
     */
    public List<Promotion> getPromotionList() {
        return promotionList;
    }

    /** 
     * Set the list of 'Promotion' element items.
     * 
     * @param list
     */
    public void setPromotionList(List<Promotion> list) {
        promotionList = list;
    }

    /** 
     * Get the list of 'AppliedAmount' element items.
     * 
     * @return list
     */
    public List<AccountingTransactionAmount> getAppliedAmountList() {
        return appliedAmountList;
    }

    /** 
     * Set the list of 'AppliedAmount' element items.
     * 
     * @param list
     */
    public void setAppliedAmountList(List<AccountingTransactionAmount> list) {
        appliedAmountList = list;
    }

    /** 
     * Get the list of 'Passenger' element items.
     * 
     * @return list
     */
    public List<NameAssociationTag> getPassengerList() {
        return passengerList;
    }

    /** 
     * Set the list of 'Passenger' element items.
     * 
     * @param list
     */
    public void setPassengerList(List<NameAssociationTag> list) {
        passengerList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AccountingTransactionAmountWithRule">
     *         &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Tax extends AccountingTransactionAmountWithRule
        implements Serializable
    {
        private String code;

        /** 
         * Get the 'code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AccountingTransactionAmountWithRule">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
     *           &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
     *           &lt;xs:element type="xs:string" name="OfferName" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotion extends AccountingTransactionAmountWithRule
        implements Serializable
    {
        private String type;
        private BigDecimal percentage;
        private String offerName;

        /** 
         * Get the 'Type' element value.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Percentage' element value.
         * 
         * @return value
         */
        public BigDecimal getPercentage() {
            return percentage;
        }

        /** 
         * Set the 'Percentage' element value.
         * 
         * @param percentage
         */
        public void setPercentage(BigDecimal percentage) {
            this.percentage = percentage;
        }

        /** 
         * Get the 'OfferName' element value.
         * 
         * @return value
         */
        public String getOfferName() {
            return offerName;
        }

        /** 
         * Set the 'OfferName' element value.
         * 
         * @param offerName
         */
        public void setOfferName(String offerName) {
            this.offerName = offerName;
        }
    }
}
