
package com.sabre.services.sp.updatereservation.v11;

import com.sabre.services.stlpayload.v0201.STLPayload1;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePassengerNameRecordRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns1:STL_Payload">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="Itinerary">
 *             &lt;xs:complexType>
 *               &lt;xs:attribute type="xs:string" use="required" name="id"/>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element name="Profile" minOccurs="0">
 *             &lt;!-- Reference to inner class Profile -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="TravelItineraryAddInfo" minOccurs="0">
 *             &lt;!-- Reference to inner class TravelItineraryAddInfo -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="AirBook" minOccurs="0">
 *             &lt;!-- Reference to inner class AirBook -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="AirPrice" minOccurs="0" maxOccurs="10">
 *             &lt;!-- Reference to inner class AirPrice -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="HotelBook" minOccurs="0">
 *             &lt;!-- Reference to inner class HotelBook -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="VehicleBook" minOccurs="0">
 *             &lt;!-- Reference to inner class VehicleBook -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="MiscSegment" minOccurs="0">
 *             &lt;!-- Reference to inner class MiscSegment -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="SpecialReqDetails" minOccurs="0">
 *             &lt;!-- Reference to inner class SpecialReqDetails -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="PostProcessing" minOccurs="0">
 *             &lt;!-- Reference to inner class PostProcessing -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:string" name="targetCity"/>
 *         &lt;xs:attribute type="xs:boolean" name="haltOnInvalidMCT"/>
 *         &lt;xs:attribute type="xs:boolean" name="haltOnAirPriceError"/>
 *         &lt;xs:attribute type="xs:boolean" name="haltOnHotelBookError"/>
 *         &lt;xs:attribute type="xs:boolean" default="false" name="haltOnVehicleBookError"/>
 *         &lt;xs:attribute type="xs:boolean" default="false" name="healthCheck"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class UpdatePassengerNameRecordRQ extends STLPayload1 implements
    Serializable
{
    private String itinerary;
    private Profile profile;
    private TravelItineraryAddInfo travelItineraryAddInfo;
    private AirBook airBook;
    private List<AirPrice> airPriceList = new ArrayList<AirPrice>();
    private HotelBook hotelBook;
    private VehicleBook vehicleBook;
    private MiscSegment miscSegment;
    private SpecialReqDetails specialReqDetails;
    private PostProcessing postProcessing;
    private String targetCity;
    private Boolean haltOnInvalidMCT;
    private Boolean haltOnAirPriceError;
    private Boolean haltOnHotelBookError;
    private Boolean haltOnVehicleBookError;
    private Boolean healthCheck;

    /** 
     * Get the 'id' attribute value. "id" is used to specify a record locator.
     * 
     * @return value
     */
    public String getItinerary() {
        return itinerary;
    }

    /** 
     * Set the 'id' attribute value. "id" is used to specify a record locator.
     * 
     * @param itinerary
     */
    public void setItinerary(String itinerary) {
        this.itinerary = itinerary;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public Profile getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'TravelItineraryAddInfo' element value.
     * 
     * @return value
     */
    public TravelItineraryAddInfo getTravelItineraryAddInfo() {
        return travelItineraryAddInfo;
    }

    /** 
     * Set the 'TravelItineraryAddInfo' element value.
     * 
     * @param travelItineraryAddInfo
     */
    public void setTravelItineraryAddInfo(
            TravelItineraryAddInfo travelItineraryAddInfo) {
        this.travelItineraryAddInfo = travelItineraryAddInfo;
    }

    /** 
     * Get the 'AirBook' element value.
     * 
     * @return value
     */
    public AirBook getAirBook() {
        return airBook;
    }

    /** 
     * Set the 'AirBook' element value.
     * 
     * @param airBook
     */
    public void setAirBook(AirBook airBook) {
        this.airBook = airBook;
    }

    /** 
     * Get the list of 'AirPrice' element items.
     * 
     * @return list
     */
    public List<AirPrice> getAirPriceList() {
        return airPriceList;
    }

    /** 
     * Set the list of 'AirPrice' element items.
     * 
     * @param list
     */
    public void setAirPriceList(List<AirPrice> list) {
        airPriceList = list;
    }

    /** 
     * Get the 'HotelBook' element value.
     * 
     * @return value
     */
    public HotelBook getHotelBook() {
        return hotelBook;
    }

    /** 
     * Set the 'HotelBook' element value.
     * 
     * @param hotelBook
     */
    public void setHotelBook(HotelBook hotelBook) {
        this.hotelBook = hotelBook;
    }

    /** 
     * Get the 'VehicleBook' element value.
     * 
     * @return value
     */
    public VehicleBook getVehicleBook() {
        return vehicleBook;
    }

    /** 
     * Set the 'VehicleBook' element value.
     * 
     * @param vehicleBook
     */
    public void setVehicleBook(VehicleBook vehicleBook) {
        this.vehicleBook = vehicleBook;
    }

    /** 
     * Get the 'MiscSegment' element value.
     * 
     * @return value
     */
    public MiscSegment getMiscSegment() {
        return miscSegment;
    }

    /** 
     * Set the 'MiscSegment' element value.
     * 
     * @param miscSegment
     */
    public void setMiscSegment(MiscSegment miscSegment) {
        this.miscSegment = miscSegment;
    }

    /** 
     * Get the 'SpecialReqDetails' element value.
     * 
     * @return value
     */
    public SpecialReqDetails getSpecialReqDetails() {
        return specialReqDetails;
    }

    /** 
     * Set the 'SpecialReqDetails' element value.
     * 
     * @param specialReqDetails
     */
    public void setSpecialReqDetails(SpecialReqDetails specialReqDetails) {
        this.specialReqDetails = specialReqDetails;
    }

    /** 
     * Get the 'PostProcessing' element value.
     * 
     * @return value
     */
    public PostProcessing getPostProcessing() {
        return postProcessing;
    }

    /** 
     * Set the 'PostProcessing' element value.
     * 
     * @param postProcessing
     */
    public void setPostProcessing(PostProcessing postProcessing) {
        this.postProcessing = postProcessing;
    }

    /** 
     * Get the 'targetCity' attribute value. Used to specify to which city service should change context using ContextChange (AAA) and the rest of the service uses new security. If empty or equals current city the context doesn't change.
     * 
     * @return value
     */
    public String getTargetCity() {
        return targetCity;
    }

    /** 
     * Set the 'targetCity' attribute value. Used to specify to which city service should change context using ContextChange (AAA) and the rest of the service uses new security. If empty or equals current city the context doesn't change.
     * 
     * @param targetCity
     */
    public void setTargetCity(String targetCity) {
        this.targetCity = targetCity;
    }

    /** 
     * Get the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
     * 
     * @return value
     */
    public Boolean getHaltOnInvalidMCT() {
        return haltOnInvalidMCT;
    }

    /** 
     * Set the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
     * 
     * @param haltOnInvalidMCT
     */
    public void setHaltOnInvalidMCT(Boolean haltOnInvalidMCT) {
        this.haltOnInvalidMCT = haltOnInvalidMCT;
    }

    /** 
     * Get the 'haltOnAirPriceError' attribute value. Used to specify whether the service should stop processing upon encountering a pricing error
     * 
     * @return value
     */
    public Boolean getHaltOnAirPriceError() {
        return haltOnAirPriceError;
    }

    /** 
     * Set the 'haltOnAirPriceError' attribute value. Used to specify whether the service should stop processing upon encountering a pricing error
     * 
     * @param haltOnAirPriceError
     */
    public void setHaltOnAirPriceError(Boolean haltOnAirPriceError) {
        this.haltOnAirPriceError = haltOnAirPriceError;
    }

    /** 
     * Get the 'haltOnHotelBookError' attribute value. Used to specify whether the service should stop processing upon encountering a hotel book error.
     * 
     * @return value
     */
    public Boolean getHaltOnHotelBookError() {
        return haltOnHotelBookError;
    }

    /** 
     * Set the 'haltOnHotelBookError' attribute value. Used to specify whether the service should stop processing upon encountering a hotel book error.
     * 
     * @param haltOnHotelBookError
     */
    public void setHaltOnHotelBookError(Boolean haltOnHotelBookError) {
        this.haltOnHotelBookError = haltOnHotelBookError;
    }

    /** 
     * Get the 'haltOnVehicleBookError' attribute value. Used to specify whether the service should stop processing upon encountering a vehicle book error.
     * 
     * @return value
     */
    public Boolean getHaltOnVehicleBookError() {
        return haltOnVehicleBookError;
    }

    /** 
     * Set the 'haltOnVehicleBookError' attribute value. Used to specify whether the service should stop processing upon encountering a vehicle book error.
     * 
     * @param haltOnVehicleBookError
     */
    public void setHaltOnVehicleBookError(Boolean haltOnVehicleBookError) {
        this.haltOnVehicleBookError = haltOnVehicleBookError;
    }

    /** 
     * Get the 'healthCheck' attribute value. Health Check.
                                  For internal use only.
     * 
     * @return value
     */
    public Boolean getHealthCheck() {
        return healthCheck;
    }

    /** 
     * Set the 'healthCheck' attribute value. Health Check.
                                  For internal use only.
     * 
     * @param healthCheck
     */
    public void setHealthCheck(Boolean healthCheck) {
        this.healthCheck = healthCheck;
    }
    /** 
     * Used to add profile information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="UniqueID">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="id"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Profile implements Serializable
    {
        private String uniqueID;

        /** 
         * Get the 'id' attribute value. Used to specify a profile name that is to be moved into the AAA to create the PNR
         * 
         * @return value
         */
        public String getUniqueID() {
            return uniqueID;
        }

        /** 
         * Set the 'id' attribute value. Used to specify a profile name that is to be moved into the AAA to create the PNR
         * 
         * @param uniqueID
         */
        public void setUniqueID(String uniqueID) {
            this.uniqueID = uniqueID;
        }
    }
    /** 
     * Used to add passenger/agency information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryAddInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgencyInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AgencyInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CustomerInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelItineraryAddInfo implements Serializable
    {
        private AgencyInfo agencyInfo;
        private CustomerInfo customerInfo;

        /** 
         * Get the 'AgencyInfo' element value.
         * 
         * @return value
         */
        public AgencyInfo getAgencyInfo() {
            return agencyInfo;
        }

        /** 
         * Set the 'AgencyInfo' element value.
         * 
         * @param agencyInfo
         */
        public void setAgencyInfo(AgencyInfo agencyInfo) {
            this.agencyInfo = agencyInfo;
        }

        /** 
         * Get the 'CustomerInfo' element value.
         * 
         * @return value
         */
        public CustomerInfo getCustomerInfo() {
            return customerInfo;
        }

        /** 
         * Set the 'CustomerInfo' element value.
         * 
         * @param customerInfo
         */
        public void setCustomerInfo(CustomerInfo customerInfo) {
            this.customerInfo = customerInfo;
        }
        /** 
         * Used to pass agency details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Address" minOccurs="0">
         *         &lt;!-- Reference to inner class Address -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AgencyInfo implements Serializable
        {
            private Address address;
            private Ticketing ticketing;

            /** 
             * Get the 'Address' element value.
             * 
             * @return value
             */
            public Address getAddress() {
                return address;
            }

            /** 
             * Set the 'Address' element value.
             * 
             * @param address
             */
            public void setAddress(Address address) {
                this.address = address;
            }

            /** 
             * Get the 'Ticketing' element value.
             * 
             * @return value
             */
            public Ticketing getTicketing() {
                return ticketing;
            }

            /** 
             * Set the 'Ticketing' element value.
             * 
             * @param ticketing
             */
            public void setTicketing(Ticketing ticketing) {
                this.ticketing = ticketing;
            }
            /** 
             * Used to pass agency address
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CityName"/>
             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="StateCountyProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateCountyProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Address implements Serializable
            {
                private String addressLine;
                private String cityName;
                private String countryCode;
                private String postalCode;
                private StateCountyProv stateCountyProv;
                private String streetNmbr;
                private VendorPrefs vendorPrefs;

                /** 
                 * Get the 'AddressLine' element value. agency address
                 * 
                 * @return value
                 */
                public String getAddressLine() {
                    return addressLine;
                }

                /** 
                 * Set the 'AddressLine' element value. agency address
                 * 
                 * @param addressLine
                 */
                public void setAddressLine(String addressLine) {
                    this.addressLine = addressLine;
                }

                /** 
                 * Get the 'CityName' element value. agency city name
                 * 
                 * @return value
                 */
                public String getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value. agency city name
                 * 
                 * @param cityName
                 */
                public void setCityName(String cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'CountryCode' element value. agency country code
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. agency country code
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'PostalCode' element value. agency postal code
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. agency postal code
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the 'StateCountyProv' element value.
                 * 
                 * @return value
                 */
                public StateCountyProv getStateCountyProv() {
                    return stateCountyProv;
                }

                /** 
                 * Set the 'StateCountyProv' element value.
                 * 
                 * @param stateCountyProv
                 */
                public void setStateCountyProv(StateCountyProv stateCountyProv) {
                    this.stateCountyProv = stateCountyProv;
                }

                /** 
                 * Get the 'StreetNmbr' element value. street number
                 * 
                 * @return value
                 */
                public String getStreetNmbr() {
                    return streetNmbr;
                }

                /** 
                 * Set the 'StreetNmbr' element value. street number
                 * 
                 * @param streetNmbr
                 */
                public void setStreetNmbr(String streetNmbr) {
                    this.streetNmbr = streetNmbr;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }
                /** 
                 * state details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="StateCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateCountyProv implements Serializable
                {
                    private String stateCode;

                    /** 
                     * Get the 'StateCode' attribute value. state code
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. state code
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
                /** 
                 * Used to specify if the request is based upon a hosted or a non-hosted carrier.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" use="required" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. For Travel Network customers "Hosted" should be set to "false" For SabreSonic RES hosted customers "Hosted" should be set to "true"
                     * 
                     * @return value
                     */
                    public boolean isAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. For Travel Network customers "Hosted" should be set to "false" For SabreSonic RES hosted customers "Hosted" should be set to "true"
                     * 
                     * @param airline
                     */
                    public void setAirline(boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to pass ticketing related information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:integer" name="QueueNumber"/>
             *     &lt;xs:attribute type="xs:string" name="QueueName"/>
             *     &lt;xs:attribute type="xs:string" name="ShortText"/>
             *     &lt;xs:attribute type="xs:string" name="TicketTimeLimit"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="TicketType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticketing implements Serializable
            {
                private String pseudoCityCode;
                private BigInteger queueNumber;
                private String queueName;
                private String shortText;
                private String ticketTimeLimit;
                private String ticketType;

                /** 
                 * Get the 'PseudoCityCode' attribute value. pseudo city code
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value. pseudo city code
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'QueueNumber' attribute value. queue number
                 * 
                 * @return value
                 */
                public BigInteger getQueueNumber() {
                    return queueNumber;
                }

                /** 
                 * Set the 'QueueNumber' attribute value. queue number
                 * 
                 * @param queueNumber
                 */
                public void setQueueNumber(BigInteger queueNumber) {
                    this.queueNumber = queueNumber;
                }

                /** 
                 * Get the 'QueueName' attribute value. queue name
                 * 
                 * @return value
                 */
                public String getQueueName() {
                    return queueName;
                }

                /** 
                 * Set the 'QueueName' attribute value. queue name
                 * 
                 * @param queueName
                 */
                public void setQueueName(String queueName) {
                    this.queueName = queueName;
                }

                /** 
                 * Get the 'ShortText' attribute value. miscellaneous free text
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' attribute value. miscellaneous free text
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'TicketTimeLimit' attribute value. ticketing time limit, follows this format: MM-DDTHH:00, must be at the top of the hour 
                 * 
                 * @return value
                 */
                public String getTicketTimeLimit() {
                    return ticketTimeLimit;
                }

                /** 
                 * Set the 'TicketTimeLimit' attribute value. ticketing time limit, follows this format: MM-DDTHH:00, must be at the top of the hour 
                 * 
                 * @param ticketTimeLimit
                 */
                public void setTicketTimeLimit(String ticketTimeLimit) {
                    this.ticketTimeLimit = ticketTimeLimit;
                }

                /** 
                 * Get the 'TicketType' attribute value. acceptable values are: "7TAW", "7TAX", "7T-A", 8(time), or 8(time/(date)
                 * 
                 * @return value
                 */
                public String getTicketType() {
                    return ticketType;
                }

                /** 
                 * Set the 'TicketType' attribute value. acceptable values are: "7TAW", "7TAX", "7T-A", 8(time), or 8(time/(date)
                 * 
                 * @param ticketType
                 */
                public void setTicketType(String ticketType) {
                    this.ticketType = ticketType;
                }
            }
        }
        /** 
         * Used to pass passenger details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
         *         &lt;!-- Reference to inner class ContactNumbers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Corporate" minOccurs="0">
         *         &lt;!-- Reference to inner class Corporate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CreditCardData" minOccurs="0">
         *         &lt;!-- Reference to inner class CreditCardData -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CustLoyalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CustomerIdentifier" minOccurs="0"/>
         *       &lt;xs:element name="Email" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Email -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerInfo implements Serializable
        {
            private ContactNumbers contactNumbers;
            private Corporate corporate;
            private CreditCardData creditCardData;
            private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
            private String customerIdentifier;
            private List<Email> emailList = new ArrayList<Email>();
            private List<PersonName> personNameList = new ArrayList<PersonName>();

            /** 
             * Get the 'ContactNumbers' element value.
             * 
             * @return value
             */
            public ContactNumbers getContactNumbers() {
                return contactNumbers;
            }

            /** 
             * Set the 'ContactNumbers' element value.
             * 
             * @param contactNumbers
             */
            public void setContactNumbers(ContactNumbers contactNumbers) {
                this.contactNumbers = contactNumbers;
            }

            /** 
             * Get the 'Corporate' element value.
             * 
             * @return value
             */
            public Corporate getCorporate() {
                return corporate;
            }

            /** 
             * Set the 'Corporate' element value.
             * 
             * @param corporate
             */
            public void setCorporate(Corporate corporate) {
                this.corporate = corporate;
            }

            /** 
             * Get the 'CreditCardData' element value.
             * 
             * @return value
             */
            public CreditCardData getCreditCardData() {
                return creditCardData;
            }

            /** 
             * Set the 'CreditCardData' element value.
             * 
             * @param creditCardData
             */
            public void setCreditCardData(CreditCardData creditCardData) {
                this.creditCardData = creditCardData;
            }

            /** 
             * Get the list of 'CustLoyalty' element items.
             * 
             * @return list
             */
            public List<CustLoyalty> getCustLoyaltyList() {
                return custLoyaltyList;
            }

            /** 
             * Set the list of 'CustLoyalty' element items.
             * 
             * @param list
             */
            public void setCustLoyaltyList(List<CustLoyalty> list) {
                custLoyaltyList = list;
            }

            /** 
             * Get the 'CustomerIdentifier' element value. Used to add a customer number (Also known as `DK number`) into the record.
                                                                  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                  The value of can be `6`, `7`, or `10` alphanumeric.
             * 
             * @return value
             */
            public String getCustomerIdentifier() {
                return customerIdentifier;
            }

            /** 
             * Set the 'CustomerIdentifier' element value. Used to add a customer number (Also known as `DK number`) into the record.
                                                                  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                  The value of can be `6`, `7`, or `10` alphanumeric.
             * 
             * @param customerIdentifier
             */
            public void setCustomerIdentifier(String customerIdentifier) {
                this.customerIdentifier = customerIdentifier;
            }

            /** 
             * Get the list of 'Email' element items.
             * 
             * @return list
             */
            public List<Email> getEmailList() {
                return emailList;
            }

            /** 
             * Set the list of 'Email' element items.
             * 
             * @param list
             */
            public void setEmailList(List<Email> list) {
                emailList = list;
            }

            /** 
             * Get the list of 'PersonName' element items.
             * 
             * @return list
             */
            public List<PersonName> getPersonNameList() {
                return personNameList;
            }

            /** 
             * Set the list of 'PersonName' element items.
             * 
             * @param list
             */
            public void setPersonNameList(List<PersonName> list) {
                personNameList = list;
            }
            /** 
             * Used to pass passenger contact numbers
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ContactNumber" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ContactNumber -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ContactNumbers implements Serializable
            {
                private List<ContactNumber> contactNumberList = new ArrayList<ContactNumber>();

                /** 
                 * Get the list of 'ContactNumber' element items.
                 * 
                 * @return list
                 */
                public List<ContactNumber> getContactNumberList() {
                    return contactNumberList;
                }

                /** 
                 * Set the list of 'ContactNumber' element items.
                 * 
                 * @param list
                 */
                public void setContactNumberList(List<ContactNumber> list) {
                    contactNumberList = list;
                }
                /** 
                 * Used to pass contact details for a specific passenger
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" name="InsertAfter"/>
                 *     &lt;xs:attribute type="xs:string" name="LocationCode"/>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Phone"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PhoneUseType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ContactNumber implements Serializable
                {
                    private BigInteger insertAfter;
                    private String locationCode;
                    private String nameNumber;
                    private String phone;
                    private String phoneUseType;

                    /** 
                     * Get the 'InsertAfter' attribute value. Used to add a phone number after or before an existing phone number
                     * 
                     * @return value
                     */
                    public BigInteger getInsertAfter() {
                        return insertAfter;
                    }

                    /** 
                     * Set the 'InsertAfter' attribute value. Used to add a phone number after or before an existing phone number
                     * 
                     * @param insertAfter
                     */
                    public void setInsertAfter(BigInteger insertAfter) {
                        this.insertAfter = insertAfter;
                    }

                    /** 
                     * Get the 'LocationCode' attribute value. Used to override the default city in the application's Travel Journal Record
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value. Used to override the default city in the application's Travel Journal Record
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Used to specify a passenger name number
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to specify a passenger name number
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'Phone' attribute value. Used to add customer telephone numbers into the record if applicable
                     * 
                     * @return value
                     */
                    public String getPhone() {
                        return phone;
                    }

                    /** 
                     * Set the 'Phone' attribute value. Used to add customer telephone numbers into the record if applicable
                     * 
                     * @param phone
                     */
                    public void setPhone(String phone) {
                        this.phone = phone;
                    }

                    /** 
                     * Get the 'PhoneUseType' attribute value. Used to specify if the number is agency "A", home "H", business "B" or fax "F".
                     * 
                     * @return value
                     */
                    public String getPhoneUseType() {
                        return phoneUseType;
                    }

                    /** 
                     * Set the 'PhoneUseType' attribute value. Used to specify if the number is agency "A", home "H", business "B" or fax "F".
                     * 
                     * @param phoneUseType
                     */
                    public void setPhoneUseType(String phoneUseType) {
                        this.phoneUseType = phoneUseType;
                    }
                }
            }
            /** 
             * Used to pass corporate ID into the record if applicable. Cannot combine with any other qualifier
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ID"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Corporate implements Serializable
            {
                private String ID;

                /** 
                 * Get the 'ID' element value. Used to add a corporate ID into the record if applicable.  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.  Furthermore, Sabre Travel Network-based customers need to first have this functionality activated for their particular location by their account representative prior to attempting to utilize this element
                 * 
                 * @return value
                 */
                public String getID() {
                    return ID;
                }

                /** 
                 * Set the 'ID' element value. Used to add a corporate ID into the record if applicable.  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.  Furthermore, Sabre Travel Network-based customers need to first have this functionality activated for their particular location by their account representative prior to attempting to utilize this element
                 * 
                 * @param ID
                 */
                public void setID(String ID) {
                    this.ID = ID;
                }
            }
            /** 
             * Used to pass the credit card billing information. Please note that .../BillingInformation and .../PreferredCustomer are mutually exclusive
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditCardData" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element name="BillingInformation">
             *         &lt;xs:complexType>
             *           &lt;xs:choice>
             *             &lt;xs:element type="xs:string" name="PostalCode"/>
             *             &lt;xs:element type="xs:string" name="Zip"/>
             *           &lt;/xs:choice>
             *           &lt;xs:attribute type="xs:string" use="required" name="cardHolderName"/>
             *           &lt;xs:attribute type="xs:string" use="required" name="streetAddress"/>
             *           &lt;xs:attribute type="xs:string" use="required" name="city"/>
             *           &lt;xs:attribute type="xs:string" name="stateOrProvince"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="PreferredCustomer">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:boolean" default="false" name="ind"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CreditCardData implements Serializable
            {
                private int creditCardDataSelect = -1;
                private static final int BILLING_INFORMATION_CHOICE = 0;
                private static final int PREFERRED_CUSTOMER_CHOICE = 1;
                private int billingInformationChoiceSelect = -1;
                private static final int BILLING_INFORMATION_POSTAL_CODE_CHOICE = 0;
                private static final int BILLING_INFORMATION_ZIP_CHOICE = 1;
                private String billingInformationPostalCode;
                private String billingInformationZip;
                private String billingInformationCardHolderName;
                private String billingInformationStreetAddress;
                private String billingInformationCity;
                private String billingInformationStateOrProvince;
                private Boolean preferredCustomer;

                private void setCreditCardDataSelect(int choice) {
                    if (creditCardDataSelect == -1) {
                        creditCardDataSelect = choice;
                    } else if (creditCardDataSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearCreditCardDataSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearCreditCardDataSelect() {
                    creditCardDataSelect = -1;
                }

                /** 
                 * Check if BillingInformation is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBillingInformation() {
                    return creditCardDataSelect == BILLING_INFORMATION_CHOICE;
                }

                private void setBillingInformationChoiceSelect(int choice) {
                    setCreditCardDataSelect(BILLING_INFORMATION_CHOICE);
                    if (billingInformationChoiceSelect == -1) {
                        billingInformationChoiceSelect = choice;
                    } else if (billingInformationChoiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearBillingInformationChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearBillingInformationChoiceSelect() {
                    billingInformationChoiceSelect = -1;
                }

                /** 
                 * Check if BillingInformationPostalCode is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBillingInformationPostalCode() {
                    return billingInformationChoiceSelect == BILLING_INFORMATION_POSTAL_CODE_CHOICE;
                }

                /** 
                 * Get the 'PostalCode' element value. Used to specify the postal code of the card holder
                 * 
                 * @return value
                 */
                public String getBillingInformationPostalCode() {
                    return billingInformationPostalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. Used to specify the postal code of the card holder
                 * 
                 * @param billingInformationPostalCode
                 */
                public void setBillingInformationPostalCode(
                        String billingInformationPostalCode) {
                    setBillingInformationChoiceSelect(BILLING_INFORMATION_POSTAL_CODE_CHOICE);
                    this.billingInformationPostalCode = billingInformationPostalCode;
                }

                /** 
                 * Check if BillingInformationZip is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBillingInformationZip() {
                    return billingInformationChoiceSelect == BILLING_INFORMATION_ZIP_CHOICE;
                }

                /** 
                 * Get the 'Zip' element value. Used to specify the zip code of the card holder
                 * 
                 * @return value
                 */
                public String getBillingInformationZip() {
                    return billingInformationZip;
                }

                /** 
                 * Set the 'Zip' element value. Used to specify the zip code of the card holder
                 * 
                 * @param billingInformationZip
                 */
                public void setBillingInformationZip(
                        String billingInformationZip) {
                    setBillingInformationChoiceSelect(BILLING_INFORMATION_ZIP_CHOICE);
                    this.billingInformationZip = billingInformationZip;
                }

                /** 
                 * Get the 'cardHolderName' attribute value. Used to specify the name of the card holder
                 * 
                 * @return value
                 */
                public String getBillingInformationCardHolderName() {
                    return billingInformationCardHolderName;
                }

                /** 
                 * Set the 'cardHolderName' attribute value. Used to specify the name of the card holder
                 * 
                 * @param billingInformationCardHolderName
                 */
                public void setBillingInformationCardHolderName(
                        String billingInformationCardHolderName) {
                    setCreditCardDataSelect(BILLING_INFORMATION_CHOICE);
                    this.billingInformationCardHolderName = billingInformationCardHolderName;
                }

                /** 
                 * Get the 'streetAddress' attribute value. Used to specify the street address of the card holder
                 * 
                 * @return value
                 */
                public String getBillingInformationStreetAddress() {
                    return billingInformationStreetAddress;
                }

                /** 
                 * Set the 'streetAddress' attribute value. Used to specify the street address of the card holder
                 * 
                 * @param billingInformationStreetAddress
                 */
                public void setBillingInformationStreetAddress(
                        String billingInformationStreetAddress) {
                    setCreditCardDataSelect(BILLING_INFORMATION_CHOICE);
                    this.billingInformationStreetAddress = billingInformationStreetAddress;
                }

                /** 
                 * Get the 'city' attribute value. Used to specify the city of the card holder
                 * 
                 * @return value
                 */
                public String getBillingInformationCity() {
                    return billingInformationCity;
                }

                /** 
                 * Set the 'city' attribute value. Used to specify the city of the card holder
                 * 
                 * @param billingInformationCity
                 */
                public void setBillingInformationCity(
                        String billingInformationCity) {
                    setCreditCardDataSelect(BILLING_INFORMATION_CHOICE);
                    this.billingInformationCity = billingInformationCity;
                }

                /** 
                 * Get the 'stateOrProvince' attribute value. Used to specify the state or province of the card holder. "stateOrProvince" with a state code is required for addresses in the United States, U.S. Virgin Islands, Puerto Rico. "stateOrProvince" with a province code is required for addresses outside the United States, U.S. Virgin Islands, Puerto Rico
                 * 
                 * @return value
                 */
                public String getBillingInformationStateOrProvince() {
                    return billingInformationStateOrProvince;
                }

                /** 
                 * Set the 'stateOrProvince' attribute value. Used to specify the state or province of the card holder. "stateOrProvince" with a state code is required for addresses in the United States, U.S. Virgin Islands, Puerto Rico. "stateOrProvince" with a province code is required for addresses outside the United States, U.S. Virgin Islands, Puerto Rico
                 * 
                 * @param billingInformationStateOrProvince
                 */
                public void setBillingInformationStateOrProvince(
                        String billingInformationStateOrProvince) {
                    setCreditCardDataSelect(BILLING_INFORMATION_CHOICE);
                    this.billingInformationStateOrProvince = billingInformationStateOrProvince;
                }

                /** 
                 * Check if PreferredCustomer is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPreferredCustomer() {
                    return creditCardDataSelect == PREFERRED_CUSTOMER_CHOICE;
                }

                /** 
                 * Get the 'ind' attribute value. Used to indicate in a client's Passenger Name Record (PNR) that your client is a preferred customer, overriding the automatic address verification (AVS) check at time of ticketing
                 * 
                 * @return value
                 */
                public Boolean getPreferredCustomer() {
                    return preferredCustomer;
                }

                /** 
                 * Set the 'ind' attribute value. Used to indicate in a client's Passenger Name Record (PNR) that your client is a preferred customer, overriding the automatic address verification (AVS) check at time of ticketing
                 * 
                 * @param preferredCustomer
                 */
                public void setPreferredCustomer(Boolean preferredCustomer) {
                    setCreditCardDataSelect(PREFERRED_CUSTOMER_CHOICE);
                    this.preferredCustomer = preferredCustomer;
                }
            }
            /** 
             * Used to pass frequent flyer number information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="MembershipID"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="ProgramID"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute type="xs:string" name="TravelingCarrierCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CustLoyalty implements Serializable
            {
                private String membershipID;
                private String nameNumber;
                private String programID;
                private String segmentNumber;
                private String travelingCarrierCode;

                /** 
                 * Get the 'MembershipID' attribute value. Used to add a frequent traveler number into the record.
                 * 
                 * @return value
                 */
                public String getMembershipID() {
                    return membershipID;
                }

                /** 
                 * Set the 'MembershipID' attribute value. Used to add a frequent traveler number into the record.
                 * 
                 * @param membershipID
                 */
                public void setMembershipID(String membershipID) {
                    this.membershipID = membershipID;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'ProgramID' attribute value. Used to add the carrier code associated with the frequent traveler number
                 * 
                 * @return value
                 */
                public String getProgramID() {
                    return programID;
                }

                /** 
                 * Set the 'ProgramID' attribute value. Used to add the carrier code associated with the frequent traveler number
                 * 
                 * @param programID
                 */
                public void setProgramID(String programID) {
                    this.programID = programID;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to add a segment number to associate the frequent traveler number to. SegmentNumber and TravelingCarrierCode cannot combine
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to add a segment number to associate the frequent traveler number to. SegmentNumber and TravelingCarrierCode cannot combine
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'TravelingCarrierCode' attribute value. Used to transmit the frequent traveler number of one airline to accrue mileage on another carrier. SegmentNumber and TravelingCarrierCode cannot combine
                 * 
                 * @return value
                 */
                public String getTravelingCarrierCode() {
                    return travelingCarrierCode;
                }

                /** 
                 * Set the 'TravelingCarrierCode' attribute value. Used to transmit the frequent traveler number of one airline to accrue mileage on another carrier. SegmentNumber and TravelingCarrierCode cannot combine
                 * 
                 * @param travelingCarrierCode
                 */
                public void setTravelingCarrierCode(String travelingCarrierCode) {
                    this.travelingCarrierCode = travelingCarrierCode;
                }
            }
            /** 
             * Used to pass e-mail details
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Address"/>
             *     &lt;xs:attribute type="xs:string" name="LanguageOverride"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="ShortText"/>
             *     &lt;xs:attribute name="Type">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Type -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Email implements Serializable
            {
                private String address;
                private String languageOverride;
                private String nameNumber;
                private String shortText;
                private Type type;

                /** 
                 * Get the 'Address' attribute value. Used to add an email address into the record
                 * 
                 * @return value
                 */
                public String getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' attribute value. Used to add an email address into the record
                 * 
                 * @param address
                 */
                public void setAddress(String address) {
                    this.address = address;
                }

                /** 
                 * Get the 'LanguageOverride' attribute value. Used to override the language in the agency's Travel Journal Record (TJR).
                 * 
                 * @return value
                 */
                public String getLanguageOverride() {
                    return languageOverride;
                }

                /** 
                 * Set the 'LanguageOverride' attribute value. Used to override the language in the agency's Travel Journal Record (TJR).
                 * 
                 * @param languageOverride
                 */
                public void setLanguageOverride(String languageOverride) {
                    this.languageOverride = languageOverride;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'ShortText' attribute value. Used to specify miscellaneous email address-related free text information if applicable
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' attribute value. Used to specify miscellaneous email address-related free text information if applicable
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the type of email address.  Acceptable values for "Type" are: "BC" for blind copy, "CC" for carbon copy, "FR" for from, or "To" for to
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the type of email address.  Acceptable values for "Type" are: "BC" for blind copy, "CC" for carbon copy, "FR" for from, or "To" for to
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="BC"/>
                 *     &lt;xs:enumeration value="CC"/>
                 *     &lt;xs:enumeration value="FR"/>
                 *     &lt;xs:enumeration value="TO"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    BC, CC, FR, TO
                }
            }
            /** 
             * Used to add passenger names
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
             *       &lt;xs:element name="GroupInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class GroupInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="Infant"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="NameReference"/>
             *     &lt;xs:attribute type="xs:string" name="PassengerType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String givenName;
                private GroupInfo groupInfo;
                private String surname;
                private Boolean infant;
                private String nameNumber;
                private String nameReference;
                private String passengerType;

                /** 
                 * Get the 'GivenName' element value. Passenger first name
                 * 
                 * @return value
                 */
                public String getGivenName() {
                    return givenName;
                }

                /** 
                 * Set the 'GivenName' element value. Passenger first name
                 * 
                 * @param givenName
                 */
                public void setGivenName(String givenName) {
                    this.givenName = givenName;
                }

                /** 
                 * Get the 'GroupInfo' element value.
                 * 
                 * @return value
                 */
                public GroupInfo getGroupInfo() {
                    return groupInfo;
                }

                /** 
                 * Set the 'GroupInfo' element value.
                 * 
                 * @param groupInfo
                 */
                public void setGroupInfo(GroupInfo groupInfo) {
                    this.groupInfo = groupInfo;
                }

                /** 
                 * Get the 'Surname' element value. Passenger surname
                 * 
                 * @return value
                 */
                public String getSurname() {
                    return surname;
                }

                /** 
                 * Set the 'Surname' element value. Passenger surname
                 * 
                 * @param surname
                 */
                public void setSurname(String surname) {
                    this.surname = surname;
                }

                /** 
                 * Get the 'Infant' attribute value. Used to specify that the particular passenger is an infant
                 * 
                 * @return value
                 */
                public Boolean getInfant() {
                    return infant;
                }

                /** 
                 * Set the 'Infant' attribute value. Used to specify that the particular passenger is an infant
                 * 
                 * @param infant
                 */
                public void setInfant(Boolean infant) {
                    this.infant = infant;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number, and is only applicable when used in conjunction with @PassengerType
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number, and is only applicable when used in conjunction with @PassengerType
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'NameReference' attribute value. Used to specify miscellaneous name reference-related information if applicable
                 * 
                 * @return value
                 */
                public String getNameReference() {
                    return nameReference;
                }

                /** 
                 * Set the 'NameReference' attribute value. Used to specify miscellaneous name reference-related information if applicable
                 * 
                 * @param nameReference
                 */
                public void setNameReference(String nameReference) {
                    this.nameReference = nameReference;
                }

                /** 
                 * Get the 'PassengerType' attribute value. Used to add a passenger type code into the record.  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                 * 
                 * @return value
                 */
                public String getPassengerType() {
                    return passengerType;
                }

                /** 
                 * Set the 'PassengerType' attribute value. Used to add a passenger type code into the record.  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                 * 
                 * @param passengerType
                 */
                public void setPassengerType(String passengerType) {
                    this.passengerType = passengerType;
                }
                /** 
                 * Group details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="VendorPrefs" minOccurs="0">
                 *         &lt;!-- Reference to inner class VendorPrefs -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="NumSeatsRemaining"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GroupInfo implements Serializable
                {
                    private VendorPrefs vendorPrefs;
                    private String name;
                    private BigInteger numSeatsRemaining;

                    /** 
                     * Get the 'VendorPrefs' element value.
                     * 
                     * @return value
                     */
                    public VendorPrefs getVendorPrefs() {
                        return vendorPrefs;
                    }

                    /** 
                     * Set the 'VendorPrefs' element value.
                     * 
                     * @param vendorPrefs
                     */
                    public void setVendorPrefs(VendorPrefs vendorPrefs) {
                        this.vendorPrefs = vendorPrefs;
                    }

                    /** 
                     * Get the 'Name' attribute value. Used to specify miscellaneous group booking-related free text title information if applicable
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. Used to specify miscellaneous group booking-related free text title information if applicable
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'NumSeatsRemaining' attribute value. Used to specify the number of passengers travelling in a group if applicable
                     * 
                     * @return value
                     */
                    public BigInteger getNumSeatsRemaining() {
                        return numSeatsRemaining;
                    }

                    /** 
                     * Set the 'NumSeatsRemaining' attribute value. Used to specify the number of passengers travelling in a group if applicable
                     * 
                     * @param numSeatsRemaining
                     */
                    public void setNumSeatsRemaining(
                            BigInteger numSeatsRemaining) {
                        this.numSeatsRemaining = numSeatsRemaining;
                    }
                    /** 
                     * Used to specify if the request is based upon a hosted or a non-hosted carrier.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Airline">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class VendorPrefs implements Serializable
                    {
                        private String airline;

                        /** 
                         * Get the 'Code' attribute value. Used to specify the airline that the group is travelling on if applicable.  Please note that this qualifier is not applicable to Sabre Sonic Res-based subscribers, or Sabre Travel Network-based subscribers.
                         * 
                         * @return value
                         */
                        public String getAirline() {
                            return airline;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify the airline that the group is travelling on if applicable.  Please note that this qualifier is not applicable to Sabre Sonic Res-based subscribers, or Sabre Travel Network-based subscribers.
                         * 
                         * @param airline
                         */
                        public void setAirline(String airline) {
                            this.airline = airline;
                        }
                    }
                }
            }
        }
    }
    /** 
     * Used to add air segments
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirBook" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="RetryRebook" minOccurs="0">
     *         &lt;!-- Reference to inner class RetryRebook -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HaltOnStatus" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HaltOnStatus -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestinationInformation">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="FlightSegment" maxOccurs="16">
     *               &lt;!-- Reference to inner class FlightSegment -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="RedisplayReservation" minOccurs="0">
     *         &lt;!-- Reference to inner class RedisplayReservation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirBook implements Serializable
    {
        private RetryRebook retryRebook;
        private List<HaltOnStatus> haltOnStatuList = new ArrayList<HaltOnStatus>();
        private List<FlightSegment> originDestinationInformationList = new ArrayList<FlightSegment>();
        private RedisplayReservation redisplayReservation;

        /** 
         * Get the 'RetryRebook' element value.
         * 
         * @return value
         */
        public RetryRebook getRetryRebook() {
            return retryRebook;
        }

        /** 
         * Set the 'RetryRebook' element value.
         * 
         * @param retryRebook
         */
        public void setRetryRebook(RetryRebook retryRebook) {
            this.retryRebook = retryRebook;
        }

        /** 
         * Get the list of 'HaltOnStatus' element items.
         * 
         * @return list
         */
        public List<HaltOnStatus> getHaltOnStatuList() {
            return haltOnStatuList;
        }

        /** 
         * Set the list of 'HaltOnStatus' element items.
         * 
         * @param list
         */
        public void setHaltOnStatuList(List<HaltOnStatus> list) {
            haltOnStatuList = list;
        }

        /** 
         * Get the list of 'FlightSegment' element items. Used to specify air segments to be booked
         * 
         * @return list
         */
        public List<FlightSegment> getOriginDestinationInformationList() {
            return originDestinationInformationList;
        }

        /** 
         * Set the list of 'FlightSegment' element items. Used to specify air segments to be booked
         * 
         * @param list
         */
        public void setOriginDestinationInformationList(List<FlightSegment> list) {
            originDestinationInformationList = list;
        }

        /** 
         * Get the 'RedisplayReservation' element value.
         * 
         * @return value
         */
        public RedisplayReservation getRedisplayReservation() {
            return redisplayReservation;
        }

        /** 
         * Set the 'RedisplayReservation' element value.
         * 
         * @param redisplayReservation
         */
        public void setRedisplayReservation(
                RedisplayReservation redisplayReservation) {
            this.redisplayReservation = redisplayReservation;
        }
        /** 
         * Used to specify if Rebooking of segments is required if UC is encountered
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetryRebook" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Option"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RetryRebook implements Serializable
        {
            private boolean option;

            /** 
             * Get the 'Option' attribute value. "Option" is used to specify if Rebooking of segments is required if UC is encountered in any of the segments which is trying to be booked
             * 
             * @return value
             */
            public boolean isOption() {
                return option;
            }

            /** 
             * Set the 'Option' attribute value. "Option" is used to specify if Rebooking of segments is required if UC is encountered in any of the segments which is trying to be booked
             * 
             * @param option
             */
            public void setOption(boolean option) {
                this.option = option;
            }
        }
        /** 
         * Used to specify values that cause subsequent pricing, and beyond processing to stop if they appear
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HaltOnStatus" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HaltOnStatus implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Used to specify values that cause subsequent pricing, and beyond processing to stop if they appear. In order to successfully price an air itinerary the status code associated with the individual segments cannot be NN, NO, UC or US. After successfully booking flights, the system will compare the status codes returned from the carrier against the client-specified codes to determine if subsequent pricing, and beyond processing should occur
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Used to specify values that cause subsequent pricing, and beyond processing to stop if they appear. In order to successfully price an air itinerary the status code associated with the individual segments cannot be NN, NO, UC or US. After successfully booking flights, the system will compare the status codes returned from the carrier against the client-specified codes to determine if subsequent pricing, and beyond processing should occur
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Used for a specific air segment to be booked.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="16">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DestinationLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Equipment" minOccurs="0">
         *         &lt;!-- Reference to inner class Equipment -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingAirline">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarriageGrp" minOccurs="0">
         *         &lt;xs:simpleType>
         *           &lt;!-- Reference to inner class MarriageGrp -->
         *         &lt;/xs:simpleType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="OperatingAirline" minOccurs="0">
         *         &lt;!-- Reference to inner class OperatingAirline -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AirlineRefId"/>
         *     &lt;xs:attribute type="xs:string" name="ArrivalDateTime"/>
         *     &lt;xs:attribute type="xs:string" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="NumberInParty"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ResBookDesigCode"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Status"/>
         *     &lt;xs:attribute type="xs:boolean" name="InstantPurchase"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private String destinationLocation;
            private Equipment equipment;
            private String marketingAirlineCode;
            private String marketingAirlineFlightNumber;
            private MarriageGrp marriageGrp;
            private OperatingAirline operatingAirline;
            private String originLocation;
            private String airlineRefId;
            private String arrivalDateTime;
            private String departureDateTime;
            private String flightNumber;
            private String numberInParty;
            private String resBookDesigCode;
            private String status;
            private Boolean instantPurchase;

            /** 
             * Get the 'LocationCode' attribute value. Used to specify the arrival airport code
             * 
             * @return value
             */
            public String getDestinationLocation() {
                return destinationLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value. Used to specify the arrival airport code
             * 
             * @param destinationLocation
             */
            public void setDestinationLocation(String destinationLocation) {
                this.destinationLocation = destinationLocation;
            }

            /** 
             * Get the 'Equipment' element value.
             * 
             * @return value
             */
            public Equipment getEquipment() {
                return equipment;
            }

            /** 
             * Set the 'Equipment' element value.
             * 
             * @param equipment
             */
            public void setEquipment(Equipment equipment) {
                this.equipment = equipment;
            }

            /** 
             * Get the 'Code' attribute value. Used to specify the marketing airline code.
             * 
             * @return value
             */
            public String getMarketingAirlineCode() {
                return marketingAirlineCode;
            }

            /** 
             * Set the 'Code' attribute value. Used to specify the marketing airline code.
             * 
             * @param marketingAirlineCode
             */
            public void setMarketingAirlineCode(String marketingAirlineCode) {
                this.marketingAirlineCode = marketingAirlineCode;
            }

            /** 
             * Get the 'FlightNumber' attribute value. Used to specify the flight number.  OPEN can also be passed if the user desires an open space ticket
             * 
             * @return value
             */
            public String getMarketingAirlineFlightNumber() {
                return marketingAirlineFlightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value. Used to specify the flight number.  OPEN can also be passed if the user desires an open space ticket
             * 
             * @param marketingAirlineFlightNumber
             */
            public void setMarketingAirlineFlightNumber(
                    String marketingAirlineFlightNumber) {
                this.marketingAirlineFlightNumber = marketingAirlineFlightNumber;
            }

            /** 
             * Get the 'MarriageGrp' element value. Information whether the flight segment is part of a married connection. O means no. I means yes.
             * 
             * @return value
             */
            public MarriageGrp getMarriageGrp() {
                return marriageGrp;
            }

            /** 
             * Set the 'MarriageGrp' element value. Information whether the flight segment is part of a married connection. O means no. I means yes.
             * 
             * @param marriageGrp
             */
            public void setMarriageGrp(MarriageGrp marriageGrp) {
                this.marriageGrp = marriageGrp;
            }

            /** 
             * Get the 'OperatingAirline' element value.
             * 
             * @return value
             */
            public OperatingAirline getOperatingAirline() {
                return operatingAirline;
            }

            /** 
             * Set the 'OperatingAirline' element value.
             * 
             * @param operatingAirline
             */
            public void setOperatingAirline(OperatingAirline operatingAirline) {
                this.operatingAirline = operatingAirline;
            }

            /** 
             * Get the 'LocationCode' attribute value. Used to specify the departure airport code
             * 
             * @return value
             */
            public String getOriginLocation() {
                return originLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value. Used to specify the departure airport code
             * 
             * @param originLocation
             */
            public void setOriginLocation(String originLocation) {
                this.originLocation = originLocation;
            }

            /** 
             * Get the 'AirlineRefId' attribute value. Used to pass an airline reference for a booking made outside of Sabre system. When you combine "AirlineRefId"  with other flight segment details, system will create a passive PNR segment.
             * 
             * @return value
             */
            public String getAirlineRefId() {
                return airlineRefId;
            }

            /** 
             * Set the 'AirlineRefId' attribute value. Used to pass an airline reference for a booking made outside of Sabre system. When you combine "AirlineRefId"  with other flight segment details, system will create a passive PNR segment.
             * 
             * @param airlineRefId
             */
            public void setAirlineRefId(String airlineRefId) {
                this.airlineRefId = airlineRefId;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value. Used to specify the time and date of flight arrival.  Please note that the value within this attribute if passed cannot be null
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value. Used to specify the time and date of flight arrival.  Please note that the value within this attribute if passed cannot be null
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value. Used to specify the time and date of flight departure
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value. Used to specify the time and date of flight departure
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'FlightNumber' attribute value. Used to specify the flight number.  OPEN can also be passed if the user desires an open space ticket
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value. Used to specify the flight number.  OPEN can also be passed if the user desires an open space ticket
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'NumberInParty' attribute value. Used to specify the number of passengers that need to be booked during this transaction
             * 
             * @return value
             */
            public String getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' attribute value. Used to specify the number of passengers that need to be booked during this transaction
             * 
             * @param numberInParty
             */
            public void setNumberInParty(String numberInParty) {
                this.numberInParty = numberInParty;
            }

            /** 
             * Get the 'ResBookDesigCode' attribute value. Used to specify the booking class
             * 
             * @return value
             */
            public String getResBookDesigCode() {
                return resBookDesigCode;
            }

            /** 
             * Set the 'ResBookDesigCode' attribute value. Used to specify the booking class
             * 
             * @param resBookDesigCode
             */
            public void setResBookDesigCode(String resBookDesigCode) {
                this.resBookDesigCode = resBookDesigCode;
            }

            /** 
             * Get the 'Status' attribute value. Used to specify the action code to be used to sell the flight inventory. Valid values for "Status": NN, HL, GK, QF, SA, MM, or OPEN
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'Status' attribute value. Used to specify the action code to be used to sell the flight inventory. Valid values for "Status": NN, HL, GK, QF, SA, MM, or OPEN
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }

            /** 
             * Get the 'InstantPurchase' attribute value. Used to send a request to an open system AirBookRQ
             * 
             * @return value
             */
            public Boolean getInstantPurchase() {
                return instantPurchase;
            }

            /** 
             * Set the 'InstantPurchase' attribute value. Used to send a request to an open system AirBookRQ
             * 
             * @param instantPurchase
             */
            public void setInstantPurchase(Boolean instantPurchase) {
                this.instantPurchase = instantPurchase;
            }
            /** 
             * Used to specify the equipment type of the aircraft being booked
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="AirEquipType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Equipment implements Serializable
            {
                private String airEquipType;

                /** 
                 * Get the 'AirEquipType' attribute value. Used to specify the equipment type of the aircraft being booked
                 * 
                 * @return value
                 */
                public String getAirEquipType() {
                    return airEquipType;
                }

                /** 
                 * Set the 'AirEquipType' attribute value. Used to specify the equipment type of the aircraft being booked
                 * 
                 * @param airEquipType
                 */
                public void setAirEquipType(String airEquipType) {
                    this.airEquipType = airEquipType;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="O"/>
             *     &lt;xs:enumeration value="I"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum MarriageGrp implements Serializable {
                O, I
            }
            /** 
             * Used to specify the operating airline code
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OperatingAirline implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Used to specify the operating airline code
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Used to specify the operating airline code
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Used to request a redisplay reservation attempt to validate if the desired segment status code remains unaltered
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedisplayReservation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="NumAttempts"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="WaitInterval"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RedisplayReservation implements Serializable
        {
            private BigInteger numAttempts;
            private BigInteger waitInterval;

            /** 
             * Get the 'NumAttempts' attribute value. Used to specify a number of times to make the TravelItineraryReadRQ service call before proceeding to the OTA_AirPriceLLSRQ or the next service call. 
             * 
             * @return value
             */
            public BigInteger getNumAttempts() {
                return numAttempts;
            }

            /** 
             * Set the 'NumAttempts' attribute value. Used to specify a number of times to make the TravelItineraryReadRQ service call before proceeding to the OTA_AirPriceLLSRQ or the next service call. 
             * 
             * @param numAttempts
             */
            public void setNumAttempts(BigInteger numAttempts) {
                this.numAttempts = numAttempts;
            }

            /** 
             * Get the 'WaitInterval' attribute value. Used to specify an interval that the system should wait in milliseconds before making redisplay service calls
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'WaitInterval' attribute value. Used to specify an interval that the system should wait in milliseconds before making redisplay service calls
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }
        }
    }
    /** 
     * Used to price air segments
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirPrice" minOccurs="0" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceComparison" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceComparison -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriceRequestInformation">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="OptionalQualifiers" minOccurs="0">
     *               &lt;!-- Reference to inner class OptionalQualifiers -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:boolean" name="AlternativePricing"/>
     *           &lt;xs:attribute type="xs:boolean" name="FutureTicket"/>
     *           &lt;xs:attribute type="xs:boolean" name="Manual"/>
     *           &lt;xs:attribute type="xs:boolean" name="Retain"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirPrice implements Serializable
    {
        private PriceComparison priceComparison;
        private OptionalQualifiers optionalQualifiers;
        private Boolean priceRequestInformationAlternativePricing;
        private Boolean priceRequestInformationFutureTicket;
        private Boolean priceRequestInformationManual;
        private Boolean priceRequestInformationRetain;

        /** 
         * Get the 'PriceComparison' element value.
         * 
         * @return value
         */
        public PriceComparison getPriceComparison() {
            return priceComparison;
        }

        /** 
         * Set the 'PriceComparison' element value.
         * 
         * @param priceComparison
         */
        public void setPriceComparison(PriceComparison priceComparison) {
            this.priceComparison = priceComparison;
        }

        /** 
         * Get the 'OptionalQualifiers' element value. Used to define pricing variables
         * 
         * @return value
         */
        public OptionalQualifiers getOptionalQualifiers() {
            return optionalQualifiers;
        }

        /** 
         * Set the 'OptionalQualifiers' element value. Used to define pricing variables
         * 
         * @param optionalQualifiers
         */
        public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
            this.optionalQualifiers = optionalQualifiers;
        }

        /** 
         * Get the 'AlternativePricing' attribute value. Used to instruct the system to request Alternative Pricing. Please note that "AlternativePricing" cannot be combined with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder
         * 
         * @return value
         */
        public Boolean getPriceRequestInformationAlternativePricing() {
            return priceRequestInformationAlternativePricing;
        }

        /** 
         * Set the 'AlternativePricing' attribute value. Used to instruct the system to request Alternative Pricing. Please note that "AlternativePricing" cannot be combined with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder
         * 
         * @param priceRequestInformationAlternativePricing
         */
        public void setPriceRequestInformationAlternativePricing(
                Boolean priceRequestInformationAlternativePricing) {
            this.priceRequestInformationAlternativePricing = priceRequestInformationAlternativePricing;
        }

        /** 
         * Get the 'FutureTicket' attribute value. Used to instruct the system to create an FP line for future ticketing
         * 
         * @return value
         */
        public Boolean getPriceRequestInformationFutureTicket() {
            return priceRequestInformationFutureTicket;
        }

        /** 
         * Set the 'FutureTicket' attribute value. Used to instruct the system to create an FP line for future ticketing
         * 
         * @param priceRequestInformationFutureTicket
         */
        public void setPriceRequestInformationFutureTicket(
                Boolean priceRequestInformationFutureTicket) {
            this.priceRequestInformationFutureTicket = priceRequestInformationFutureTicket;
        }

        /** 
         * Get the 'Manual' attribute value. This attribute is not used
         * 
         * @return value
         */
        public Boolean getPriceRequestInformationManual() {
            return priceRequestInformationManual;
        }

        /** 
         * Set the 'Manual' attribute value. This attribute is not used
         * 
         * @param priceRequestInformationManual
         */
        public void setPriceRequestInformationManual(
                Boolean priceRequestInformationManual) {
            this.priceRequestInformationManual = priceRequestInformationManual;
        }

        /** 
         * Get the 'Retain' attribute value. Used to instruct the system to retain the pricing response and create a price quote record.
         * 
         * @return value
         */
        public Boolean getPriceRequestInformationRetain() {
            return priceRequestInformationRetain;
        }

        /** 
         * Set the 'Retain' attribute value. Used to instruct the system to retain the pricing response and create a price quote record.
         * 
         * @param priceRequestInformationRetain
         */
        public void setPriceRequestInformationRetain(
                Boolean priceRequestInformationRetain) {
            this.priceRequestInformationRetain = priceRequestInformationRetain;
        }
        /** 
         * Used to specify a specific total price threshold which is acceptable.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceComparison" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AcceptablePriceIncrease" minOccurs="0">
         *         &lt;!-- Reference to inner class AcceptablePriceIncrease -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AcceptablePriceDecrease" minOccurs="0">
         *         &lt;!-- Reference to inner class AcceptablePriceDecrease -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:decimal" use="required" name="AmountSpecified"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceComparison implements Serializable
        {
            private AcceptablePriceIncrease acceptablePriceIncrease;
            private AcceptablePriceDecrease acceptablePriceDecrease;
            private BigDecimal amountSpecified;

            /** 
             * Get the 'AcceptablePriceIncrease' element value.
             * 
             * @return value
             */
            public AcceptablePriceIncrease getAcceptablePriceIncrease() {
                return acceptablePriceIncrease;
            }

            /** 
             * Set the 'AcceptablePriceIncrease' element value.
             * 
             * @param acceptablePriceIncrease
             */
            public void setAcceptablePriceIncrease(
                    AcceptablePriceIncrease acceptablePriceIncrease) {
                this.acceptablePriceIncrease = acceptablePriceIncrease;
            }

            /** 
             * Get the 'AcceptablePriceDecrease' element value.
             * 
             * @return value
             */
            public AcceptablePriceDecrease getAcceptablePriceDecrease() {
                return acceptablePriceDecrease;
            }

            /** 
             * Set the 'AcceptablePriceDecrease' element value.
             * 
             * @param acceptablePriceDecrease
             */
            public void setAcceptablePriceDecrease(
                    AcceptablePriceDecrease acceptablePriceDecrease) {
                this.acceptablePriceDecrease = acceptablePriceDecrease;
            }

            /** 
             * Get the 'AmountSpecified' attribute value. Used to specify the total amount associated with the itinerary returned via the previous shopping method for comparision purposes against the current price being returned for the same itinerary
             * 
             * @return value
             */
            public BigDecimal getAmountSpecified() {
                return amountSpecified;
            }

            /** 
             * Set the 'AmountSpecified' attribute value. Used to specify the total amount associated with the itinerary returned via the previous shopping method for comparision purposes against the current price being returned for the same itinerary
             * 
             * @param amountSpecified
             */
            public void setAmountSpecified(BigDecimal amountSpecified) {
                this.amountSpecified = amountSpecified;
            }
            /** 
             * Used to define the acceptable price increase threshold
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptablePriceIncrease" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element type="xs:decimal" name="Amount"/>
             *       &lt;xs:element type="xs:decimal" name="Percent"/>
             *     &lt;/xs:choice>
             *     &lt;xs:attribute type="xs:boolean" default="false" name="HaltOnNonAcceptablePrice"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AcceptablePriceIncrease implements Serializable
            {
                private int choiceSelect = -1;
                private static final int AMOUNT_CHOICE = 0;
                private static final int PERCENT_CHOICE = 1;
                private BigDecimal amount;
                private BigDecimal percent;
                private Boolean haltOnNonAcceptablePrice;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if Amount is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAmount() {
                    return choiceSelect == AMOUNT_CHOICE;
                }

                /** 
                 * Get the 'Amount' element value. Used to define an amount threshold.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Used to define an amount threshold.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    setChoiceSelect(AMOUNT_CHOICE);
                    this.amount = amount;
                }

                /** 
                 * Check if Percent is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPercent() {
                    return choiceSelect == PERCENT_CHOICE;
                }

                /** 
                 * Get the 'Percent' element value. Used to define a percent threshold.
                 * 
                 * @return value
                 */
                public BigDecimal getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' element value. Used to define a percent threshold.
                 * 
                 * @param percent
                 */
                public void setPercent(BigDecimal percent) {
                    setChoiceSelect(PERCENT_CHOICE);
                    this.percent = percent;
                }

                /** 
                 * Get the 'HaltOnNonAcceptablePrice' attribute value. Used to specify whether service should stop when actual price would be greater than "AmountSpecified" + percent or amount increase
                 * 
                 * @return value
                 */
                public Boolean getHaltOnNonAcceptablePrice() {
                    return haltOnNonAcceptablePrice;
                }

                /** 
                 * Set the 'HaltOnNonAcceptablePrice' attribute value. Used to specify whether service should stop when actual price would be greater than "AmountSpecified" + percent or amount increase
                 * 
                 * @param haltOnNonAcceptablePrice
                 */
                public void setHaltOnNonAcceptablePrice(
                        Boolean haltOnNonAcceptablePrice) {
                    this.haltOnNonAcceptablePrice = haltOnNonAcceptablePrice;
                }
            }
            /** 
             * Used to define the acceptable price decrease threshold
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptablePriceDecrease" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element type="xs:decimal" name="Amount"/>
             *       &lt;xs:element type="xs:decimal" name="Percent"/>
             *     &lt;/xs:choice>
             *     &lt;xs:attribute type="xs:boolean" default="false" name="HaltOnNonAcceptablePrice"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AcceptablePriceDecrease implements Serializable
            {
                private int choiceSelect = -1;
                private static final int AMOUNT_CHOICE = 0;
                private static final int PERCENT_CHOICE = 1;
                private BigDecimal amount;
                private BigDecimal percent;
                private Boolean haltOnNonAcceptablePrice;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if Amount is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAmount() {
                    return choiceSelect == AMOUNT_CHOICE;
                }

                /** 
                 * Get the 'Amount' element value. Used to define an amount threshold.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Used to define an amount threshold.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    setChoiceSelect(AMOUNT_CHOICE);
                    this.amount = amount;
                }

                /** 
                 * Check if Percent is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPercent() {
                    return choiceSelect == PERCENT_CHOICE;
                }

                /** 
                 * Get the 'Percent' element value. Used to define a percent threshold.
                 * 
                 * @return value
                 */
                public BigDecimal getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' element value. Used to define a percent threshold.
                 * 
                 * @param percent
                 */
                public void setPercent(BigDecimal percent) {
                    setChoiceSelect(PERCENT_CHOICE);
                    this.percent = percent;
                }

                /** 
                 * Get the 'HaltOnNonAcceptablePrice' attribute value. Used to specify whether service should stop when actual price would be lesser than "AmountSpecified" + percent or amount decrease
                 * 
                 * @return value
                 */
                public Boolean getHaltOnNonAcceptablePrice() {
                    return haltOnNonAcceptablePrice;
                }

                /** 
                 * Set the 'HaltOnNonAcceptablePrice' attribute value. Used to specify whether service should stop when actual price would be lesser than "AmountSpecified" + percent or amount decrease
                 * 
                 * @param haltOnNonAcceptablePrice
                 */
                public void setHaltOnNonAcceptablePrice(
                        Boolean haltOnNonAcceptablePrice) {
                    this.haltOnNonAcceptablePrice = haltOnNonAcceptablePrice;
                }
            }
        }
        /** 
         * Used to define all the pricing variables.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class FlightQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FOP_Qualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class FOPQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class MiscQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PricingQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class PricingQualifiers -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OptionalQualifiers implements Serializable
        {
            private FlightQualifiers flightQualifiers;
            private FOPQualifiers FOPQualifiers1;
            private MiscQualifiers miscQualifiers;
            private PricingQualifiers pricingQualifiers;

            /** 
             * Get the 'FlightQualifiers' element value.
             * 
             * @return value
             */
            public FlightQualifiers getFlightQualifiers() {
                return flightQualifiers;
            }

            /** 
             * Set the 'FlightQualifiers' element value.
             * 
             * @param flightQualifiers
             */
            public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
                this.flightQualifiers = flightQualifiers;
            }

            /** 
             * Get the 'FOP_Qualifiers' element value.
             * 
             * @return value
             */
            public FOPQualifiers getFOPQualifiers1() {
                return FOPQualifiers1;
            }

            /** 
             * Set the 'FOP_Qualifiers' element value.
             * 
             * @param FOPQualifiers1
             */
            public void setFOPQualifiers1(FOPQualifiers FOPQualifiers1) {
                this.FOPQualifiers1 = FOPQualifiers1;
            }

            /** 
             * Get the 'MiscQualifiers' element value.
             * 
             * @return value
             */
            public MiscQualifiers getMiscQualifiers() {
                return miscQualifiers;
            }

            /** 
             * Set the 'MiscQualifiers' element value.
             * 
             * @param miscQualifiers
             */
            public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
                this.miscQualifiers = miscQualifiers;
            }

            /** 
             * Get the 'PricingQualifiers' element value.
             * 
             * @return value
             */
            public PricingQualifiers getPricingQualifiers() {
                return pricingQualifiers;
            }

            /** 
             * Set the 'PricingQualifiers' element value.
             * 
             * @param pricingQualifiers
             */
            public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
                this.pricingQualifiers = pricingQualifiers;
            }
            /** 
             * Used to define carrier specific variables
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightQualifiers implements Serializable
            {
                private VendorPrefs vendorPrefs;

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }
                /** 
                 * Carrier preferences
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private String airline;

                    /** 
                     * Get the 'Code' attribute value. Used to specify a particular vendor code
                     * 
                     * @return value
                     */
                    public String getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Code' attribute value. Used to specify a particular vendor code
                     * 
                     * @param airline
                     */
                    public void setAirline(String airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to define form of payment variables
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Qualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BasicFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class BasicFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="BSP_Ticketing" minOccurs="0">
             *         &lt;!-- Reference to inner class BSPTicketing -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleCC_FOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleCCFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SabreSonicTicketing" minOccurs="0">
             *         &lt;!-- Reference to inner class SabreSonicTicketing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="IgnoreStoredFOP"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FOPQualifiers implements Serializable
            {
                private BasicFOP basicFOP;
                private BSPTicketing BSPTicketing1;
                private MultipleCCFOP multipleCCFOP;
                private SabreSonicTicketing sabreSonicTicketing;
                private Boolean ignoreStoredFOP;

                /** 
                 * Get the 'BasicFOP' element value.
                 * 
                 * @return value
                 */
                public BasicFOP getBasicFOP() {
                    return basicFOP;
                }

                /** 
                 * Set the 'BasicFOP' element value.
                 * 
                 * @param basicFOP
                 */
                public void setBasicFOP(BasicFOP basicFOP) {
                    this.basicFOP = basicFOP;
                }

                /** 
                 * Get the 'BSP_Ticketing' element value.
                 * 
                 * @return value
                 */
                public BSPTicketing getBSPTicketing1() {
                    return BSPTicketing1;
                }

                /** 
                 * Set the 'BSP_Ticketing' element value.
                 * 
                 * @param BSPTicketing1
                 */
                public void setBSPTicketing1(BSPTicketing BSPTicketing1) {
                    this.BSPTicketing1 = BSPTicketing1;
                }

                /** 
                 * Get the 'MultipleCC_FOP' element value.
                 * 
                 * @return value
                 */
                public MultipleCCFOP getMultipleCCFOP() {
                    return multipleCCFOP;
                }

                /** 
                 * Set the 'MultipleCC_FOP' element value.
                 * 
                 * @param multipleCCFOP
                 */
                public void setMultipleCCFOP(MultipleCCFOP multipleCCFOP) {
                    this.multipleCCFOP = multipleCCFOP;
                }

                /** 
                 * Get the 'SabreSonicTicketing' element value.
                 * 
                 * @return value
                 */
                public SabreSonicTicketing getSabreSonicTicketing() {
                    return sabreSonicTicketing;
                }

                /** 
                 * Set the 'SabreSonicTicketing' element value.
                 * 
                 * @param sabreSonicTicketing
                 */
                public void setSabreSonicTicketing(
                        SabreSonicTicketing sabreSonicTicketing) {
                    this.sabreSonicTicketing = sabreSonicTicketing;
                }

                /** 
                 * Get the 'IgnoreStoredFOP' attribute value. This attribute is not in use.
                 * 
                 * @return value
                 */
                public Boolean getIgnoreStoredFOP() {
                    return ignoreStoredFOP;
                }

                /** 
                 * Set the 'IgnoreStoredFOP' attribute value. This attribute is not in use.
                 * 
                 * @param ignoreStoredFOP
                 */
                public void setIgnoreStoredFOP(Boolean ignoreStoredFOP) {
                    this.ignoreStoredFOP = ignoreStoredFOP;
                }
                /** 
                 * Used to define a single form of payment. BasicFOP cannot combine with .../BSP_Ticketing, or .../SabreSonicTicketing, or .../MultipleCC_FOP
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Type"/>
                 *     &lt;xs:attribute type="xs:integer" name="Reference"/>
                 *     &lt;xs:attribute type="xs:string" name="Virtual"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BasicFOP implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String type;
                    private BigInteger reference;
                    private String virtual;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                     * 
                     * @return value
                     */
                    public BigInteger getReference() {
                        return reference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                     * 
                     * @param reference
                     */
                    public void setReference(BigInteger reference) {
                        this.reference = reference;
                    }

                    /** 
                     * Get the 'Virtual' attribute value. Used to pass virtual form of payment information
                     * 
                     * @return value
                     */
                    public String getVirtual() {
                        return virtual;
                    }

                    /** 
                     * Set the 'Virtual' attribute value. Used to pass virtual form of payment information
                     * 
                     * @param virtual
                     */
                    public void setVirtual(String virtual) {
                        this.virtual = virtual;
                    }
                    /** 
                     * Used to pass credit card information
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * Used to define forms of payment acceptable within BSP region. BSP_Ticketing cannot combine with .../SabreSonicTicketing, or .../MultipleCC_FOP
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSP_Ticketing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="MultipleFOP" minOccurs="0">
                 *         &lt;!-- Reference to inner class MultipleFOP -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MultipleMiscFOP" minOccurs="0">
                 *         &lt;!-- Reference to inner class MultipleMiscFOP -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PayLaterPlan" minOccurs="0">
                 *         &lt;!-- Reference to inner class PayLaterPlan -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BSPTicketing implements Serializable
                {
                    private MultipleFOP multipleFOP;
                    private MultipleMiscFOP multipleMiscFOP;
                    private PayLaterPlan payLaterPlan;

                    /** 
                     * Get the 'MultipleFOP' element value.
                     * 
                     * @return value
                     */
                    public MultipleFOP getMultipleFOP() {
                        return multipleFOP;
                    }

                    /** 
                     * Set the 'MultipleFOP' element value.
                     * 
                     * @param multipleFOP
                     */
                    public void setMultipleFOP(MultipleFOP multipleFOP) {
                        this.multipleFOP = multipleFOP;
                    }

                    /** 
                     * Get the 'MultipleMiscFOP' element value.
                     * 
                     * @return value
                     */
                    public MultipleMiscFOP getMultipleMiscFOP() {
                        return multipleMiscFOP;
                    }

                    /** 
                     * Set the 'MultipleMiscFOP' element value.
                     * 
                     * @param multipleMiscFOP
                     */
                    public void setMultipleMiscFOP(
                            MultipleMiscFOP multipleMiscFOP) {
                        this.multipleMiscFOP = multipleMiscFOP;
                    }

                    /** 
                     * Get the 'PayLaterPlan' element value.
                     * 
                     * @return value
                     */
                    public PayLaterPlan getPayLaterPlan() {
                        return payLaterPlan;
                    }

                    /** 
                     * Set the 'PayLaterPlan' element value.
                     * 
                     * @param payLaterPlan
                     */
                    public void setPayLaterPlan(PayLaterPlan payLaterPlan) {
                        this.payLaterPlan = payLaterPlan;
                    }
                    /** 
                     * Used to define multiple forms of payment. MultipleFOP cannot combine with .../MultipleMiscFOP, or .../PayLaterPlan
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Fare">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_One">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *           &lt;xs:attribute type="xs:integer" name="Reference"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_Two">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo1 -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *           &lt;xs:attribute type="xs:integer" name="Reference"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MultipleFOP implements Serializable
                    {
                        private String fare;
                        private CCInfo CCInfo2;
                        private String FOPOneType;
                        private BigInteger FOPOneReference;
                        private CCInfo1 CCInfo3;
                        private String FOPTwoType;
                        private BigInteger FOPTwoReference;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @return value
                         */
                        public String getFare() {
                            return fare;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @param fare
                         */
                        public void setFare(String fare) {
                            this.fare = fare;
                        }

                        /** 
                         * Get the 'CC_Info' element value. First form of payment
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo2() {
                            return CCInfo2;
                        }

                        /** 
                         * Set the 'CC_Info' element value. First form of payment
                         * 
                         * @param CCInfo2
                         */
                        public void setCCInfo2(CCInfo CCInfo2) {
                            this.CCInfo2 = CCInfo2;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPOneType() {
                            return FOPOneType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPOneType
                         */
                        public void setFOPOneType(String FOPOneType) {
                            this.FOPOneType = FOPOneType;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @return value
                         */
                        public BigInteger getFOPOneReference() {
                            return FOPOneReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @param FOPOneReference
                         */
                        public void setFOPOneReference(
                                BigInteger FOPOneReference) {
                            this.FOPOneReference = FOPOneReference;
                        }

                        /** 
                         * Get the 'CC_Info' element value. Second form of payment
                         * 
                         * @return value
                         */
                        public CCInfo1 getCCInfo3() {
                            return CCInfo3;
                        }

                        /** 
                         * Set the 'CC_Info' element value. Second form of payment
                         * 
                         * @param CCInfo3
                         */
                        public void setCCInfo3(CCInfo1 CCInfo3) {
                            this.CCInfo3 = CCInfo3;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPTwoType() {
                            return FOPTwoType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPTwoType
                         */
                        public void setFOPTwoType(String FOPTwoType) {
                            this.FOPTwoType = FOPTwoType;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @return value
                         */
                        public BigInteger getFOPTwoReference() {
                            return FOPTwoReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @param FOPTwoReference
                         */
                        public void setFOPTwoReference(
                                BigInteger FOPTwoReference) {
                            this.FOPTwoReference = FOPTwoReference;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;
                            private Boolean suppress;

                            /** 
                             * Get the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. sed to specify a manual approval credit card code if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. sed to specify a manual approval credit card code if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }

                            /** 
                             * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @return value
                             */
                            public Boolean getSuppress() {
                                return suppress;
                            }

                            /** 
                             * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @param suppress
                             */
                            public void setSuppress(Boolean suppress) {
                                this.suppress = suppress;
                            }
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo1 implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;
                            private Boolean suppress;

                            /** 
                             * Get the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }

                            /** 
                             * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @return value
                             */
                            public Boolean getSuppress() {
                                return suppress;
                            }

                            /** 
                             * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @param suppress
                             */
                            public void setSuppress(Boolean suppress) {
                                this.suppress = suppress;
                            }
                        }
                    }
                    /** 
                     * Used to define multiple miscellaneous forms of payment. MultipleMiscFOP cannot combine with .../MultipleFOP, or .../PayLaterPlan
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleMiscFOP" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Fare">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_One">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *           &lt;xs:attribute type="xs:integer" name="Reference"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_Two">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="ExtendedPayment" minOccurs="0">
                     *               &lt;!-- Reference to inner class ExtendedPayment -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                     *           &lt;xs:attribute type="xs:integer" name="Reference"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Taxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class Taxes -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MultipleMiscFOP implements Serializable
                    {
                        private String fare;
                        private CCInfo CCInfo1;
                        private String FOPOneType;
                        private BigInteger FOPOneReference;
                        private ExtendedPayment extendedPayment;
                        private String FOPTwoType;
                        private BigInteger FOPTwoReference;
                        private Taxes taxes;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @return value
                         */
                        public String getFare() {
                            return fare;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @param fare
                         */
                        public void setFare(String fare) {
                            this.fare = fare;
                        }

                        /** 
                         * Get the 'CC_Info' element value. First form of payment
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo1() {
                            return CCInfo1;
                        }

                        /** 
                         * Set the 'CC_Info' element value. First form of payment
                         * 
                         * @param CCInfo1
                         */
                        public void setCCInfo1(CCInfo CCInfo1) {
                            this.CCInfo1 = CCInfo1;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPOneType() {
                            return FOPOneType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPOneType
                         */
                        public void setFOPOneType(String FOPOneType) {
                            this.FOPOneType = FOPOneType;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @return value
                         */
                        public BigInteger getFOPOneReference() {
                            return FOPOneReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @param FOPOneReference
                         */
                        public void setFOPOneReference(
                                BigInteger FOPOneReference) {
                            this.FOPOneReference = FOPOneReference;
                        }

                        /** 
                         * Get the 'ExtendedPayment' element value. Second form of payment
                         * 
                         * @return value
                         */
                        public ExtendedPayment getExtendedPayment() {
                            return extendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' element value. Second form of payment
                         * 
                         * @param extendedPayment
                         */
                        public void setExtendedPayment(
                                ExtendedPayment extendedPayment) {
                            this.extendedPayment = extendedPayment;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the misc payment
                         * 
                         * @return value
                         */
                        public String getFOPTwoType() {
                            return FOPTwoType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the misc payment
                         * 
                         * @param FOPTwoType
                         */
                        public void setFOPTwoType(String FOPTwoType) {
                            this.FOPTwoType = FOPTwoType;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @return value
                         */
                        public BigInteger getFOPTwoReference() {
                            return FOPTwoReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @param FOPTwoReference
                         */
                        public void setFOPTwoReference(
                                BigInteger FOPTwoReference) {
                            this.FOPTwoReference = FOPTwoReference;
                        }

                        /** 
                         * Get the 'Taxes' element value.
                         * 
                         * @return value
                         */
                        public Taxes getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(Taxes taxes) {
                            this.taxes = taxes;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;
                            private Boolean suppress;

                            /** 
                             * Get the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }

                            /** 
                             * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @return value
                             */
                            public Boolean getSuppress() {
                                return suppress;
                            }

                            /** 
                             * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @param suppress
                             */
                            public void setSuppress(Boolean suppress) {
                                this.suppress = suppress;
                            }
                        }
                        /** 
                         * Used to specify extended payment if applicable
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtendedPayment" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:integer" use="required" name="NumMonths"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ExtendedPayment implements
                            Serializable
                        {
                            private BigInteger numMonths;

                            /** 
                             * Get the 'NumMonths' attribute value. Used to define number of months for the extension.
                             * 
                             * @return value
                             */
                            public BigInteger getNumMonths() {
                                return numMonths;
                            }

                            /** 
                             * Set the 'NumMonths' attribute value. Used to define number of months for the extension.
                             * 
                             * @param numMonths
                             */
                            public void setNumMonths(BigInteger numMonths) {
                                this.numMonths = numMonths;
                            }
                        }
                        /** 
                         * Used to define tax details
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax" maxOccurs="2">
                         *         &lt;!-- Reference to inner class Tax -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Taxes implements Serializable
                        {
                            private List<Tax> taxList = new ArrayList<Tax>();

                            /** 
                             * Get the list of 'Tax' element items.
                             * 
                             * @return list
                             */
                            public List<Tax> getTaxList() {
                                return taxList;
                            }

                            /** 
                             * Set the list of 'Tax' element items.
                             * 
                             * @param list
                             */
                            public void setTaxList(List<Tax> list) {
                                taxList = list;
                            }
                            /** 
                             * Used to define tax details
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="2">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Tax implements Serializable
                            {
                                private String amount;
                                private String taxCode;

                                /** 
                                 * Get the 'Amount' attribute value. Used to specify the tax amount
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. Used to specify the tax amount
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'TaxCode' attribute value. Used to specify the tax code
                                 * 
                                 * @return value
                                 */
                                public String getTaxCode() {
                                    return taxCode;
                                }

                                /** 
                                 * Set the 'TaxCode' attribute value. Used to specify the tax code
                                 * 
                                 * @param taxCode
                                 */
                                public void setTaxCode(String taxCode) {
                                    this.taxCode = taxCode;
                                }
                            }
                        }
                    }
                    /** 
                     * Only applicable to Brazil. PayLaterPlan cannot combine with MultipleFOP, or MultipleMiscFOP
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayLaterPlan" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Fare">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *           &lt;xs:attribute type="xs:string" name="Reference"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Installment">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Count"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="PayLaterReferenceNumber"/>
                     *           &lt;xs:attribute type="xs:integer" name="Reference"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PayLaterPlan implements Serializable
                    {
                        private String fare;
                        private CCInfo CCInfo1;
                        private String FOPType;
                        private String FOPReference;
                        private String installmentCount;
                        private String installmentPayLaterReferenceNumber;
                        private BigInteger installmentReference;
                        private String installmentValue;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the remaining fare amount.
                         * 
                         * @return value
                         */
                        public String getFare() {
                            return fare;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the remaining fare amount.
                         * 
                         * @param fare
                         */
                        public void setFare(String fare) {
                            this.fare = fare;
                        }

                        /** 
                         * Get the 'CC_Info' element value. Used to define form of payment.
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo1() {
                            return CCInfo1;
                        }

                        /** 
                         * Set the 'CC_Info' element value. Used to define form of payment.
                         * 
                         * @param CCInfo1
                         */
                        public void setCCInfo1(CCInfo CCInfo1) {
                            this.CCInfo1 = CCInfo1;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                         * 
                         * @return value
                         */
                        public String getFOPType() {
                            return FOPType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                         * 
                         * @param FOPType
                         */
                        public void setFOPType(String FOPType) {
                            this.FOPType = FOPType;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @return value
                         */
                        public String getFOPReference() {
                            return FOPReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to reference a line number from PNR FOP field
                         * 
                         * @param FOPReference
                         */
                        public void setFOPReference(String FOPReference) {
                            this.FOPReference = FOPReference;
                        }

                        /** 
                         * Get the 'Count' attribute value. Used to specify the number of installments
                         * 
                         * @return value
                         */
                        public String getInstallmentCount() {
                            return installmentCount;
                        }

                        /** 
                         * Set the 'Count' attribute value. Used to specify the number of installments
                         * 
                         * @param installmentCount
                         */
                        public void setInstallmentCount(String installmentCount) {
                            this.installmentCount = installmentCount;
                        }

                        /** 
                         * Get the 'PayLaterReferenceNumber' attribute value. Used to specify the pay later reference number
                         * 
                         * @return value
                         */
                        public String getInstallmentPayLaterReferenceNumber() {
                            return installmentPayLaterReferenceNumber;
                        }

                        /** 
                         * Set the 'PayLaterReferenceNumber' attribute value. Used to specify the pay later reference number
                         * 
                         * @param installmentPayLaterReferenceNumber
                         */
                        public void setInstallmentPayLaterReferenceNumber(
                                String installmentPayLaterReferenceNumber) {
                            this.installmentPayLaterReferenceNumber = installmentPayLaterReferenceNumber;
                        }

                        /** 
                         * Get the 'Reference' attribute value. Used to define reference number
                         * 
                         * @return value
                         */
                        public BigInteger getInstallmentReference() {
                            return installmentReference;
                        }

                        /** 
                         * Set the 'Reference' attribute value. Used to define reference number
                         * 
                         * @param installmentReference
                         */
                        public void setInstallmentReference(
                                BigInteger installmentReference) {
                            this.installmentReference = installmentReference;
                        }

                        /** 
                         * Get the 'Value' attribute value. Used to specify the value of the installments.  Please note that decimals are not permitted
                         * 
                         * @return value
                         */
                        public String getInstallmentValue() {
                            return installmentValue;
                        }

                        /** 
                         * Set the 'Value' attribute value. Used to specify the value of the installments.  Please note that decimals are not permitted
                         * 
                         * @param installmentValue
                         */
                        public void setInstallmentValue(String installmentValue) {
                            this.installmentValue = installmentValue;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;

                            /** 
                             * Get the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify a credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify a credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }
                        }
                    }
                }
                /** 
                 * Used to specify multiple credit card form of payment. Multiple CC_FOP cannot combine with .../BSP_Ticketing, or .../SabreSonicTicketing
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleCC_FOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CC_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CC_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleCCFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCOne;
                    private CCInfo1 CCTwo;

                    /** 
                     * Get the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First credit card
                     * 
                     * @return value
                     */
                    public CCInfo getCCOne() {
                        return CCOne;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First credit card
                     * 
                     * @param CCOne
                     */
                    public void setCCOne(CCInfo CCOne) {
                        this.CCOne = CCOne;
                    }

                    /** 
                     * Get the 'CC_Info' element value. Second credit card
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCTwo() {
                        return CCTwo;
                    }

                    /** 
                     * Set the 'CC_Info' element value. Second credit card
                     * 
                     * @param CCTwo
                     */
                    public void setCCTwo(CCInfo1 CCTwo) {
                        this.CCTwo = CCTwo;
                    }
                    /** 
                     * Used to pass credit card information
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Used to pass credit card information
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify a credit card vendor code
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date. "ExpireDate" follows this format: YYYY-MM
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval credit card code if applicable
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. Used to specify a credit card number
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * Valid for SabreSonic-based airlines. SabreSonicTicketing cannot combine with .../BSP_Ticketing. or .../MultipleCC_FOP.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreSonicTicketing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BasicFOP" minOccurs="0">
                 *         &lt;!-- Reference to inner class BasicFOP -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EnhancedMultipleFOP" minOccurs="0">
                 *         &lt;!-- Reference to inner class EnhancedMultipleFOP -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MultipleFOP" minOccurs="0">
                 *         &lt;!-- Reference to inner class MultipleFOP -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SabreSonicTicketing implements Serializable
                {
                    private BasicFOP basicFOP;
                    private EnhancedMultipleFOP enhancedMultipleFOP;
                    private MultipleFOP multipleFOP;

                    /** 
                     * Get the 'BasicFOP' element value.
                     * 
                     * @return value
                     */
                    public BasicFOP getBasicFOP() {
                        return basicFOP;
                    }

                    /** 
                     * Set the 'BasicFOP' element value.
                     * 
                     * @param basicFOP
                     */
                    public void setBasicFOP(BasicFOP basicFOP) {
                        this.basicFOP = basicFOP;
                    }

                    /** 
                     * Get the 'EnhancedMultipleFOP' element value.
                     * 
                     * @return value
                     */
                    public EnhancedMultipleFOP getEnhancedMultipleFOP() {
                        return enhancedMultipleFOP;
                    }

                    /** 
                     * Set the 'EnhancedMultipleFOP' element value.
                     * 
                     * @param enhancedMultipleFOP
                     */
                    public void setEnhancedMultipleFOP(
                            EnhancedMultipleFOP enhancedMultipleFOP) {
                        this.enhancedMultipleFOP = enhancedMultipleFOP;
                    }

                    /** 
                     * Get the 'MultipleFOP' element value.
                     * 
                     * @return value
                     */
                    public MultipleFOP getMultipleFOP() {
                        return multipleFOP;
                    }

                    /** 
                     * Set the 'MultipleFOP' element value.
                     * 
                     * @param multipleFOP
                     */
                    public void setMultipleFOP(MultipleFOP multipleFOP) {
                        this.multipleFOP = multipleFOP;
                    }
                    /** 
                     * Used to define a single form of payment. FOP cannot combine with .../EnhancedMultipleFOP, or .../MultipleFOP
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="CC_Info" minOccurs="0">
                     *         &lt;!-- Reference to inner class CCInfo -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                     *     &lt;xs:attribute type="xs:string" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BasicFOP implements Serializable
                    {
                        private CCInfo CCInfo1;
                        private String manualApprovalCode;
                        private String type;

                        /** 
                         * Get the 'CC_Info' element value.
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo1() {
                            return CCInfo1;
                        }

                        /** 
                         * Set the 'CC_Info' element value.
                         * 
                         * @param CCInfo1
                         */
                        public void setCCInfo1(CCInfo CCInfo1) {
                            this.CCInfo1 = CCInfo1;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. Used to specify a manual approval code for non-credit card forms of payment
                         * 
                         * @return value
                         */
                        public String getManualApprovalCode() {
                            return manualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. Used to specify a manual approval code for non-credit card forms of payment
                         * 
                         * @param manualApprovalCode
                         */
                        public void setManualApprovalCode(
                                String manualApprovalCode) {
                            this.manualApprovalCode = manualApprovalCode;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash, "CK" (check), "CQ" (cheque), "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA" (cash, "CK" (check), "CQ" (cheque), "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check). If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:integer" name="CardSecurityCode"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private BigInteger paymentCardCardSecurityCode;
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;
                            private Boolean suppress;

                            /** 
                             * Get the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardCardSecurityCode() {
                                return paymentCardCardSecurityCode;
                            }

                            /** 
                             * Set the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @param paymentCardCardSecurityCode
                             */
                            public void setPaymentCardCardSecurityCode(
                                    BigInteger paymentCardCardSecurityCode) {
                                this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                            }

                            /** 
                             * Get the 'Code' attribute value. Used to specify the credit card vendor code.
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify the credit card vendor code.
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }

                            /** 
                             * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @return value
                             */
                            public Boolean getSuppress() {
                                return suppress;
                            }

                            /** 
                             * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                             * 
                             * @param suppress
                             */
                            public void setSuppress(Boolean suppress) {
                                this.suppress = suppress;
                            }
                        }
                    }
                    /** 
                     * Valid for SabreSonic-based airlines who have activated the enhanced multiple form of payment option. EnhancedMultipleFOP cannot combine with .../MultipleFOP
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnhancedMultipleFOP" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Fare">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_One">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_Two">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo1 -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Taxes">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="Tax">
                     *               &lt;xs:complexType>
                     *                 &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *                 &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                     *               &lt;/xs:complexType>
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EnhancedMultipleFOP implements
                        Serializable
                    {
                        private String fare;
                        private CCInfo CCInfo2;
                        private String FOPOneType;
                        private CCInfo1 CCInfo3;
                        private String FOPTwoType;
                        private String taxesTaxAmount;
                        private String taxesTaxTaxCode;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @return value
                         */
                        public String getFare() {
                            return fare;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @param fare
                         */
                        public void setFare(String fare) {
                            this.fare = fare;
                        }

                        /** 
                         * Get the 'CC_Info' element value. First form of payment
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo2() {
                            return CCInfo2;
                        }

                        /** 
                         * Set the 'CC_Info' element value. First form of payment
                         * 
                         * @param CCInfo2
                         */
                        public void setCCInfo2(CCInfo CCInfo2) {
                            this.CCInfo2 = CCInfo2;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPOneType() {
                            return FOPOneType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPOneType
                         */
                        public void setFOPOneType(String FOPOneType) {
                            this.FOPOneType = FOPOneType;
                        }

                        /** 
                         * Get the 'CC_Info' element value. Second form of payment
                         * 
                         * @return value
                         */
                        public CCInfo1 getCCInfo3() {
                            return CCInfo3;
                        }

                        /** 
                         * Set the 'CC_Info' element value. Second form of payment
                         * 
                         * @param CCInfo3
                         */
                        public void setCCInfo3(CCInfo1 CCInfo3) {
                            this.CCInfo3 = CCInfo3;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPTwoType() {
                            return FOPTwoType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPTwoType
                         */
                        public void setFOPTwoType(String FOPTwoType) {
                            this.FOPTwoType = FOPTwoType;
                        }

                        /** 
                         * Get the 'Amount' attribute value. Tax amount
                         * 
                         * @return value
                         */
                        public String getTaxesTaxAmount() {
                            return taxesTaxAmount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Tax amount
                         * 
                         * @param taxesTaxAmount
                         */
                        public void setTaxesTaxAmount(String taxesTaxAmount) {
                            this.taxesTaxAmount = taxesTaxAmount;
                        }

                        /** 
                         * Get the 'TaxCode' attribute value. Tax code
                         * 
                         * @return value
                         */
                        public String getTaxesTaxTaxCode() {
                            return taxesTaxTaxCode;
                        }

                        /** 
                         * Set the 'TaxCode' attribute value. Tax code
                         * 
                         * @param taxesTaxTaxCode
                         */
                        public void setTaxesTaxTaxCode(String taxesTaxTaxCode) {
                            this.taxesTaxTaxCode = taxesTaxTaxCode;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="CardSecurityCode"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private String paymentCardCardSecurityCode;
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;

                            /** 
                             * Get the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCardSecurityCode() {
                                return paymentCardCardSecurityCode;
                            }

                            /** 
                             * Set the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @param paymentCardCardSecurityCode
                             */
                            public void setPaymentCardCardSecurityCode(
                                    String paymentCardCardSecurityCode) {
                                this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                            }

                            /** 
                             * Get the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" name="CardSecurityCode"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                         *           &lt;xs:attribute type="xs:integer" name="ExtendedPayment"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo1 implements Serializable
                        {
                            private String paymentCardCardSecurityCode;
                            private String paymentCardCode;
                            private String paymentCardExpireDate;
                            private BigInteger paymentCardExtendedPayment;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;

                            /** 
                             * Get the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCardSecurityCode() {
                                return paymentCardCardSecurityCode;
                            }

                            /** 
                             * Set the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                             * 
                             * @param paymentCardCardSecurityCode
                             */
                            public void setPaymentCardCardSecurityCode(
                                    String paymentCardCardSecurityCode) {
                                this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                            }

                            /** 
                             * Get the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @return value
                             */
                            public String getPaymentCardExpireDate() {
                                return paymentCardExpireDate;
                            }

                            /** 
                             * Set the 'ExpireDate' attribute value. Used to specify the credit card expiration date
                             * 
                             * @param paymentCardExpireDate
                             */
                            public void setPaymentCardExpireDate(
                                    String paymentCardExpireDate) {
                                this.paymentCardExpireDate = paymentCardExpireDate;
                            }

                            /** 
                             * Get the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardExtendedPayment() {
                                return paymentCardExtendedPayment;
                            }

                            /** 
                             * Set the 'ExtendedPayment' attribute value. Used to specify extended payment if applicable
                             * 
                             * @param paymentCardExtendedPayment
                             */
                            public void setPaymentCardExtendedPayment(
                                    BigInteger paymentCardExtendedPayment) {
                                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }
                        }
                    }
                    /** 
                     * MultipleFOP cannot combine with .../EnhancedMultipleFOP
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Fare">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_One">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FOP_Two">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element name="CC_Info" minOccurs="0">
                     *               &lt;!-- Reference to inner class CCInfo1 -->
                     *             &lt;/xs:element>
                     *           &lt;/xs:sequence>
                     *           &lt;xs:attribute type="xs:string" name="Type"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Taxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class Taxes -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MultipleFOP implements Serializable
                    {
                        private String fare;
                        private CCInfo CCInfo2;
                        private String FOPOneType;
                        private CCInfo1 CCInfo3;
                        private String FOPTwoType;
                        private Taxes taxes;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @return value
                         */
                        public String getFare() {
                            return fare;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount to be applied to the second FOP
                         * 
                         * @param fare
                         */
                        public void setFare(String fare) {
                            this.fare = fare;
                        }

                        /** 
                         * Get the 'CC_Info' element value. First form of payment
                         * 
                         * @return value
                         */
                        public CCInfo getCCInfo2() {
                            return CCInfo2;
                        }

                        /** 
                         * Set the 'CC_Info' element value. First form of payment
                         * 
                         * @param CCInfo2
                         */
                        public void setCCInfo2(CCInfo CCInfo2) {
                            this.CCInfo2 = CCInfo2;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPOneType() {
                            return FOPOneType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPOneType
                         */
                        public void setFOPOneType(String FOPOneType) {
                            this.FOPOneType = FOPOneType;
                        }

                        /** 
                         * Get the 'CC_Info' element value. Second form of payment
                         * 
                         * @return value
                         */
                        public CCInfo1 getCCInfo3() {
                            return CCInfo3;
                        }

                        /** 
                         * Set the 'CC_Info' element value. Second form of payment
                         * 
                         * @param CCInfo3
                         */
                        public void setCCInfo3(CCInfo1 CCInfo3) {
                            this.CCInfo3 = CCInfo3;
                        }

                        /** 
                         * Get the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @return value
                         */
                        public String getFOPTwoType() {
                            return FOPTwoType;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node
                         * 
                         * @param FOPTwoType
                         */
                        public void setFOPTwoType(String FOPTwoType) {
                            this.FOPTwoType = FOPTwoType;
                        }

                        /** 
                         * Get the 'Taxes' element value.
                         * 
                         * @return value
                         */
                        public Taxes getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(Taxes taxes) {
                            this.taxes = taxes;
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;

                            /** 
                             * Get the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }
                        }
                        /** 
                         * Used to pass credit card information
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                         *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CCInfo1 implements Serializable
                        {
                            private String paymentCardCode;
                            private String paymentCardManualApprovalCode;
                            private BigInteger paymentCardNumber;

                            /** 
                             * Get the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @return value
                             */
                            public String getPaymentCardCode() {
                                return paymentCardCode;
                            }

                            /** 
                             * Set the 'Code' attribute value. Used to specify the credit card vendor code
                             * 
                             * @param paymentCardCode
                             */
                            public void setPaymentCardCode(
                                    String paymentCardCode) {
                                this.paymentCardCode = paymentCardCode;
                            }

                            /** 
                             * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @return value
                             */
                            public String getPaymentCardManualApprovalCode() {
                                return paymentCardManualApprovalCode;
                            }

                            /** 
                             * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                             * 
                             * @param paymentCardManualApprovalCode
                             */
                            public void setPaymentCardManualApprovalCode(
                                    String paymentCardManualApprovalCode) {
                                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @return value
                             */
                            public BigInteger getPaymentCardNumber() {
                                return paymentCardNumber;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify the credit card number
                             * 
                             * @param paymentCardNumber
                             */
                            public void setPaymentCardNumber(
                                    BigInteger paymentCardNumber) {
                                this.paymentCardNumber = paymentCardNumber;
                            }
                        }
                        /** 
                         * Used to specify the tax amount
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax">
                         *         &lt;xs:complexType>
                         *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *           &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *         &lt;/xs:complexType>
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Taxes implements Serializable
                        {
                            private String taxAmount;
                            private String taxTaxCode;

                            /** 
                             * Get the 'Amount' attribute value. Tax amount
                             * 
                             * @return value
                             */
                            public String getTaxAmount() {
                                return taxAmount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. Tax amount
                             * 
                             * @param taxAmount
                             */
                            public void setTaxAmount(String taxAmount) {
                                this.taxAmount = taxAmount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value. Tax code
                             * 
                             * @return value
                             */
                            public String getTaxTaxCode() {
                                return taxTaxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value. Tax code
                             * 
                             * @param taxTaxCode
                             */
                            public void setTaxTaxCode(String taxTaxCode) {
                                this.taxTaxCode = taxTaxCode;
                            }
                        }
                    }
                }
            }
            /** 
             * Used to define miscellaneous variables
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AirExtras" minOccurs="0">
             *         &lt;!-- Reference to inner class AirExtras -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class BaggageAllowance -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Customer" minOccurs="0">
             *         &lt;!-- Reference to inner class Customer -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Endorsements" minOccurs="0">
             *         &lt;!-- Reference to inner class Endorsements -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="HemisphereCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="JourneyCode" minOccurs="0"/>
             *       &lt;xs:element name="MultiTicket" minOccurs="0">
             *         &lt;!-- Reference to inner class MultiTicket -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TourCode" minOccurs="0">
             *         &lt;!-- Reference to inner class TourCode -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ValidationMethod" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiscQualifiers implements Serializable
            {
                private AirExtras airExtras;
                private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();
                private Commission commission;
                private Customer customer;
                private Endorsements endorsements;
                private String hemisphereCode;
                private String journeyCode;
                private MultiTicket multiTicket;
                private TourCode tourCode;
                private String validationMethod;

                /** 
                 * Get the 'AirExtras' element value.
                 * 
                 * @return value
                 */
                public AirExtras getAirExtras() {
                    return airExtras;
                }

                /** 
                 * Set the 'AirExtras' element value.
                 * 
                 * @param airExtras
                 */
                public void setAirExtras(AirExtras airExtras) {
                    this.airExtras = airExtras;
                }

                /** 
                 * Get the list of 'BaggageAllowance' element items.
                 * 
                 * @return list
                 */
                public List<BaggageAllowance> getBaggageAllowanceList() {
                    return baggageAllowanceList;
                }

                /** 
                 * Set the list of 'BaggageAllowance' element items.
                 * 
                 * @param list
                 */
                public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                    baggageAllowanceList = list;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'Customer' element value.
                 * 
                 * @return value
                 */
                public Customer getCustomer() {
                    return customer;
                }

                /** 
                 * Set the 'Customer' element value.
                 * 
                 * @param customer
                 */
                public void setCustomer(Customer customer) {
                    this.customer = customer;
                }

                /** 
                 * Get the 'Endorsements' element value.
                 * 
                 * @return value
                 */
                public Endorsements getEndorsements() {
                    return endorsements;
                }

                /** 
                 * Set the 'Endorsements' element value.
                 * 
                 * @param endorsements
                 */
                public void setEndorsements(Endorsements endorsements) {
                    this.endorsements = endorsements;
                }

                /** 
                 * Get the 'HemisphereCode' element value. Hemisphere code
                 * 
                 * @return value
                 */
                public String getHemisphereCode() {
                    return hemisphereCode;
                }

                /** 
                 * Set the 'HemisphereCode' element value. Hemisphere code
                 * 
                 * @param hemisphereCode
                 */
                public void setHemisphereCode(String hemisphereCode) {
                    this.hemisphereCode = hemisphereCode;
                }

                /** 
                 * Get the 'JourneyCode' element value. Journey code
                 * 
                 * @return value
                 */
                public String getJourneyCode() {
                    return journeyCode;
                }

                /** 
                 * Set the 'JourneyCode' element value. Journey code
                 * 
                 * @param journeyCode
                 */
                public void setJourneyCode(String journeyCode) {
                    this.journeyCode = journeyCode;
                }

                /** 
                 * Get the 'MultiTicket' element value.
                 * 
                 * @return value
                 */
                public MultiTicket getMultiTicket() {
                    return multiTicket;
                }

                /** 
                 * Set the 'MultiTicket' element value.
                 * 
                 * @param multiTicket
                 */
                public void setMultiTicket(MultiTicket multiTicket) {
                    this.multiTicket = multiTicket;
                }

                /** 
                 * Get the 'TourCode' element value.
                 * 
                 * @return value
                 */
                public TourCode getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' element value.
                 * 
                 * @param tourCode
                 */
                public void setTourCode(TourCode tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'ValidationMethod' element value. Used to specify a validation method
                 * 
                 * @return value
                 */
                public String getValidationMethod() {
                    return validationMethod;
                }

                /** 
                 * Set the 'ValidationMethod' element value. Used to specify a validation method
                 * 
                 * @param validationMethod
                 */
                public void setValidationMethod(String validationMethod) {
                    this.validationMethod = validationMethod;
                }
                /** 
                 * utilized to display air extra-related content, i.e. optional services, ancillary services, etc
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirExtras" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class CustLoyalty -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="xs:string" name="SSR_Code" minOccurs="0" maxOccurs="26"/>
                 *       &lt;xs:element name="Ticketing" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Ticketing -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Summary"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AirExtras implements Serializable
                {
                    private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
                    private List<String> qualifierList = new ArrayList<String>();
                    private List<String> SSRCodeList = new ArrayList<String>();
                    private List<Ticketing> ticketingList = new ArrayList<Ticketing>();
                    private boolean ind;
                    private Boolean summary;

                    /** 
                     * Get the list of 'CustLoyalty' element items.
                     * 
                     * @return list
                     */
                    public List<CustLoyalty> getCustLoyaltyList() {
                        return custLoyaltyList;
                    }

                    /** 
                     * Set the list of 'CustLoyalty' element items.
                     * 
                     * @param list
                     */
                    public void setCustLoyaltyList(List<CustLoyalty> list) {
                        custLoyaltyList = list;
                    }

                    /** 
                     * Get the list of 'Qualifier' element items. Used to specify a particular air extra to be included
                     * 
                     * @return list
                     */
                    public List<String> getQualifierList() {
                        return qualifierList;
                    }

                    /** 
                     * Set the list of 'Qualifier' element items. Used to specify a particular air extra to be included
                     * 
                     * @param list
                     */
                    public void setQualifierList(List<String> list) {
                        qualifierList = list;
                    }

                    /** 
                     * Get the list of 'SSR_Code' element items.
                     * 
                     * @return list
                     */
                    public List<String> getSSRCodeList() {
                        return SSRCodeList;
                    }

                    /** 
                     * Set the list of 'SSR_Code' element items.
                     * 
                     * @param list
                     */
                    public void setSSRCodeList(List<String> list) {
                        SSRCodeList = list;
                    }

                    /** 
                     * Get the list of 'Ticketing' element items.
                     * 
                     * @return list
                     */
                    public List<Ticketing> getTicketingList() {
                        return ticketingList;
                    }

                    /** 
                     * Set the list of 'Ticketing' element items.
                     * 
                     * @param list
                     */
                    public void setTicketingList(List<Ticketing> list) {
                        ticketingList = list;
                    }

                    /** 
                     * Get the 'Ind' attribute value. Used to specify for the system to include air extras
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Used to specify for the system to include air extras
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }

                    /** 
                     * Get the 'Summary' attribute value. This attribute is not in use
                     * 
                     * @return value
                     */
                    public Boolean getSummary() {
                        return summary;
                    }

                    /** 
                     * Set the 'Summary' attribute value. This attribute is not in use
                     * 
                     * @param summary
                     */
                    public void setSummary(Boolean summary) {
                        this.summary = summary;
                    }
                    /** 
                     * Used to pass frequent flyer information
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="ProgramID"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="TierLevel"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CustLoyalty implements Serializable
                    {
                        private String programID;
                        private String tierLevel;

                        /** 
                         * Get the 'ProgramID' attribute value. Program ID
                         * 
                         * @return value
                         */
                        public String getProgramID() {
                            return programID;
                        }

                        /** 
                         * Set the 'ProgramID' attribute value. Program ID
                         * 
                         * @param programID
                         */
                        public void setProgramID(String programID) {
                            this.programID = programID;
                        }

                        /** 
                         * Get the 'TierLevel' attribute value. Tier Level
                         * 
                         * @return value
                         */
                        public String getTierLevel() {
                            return tierLevel;
                        }

                        /** 
                         * Set the 'TierLevel' attribute value. Tier Level
                         * 
                         * @param tierLevel
                         */
                        public void setTierLevel(String tierLevel) {
                            this.tierLevel = tierLevel;
                        }
                    }
                    /** 
                     * Used to specify an eTicket number to view air extra-related information for
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" name="EndNumber"/>
                     *     &lt;xs:attribute type="xs:integer" name="eTicketNumber"/>
                     *     &lt;xs:attribute type="xs:integer" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Ticketing implements Serializable
                    {
                        private BigInteger endNumber;
                        private BigInteger ETicketNumber;
                        private BigInteger number;

                        /** 
                         * Get the 'EndNumber' attribute value. Used to specify an end of range line number in the PNR's ticketing field to view air extra-related information for
                         * 
                         * @return value
                         */
                        public BigInteger getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value. Used to specify an end of range line number in the PNR's ticketing field to view air extra-related information for
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(BigInteger endNumber) {
                            this.endNumber = endNumber;
                        }

                        /** 
                         * Get the 'eTicketNumber' attribute value. Used to specify an eTicket number to view air extra-related information for
                         * 
                         * @return value
                         */
                        public BigInteger getETicketNumber() {
                            return ETicketNumber;
                        }

                        /** 
                         * Set the 'eTicketNumber' attribute value. Used to specify an eTicket number to view air extra-related information for
                         * 
                         * @param eTicketNumber
                         */
                        public void setETicketNumber(BigInteger eTicketNumber) {
                            ETicketNumber = eTicketNumber;
                        }

                        /** 
                         * Get the 'Number' attribute value. Used to specify a particular line from the PNR's ticketing field to view air extra-related information for.
                         * 
                         * @return value
                         */
                        public BigInteger getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Used to specify a particular line from the PNR's ticketing field to view air extra-related information for.
                         * 
                         * @param number
                         */
                        public void setNumber(BigInteger number) {
                            this.number = number;
                        }
                    }
                }
                /** 
                 * Used to define baggage allowance details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Segment" minOccurs="0">
                 *         &lt;!-- Reference to inner class Segment -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" name="Weight"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaggageAllowance implements Serializable
                {
                    private Segment segment;
                    private String number;
                    private String weight;

                    /** 
                     * Get the 'Segment' element value.
                     * 
                     * @return value
                     */
                    public Segment getSegment() {
                        return segment;
                    }

                    /** 
                     * Set the 'Segment' element value.
                     * 
                     * @param segment
                     */
                    public void setSegment(Segment segment) {
                        this.segment = segment;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify the quantity of checked bags. @Number and @Weight cannot combine
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify the quantity of checked bags. @Number and @Weight cannot combine
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Weight' attribute value. Used to specify the weight in kilos of checked bags.@Number and @Weight cannot combine
                     * 
                     * @return value
                     */
                    public String getWeight() {
                        return weight;
                    }

                    /** 
                     * Set the 'Weight' attribute value. Used to specify the weight in kilos of checked bags.@Number and @Weight cannot combine
                     * 
                     * @param weight
                     */
                    public void setWeight(String weight) {
                        this.weight = weight;
                    }
                    /** 
                     * Used to specify the relevant itinerary segments
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *     &lt;xs:attribute type="xs:string" name="EndNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Segment implements Serializable
                    {
                        private String number;
                        private String endNumber;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }

                        /** 
                         * Get the 'EndNumber' attribute value. Final number in range
                         * 
                         * @return value
                         */
                        public String getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value. Final number in range
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(String endNumber) {
                            this.endNumber = endNumber;
                        }
                    }
                }
                /** 
                 * Details of the commission being claimed
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private String amount;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value. Used to specify the numeric amount of commission being claimed if applicable.Amount and Percent are mutually exclusive
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Used to specify the numeric amount of commission being claimed if applicable.Amount and Percent are mutually exclusive
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percent' attribute value. Used to specify the percentage of commission being claimed if applicable. Amount and Percent are mutually exclusive
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value. Used to specify the percentage of commission being claimed if applicable. Amount and Percent are mutually exclusive
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Used to specify the DK customer number
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Customer implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value. DK number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. DK number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Used to specify miscellaneous text in the endorsements field
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="Override"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Endorsements implements Serializable
                {
                    private String text;
                    private Boolean override;

                    /** 
                     * Get the 'Text' element value. Used to specify miscellaneous text in the endorsements field
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. Used to specify miscellaneous text in the endorsements field
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'Override' attribute value. Override any endorsement
                     * 
                     * @return value
                     */
                    public Boolean getOverride() {
                        return override;
                    }

                    /** 
                     * Set the 'Override' attribute value. Override any endorsement
                     * 
                     * @param override
                     */
                    public void setOverride(Boolean override) {
                        this.override = override;
                    }
                }
                /** 
                 * Used to instruct the system to consider multi-ticket solutions to find the lowest possible price
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiTicket" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultiTicket implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. Used to instruct the system to consider multi-ticket solutions to find the lowest possible price
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Used to instruct the system to consider multi-ticket solutions to find the lowest possible price
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Tour code details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="SuppressFareReplaceWithBT" minOccurs="0">
                 *         &lt;!-- Reference to inner class SuppressFareReplaceWithBT -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SuppressFareReplaceWithIT" minOccurs="0">
                 *         &lt;!-- Reference to inner class SuppressFareReplaceWithIT -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SuppressIT" minOccurs="0">
                 *         &lt;!-- Reference to inner class SuppressIT -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SuppressITSupressFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class SuppressITSupressFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TourCode implements Serializable
                {
                    private SuppressFareReplaceWithBT suppressFareReplaceWithBT;
                    private SuppressFareReplaceWithIT suppressFareReplaceWithIT;
                    private SuppressIT suppressIT;
                    private SuppressITSupressFare suppressITSupressFare;
                    private String text;

                    /** 
                     * Get the 'SuppressFareReplaceWithBT' element value.
                     * 
                     * @return value
                     */
                    public SuppressFareReplaceWithBT getSuppressFareReplaceWithBT() {
                        return suppressFareReplaceWithBT;
                    }

                    /** 
                     * Set the 'SuppressFareReplaceWithBT' element value.
                     * 
                     * @param suppressFareReplaceWithBT
                     */
                    public void setSuppressFareReplaceWithBT(
                            SuppressFareReplaceWithBT suppressFareReplaceWithBT) {
                        this.suppressFareReplaceWithBT = suppressFareReplaceWithBT;
                    }

                    /** 
                     * Get the 'SuppressFareReplaceWithIT' element value.
                     * 
                     * @return value
                     */
                    public SuppressFareReplaceWithIT getSuppressFareReplaceWithIT() {
                        return suppressFareReplaceWithIT;
                    }

                    /** 
                     * Set the 'SuppressFareReplaceWithIT' element value.
                     * 
                     * @param suppressFareReplaceWithIT
                     */
                    public void setSuppressFareReplaceWithIT(
                            SuppressFareReplaceWithIT suppressFareReplaceWithIT) {
                        this.suppressFareReplaceWithIT = suppressFareReplaceWithIT;
                    }

                    /** 
                     * Get the 'SuppressIT' element value.
                     * 
                     * @return value
                     */
                    public SuppressIT getSuppressIT() {
                        return suppressIT;
                    }

                    /** 
                     * Set the 'SuppressIT' element value.
                     * 
                     * @param suppressIT
                     */
                    public void setSuppressIT(SuppressIT suppressIT) {
                        this.suppressIT = suppressIT;
                    }

                    /** 
                     * Get the 'SuppressITSupressFare' element value.
                     * 
                     * @return value
                     */
                    public SuppressITSupressFare getSuppressITSupressFare() {
                        return suppressITSupressFare;
                    }

                    /** 
                     * Set the 'SuppressITSupressFare' element value.
                     * 
                     * @param suppressITSupressFare
                     */
                    public void setSuppressITSupressFare(
                            SuppressITSupressFare suppressITSupressFare) {
                        this.suppressITSupressFare = suppressITSupressFare;
                    }

                    /** 
                     * Get the 'Text' element value. Used to specify tour code
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. Used to specify tour code
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                    /** 
                     * Used to specify to suppress the fare amount on the ticket and replace with BT
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithBT" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SuppressFareReplaceWithBT implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to specify to suppress the fare amount on the ticket and replace with BT
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to specify to suppress the fare amount on the ticket and replace with BT
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to specify to suppress the fare amount on the ticket and replace with IT
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithIT" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SuppressFareReplaceWithIT implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to specify to suppress the fare amount on the ticket and replace with IT
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to specify to suppress the fare amount on the ticket and replace with IT
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to specify to to suppress the IT in the tourcode box from printing
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressIT" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SuppressIT implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to specify to to suppress the IT in the tourcode box from printing
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to specify to to suppress the IT in the tourcode box from printing
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to specify to specify to suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressITSupressFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SuppressITSupressFare implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to specify to specify to suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to specify to specify to suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                }
            }
            /** 
             * All the price specific variables
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Account" minOccurs="0">
             *         &lt;!-- Reference to inner class Account -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AlternativePricing" minOccurs="0">
             *         &lt;!-- Reference to inner class AlternativePricing -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="BankersSellingRate" minOccurs="0"/>
             *       &lt;xs:element name="BargainFinder" minOccurs="0">
             *         &lt;!-- Reference to inner class BargainFinder -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="BasicEconomyExclude" minOccurs="0" maxOccurs="5"/>
             *       &lt;xs:element name="Brand" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Brand -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="BuyingDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0"/>
             *       &lt;xs:element name="CommandPricing" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class CommandPricing -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="CommissionContract" minOccurs="0" maxOccurs="4"/>
             *       &lt;xs:element name="Corporate" minOccurs="0">
             *         &lt;!-- Reference to inner class Corporate -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Fare" minOccurs="0">
             *         &lt;!-- Reference to inner class Fare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareOptions" minOccurs="0">
             *         &lt;!-- Reference to inner class FareOptions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
             *         &lt;!-- Reference to inner class ItineraryOptions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ManuallyAdjustedSellingLevel" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ManuallyAdjustedSellingLevel -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class NameSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NetRemit" minOccurs="0">
             *         &lt;!-- Reference to inner class NetRemit -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Overrides" minOccurs="0">
             *         &lt;!-- Reference to inner class Overrides -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="PassengerStatus" minOccurs="0"/>
             *       &lt;xs:element name="PassengerType" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PassengerType -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PlusUp" minOccurs="0">
             *         &lt;!-- Reference to inner class PlusUp -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RetailerRuleQualifier" minOccurs="0">
             *         &lt;!-- Reference to inner class RetailerRuleQualifier -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ShipsRegistry" minOccurs="0"/>
             *       &lt;xs:element name="SpanishLargeFamilyDiscountLevel" minOccurs="0">
             *         &lt;xs:simpleType>
             *           &lt;!-- Reference to inner class SpanishLargeFamilyDiscountLevel -->
             *         &lt;/xs:simpleType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="SpanishResidentDiscount" minOccurs="0"/>
             *       &lt;xs:element name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SpecificFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
             *         &lt;!-- Reference to inner class SpecificPenalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ValidityDates -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="AlternateCurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:boolean" name="AggregatedContentExclude"/>
             *     &lt;xs:attribute type="xs:boolean" name="FareFocusExclude"/>
             *     &lt;xs:attribute type="xs:boolean" name="NoDate"/>
             *     &lt;xs:attribute type="xs:boolean" name="RoundTheWorld"/>
             *     &lt;xs:attribute type="xs:string" name="Source"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PricingQualifiers implements Serializable
            {
                private Account account;
                private AlternativePricing alternativePricing;
                private String bankersSellingRate;
                private BargainFinder bargainFinder;
                private List<String> basicEconomyExcludeList = new ArrayList<String>();
                private List<Brand> brandList = new ArrayList<Brand>();
                private String buyingDate;
                private String cabin;
                private List<CommandPricing> commandPricingList = new ArrayList<CommandPricing>();
                private List<String> commissionContractList = new ArrayList<String>();
                private Corporate corporate;
                private Fare fare;
                private FareOptions fareOptions;
                private ItineraryOptions itineraryOptions;
                private List<ManuallyAdjustedSellingLevel> manuallyAdjustedSellingLevelList = new ArrayList<ManuallyAdjustedSellingLevel>();
                private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
                private NetRemit netRemit;
                private Overrides overrides;
                private String passengerStatus;
                private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();
                private PlusUp plusUp;
                private RetailerRuleQualifier retailerRuleQualifier;
                private String shipsRegistry;
                private SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel;
                private String spanishResidentDiscount;
                private List<SpecificFare> specificFareList = new ArrayList<SpecificFare>();
                private SpecificPenalty specificPenalty;
                private Taxes taxes;
                private List<ValidityDates> validityDateList = new ArrayList<ValidityDates>();
                private String alternateCurrencyCode;
                private String currencyCode;
                private Boolean aggregatedContentExclude;
                private Boolean fareFocusExclude;
                private Boolean noDate;
                private Boolean roundTheWorld;
                private String source;

                /** 
                 * Get the 'Account' element value.
                 * 
                 * @return value
                 */
                public Account getAccount() {
                    return account;
                }

                /** 
                 * Set the 'Account' element value.
                 * 
                 * @param account
                 */
                public void setAccount(Account account) {
                    this.account = account;
                }

                /** 
                 * Get the 'AlternativePricing' element value.
                 * 
                 * @return value
                 */
                public AlternativePricing getAlternativePricing() {
                    return alternativePricing;
                }

                /** 
                 * Set the 'AlternativePricing' element value.
                 * 
                 * @param alternativePricing
                 */
                public void setAlternativePricing(
                        AlternativePricing alternativePricing) {
                    this.alternativePricing = alternativePricing;
                }

                /** 
                 * Get the 'BankersSellingRate' element value. Used to instruct the system to price an itinerary according to a specified banker's selling rate.
                 * 
                 * @return value
                 */
                public String getBankersSellingRate() {
                    return bankersSellingRate;
                }

                /** 
                 * Set the 'BankersSellingRate' element value. Used to instruct the system to price an itinerary according to a specified banker's selling rate.
                 * 
                 * @param bankersSellingRate
                 */
                public void setBankersSellingRate(String bankersSellingRate) {
                    this.bankersSellingRate = bankersSellingRate;
                }

                /** 
                 * Get the 'BargainFinder' element value.
                 * 
                 * @return value
                 */
                public BargainFinder getBargainFinder() {
                    return bargainFinder;
                }

                /** 
                 * Set the 'BargainFinder' element value.
                 * 
                 * @param bargainFinder
                 */
                public void setBargainFinder(BargainFinder bargainFinder) {
                    this.bargainFinder = bargainFinder;
                }

                /** 
                 * Get the list of 'BasicEconomyExclude' element items. Ued to exclude Basic Economy Fares (up to 5 booking classes can be selected). Please note that this element is only applicable to airline customers. "BasicEconomyExclude" can only be used with .../BargainFinder 
                 * 
                 * @return list
                 */
                public List<String> getBasicEconomyExcludeList() {
                    return basicEconomyExcludeList;
                }

                /** 
                 * Set the list of 'BasicEconomyExclude' element items. Ued to exclude Basic Economy Fares (up to 5 booking classes can be selected). Please note that this element is only applicable to airline customers. "BasicEconomyExclude" can only be used with .../BargainFinder 
                 * 
                 * @param list
                 */
                public void setBasicEconomyExcludeList(List<String> list) {
                    basicEconomyExcludeList = list;
                }

                /** 
                 * Get the list of 'Brand' element items.
                 * 
                 * @return list
                 */
                public List<Brand> getBrandList() {
                    return brandList;
                }

                /** 
                 * Set the list of 'Brand' element items.
                 * 
                 * @param list
                 */
                public void setBrandList(List<Brand> list) {
                    brandList = list;
                }

                /** 
                 * Get the 'BuyingDate' element value. Used to instruct the system to specify the purchase date for the fare. "BuyingDate" follows this format: YYYY-MM-DD
                 * 
                 * @return value
                 */
                public String getBuyingDate() {
                    return buyingDate;
                }

                /** 
                 * Set the 'BuyingDate' element value. Used to instruct the system to specify the purchase date for the fare. "BuyingDate" follows this format: YYYY-MM-DD
                 * 
                 * @param buyingDate
                 */
                public void setBuyingDate(String buyingDate) {
                    this.buyingDate = buyingDate;
                }

                /** 
                 * Get the 'Cabin' element value. Used to instruct the system to specify fares by a specific cabin or the lowest fare across all cabins. Please note that Cabin may only be used together with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder or .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/AlternativePricing/Overrides/NoMatch
                 * 
                 * @return value
                 */
                public String getCabin() {
                    return cabin;
                }

                /** 
                 * Set the 'Cabin' element value. Used to instruct the system to specify fares by a specific cabin or the lowest fare across all cabins. Please note that Cabin may only be used together with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder or .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/AlternativePricing/Overrides/NoMatch
                 * 
                 * @param cabin
                 */
                public void setCabin(String cabin) {
                    this.cabin = cabin;
                }

                /** 
                 * Get the list of 'CommandPricing' element items.
                 * 
                 * @return list
                 */
                public List<CommandPricing> getCommandPricingList() {
                    return commandPricingList;
                }

                /** 
                 * Set the list of 'CommandPricing' element items.
                 * 
                 * @param list
                 */
                public void setCommandPricingList(List<CommandPricing> list) {
                    commandPricingList = list;
                }

                /** 
                 * Get the list of 'CommissionContract' element items. Used to select specific contracts to process at a time of pricing
                 * 
                 * @return list
                 */
                public List<String> getCommissionContractList() {
                    return commissionContractList;
                }

                /** 
                 * Set the list of 'CommissionContract' element items. Used to select specific contracts to process at a time of pricing
                 * 
                 * @param list
                 */
                public void setCommissionContractList(List<String> list) {
                    commissionContractList = list;
                }

                /** 
                 * Get the 'Corporate' element value.
                 * 
                 * @return value
                 */
                public Corporate getCorporate() {
                    return corporate;
                }

                /** 
                 * Set the 'Corporate' element value.
                 * 
                 * @param corporate
                 */
                public void setCorporate(Corporate corporate) {
                    this.corporate = corporate;
                }

                /** 
                 * Get the 'Fare' element value.
                 * 
                 * @return value
                 */
                public Fare getFare() {
                    return fare;
                }

                /** 
                 * Set the 'Fare' element value.
                 * 
                 * @param fare
                 */
                public void setFare(Fare fare) {
                    this.fare = fare;
                }

                /** 
                 * Get the 'FareOptions' element value.
                 * 
                 * @return value
                 */
                public FareOptions getFareOptions() {
                    return fareOptions;
                }

                /** 
                 * Set the 'FareOptions' element value.
                 * 
                 * @param fareOptions
                 */
                public void setFareOptions(FareOptions fareOptions) {
                    this.fareOptions = fareOptions;
                }

                /** 
                 * Get the 'ItineraryOptions' element value.
                 * 
                 * @return value
                 */
                public ItineraryOptions getItineraryOptions() {
                    return itineraryOptions;
                }

                /** 
                 * Set the 'ItineraryOptions' element value.
                 * 
                 * @param itineraryOptions
                 */
                public void setItineraryOptions(
                        ItineraryOptions itineraryOptions) {
                    this.itineraryOptions = itineraryOptions;
                }

                /** 
                 * Get the list of 'ManuallyAdjustedSellingLevel' element items.
                 * 
                 * @return list
                 */
                public List<ManuallyAdjustedSellingLevel> getManuallyAdjustedSellingLevelList() {
                    return manuallyAdjustedSellingLevelList;
                }

                /** 
                 * Set the list of 'ManuallyAdjustedSellingLevel' element items.
                 * 
                 * @param list
                 */
                public void setManuallyAdjustedSellingLevelList(
                        List<ManuallyAdjustedSellingLevel> list) {
                    manuallyAdjustedSellingLevelList = list;
                }

                /** 
                 * Get the list of 'NameSelect' element items.
                 * 
                 * @return list
                 */
                public List<NameSelect> getNameSelectList() {
                    return nameSelectList;
                }

                /** 
                 * Set the list of 'NameSelect' element items.
                 * 
                 * @param list
                 */
                public void setNameSelectList(List<NameSelect> list) {
                    nameSelectList = list;
                }

                /** 
                 * Get the 'NetRemit' element value.
                 * 
                 * @return value
                 */
                public NetRemit getNetRemit() {
                    return netRemit;
                }

                /** 
                 * Set the 'NetRemit' element value.
                 * 
                 * @param netRemit
                 */
                public void setNetRemit(NetRemit netRemit) {
                    this.netRemit = netRemit;
                }

                /** 
                 * Get the 'Overrides' element value.
                 * 
                 * @return value
                 */
                public Overrides getOverrides() {
                    return overrides;
                }

                /** 
                 * Set the 'Overrides' element value.
                 * 
                 * @param overrides
                 */
                public void setOverrides(Overrides overrides) {
                    this.overrides = overrides;
                }

                /** 
                 * Get the 'PassengerStatus' element value. Used to is used to instruct the system to price the itinerary with a specified passenger status code. Equivalent Sabre host command: WPEM/(country or state code), WPRY/(country or state code), WPNT/(country or state code)
                 * 
                 * @return value
                 */
                public String getPassengerStatus() {
                    return passengerStatus;
                }

                /** 
                 * Set the 'PassengerStatus' element value. Used to is used to instruct the system to price the itinerary with a specified passenger status code. Equivalent Sabre host command: WPEM/(country or state code), WPRY/(country or state code), WPNT/(country or state code)
                 * 
                 * @param passengerStatus
                 */
                public void setPassengerStatus(String passengerStatus) {
                    this.passengerStatus = passengerStatus;
                }

                /** 
                 * Get the list of 'PassengerType' element items.
                 * 
                 * @return list
                 */
                public List<PassengerType> getPassengerTypeList() {
                    return passengerTypeList;
                }

                /** 
                 * Set the list of 'PassengerType' element items.
                 * 
                 * @param list
                 */
                public void setPassengerTypeList(List<PassengerType> list) {
                    passengerTypeList = list;
                }

                /** 
                 * Get the 'PlusUp' element value.
                 * 
                 * @return value
                 */
                public PlusUp getPlusUp() {
                    return plusUp;
                }

                /** 
                 * Set the 'PlusUp' element value.
                 * 
                 * @param plusUp
                 */
                public void setPlusUp(PlusUp plusUp) {
                    this.plusUp = plusUp;
                }

                /** 
                 * Get the 'RetailerRuleQualifier' element value.
                 * 
                 * @return value
                 */
                public RetailerRuleQualifier getRetailerRuleQualifier() {
                    return retailerRuleQualifier;
                }

                /** 
                 * Set the 'RetailerRuleQualifier' element value.
                 * 
                 * @param retailerRuleQualifier
                 */
                public void setRetailerRuleQualifier(
                        RetailerRuleQualifier retailerRuleQualifier) {
                    this.retailerRuleQualifier = retailerRuleQualifier;
                }

                /** 
                 * Get the 'ShipsRegistry' element value. Used to specify a ship's country of registration. This element is only to be used when .../PassengerType@Code="SEA"
                 * 
                 * @return value
                 */
                public String getShipsRegistry() {
                    return shipsRegistry;
                }

                /** 
                 * Set the 'ShipsRegistry' element value. Used to specify a ship's country of registration. This element is only to be used when .../PassengerType@Code="SEA"
                 * 
                 * @param shipsRegistry
                 */
                public void setShipsRegistry(String shipsRegistry) {
                    this.shipsRegistry = shipsRegistry;
                }

                /** 
                 * Get the 'SpanishLargeFamilyDiscountLevel' element value. Used to specify the Spanish large family discount level. Please note that this qualifier is only applicable to Spain-based subscribers
                 * 
                 * @return value
                 */
                public SpanishLargeFamilyDiscountLevel getSpanishLargeFamilyDiscountLevel() {
                    return spanishLargeFamilyDiscountLevel;
                }

                /** 
                 * Set the 'SpanishLargeFamilyDiscountLevel' element value. Used to specify the Spanish large family discount level. Please note that this qualifier is only applicable to Spain-based subscribers
                 * 
                 * @param spanishLargeFamilyDiscountLevel
                 */
                public void setSpanishLargeFamilyDiscountLevel(
                        SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel) {
                    this.spanishLargeFamilyDiscountLevel = spanishLargeFamilyDiscountLevel;
                }

                /** 
                 * Get the 'SpanishResidentDiscount' element value. Used to specify the Island Resident code applicable for discount.
                 * 
                 * @return value
                 */
                public String getSpanishResidentDiscount() {
                    return spanishResidentDiscount;
                }

                /** 
                 * Set the 'SpanishResidentDiscount' element value. Used to specify the Island Resident code applicable for discount.
                 * 
                 * @param spanishResidentDiscount
                 */
                public void setSpanishResidentDiscount(
                        String spanishResidentDiscount) {
                    this.spanishResidentDiscount = spanishResidentDiscount;
                }

                /** 
                 * Get the list of 'SpecificFare' element items.
                 * 
                 * @return list
                 */
                public List<SpecificFare> getSpecificFareList() {
                    return specificFareList;
                }

                /** 
                 * Set the list of 'SpecificFare' element items.
                 * 
                 * @param list
                 */
                public void setSpecificFareList(List<SpecificFare> list) {
                    specificFareList = list;
                }

                /** 
                 * Get the 'SpecificPenalty' element value.
                 * 
                 * @return value
                 */
                public SpecificPenalty getSpecificPenalty() {
                    return specificPenalty;
                }

                /** 
                 * Set the 'SpecificPenalty' element value.
                 * 
                 * @param specificPenalty
                 */
                public void setSpecificPenalty(SpecificPenalty specificPenalty) {
                    this.specificPenalty = specificPenalty;
                }

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the list of 'ValidityDates' element items.
                 * 
                 * @return list
                 */
                public List<ValidityDates> getValidityDateList() {
                    return validityDateList;
                }

                /** 
                 * Set the list of 'ValidityDates' element items.
                 * 
                 * @param list
                 */
                public void setValidityDateList(List<ValidityDates> list) {
                    validityDateList = list;
                }

                /** 
                 * Get the 'AlternateCurrencyCode' attribute value. Used to specify an alternate currency code to price with
                 * 
                 * @return value
                 */
                public String getAlternateCurrencyCode() {
                    return alternateCurrencyCode;
                }

                /** 
                 * Set the 'AlternateCurrencyCode' attribute value. Used to specify an alternate currency code to price with
                 * 
                 * @param alternateCurrencyCode
                 */
                public void setAlternateCurrencyCode(
                        String alternateCurrencyCode) {
                    this.alternateCurrencyCode = alternateCurrencyCode;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. Used to specify a currency code to price with
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. Used to specify a currency code to price with
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'AggregatedContentExclude' attribute value. Used to exclude aggregated content. Please note that it can only be combined with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder
                 * 
                 * @return value
                 */
                public Boolean getAggregatedContentExclude() {
                    return aggregatedContentExclude;
                }

                /** 
                 * Set the 'AggregatedContentExclude' attribute value. Used to exclude aggregated content. Please note that it can only be combined with .../PriceRequestInformation/OptionalQualifiers/PricingQualifiers/BargainFinder
                 * 
                 * @param aggregatedContentExclude
                 */
                public void setAggregatedContentExclude(
                        Boolean aggregatedContentExclude) {
                    this.aggregatedContentExclude = aggregatedContentExclude;
                }

                /** 
                 * Get the 'FareFocusExclude' attribute value. Used to exclude or ignore fare focus fares
                 * 
                 * @return value
                 */
                public Boolean getFareFocusExclude() {
                    return fareFocusExclude;
                }

                /** 
                 * Set the 'FareFocusExclude' attribute value. Used to exclude or ignore fare focus fares
                 * 
                 * @param fareFocusExclude
                 */
                public void setFareFocusExclude(Boolean fareFocusExclude) {
                    this.fareFocusExclude = fareFocusExclude;
                }

                /** 
                 * Get the 'NoDate' attribute value. Used to price itinerary without a date
                 * 
                 * @return value
                 */
                public Boolean getNoDate() {
                    return noDate;
                }

                /** 
                 * Set the 'NoDate' attribute value. Used to price itinerary without a date
                 * 
                 * @param noDate
                 */
                public void setNoDate(Boolean noDate) {
                    this.noDate = noDate;
                }

                /** 
                 * Get the 'RoundTheWorld' attribute value. Allows a request for a round the world/circle trip fare
                 * 
                 * @return value
                 */
                public Boolean getRoundTheWorld() {
                    return roundTheWorld;
                }

                /** 
                 * Set the 'RoundTheWorld' attribute value. Allows a request for a round the world/circle trip fare
                 * 
                 * @param roundTheWorld
                 */
                public void setRoundTheWorld(Boolean roundTheWorld) {
                    this.roundTheWorld = roundTheWorld;
                }

                /** 
                 * Get the 'Source' attribute value. Used to specify the pricing source
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'Source' attribute value. Used to specify the pricing source
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }
                /** 
                 * Used to specify an account code to price with
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Code" maxOccurs="4"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Account implements Serializable
                {
                    private List<String> codeList = new ArrayList<String>();
                    private String force;

                    /** 
                     * Get the list of 'Code' element items. Used to specify an account code to price with
                     * 
                     * @return list
                     */
                    public List<String> getCodeList() {
                        return codeList;
                    }

                    /** 
                     * Set the list of 'Code' element items. Used to specify an account code to price with
                     * 
                     * @param list
                     */
                    public void setCodeList(List<String> list) {
                        codeList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value. Used to instruct the system to force the specific account code
                     * 
                     * @return value
                     */
                    public String getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value. Used to instruct the system to force the specific account code
                     * 
                     * @param force
                     */
                    public void setForce(String force) {
                        this.force = force;
                    }
                }
                /** 
                 * Please note that the AlternativePricing node can only be used together with .../PriceRequestInformation/@AlternativePricing set to "true"
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternativePricing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Overrides" minOccurs="0">
                 *         &lt;!-- Reference to inner class Overrides -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="NoAvailCheck"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AlternativePricing implements Serializable
                {
                    private Overrides overrides;
                    private Boolean noAvailCheck;

                    /** 
                     * Get the 'Overrides' element value.
                     * 
                     * @return value
                     */
                    public Overrides getOverrides() {
                        return overrides;
                    }

                    /** 
                     * Set the 'Overrides' element value.
                     * 
                     * @param overrides
                     */
                    public void setOverrides(Overrides overrides) {
                        this.overrides = overrides;
                    }

                    /** 
                     * Get the 'NoAvailCheck' attribute value. Used to instruct the system to request alternative pricing regardless of availability
                     * 
                     * @return value
                     */
                    public Boolean getNoAvailCheck() {
                        return noAvailCheck;
                    }

                    /** 
                     * Set the 'NoAvailCheck' attribute value. Used to instruct the system to request alternative pricing regardless of availability
                     * 
                     * @param noAvailCheck
                     */
                    public void setNoAvailCheck(Boolean noAvailCheck) {
                        this.noAvailCheck = noAvailCheck;
                    }
                    /** 
                     * Overrides
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Overrides" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="MatchNoMatch" minOccurs="0">
                     *         &lt;!-- Reference to inner class MatchNoMatch -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="NoMatch" minOccurs="0">
                     *         &lt;!-- Reference to inner class NoMatch -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Overrides implements Serializable
                    {
                        private MatchNoMatch matchNoMatch;
                        private NoMatch noMatch;

                        /** 
                         * Get the 'MatchNoMatch' element value.
                         * 
                         * @return value
                         */
                        public MatchNoMatch getMatchNoMatch() {
                            return matchNoMatch;
                        }

                        /** 
                         * Set the 'MatchNoMatch' element value.
                         * 
                         * @param matchNoMatch
                         */
                        public void setMatchNoMatch(MatchNoMatch matchNoMatch) {
                            this.matchNoMatch = matchNoMatch;
                        }

                        /** 
                         * Get the 'NoMatch' element value.
                         * 
                         * @return value
                         */
                        public NoMatch getNoMatch() {
                            return noMatch;
                        }

                        /** 
                         * Set the 'NoMatch' element value.
                         * 
                         * @param noMatch
                         */
                        public void setNoMatch(NoMatch noMatch) {
                            this.noMatch = noMatch;
                        }
                        /** 
                         * Used to instruct the system to return both match and no match alternative pricing options
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchNoMatch" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MatchNoMatch implements
                            Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value. Used to instruct the system to return both match and no match alternative pricing options
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value. Used to instruct the system to return both match and no match alternative pricing options
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMatch" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class NoMatch implements Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value. Used to instruct the system to return no match alternative pricing options
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value. Used to instruct the system to return no match alternative pricing options
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                    }
                }
                /** 
                 * Used to instruct the system to search out lower fares based upon the existing itinerary segments
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BargainFinder" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="Historical"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Rebook"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BargainFinder implements Serializable
                {
                    private Boolean historical;
                    private Boolean rebook;

                    /** 
                     * Get the 'Historical' attribute value. Used to instruct the system to return the lowest fare ever offered for the particular itinerary regardless of whether or not it is currently available
                     * 
                     * @return value
                     */
                    public Boolean getHistorical() {
                        return historical;
                    }

                    /** 
                     * Set the 'Historical' attribute value. Used to instruct the system to return the lowest fare ever offered for the particular itinerary regardless of whether or not it is currently available
                     * 
                     * @param historical
                     */
                    public void setHistorical(Boolean historical) {
                        this.historical = historical;
                    }

                    /** 
                     * Get the 'Rebook' attribute value. Used to instruct the system to rebook the flights in the applicable classes of service to get the lower fare
                     * 
                     * @return value
                     */
                    public Boolean getRebook() {
                        return rebook;
                    }

                    /** 
                     * Set the 'Rebook' attribute value. Used to instruct the system to rebook the flights in the applicable classes of service to get the lower fare
                     * 
                     * @param rebook
                     */
                    public void setRebook(Boolean rebook) {
                        this.rebook = rebook;
                    }
                }
                /** 
                 * Used to specify a brand.  Please note that it's not possible to request more than 1 brand for an entire journey, or for the same segment
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Brand" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:integer" name="RPH"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Brand implements Serializable
                {
                    private String string;
                    private BigInteger RPH;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'RPH' attribute value. Used to match up with "SegmentSelect" Brand/@RPH cannot combine with .../CommandPricing/@RPH
                     * 
                     * @return value
                     */
                    public BigInteger getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. Used to match up with "SegmentSelect" Brand/@RPH cannot combine with .../CommandPricing/@RPH
                     * 
                     * @param RPH
                     */
                    public void setRPH(BigInteger RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * All of the CommandPricing entries are concerned with specifying fare basis codes, ticket designators, and discounts.  This base level command is WPQ followed by one or more of the below elements
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommandPricing" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Discount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Discount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareBasis -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CommandPricing implements Serializable
                {
                    private Discount discount;
                    private FareBasis fareBasis;
                    private String RPH;

                    /** 
                     * Get the 'Discount' element value.
                     * 
                     * @return value
                     */
                    public Discount getDiscount() {
                        return discount;
                    }

                    /** 
                     * Set the 'Discount' element value.
                     * 
                     * @param discount
                     */
                    public void setDiscount(Discount discount) {
                        this.discount = discount;
                    }

                    /** 
                     * Get the 'FareBasis' element value.
                     * 
                     * @return value
                     */
                    public FareBasis getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value.
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(FareBasis fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the 'RPH' attribute value. Used to match up with "SegmentSelect".  These formats require a "*", i.e. requires a "/", i.e. WPS1*QY/AD75
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. Used to match up with "SegmentSelect".  These formats require a "*", i.e. requires a "/", i.e. WPS1*QY/AD75
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                    /** 
                     * Used to specify discount information
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" name="AuthCode"/>
                     *     &lt;xs:attribute type="xs:string" name="Percent"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Discount implements Serializable
                    {
                        private String amount;
                        private String authCode;
                        private String percent;

                        /** 
                         * Get the 'Amount' attribute value. Amount
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Amount
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'AuthCode' attribute value. Authorization code
                         * 
                         * @return value
                         */
                        public String getAuthCode() {
                            return authCode;
                        }

                        /** 
                         * Set the 'AuthCode' attribute value. Authorization code
                         * 
                         * @param authCode
                         */
                        public void setAuthCode(String authCode) {
                            this.authCode = authCode;
                        }

                        /** 
                         * Get the 'Percent' attribute value. Percent
                         * 
                         * @return value
                         */
                        public String getPercent() {
                            return percent;
                        }

                        /** 
                         * Set the 'Percent' attribute value. Percent
                         * 
                         * @param percent
                         */
                        public void setPercent(String percent) {
                            this.percent = percent;
                        }
                    }
                    /** 
                     * Used to instruct the system to price the itinerary utilizing the fare basis code
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" name="TicketDesignator"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareBasis implements Serializable
                    {
                        private String code;
                        private String ticketDesignator;

                        /** 
                         * Get the 'Code' attribute value. Used to instruct the system to price the itinerary utilizing the fare basis code
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to instruct the system to price the itinerary utilizing the fare basis code
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'TicketDesignator' attribute value. Used to specify a ticket designator
                         * 
                         * @return value
                         */
                        public String getTicketDesignator() {
                            return ticketDesignator;
                        }

                        /** 
                         * Set the 'TicketDesignator' attribute value. Used to specify a ticket designator
                         * 
                         * @param ticketDesignator
                         */
                        public void setTicketDesignator(String ticketDesignator) {
                            this.ticketDesignator = ticketDesignator;
                        }
                    }
                }
                /** 
                 * Used to specify a corporate ID to price with
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="ID" maxOccurs="4"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Corporate implements Serializable
                {
                    private List<String> IDList = new ArrayList<String>();
                    private String force;

                    /** 
                     * Get the list of 'ID' element items. Used to specify a corporate ID to price with
                     * 
                     * @return list
                     */
                    public List<String> getIDList() {
                        return IDList;
                    }

                    /** 
                     * Set the list of 'ID' element items. Used to specify a corporate ID to price with
                     * 
                     * @param list
                     */
                    public void setIDList(List<String> list) {
                        IDList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value. Used to instruct the system to price with corporate fares only
                     * 
                     * @return value
                     */
                    public String getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value. Used to instruct the system to price with corporate fares only
                     * 
                     * @param force
                     */
                    public void setForce(String force) {
                        this.force = force;
                    }
                }
                /** 
                 * Please note that this functionality is restricted to Sabre's Asian joint venture customers.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Fare implements Serializable
                {
                    private String type;

                    /** 
                     * Get the 'Type' attribute value. Used to specify a fare type.  Acceptable values are "NL" for normal fare, "EX" for special fare, and 'IT" for inclusive tour
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify a fare type.  Acceptable values are "NL" for normal fare, "EX" for special fare, and 'IT" for inclusive tour
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
                /** 
                 * Different fare options
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOptions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="ASLBreakdown"/>
                 *     &lt;xs:attribute type="xs:boolean" name="ASLIgnore"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Excursion"/>
                 *     &lt;xs:attribute type="xs:boolean" name="HandlingFees"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Net"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Private"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Public"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareOptions implements Serializable
                {
                    private Boolean ASLBreakdown;
                    private Boolean ASLIgnore;
                    private Boolean excursion;
                    private Boolean handlingFees;
                    private Boolean net;
                    private Boolean _private;
                    private Boolean _public;

                    /** 
                     * Get the 'ASLBreakdown' attribute value. Used to display the original base fare and GST (when applicable), along with new information displaying the ASL amounts and any applicable GST
                     * 
                     * @return value
                     */
                    public Boolean getASLBreakdown() {
                        return ASLBreakdown;
                    }

                    /** 
                     * Set the 'ASLBreakdown' attribute value. Used to display the original base fare and GST (when applicable), along with new information displaying the ASL amounts and any applicable GST
                     * 
                     * @param ASLBreakdown
                     */
                    public void setASLBreakdown(Boolean ASLBreakdown) {
                        this.ASLBreakdown = ASLBreakdown;
                    }

                    /** 
                     * Get the 'ASLIgnore' attribute value. Used to instruct the system to ignore Adjusted Selling Level processing logic
                     * 
                     * @return value
                     */
                    public Boolean getASLIgnore() {
                        return ASLIgnore;
                    }

                    /** 
                     * Set the 'ASLIgnore' attribute value. Used to instruct the system to ignore Adjusted Selling Level processing logic
                     * 
                     * @param ASLIgnore
                     */
                    public void setASLIgnore(Boolean ASLIgnore) {
                        this.ASLIgnore = ASLIgnore;
                    }

                    /** 
                     * Get the 'Excursion' attribute value. Used to instruct the system to price the itinerary with an excursion fare if applicable
                     * 
                     * @return value
                     */
                    public Boolean getExcursion() {
                        return excursion;
                    }

                    /** 
                     * Set the 'Excursion' attribute value. Used to instruct the system to price the itinerary with an excursion fare if applicable
                     * 
                     * @param excursion
                     */
                    public void setExcursion(Boolean excursion) {
                        this.excursion = excursion;
                    }

                    /** 
                     * Get the 'HandlingFees' attribute value. Used to to display the original base fare and GST (when applicable), along with new information displaying all handling fees (with applicable GST) in the response
                     * 
                     * @return value
                     */
                    public Boolean getHandlingFees() {
                        return handlingFees;
                    }

                    /** 
                     * Set the 'HandlingFees' attribute value. Used to to display the original base fare and GST (when applicable), along with new information displaying all handling fees (with applicable GST) in the response
                     * 
                     * @param handlingFees
                     */
                    public void setHandlingFees(Boolean handlingFees) {
                        this.handlingFees = handlingFees;
                    }

                    /** 
                     * Get the 'Net' attribute value. Used to instruct the system to price the itinerary with a net fare if applicable
                     * 
                     * @return value
                     */
                    public Boolean getNet() {
                        return net;
                    }

                    /** 
                     * Set the 'Net' attribute value. Used to instruct the system to price the itinerary with a net fare if applicable
                     * 
                     * @param net
                     */
                    public void setNet(Boolean net) {
                        this.net = net;
                    }

                    /** 
                     * Get the 'Private' attribute value. Used to instruct the system to price the itinerary with a private fare if applicable
                     * 
                     * @return value
                     */
                    public Boolean getPrivate() {
                        return _private;
                    }

                    /** 
                     * Set the 'Private' attribute value. Used to instruct the system to price the itinerary with a private fare if applicable
                     * 
                     * @param _private
                     */
                    public void setPrivate(Boolean _private) {
                        this._private = _private;
                    }

                    /** 
                     * Get the 'Public' attribute value. Used to instruct the system to price the itinerary with a public fare if applicable
                     * 
                     * @return value
                     */
                    public Boolean getPublic() {
                        return _public;
                    }

                    /** 
                     * Set the 'Public' attribute value. Used to instruct the system to price the itinerary with a public fare if applicable
                     * 
                     * @param _public
                     */
                    public void setPublic(Boolean _public) {
                        this._public = _public;
                    }
                }
                /** 
                 * Pricing variables related to itinerary
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BreakFare" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class BreakFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ForceConnection" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class ForceConnection -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ForceStopOver" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class ForceStopOver -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OverrideBreak" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OverrideBreak -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SegmentSelect -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SideTrip" minOccurs="0">
                 *         &lt;!-- Reference to inner class SideTrip -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItineraryOptions implements Serializable
                {
                    private List<BreakFare> breakFareList = new ArrayList<BreakFare>();
                    private List<ForceConnection> forceConnectionList = new ArrayList<ForceConnection>();
                    private List<ForceStopOver> forceStopOverList = new ArrayList<ForceStopOver>();
                    private List<OverrideBreak> overrideBreakList = new ArrayList<OverrideBreak>();
                    private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
                    private SideTrip sideTrip;

                    /** 
                     * Get the list of 'BreakFare' element items.
                     * 
                     * @return list
                     */
                    public List<BreakFare> getBreakFareList() {
                        return breakFareList;
                    }

                    /** 
                     * Set the list of 'BreakFare' element items.
                     * 
                     * @param list
                     */
                    public void setBreakFareList(List<BreakFare> list) {
                        breakFareList = list;
                    }

                    /** 
                     * Get the list of 'ForceConnection' element items.
                     * 
                     * @return list
                     */
                    public List<ForceConnection> getForceConnectionList() {
                        return forceConnectionList;
                    }

                    /** 
                     * Set the list of 'ForceConnection' element items.
                     * 
                     * @param list
                     */
                    public void setForceConnectionList(
                            List<ForceConnection> list) {
                        forceConnectionList = list;
                    }

                    /** 
                     * Get the list of 'ForceStopOver' element items.
                     * 
                     * @return list
                     */
                    public List<ForceStopOver> getForceStopOverList() {
                        return forceStopOverList;
                    }

                    /** 
                     * Set the list of 'ForceStopOver' element items.
                     * 
                     * @param list
                     */
                    public void setForceStopOverList(List<ForceStopOver> list) {
                        forceStopOverList = list;
                    }

                    /** 
                     * Get the list of 'OverrideBreak' element items.
                     * 
                     * @return list
                     */
                    public List<OverrideBreak> getOverrideBreakList() {
                        return overrideBreakList;
                    }

                    /** 
                     * Set the list of 'OverrideBreak' element items.
                     * 
                     * @param list
                     */
                    public void setOverrideBreakList(List<OverrideBreak> list) {
                        overrideBreakList = list;
                    }

                    /** 
                     * Get the list of 'SegmentSelect' element items.
                     * 
                     * @return list
                     */
                    public List<SegmentSelect> getSegmentSelectList() {
                        return segmentSelectList;
                    }

                    /** 
                     * Set the list of 'SegmentSelect' element items.
                     * 
                     * @param list
                     */
                    public void setSegmentSelectList(List<SegmentSelect> list) {
                        segmentSelectList = list;
                    }

                    /** 
                     * Get the 'SideTrip' element value.
                     * 
                     * @return value
                     */
                    public SideTrip getSideTrip() {
                        return sideTrip;
                    }

                    /** 
                     * Set the 'SideTrip' element value.
                     * 
                     * @param sideTrip
                     */
                    public void setSideTrip(SideTrip sideTrip) {
                        this.sideTrip = sideTrip;
                    }
                    /** 
                     * Used to instruct the system to break the fare at a specified segment
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BreakFare" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BreakFare implements Serializable
                    {
                        private String number;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }
                    }
                    /** 
                     * Used to instruct the system to force a connection at a specified segment
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceConnection" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ForceConnection implements Serializable
                    {
                        private String number;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }
                    }
                    /** 
                     * Used to instruct the system to force a stopover at a specified segment
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceStopOver" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ForceStopOver implements Serializable
                    {
                        private String number;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }
                    }
                    /** 
                     * Used to instruct the system to override a fare break
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverrideBreak" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OverrideBreak implements Serializable
                    {
                        private String number;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }
                    }
                    /** 
                     * Used to instruct the system to price specified itinerary segments
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *     &lt;xs:attribute type="xs:string" name="EndNumber"/>
                     *     &lt;xs:attribute type="xs:string" name="RPH"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SegmentSelect implements Serializable
                    {
                        private String number;
                        private String endNumber;
                        private String RPH;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }

                        /** 
                         * Get the 'EndNumber' attribute value. Segment end number in range
                         * 
                         * @return value
                         */
                        public String getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value. Segment end number in range
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(String endNumber) {
                            this.endNumber = endNumber;
                        }

                        /** 
                         * Get the 'RPH' attribute value. Used to match up with ".../CommandPricing" or .../ItineraryOptions/GoverningCarrierOverride or .../SpecificFare
                         * 
                         * @return value
                         */
                        public String getRPH() {
                            return RPH;
                        }

                        /** 
                         * Set the 'RPH' attribute value. Used to match up with ".../CommandPricing" or .../ItineraryOptions/GoverningCarrierOverride or .../SpecificFare
                         * 
                         * @param RPH
                         */
                        public void setRPH(String RPH) {
                            this.RPH = RPH;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SideTrip" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                     *     &lt;xs:attribute type="xs:string" name="EndNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SideTrip implements Serializable
                    {
                        private String number;
                        private String endNumber;

                        /** 
                         * Get the 'Number' attribute value. Segment number
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. Segment number
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }

                        /** 
                         * Get the 'EndNumber' attribute value. Segment end number in range
                         * 
                         * @return value
                         */
                        public String getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value. Segment end number in range
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(String endNumber) {
                            this.endNumber = endNumber;
                        }
                    }
                }
                /** 
                 * Used to to specify the markup/down amount that's to be applied at time of pricing to create a manually Adjusted Selling Level fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManuallyAdjustedSellingLevel" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" name="MarkDown"/>
                 *     &lt;xs:attribute type="xs:decimal" name="MarkUp"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManuallyAdjustedSellingLevel implements
                    Serializable
                {
                    private BigDecimal markDown;
                    private BigDecimal markUp;

                    /** 
                     * Get the 'MarkDown' attribute value. Used to instruct the system to price the itinerary with a mark down amount
                     * 
                     * @return value
                     */
                    public BigDecimal getMarkDown() {
                        return markDown;
                    }

                    /** 
                     * Set the 'MarkDown' attribute value. Used to instruct the system to price the itinerary with a mark down amount
                     * 
                     * @param markDown
                     */
                    public void setMarkDown(BigDecimal markDown) {
                        this.markDown = markDown;
                    }

                    /** 
                     * Get the 'MarkUp' attribute value. Used to instruct the system to price the itinerary with a mark up amount. MarkDown cannot be combined with MarkUp
                     * 
                     * @return value
                     */
                    public BigDecimal getMarkUp() {
                        return markUp;
                    }

                    /** 
                     * Set the 'MarkUp' attribute value. Used to instruct the system to price the itinerary with a mark up amount. MarkDown cannot be combined with MarkUp
                     * 
                     * @param markUp
                     */
                    public void setMarkUp(BigDecimal markUp) {
                        this.markUp = markUp;
                    }
                }
                /** 
                 * Used to instruct the system to price the itinerary based upon a particular name field
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:string" name="EndNameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameSelect implements Serializable
                {
                    private String nameNumber;
                    private String endNameNumber;

                    /** 
                     * Get the 'NameNumber' attribute value. Name number
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'EndNameNumber' attribute value. End number within a range
                     * 
                     * @return value
                     */
                    public String getEndNameNumber() {
                        return endNameNumber;
                    }

                    /** 
                     * Set the 'EndNameNumber' attribute value. End number within a range
                     * 
                     * @param endNameNumber
                     */
                    public void setEndNameNumber(String endNameNumber) {
                        this.endNameNumber = endNameNumber;
                    }
                }
                /** 
                 * /NetRemit is ONLY applicable to BSP-based subscribers. /NetRemit is NOT applicable to ARC-based subscribers
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CAR" minOccurs="0">
                 *         &lt;!-- Reference to inner class CAR -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Cash" minOccurs="0">
                 *         &lt;!-- Reference to inner class Cash -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Credit" minOccurs="0">
                 *         &lt;!-- Reference to inner class Credit -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NetRemit implements Serializable
                {
                    private CAR CAR1;
                    private Cash cash;
                    private Credit credit;
                    private String code;

                    /** 
                     * Get the 'CAR' element value.
                     * 
                     * @return value
                     */
                    public CAR getCAR1() {
                        return CAR1;
                    }

                    /** 
                     * Set the 'CAR' element value.
                     * 
                     * @param CAR1
                     */
                    public void setCAR1(CAR CAR1) {
                        this.CAR1 = CAR1;
                    }

                    /** 
                     * Get the 'Cash' element value.
                     * 
                     * @return value
                     */
                    public Cash getCash() {
                        return cash;
                    }

                    /** 
                     * Set the 'Cash' element value.
                     * 
                     * @param cash
                     */
                    public void setCash(Cash cash) {
                        this.cash = cash;
                    }

                    /** 
                     * Get the 'Credit' element value.
                     * 
                     * @return value
                     */
                    public Credit getCredit() {
                        return credit;
                    }

                    /** 
                     * Set the 'Credit' element value.
                     * 
                     * @param credit
                     */
                    public void setCredit(Credit credit) {
                        this.credit = credit;
                    }

                    /** 
                     * Get the 'Code' attribute value. Net remit code
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. Net remit code
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                    /** 
                     * Car code
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CAR" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CAR implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value. Car code
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. Car code
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to specify the amount of net cash
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cash" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Cash implements Serializable
                    {
                        private String currencyCode;
                        private String amount;

                        /** 
                         * Get the 'CurrencyCode' attribute value. Currency code
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. Currency code
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount of net cash
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount of net cash
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                    /** 
                     * Used to specify the amount of credit
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Credit" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Credit implements Serializable
                    {
                        private String amount;

                        /** 
                         * Get the 'Amount' attribute value. Used to specify the amount of credit
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to specify the amount of credit
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                }
                /** 
                 * Pricing overrides
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Overrides" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FuelSurchargeOverride" minOccurs="0">
                 *         &lt;!-- Reference to inner class FuelSurchargeOverride -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="GoverningCarrierOverride" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class GoverningCarrierOverride -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoAdvancePurchase" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoAdvancePurchase -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoFareRestrictions" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoFareRestrictions -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoMinMaxStay" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoMinMaxStay -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoPenalty" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoPenalty -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Purchase" minOccurs="0">
                 *         &lt;!-- Reference to inner class Purchase -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Ticketing" minOccurs="0">
                 *         &lt;!-- Reference to inner class Ticketing -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Overrides implements Serializable
                {
                    private FuelSurchargeOverride fuelSurchargeOverride;
                    private List<GoverningCarrierOverride> governingCarrierOverrideList = new ArrayList<GoverningCarrierOverride>();
                    private NoAdvancePurchase noAdvancePurchase;
                    private NoFareRestrictions noFareRestrictions;
                    private NoMinMaxStay noMinMaxStay;
                    private NoPenalty noPenalty;
                    private Purchase purchase;
                    private Ticketing ticketing;

                    /** 
                     * Get the 'FuelSurchargeOverride' element value.
                     * 
                     * @return value
                     */
                    public FuelSurchargeOverride getFuelSurchargeOverride() {
                        return fuelSurchargeOverride;
                    }

                    /** 
                     * Set the 'FuelSurchargeOverride' element value.
                     * 
                     * @param fuelSurchargeOverride
                     */
                    public void setFuelSurchargeOverride(
                            FuelSurchargeOverride fuelSurchargeOverride) {
                        this.fuelSurchargeOverride = fuelSurchargeOverride;
                    }

                    /** 
                     * Get the list of 'GoverningCarrierOverride' element items.
                     * 
                     * @return list
                     */
                    public List<GoverningCarrierOverride> getGoverningCarrierOverrideList() {
                        return governingCarrierOverrideList;
                    }

                    /** 
                     * Set the list of 'GoverningCarrierOverride' element items.
                     * 
                     * @param list
                     */
                    public void setGoverningCarrierOverrideList(
                            List<GoverningCarrierOverride> list) {
                        governingCarrierOverrideList = list;
                    }

                    /** 
                     * Get the 'NoAdvancePurchase' element value.
                     * 
                     * @return value
                     */
                    public NoAdvancePurchase getNoAdvancePurchase() {
                        return noAdvancePurchase;
                    }

                    /** 
                     * Set the 'NoAdvancePurchase' element value.
                     * 
                     * @param noAdvancePurchase
                     */
                    public void setNoAdvancePurchase(
                            NoAdvancePurchase noAdvancePurchase) {
                        this.noAdvancePurchase = noAdvancePurchase;
                    }

                    /** 
                     * Get the 'NoFareRestrictions' element value.
                     * 
                     * @return value
                     */
                    public NoFareRestrictions getNoFareRestrictions() {
                        return noFareRestrictions;
                    }

                    /** 
                     * Set the 'NoFareRestrictions' element value.
                     * 
                     * @param noFareRestrictions
                     */
                    public void setNoFareRestrictions(
                            NoFareRestrictions noFareRestrictions) {
                        this.noFareRestrictions = noFareRestrictions;
                    }

                    /** 
                     * Get the 'NoMinMaxStay' element value.
                     * 
                     * @return value
                     */
                    public NoMinMaxStay getNoMinMaxStay() {
                        return noMinMaxStay;
                    }

                    /** 
                     * Set the 'NoMinMaxStay' element value.
                     * 
                     * @param noMinMaxStay
                     */
                    public void setNoMinMaxStay(NoMinMaxStay noMinMaxStay) {
                        this.noMinMaxStay = noMinMaxStay;
                    }

                    /** 
                     * Get the 'NoPenalty' element value.
                     * 
                     * @return value
                     */
                    public NoPenalty getNoPenalty() {
                        return noPenalty;
                    }

                    /** 
                     * Set the 'NoPenalty' element value.
                     * 
                     * @param noPenalty
                     */
                    public void setNoPenalty(NoPenalty noPenalty) {
                        this.noPenalty = noPenalty;
                    }

                    /** 
                     * Get the 'Purchase' element value.
                     * 
                     * @return value
                     */
                    public Purchase getPurchase() {
                        return purchase;
                    }

                    /** 
                     * Set the 'Purchase' element value.
                     * 
                     * @param purchase
                     */
                    public void setPurchase(Purchase purchase) {
                        this.purchase = purchase;
                    }

                    /** 
                     * Get the 'Ticketing' element value.
                     * 
                     * @return value
                     */
                    public Ticketing getTicketing() {
                        return ticketing;
                    }

                    /** 
                     * Set the 'Ticketing' element value.
                     * 
                     * @param ticketing
                     */
                    public void setTicketing(Ticketing ticketing) {
                        this.ticketing = ticketing;
                    }
                    /** 
                     * Used to instruct the system to override applicable fuel surcharges
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FuelSurchargeOverride" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FuelSurchargeOverride implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to instruct the system to override applicable fuel surcharges
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to instruct the system to override applicable fuel surcharges
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to instruct the system to override the governing carrier associated with the entire itinerary, a particular segment, or a range of segments
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GoverningCarrierOverride" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Airline">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="RPH"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class GoverningCarrierOverride implements
                        Serializable
                    {
                        private String airline;
                        private String RPH;

                        /** 
                         * Get the 'Code' attribute value. Airline code
                         * 
                         * @return value
                         */
                        public String getAirline() {
                            return airline;
                        }

                        /** 
                         * Set the 'Code' attribute value. Airline code
                         * 
                         * @param airline
                         */
                        public void setAirline(String airline) {
                            this.airline = airline;
                        }

                        /** 
                         * Get the 'RPH' attribute value. Used to tie a governing carrier override to particular segments. If a client application needs to utilize a governing carrier override from a particular segment or segments the application can use .../GoverningCarrierOverride in conjunction with .../ItineraryOptions/SegmentSelect
                         * 
                         * @return value
                         */
                        public String getRPH() {
                            return RPH;
                        }

                        /** 
                         * Set the 'RPH' attribute value. Used to tie a governing carrier override to particular segments. If a client application needs to utilize a governing carrier override from a particular segment or segments the application can use .../GoverningCarrierOverride in conjunction with .../ItineraryOptions/SegmentSelect
                         * 
                         * @param RPH
                         */
                        public void setRPH(String RPH) {
                            this.RPH = RPH;
                        }
                    }
                    /** 
                     * Used to instruct the system to price the itinerary with fares having no advance purchase requirements. Cannot combine with "NoFareRestrictions."
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoAdvancePurchase" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoAdvancePurchase implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no advance purchase requirements
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no advance purchase requirements
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to instruct the system to price the itinerary with fares having no restrictions. Cannot combine with "NoAdvancePurchase", "NoMinMaxStay", or "NoPenalty"
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoFareRestrictions" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoFareRestrictions implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no restrictions
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no restrictions
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to instruct the system to price the itinerary with fares having no minimum/maximum stay requirements. Cannot combine with "NoFareRestrictions"
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMinMaxStay" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoMinMaxStay implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no minimum/maximum stay requirements
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no minimum/maximum stay requirements
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to instruct the system to price the itinerary with fares having no penalties. Cannot combine with "NoFareRestrictions"
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoPenalty" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoPenalty implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no penalties
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to instruct the system to price the itinerary with fares having no penalties
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to instruct the system to override the default POS location, and price the itinerary as if the default POS location were located in the alternate, specified location
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Purchase" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Purchase implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value. Location code
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value. Location code
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                    /** 
                     * Used to instruct the system to override the default ticketing location, and price the itinerary as if the default ticketing location were located in the alternate, specified location
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Ticketing implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value. Location code
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value. Location code
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                }
                /** 
                 * Used to specify a passenger type code
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *     &lt;xs:attribute type="xs:boolean" name="Force"/>
                 *     &lt;xs:attribute type="xs:string" name="Quantity"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerType implements Serializable
                {
                    private String code;
                    private Boolean force;
                    private String quantity;

                    /** 
                     * Get the 'Code' attribute value. Used to specify a passenger type code
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. Used to specify a passenger type code
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Force' attribute value. Used to force the system to price with the specified passenger type code. If the client requests multiple passenger types and also wishes to make use of @Force they should only pass it on the last .../PassengerType occurrence
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value. Used to force the system to price with the specified passenger type code. If the client requests multiple passenger types and also wishes to make use of @Force they should only pass it on the last .../PassengerType occurrence
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }

                    /** 
                     * Get the 'Quantity' attribute value. Used to specify the number of passengers
                     * 
                     * @return value
                     */
                    public String getQuantity() {
                        return quantity;
                    }

                    /** 
                     * Set the 'Quantity' attribute value. Used to specify the number of passengers
                     * 
                     * @param quantity
                     */
                    public void setQuantity(String quantity) {
                        this.quantity = quantity;
                    }
                }
                /** 
                 * Used to specify an amount to add on top of the fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PlusUp" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PlusUp implements Serializable
                {
                    private String ticketDesignator;
                    private String amount;

                    /** 
                     * Get the 'TicketDesignator' element value. Ticket designator
                     * 
                     * @return value
                     */
                    public String getTicketDesignator() {
                        return ticketDesignator;
                    }

                    /** 
                     * Set the 'TicketDesignator' element value. Ticket designator
                     * 
                     * @param ticketDesignator
                     */
                    public void setTicketDesignator(String ticketDesignator) {
                        this.ticketDesignator = ticketDesignator;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Used to specify an amount to add on top of the fare
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Used to specify an amount to add on top of the fare
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                }
                /** 
                 * Used to price an itinerary incorporating fares linked to a specific Retailer Rule Qualifier code
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRuleQualifier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Qualifier" maxOccurs="4"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RetailerRuleQualifier implements
                    Serializable
                {
                    private List<String> qualifierList = new ArrayList<String>();
                    private Boolean force;

                    /** 
                     * Get the list of 'Qualifier' element items. Retailer Rule Qualifier code
                     * 
                     * @return list
                     */
                    public List<String> getQualifierList() {
                        return qualifierList;
                    }

                    /** 
                     * Set the list of 'Qualifier' element items. Retailer Rule Qualifier code
                     * 
                     * @param list
                     */
                    public void setQualifierList(List<String> list) {
                        qualifierList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value. Used to force only fares with a matched Business Rule containing the specified Retailer Rule Qualifier. "Force" can only be used with one "Qualifier"
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value. Used to force only fares with a matched Business Rule containing the specified Retailer Rule Qualifier. "Force" can only be used with one "Qualifier"
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="1"/>
                 *     &lt;xs:enumeration value="2"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum SpanishLargeFamilyDiscountLevel
                        implements
                            Serializable {
                    _1("1"), _2("2");
                    private final String value;

                    private SpanishLargeFamilyDiscountLevel(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static SpanishLargeFamilyDiscountLevel convert(
                            String value) {
                        for (SpanishLargeFamilyDiscountLevel inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
                /** 
                 * This element is only applicable to Abacus
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecificFare implements Serializable
                {
                    private String fareBasis;
                    private String RPH;

                    /** 
                     * Get the 'FareBasis' element value. Used to price a specific fare basis that will, in turn, be validated
                     * 
                     * @return value
                     */
                    public String getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value. Used to price a specific fare basis that will, in turn, be validated
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(String fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the 'RPH' attribute value. RPH" is used to match up with "SegmentSelect"
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. RPH" is used to match up with "SegmentSelect"
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * Used to specify change or cancellation amounts for an itinerary
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Changeable" minOccurs="0">
                 *         &lt;!-- Reference to inner class Changeable -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EitherOr" minOccurs="0">
                 *         &lt;!-- Reference to inner class EitherOr -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Refundable" minOccurs="0">
                 *         &lt;!-- Reference to inner class Refundable -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="AdditionalInfo"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecificPenalty implements Serializable
                {
                    private Changeable changeable;
                    private EitherOr eitherOr;
                    private Refundable refundable;
                    private Boolean additionalInfo;

                    /** 
                     * Get the 'Changeable' element value.
                     * 
                     * @return value
                     */
                    public Changeable getChangeable() {
                        return changeable;
                    }

                    /** 
                     * Set the 'Changeable' element value.
                     * 
                     * @param changeable
                     */
                    public void setChangeable(Changeable changeable) {
                        this.changeable = changeable;
                    }

                    /** 
                     * Get the 'EitherOr' element value.
                     * 
                     * @return value
                     */
                    public EitherOr getEitherOr() {
                        return eitherOr;
                    }

                    /** 
                     * Set the 'EitherOr' element value.
                     * 
                     * @param eitherOr
                     */
                    public void setEitherOr(EitherOr eitherOr) {
                        this.eitherOr = eitherOr;
                    }

                    /** 
                     * Get the 'Refundable' element value.
                     * 
                     * @return value
                     */
                    public Refundable getRefundable() {
                        return refundable;
                    }

                    /** 
                     * Set the 'Refundable' element value.
                     * 
                     * @param refundable
                     */
                    public void setRefundable(Refundable refundable) {
                        this.refundable = refundable;
                    }

                    /** 
                     * Get the 'AdditionalInfo' attribute value. Used to receive additional tags with information on fare flexibility
                     * 
                     * @return value
                     */
                    public Boolean getAdditionalInfo() {
                        return additionalInfo;
                    }

                    /** 
                     * Set the 'AdditionalInfo' attribute value. Used to receive additional tags with information on fare flexibility
                     * 
                     * @param additionalInfo
                     */
                    public void setAdditionalInfo(Boolean additionalInfo) {
                        this.additionalInfo = additionalInfo;
                    }
                    /** 
                     * Changeable pricing fare options. Please note that "Changeable" and "Refundable" can be combined in a single request to query for both changeable AND refundable pricing options
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Changeable implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value. Used to specify only changeable pricing fare options
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value. Used to specify only changeable pricing fare options
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value. Used to specify the specific currency for maximum exchange penalty
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. Used to specify the specific currency for maximum exchange penalty
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value. Used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value. Used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                    /** 
                     * Refundable OR changeable pricing fare options
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EitherOr implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value. Used to specify any refundable OR changeable pricing fare options
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value. Used to specify any refundable OR changeable pricing fare options
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value. Used to specify the specific currency for either maximum refund OR change penalty
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. Used to specify the specific currency for either maximum refund OR change penalty
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value. Used to specify maximum refund OR change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-refundable OR non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value. Used to specify maximum refund OR change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-refundable OR non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                    /** 
                     * Refundable pricing fare options. Please note that "Changeable" and "Refundable" can be combined in a single request to query for both changeable AND refundable pricing options
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Refundable implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value. Used to specify any refundable pricing fare options
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value. Used to specify any refundable pricing fare options
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value. Used to specify the specific currency for maximum refund penalty
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. Used to specify the specific currency for maximum refund penalty
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value. Used to specify maximum refund penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-refundable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value. Used to specify maximum refund penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-refundable options are requested. Please note that monetary amount that includes a decimal is not allowed
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value. Used to query for before departure fees
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value. Used to query for after departure fees. It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                }
                /** 
                 * Tax related pricing variables
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="NoTax" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class TaxExempt -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class TaxOverride -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private NoTax noTax;
                    private List<TaxExempt> taxExemptList = new ArrayList<TaxExempt>();
                    private List<TaxOverride> taxOverrideList = new ArrayList<TaxOverride>();

                    /** 
                     * Get the 'NoTax' element value.
                     * 
                     * @return value
                     */
                    public NoTax getNoTax() {
                        return noTax;
                    }

                    /** 
                     * Set the 'NoTax' element value.
                     * 
                     * @param noTax
                     */
                    public void setNoTax(NoTax noTax) {
                        this.noTax = noTax;
                    }

                    /** 
                     * Get the list of 'TaxExempt' element items.
                     * 
                     * @return list
                     */
                    public List<TaxExempt> getTaxExemptList() {
                        return taxExemptList;
                    }

                    /** 
                     * Set the list of 'TaxExempt' element items.
                     * 
                     * @param list
                     */
                    public void setTaxExemptList(List<TaxExempt> list) {
                        taxExemptList = list;
                    }

                    /** 
                     * Get the list of 'TaxOverride' element items.
                     * 
                     * @return list
                     */
                    public List<TaxOverride> getTaxOverrideList() {
                        return taxOverrideList;
                    }

                    /** 
                     * Set the list of 'TaxOverride' element items.
                     * 
                     * @param list
                     */
                    public void setTaxOverrideList(List<TaxOverride> list) {
                        taxOverrideList = list;
                    }
                    /** 
                     * Used to specify to price an itinerary without taxes
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoTax" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoTax implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to specify to price an itinerary without taxes
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to specify to price an itinerary without taxes
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to specify a tax code to exempt
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TaxExempt implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value. Used to specify a tax code to exempt
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify a tax code to exempt
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to specify a tax to override
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TaxOverride implements Serializable
                    {
                        private String amount;
                        private String code;

                        /** 
                         * Get the 'Amount' attribute value. Tax amount
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Tax amount
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Code' attribute value. Tax code
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. Tax code
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
                /** 
                 * Used to specify ticket validity dates
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="NotValidAfter" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NotValidBefore" minOccurs="0"/>
                 *       &lt;xs:element name="Segment">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *           &lt;xs:attribute type="xs:string" name="EndNumber"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidityDates implements Serializable
                {
                    private String notValidAfter;
                    private String notValidBefore;
                    private String segmentNumber;
                    private String segmentEndNumber;

                    /** 
                     * Get the 'NotValidAfter' element value. Used to specify the ending validity date. "NotValidAfter" follows this format: MM-DD or YYYY-MM-DD
                     * 
                     * @return value
                     */
                    public String getNotValidAfter() {
                        return notValidAfter;
                    }

                    /** 
                     * Set the 'NotValidAfter' element value. Used to specify the ending validity date. "NotValidAfter" follows this format: MM-DD or YYYY-MM-DD
                     * 
                     * @param notValidAfter
                     */
                    public void setNotValidAfter(String notValidAfter) {
                        this.notValidAfter = notValidAfter;
                    }

                    /** 
                     * Get the 'NotValidBefore' element value. Used to specify the beginning validity date. "NotValidBefore" follows this format: MM-DD or YYYY-MM-DD
                     * 
                     * @return value
                     */
                    public String getNotValidBefore() {
                        return notValidBefore;
                    }

                    /** 
                     * Set the 'NotValidBefore' element value. Used to specify the beginning validity date. "NotValidBefore" follows this format: MM-DD or YYYY-MM-DD
                     * 
                     * @param notValidBefore
                     */
                    public void setNotValidBefore(String notValidBefore) {
                        this.notValidBefore = notValidBefore;
                    }

                    /** 
                     * Get the 'Number' attribute value. Segment number
                     * 
                     * @return value
                     */
                    public String getSegmentNumber() {
                        return segmentNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. Segment number
                     * 
                     * @param segmentNumber
                     */
                    public void setSegmentNumber(String segmentNumber) {
                        this.segmentNumber = segmentNumber;
                    }

                    /** 
                     * Get the 'EndNumber' attribute value. Segment end number in range
                     * 
                     * @return value
                     */
                    public String getSegmentEndNumber() {
                        return segmentEndNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. Segment end number in range
                     * 
                     * @param segmentEndNumber
                     */
                    public void setSegmentEndNumber(String segmentEndNumber) {
                        this.segmentEndNumber = segmentEndNumber;
                    }
                }
            }
        }
    }
    /** 
     * Used to book GDS or Aggregator chain hotels.
                                      Please note that for the successful PNR creation TravelItineraryAddInfo.AgencyInfo.Address and TravelItineraryAddInfo.CustomerInfo.PersonName need to be provided.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelBook" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BookingInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="BookingKey"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" name="CorpDiscount"/>
     *           &lt;xs:attribute type="xs:string" name="RequestorID"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Rooms" minOccurs="0">
     *         &lt;!-- Reference to inner class Rooms -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialInstructions" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialInstructions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class PaymentInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="POS" minOccurs="0">
     *         &lt;!-- Reference to inner class POS -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" default="true" name="bookGDSviaCSL"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HotelBook implements Serializable
    {
        private String bookingInfoBookingKey;
        private String bookingInfoCorpDiscount;
        private String bookingInfoRequestorID;
        private Rooms rooms;
        private SpecialInstructions specialInstructions;
        private PaymentInformation paymentInformation;
        private POS POS1;
        private Boolean bookGDSviaCSL;

        /** 
         * Get the 'BookingKey' element value. The Booking Key is returned in the Hotel Price Check API response and is a mandatory value to perform hotel booking.
                                                                BookingKey cannot be empty and must not exceed 240 characters.
         * 
         * @return value
         */
        public String getBookingInfoBookingKey() {
            return bookingInfoBookingKey;
        }

        /** 
         * Set the 'BookingKey' element value. The Booking Key is returned in the Hotel Price Check API response and is a mandatory value to perform hotel booking.
                                                                BookingKey cannot be empty and must not exceed 240 characters.
         * 
         * @param bookingInfoBookingKey
         */
        public void setBookingInfoBookingKey(String bookingInfoBookingKey) {
            this.bookingInfoBookingKey = bookingInfoBookingKey;
        }

        /** 
         * Get the 'CorpDiscount' attribute value. A code that a company may give to an agency to use for a discount.
                                                            It is quite often tied to a negotiated rate code.
         * 
         * @return value
         */
        public String getBookingInfoCorpDiscount() {
            return bookingInfoCorpDiscount;
        }

        /** 
         * Set the 'CorpDiscount' attribute value. A code that a company may give to an agency to use for a discount.
                                                            It is quite often tied to a negotiated rate code.
         * 
         * @param bookingInfoCorpDiscount
         */
        public void setBookingInfoCorpDiscount(String bookingInfoCorpDiscount) {
            this.bookingInfoCorpDiscount = bookingInfoCorpDiscount;
        }

        /** 
         * Get the 'RequestorID' attribute value. Corresponds to the Agency IATA number.
         * 
         * @return value
         */
        public String getBookingInfoRequestorID() {
            return bookingInfoRequestorID;
        }

        /** 
         * Set the 'RequestorID' attribute value. Corresponds to the Agency IATA number.
         * 
         * @param bookingInfoRequestorID
         */
        public void setBookingInfoRequestorID(String bookingInfoRequestorID) {
            this.bookingInfoRequestorID = bookingInfoRequestorID;
        }

        /** 
         * Get the 'Rooms' element value.
         * 
         * @return value
         */
        public Rooms getRooms() {
            return rooms;
        }

        /** 
         * Set the 'Rooms' element value.
         * 
         * @param rooms
         */
        public void setRooms(Rooms rooms) {
            this.rooms = rooms;
        }

        /** 
         * Get the 'SpecialInstructions' element value.
         * 
         * @return value
         */
        public SpecialInstructions getSpecialInstructions() {
            return specialInstructions;
        }

        /** 
         * Set the 'SpecialInstructions' element value.
         * 
         * @param specialInstructions
         */
        public void setSpecialInstructions(
                SpecialInstructions specialInstructions) {
            this.specialInstructions = specialInstructions;
        }

        /** 
         * Get the 'PaymentInformation' element value.
         * 
         * @return value
         */
        public PaymentInformation getPaymentInformation() {
            return paymentInformation;
        }

        /** 
         * Set the 'PaymentInformation' element value.
         * 
         * @param paymentInformation
         */
        public void setPaymentInformation(PaymentInformation paymentInformation) {
            this.paymentInformation = paymentInformation;
        }

        /** 
         * Get the 'POS' element value.
         * 
         * @return value
         */
        public POS getPOS1() {
            return POS1;
        }

        /** 
         * Set the 'POS' element value.
         * 
         * @param POS1
         */
        public void setPOS1(POS POS1) {
            this.POS1 = POS1;
        }

        /** 
         * Get the 'bookGDSviaCSL' attribute value. Used to indicate whether GDS hotel should be booked using new booking path (CSL) or the legacy path (low level services).
                                                If true, the hotel originally sourced from the GDS will be booked using the Content Services for Lodging (CSL) booking path.
                                                If false, the legacy path traditionally used in Sabre's low-level services will be used.
                                            
         * 
         * @return value
         */
        public Boolean getBookGDSviaCSL() {
            return bookGDSviaCSL;
        }

        /** 
         * Set the 'bookGDSviaCSL' attribute value. Used to indicate whether GDS hotel should be booked using new booking path (CSL) or the legacy path (low level services).
                                                If true, the hotel originally sourced from the GDS will be booked using the Content Services for Lodging (CSL) booking path.
                                                If false, the legacy path traditionally used in Sabre's low-level services will be used.
                                            
         * 
         * @param bookGDSviaCSL
         */
        public void setBookGDSviaCSL(Boolean bookGDSviaCSL) {
            this.bookGDSviaCSL = bookGDSviaCSL;
        }
        /** 
         * Room details.
                                                    Multiple room bookings are currently not supported by GDS hotels.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rooms" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Room" maxOccurs="99">
         *         &lt;!-- Reference to inner class Room -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:int" name="NumberOfRooms"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rooms implements Serializable
        {
            private List<Room> roomList = new ArrayList<Room>();
            private Integer numberOfRooms;

            /** 
             * Get the list of 'Room' element items.
             * 
             * @return list
             */
            public List<Room> getRoomList() {
                return roomList;
            }

            /** 
             * Set the list of 'Room' element items.
             * 
             * @param list
             */
            public void setRoomList(List<Room> list) {
                roomList = list;
            }

            /** 
             * Get the 'NumberOfRooms' attribute value. Indicates the number of rooms to be booked.
             * 
             * @return value
             */
            public Integer getNumberOfRooms() {
                return numberOfRooms;
            }

            /** 
             * Set the 'NumberOfRooms' attribute value. Indicates the number of rooms to be booked.
             * 
             * @param numberOfRooms
             */
            public void setNumberOfRooms(Integer numberOfRooms) {
                this.numberOfRooms = numberOfRooms;
            }
            /** 
             * Used to pass details of a single room.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Room" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Guests">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="Guest" maxOccurs="99">
             *               &lt;!-- Reference to inner class Guest -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="RoomExtras" minOccurs="0">
             *         &lt;!-- Reference to inner class RoomExtras -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" default="true" name="NonSmoking"/>
             *     &lt;xs:attribute type="xs:int" name="BedTypeCode"/>
             *     &lt;xs:attribute type="xs:int" name="AccessibilityInformation"/>
             *     &lt;xs:attribute type="xs:int" name="RoomIndex"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Room implements Serializable
            {
                private List<Guest> guestList = new ArrayList<Guest>();
                private RoomExtras roomExtras;
                private Boolean nonSmoking;
                private Integer bedTypeCode;
                private Integer accessibilityInformation;
                private Integer roomIndex;

                /** 
                 * Get the list of 'Guest' element items. A list of guests in a room.
                 * 
                 * @return list
                 */
                public List<Guest> getGuestList() {
                    return guestList;
                }

                /** 
                 * Set the list of 'Guest' element items. A list of guests in a room.
                 * 
                 * @param list
                 */
                public void setGuestList(List<Guest> list) {
                    guestList = list;
                }

                /** 
                 * Get the 'RoomExtras' element value.
                 * 
                 * @return value
                 */
                public RoomExtras getRoomExtras() {
                    return roomExtras;
                }

                /** 
                 * Set the 'RoomExtras' element value.
                 * 
                 * @param roomExtras
                 */
                public void setRoomExtras(RoomExtras roomExtras) {
                    this.roomExtras = roomExtras;
                }

                /** 
                 * Get the 'NonSmoking' attribute value. A non-smoking indicator.
                                                                            By default this is 'true'.
                                                                            When 'false' equals smoking and 'true' equals non-smoking.
                 * 
                 * @return value
                 */
                public Boolean getNonSmoking() {
                    return nonSmoking;
                }

                /** 
                 * Set the 'NonSmoking' attribute value. A non-smoking indicator.
                                                                            By default this is 'true'.
                                                                            When 'false' equals smoking and 'true' equals non-smoking.
                 * 
                 * @param nonSmoking
                 */
                public void setNonSmoking(Boolean nonSmoking) {
                    this.nonSmoking = nonSmoking;
                }

                /** 
                 * Get the 'BedTypeCode' attribute value. Allows users to request a specific bed type code.
                                                                            Used by EAN aggregator.
                 * 
                 * @return value
                 */
                public Integer getBedTypeCode() {
                    return bedTypeCode;
                }

                /** 
                 * Set the 'BedTypeCode' attribute value. Allows users to request a specific bed type code.
                                                                            Used by EAN aggregator.
                 * 
                 * @param bedTypeCode
                 */
                public void setBedTypeCode(Integer bedTypeCode) {
                    this.bedTypeCode = bedTypeCode;
                }

                /** 
                 * Get the 'AccessibilityInformation' attribute value. Used to allow a customer to request special accessibility rooms.
                 * 
                 * @return value
                 */
                public Integer getAccessibilityInformation() {
                    return accessibilityInformation;
                }

                /** 
                 * Set the 'AccessibilityInformation' attribute value. Used to allow a customer to request special accessibility rooms.
                 * 
                 * @param accessibilityInformation
                 */
                public void setAccessibilityInformation(
                        Integer accessibilityInformation) {
                    this.accessibilityInformation = accessibilityInformation;
                }

                /** 
                 * Get the 'RoomIndex' attribute value. Identifies the number of rooms being booked.
                                                                            For multi room bookings please specify '1' for the first room, '2' for the second room, etc.
                 * 
                 * @return value
                 */
                public Integer getRoomIndex() {
                    return roomIndex;
                }

                /** 
                 * Set the 'RoomIndex' attribute value. Identifies the number of rooms being booked.
                                                                            For multi room bookings please specify '1' for the first room, '2' for the second room, etc.
                 * 
                 * @param roomIndex
                 */
                public void setRoomIndex(Integer roomIndex) {
                    this.roomIndex = roomIndex;
                }
                /** 
                 * Used to pass details of a guest.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guest" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Contact" minOccurs="0">
                 *         &lt;!-- Reference to inner class Contact -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute name="Type">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class Type -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *     &lt;xs:attribute type="xs:string" name="Email"/>
                 *     &lt;xs:attribute type="xs:int" name="Age"/>
                 *     &lt;xs:attribute type="xs:int" name="Index"/>
                 *     &lt;xs:attribute type="xs:boolean" default="false" name="LeadGuest"/>
                 *     &lt;xs:attribute type="xs:string" name="FrequentFlyerNumber"/>
                 *     &lt;xs:attribute type="xs:string" name="LoyaltyId"/>
                 *     &lt;xs:attribute type="xs:string" name="Title"/>
                 *     &lt;xs:attribute type="xs:string" name="FirstName"/>
                 *     &lt;xs:attribute type="xs:string" name="LastName"/>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Guest implements Serializable
                {
                    private Contact contact;
                    private Type type;
                    private String email;
                    private Integer age;
                    private Integer index;
                    private Boolean leadGuest;
                    private String frequentFlyerNumber;
                    private String loyaltyId;
                    private String title;
                    private String firstName;
                    private String lastName;
                    private String nameNumber;

                    /** 
                     * Get the 'Contact' element value.
                     * 
                     * @return value
                     */
                    public Contact getContact() {
                        return contact;
                    }

                    /** 
                     * Set the 'Contact' element value.
                     * 
                     * @param contact
                     */
                    public void setContact(Contact contact) {
                        this.contact = contact;
                    }

                    /** 
                     * Get the 'Type' attribute value. ''Type''  defines whether the guest is an adult or child.
                                                                                                      `10`- Adult.
                                                                                                      `8` - Child.
                                                                                                      Valid values are only Adult and Child Types.
                     * 
                     * @return value
                     */
                    public Type getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. ''Type''  defines whether the guest is an adult or child.
                                                                                                      `10`- Adult.
                                                                                                      `8` - Child.
                                                                                                      Valid values are only Adult and Child Types.
                     * 
                     * @param type
                     */
                    public void setType(Type type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'Email' attribute value. Email address for the guest
                     * 
                     * @return value
                     */
                    public String getEmail() {
                        return email;
                    }

                    /** 
                     * Set the 'Email' attribute value. Email address for the guest
                     * 
                     * @param email
                     */
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    /** 
                     * Get the 'Age' attribute value. Used to pass the guest age.
                                                                                                      It is mandatory for a child guest.
                     * 
                     * @return value
                     */
                    public Integer getAge() {
                        return age;
                    }

                    /** 
                     * Set the 'Age' attribute value. Used to pass the guest age.
                                                                                                      It is mandatory for a child guest.
                     * 
                     * @param age
                     */
                    public void setAge(Integer age) {
                        this.age = age;
                    }

                    /** 
                     * Get the 'Index' attribute value. Used to pass the guest number.
                     * 
                     * @return value
                     */
                    public Integer getIndex() {
                        return index;
                    }

                    /** 
                     * Set the 'Index' attribute value. Used to pass the guest number.
                     * 
                     * @param index
                     */
                    public void setIndex(Integer index) {
                        this.index = index;
                    }

                    /** 
                     * Get the 'LeadGuest' attribute value. Indicates that this guest is the main guest for the booking.
                                                                                                      At least one and only one adult guest must be defined.
                     * 
                     * @return value
                     */
                    public Boolean getLeadGuest() {
                        return leadGuest;
                    }

                    /** 
                     * Set the 'LeadGuest' attribute value. Indicates that this guest is the main guest for the booking.
                                                                                                      At least one and only one adult guest must be defined.
                     * 
                     * @param leadGuest
                     */
                    public void setLeadGuest(Boolean leadGuest) {
                        this.leadGuest = leadGuest;
                    }

                    /** 
                     * Get the 'FrequentFlyerNumber' attribute value. Used to pass a frequent traveler number.
                                                                                                      It applies only to the LeadGuest and should be specified as a two-letter airline code followed by the traveler’s frequent flyer number (eg. LH12345).
                     * 
                     * @return value
                     */
                    public String getFrequentFlyerNumber() {
                        return frequentFlyerNumber;
                    }

                    /** 
                     * Set the 'FrequentFlyerNumber' attribute value. Used to pass a frequent traveler number.
                                                                                                      It applies only to the LeadGuest and should be specified as a two-letter airline code followed by the traveler’s frequent flyer number (eg. LH12345).
                     * 
                     * @param frequentFlyerNumber
                     */
                    public void setFrequentFlyerNumber(
                            String frequentFlyerNumber) {
                        this.frequentFlyerNumber = frequentFlyerNumber;
                    }

                    /** 
                     * Get the 'LoyaltyId' attribute value. Used to pass a loyalty identifier.
                                                                                                      It applies only to the LeadGuest.
                     * 
                     * @return value
                     */
                    public String getLoyaltyId() {
                        return loyaltyId;
                    }

                    /** 
                     * Set the 'LoyaltyId' attribute value. Used to pass a loyalty identifier.
                                                                                                      It applies only to the LeadGuest.
                     * 
                     * @param loyaltyId
                     */
                    public void setLoyaltyId(String loyaltyId) {
                        this.loyaltyId = loyaltyId;
                    }

                    /** 
                     * Get the 'Title' attribute value. Used to pass the guest title.
                                                                                                      It can include MR./MS. etc.
                     * 
                     * @return value
                     */
                    public String getTitle() {
                        return title;
                    }

                    /** 
                     * Set the 'Title' attribute value. Used to pass the guest title.
                                                                                                      It can include MR./MS. etc.
                     * 
                     * @param title
                     */
                    public void setTitle(String title) {
                        this.title = title;
                    }

                    /** 
                     * Get the 'FirstName' attribute value. First name of the guest.
                     * 
                     * @return value
                     */
                    public String getFirstName() {
                        return firstName;
                    }

                    /** 
                     * Set the 'FirstName' attribute value. First name of the guest.
                     * 
                     * @param firstName
                     */
                    public void setFirstName(String firstName) {
                        this.firstName = firstName;
                    }

                    /** 
                     * Get the 'LastName' attribute value. Last name of the guest.
                     * 
                     * @return value
                     */
                    public String getLastName() {
                        return lastName;
                    }

                    /** 
                     * Set the 'LastName' attribute value. Last name of the guest.
                     * 
                     * @param lastName
                     */
                    public void setLastName(String lastName) {
                        this.lastName = lastName;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Used to associate the GDS legacy booking (`bookGDSviaCSL`=`false`) with a specific name number from the PNR name field.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to associate the GDS legacy booking (`bookGDSviaCSL`=`false`) with a specific name number from the PNR name field.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                    /** 
                     * Guest contact details
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Phone"/>
                     *     &lt;xs:attribute type="xs:string" name="Mobile"/>
                     *     &lt;xs:attribute type="xs:string" name="Fax"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Contact implements Serializable
                    {
                        private String phone;
                        private String mobile;
                        private String fax;

                        /** 
                         * Get the 'Phone' attribute value. The main phone number.
                         * 
                         * @return value
                         */
                        public String getPhone() {
                            return phone;
                        }

                        /** 
                         * Set the 'Phone' attribute value. The main phone number.
                         * 
                         * @param phone
                         */
                        public void setPhone(String phone) {
                            this.phone = phone;
                        }

                        /** 
                         * Get the 'Mobile' attribute value. The mobile phone number.
                         * 
                         * @return value
                         */
                        public String getMobile() {
                            return mobile;
                        }

                        /** 
                         * Set the 'Mobile' attribute value. The mobile phone number.
                         * 
                         * @param mobile
                         */
                        public void setMobile(String mobile) {
                            this.mobile = mobile;
                        }

                        /** 
                         * Get the 'Fax' attribute value. The Fax number.
                         * 
                         * @return value
                         */
                        public String getFax() {
                            return fax;
                        }

                        /** 
                         * Set the 'Fax' attribute value. The Fax number.
                         * 
                         * @param fax
                         */
                        public void setFax(String fax) {
                            this.fax = fax;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:int">
                     *     &lt;xs:enumeration value="8"/>
                     *     &lt;xs:enumeration value="10"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum Type implements Serializable {
                        _8("8"), _10("10");
                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        public String xmlValue() {
                            return value;
                        }

                        public static Type convert(String value) {
                            for (Type inst : values()) {
                                if (inst.xmlValue().equals(value)) {
                                    return inst;
                                }
                            }
                            return null;
                        }
                    }
                }
                /** 
                 * Used to pass room extra information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomExtras" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RoomExtra" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class RoomExtra -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RoomExtras implements Serializable
                {
                    private List<RoomExtra> roomExtraList = new ArrayList<RoomExtra>();

                    /** 
                     * Get the list of 'RoomExtra' element items.
                     * 
                     * @return list
                     */
                    public List<RoomExtra> getRoomExtraList() {
                        return roomExtraList;
                    }

                    /** 
                     * Set the list of 'RoomExtra' element items.
                     * 
                     * @param list
                     */
                    public void setRoomExtraList(List<RoomExtra> list) {
                        roomExtraList = list;
                    }
                    /** 
                     * Details of an individual extra requested.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomExtra" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:int" name="Type"/>
                     *     &lt;xs:attribute type="xs:int" use="required" name="Quantity"/>
                     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RoomExtra implements Serializable
                    {
                        private Integer type;
                        private Integer quantity;
                        private BigDecimal amount;

                        /** 
                         * Get the 'Type' attribute value. Used to pass the room extra type.
                                                                                                        Currently supported types are:
                                                                                                        `26` - Crib.
                                                                                                        `91` - Roll-away Bed.
                                                                                                        `196` - Extra Person.
                         * 
                         * @return value
                         */
                        public Integer getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. Used to pass the room extra type.
                                                                                                        Currently supported types are:
                                                                                                        `26` - Crib.
                                                                                                        `91` - Roll-away Bed.
                                                                                                        `196` - Extra Person.
                         * 
                         * @param type
                         */
                        public void setType(Integer type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'Quantity' attribute value. Used to pass the room extra quantity.
                                                                                                        Mandatory for request.
                         * 
                         * @return value
                         */
                        public Integer getQuantity() {
                            return quantity;
                        }

                        /** 
                         * Set the 'Quantity' attribute value. Used to pass the room extra quantity.
                                                                                                        Mandatory for request.
                         * 
                         * @param quantity
                         */
                        public void setQuantity(Integer quantity) {
                            this.quantity = quantity;
                        }

                        /** 
                         * Get the 'Amount' attribute value. Used to pass the monetary amount of the room extra.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Used to pass the monetary amount of the room extra.
                         * 
                         * @param amount
                         */
                        public void setAmount(BigDecimal amount) {
                            this.amount = amount;
                        }
                    }
                }
            }
        }
        /** 
         * Used to specify miscellaneous special preference information.
                                                    All of the 'SpecialInstructions' should be free form or GTA special instructions.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialInstructions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="SpecialInstruction" maxOccurs="99"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialInstructions implements Serializable
        {
            private List<String> specialInstructionList = new ArrayList<String>();

            /** 
             * Get the list of 'SpecialInstruction' element items. Used to specify a single special instruction.
             * 
             * @return list
             */
            public List<String> getSpecialInstructionList() {
                return specialInstructionList;
            }

            /** 
             * Set the list of 'SpecialInstruction' element items. Used to specify a single special instruction.
             * 
             * @param list
             */
            public void setSpecialInstructionList(List<String> list) {
                specialInstructionList = list;
            }
        }
        /** 
         * Used to pass payment information for the hotel booking.
                                                    Omit `PaymentInformation` entirely to pay later.
                                                    In the event the chosen hotel property does not support this, an error will be returned.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FormOfPayment">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="PaymentCard" minOccurs="0">
         *               &lt;!-- Reference to inner class PaymentCard -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="VirtualCard" minOccurs="0">
         *               &lt;!-- Reference to inner class VirtualCard -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Agency" minOccurs="0">
         *               &lt;!-- Reference to inner class Agency -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Corporate" minOccurs="0">
         *               &lt;!-- Reference to inner class Corporate -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Company" minOccurs="0">
         *               &lt;!-- Reference to inner class Company -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute name="Type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentInformation implements Serializable
        {
            private PaymentCard paymentCard;
            private VirtualCard virtualCard;
            private Agency agency;
            private Corporate corporate;
            private Company company;
            private Type type;

            /** 
             * Get the 'PaymentCard' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @return value
             */
            public PaymentCard getPaymentCard() {
                return paymentCard;
            }

            /** 
             * Set the 'PaymentCard' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @param paymentCard
             */
            public void setPaymentCard(PaymentCard paymentCard) {
                this.paymentCard = paymentCard;
            }

            /** 
             * Get the 'VirtualCard' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @return value
             */
            public VirtualCard getVirtualCard() {
                return virtualCard;
            }

            /** 
             * Set the 'VirtualCard' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @param virtualCard
             */
            public void setVirtualCard(VirtualCard virtualCard) {
                this.virtualCard = virtualCard;
            }

            /** 
             * Get the 'Agency' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @return value
             */
            public Agency getAgency() {
                return agency;
            }

            /** 
             * Set the 'Agency' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @param agency
             */
            public void setAgency(Agency agency) {
                this.agency = agency;
            }

            /** 
             * Get the 'Corporate' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @return value
             */
            public Corporate getCorporate() {
                return corporate;
            }

            /** 
             * Set the 'Corporate' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @param corporate
             */
            public void setCorporate(Corporate corporate) {
                this.corporate = corporate;
            }

            /** 
             * Get the 'Company' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @return value
             */
            public Company getCompany() {
                return company;
            }

            /** 
             * Set the 'Company' element value. Contains different forms of payment to pass for a hotel booking.
                                                                  Only one may be used at a time.
             * 
             * @param company
             */
            public void setCompany(Company company) {
                this.company = company;
            }

            /** 
             * Get the 'Type' attribute value. Identifies the form of payment type.
                                                              `DEPOSIT` can only be used with credit card, agency, or corporate.
                                                              `GUARANTEE` can only be used with credit card, agency, IATA, company, or corporate.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Identifies the form of payment type.
                                                              `DEPOSIT` can only be used with credit card, agency, or corporate.
                                                              `GUARANTEE` can only be used with credit card, agency, IATA, company, or corporate.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Used to pass the details of a payment card.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PaymentType">
             *         &lt;xs:simpleType>
             *           &lt;!-- Reference to inner class PaymentType -->
             *         &lt;/xs:simpleType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="CardCode"/>
             *       &lt;xs:element type="xs:string" name="CardNumber"/>
             *       &lt;xs:element type="xs:int" name="ExpiryMonth"/>
             *       &lt;xs:element type="xs:string" name="ExpiryYear"/>
             *       &lt;xs:element name="FullCardHolderName" minOccurs="0">
             *         &lt;!-- Reference to inner class FullCardHolderName -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="CSC" minOccurs="0"/>
             *       &lt;xs:element name="Address" minOccurs="0">
             *         &lt;!-- Reference to inner class Address -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Phone" minOccurs="0">
             *         &lt;!-- Reference to inner class Phone -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PaymentCard implements Serializable
            {
                private PaymentType paymentType;
                private String cardCode;
                private String cardNumber;
                private int expiryMonth;
                private String expiryYear;
                private FullCardHolderName fullCardHolderName;
                private String CSC;
                private Address address;
                private Phone phone;

                /** 
                 * Get the 'PaymentType' element value. Used to pass the payment type.
                                                                                            Acceptable values include:
                                                                                            `CC` - credit card.
                                                                                            `CA` - cash.
                                                                                            `CK` - check.
                 * 
                 * @return value
                 */
                public PaymentType getPaymentType() {
                    return paymentType;
                }

                /** 
                 * Set the 'PaymentType' element value. Used to pass the payment type.
                                                                                            Acceptable values include:
                                                                                            `CC` - credit card.
                                                                                            `CA` - cash.
                                                                                            `CK` - check.
                 * 
                 * @param paymentType
                 */
                public void setPaymentType(PaymentType paymentType) {
                    this.paymentType = paymentType;
                }

                /** 
                 * Get the 'CardCode' element value. The 2 character code of the credit card issuer.
                 * 
                 * @return value
                 */
                public String getCardCode() {
                    return cardCode;
                }

                /** 
                 * Set the 'CardCode' element value. The 2 character code of the credit card issuer.
                 * 
                 * @param cardCode
                 */
                public void setCardCode(String cardCode) {
                    this.cardCode = cardCode;
                }

                /** 
                 * Get the 'CardNumber' element value. The credit card number.
                 * 
                 * @return value
                 */
                public String getCardNumber() {
                    return cardNumber;
                }

                /** 
                 * Set the 'CardNumber' element value. The credit card number.
                 * 
                 * @param cardNumber
                 */
                public void setCardNumber(String cardNumber) {
                    this.cardNumber = cardNumber;
                }

                /** 
                 * Get the 'ExpiryMonth' element value. The credit card expiration month.
                 * 
                 * @return value
                 */
                public int getExpiryMonth() {
                    return expiryMonth;
                }

                /** 
                 * Set the 'ExpiryMonth' element value. The credit card expiration month.
                 * 
                 * @param expiryMonth
                 */
                public void setExpiryMonth(int expiryMonth) {
                    this.expiryMonth = expiryMonth;
                }

                /** 
                 * Get the 'ExpiryYear' element value. The 4 digit credit card expiration year.
                 * 
                 * @return value
                 */
                public String getExpiryYear() {
                    return expiryYear;
                }

                /** 
                 * Set the 'ExpiryYear' element value. The 4 digit credit card expiration year.
                 * 
                 * @param expiryYear
                 */
                public void setExpiryYear(String expiryYear) {
                    this.expiryYear = expiryYear;
                }

                /** 
                 * Get the 'FullCardHolderName' element value.
                 * 
                 * @return value
                 */
                public FullCardHolderName getFullCardHolderName() {
                    return fullCardHolderName;
                }

                /** 
                 * Set the 'FullCardHolderName' element value.
                 * 
                 * @param fullCardHolderName
                 */
                public void setFullCardHolderName(
                        FullCardHolderName fullCardHolderName) {
                    this.fullCardHolderName = fullCardHolderName;
                }

                /** 
                 * Get the 'CSC' element value. The card security code.
                 * 
                 * @return value
                 */
                public String getCSC() {
                    return CSC;
                }

                /** 
                 * Set the 'CSC' element value. The card security code.
                 * 
                 * @param CSC
                 */
                public void setCSC(String CSC) {
                    this.CSC = CSC;
                }

                /** 
                 * Get the 'Address' element value.
                 * 
                 * @return value
                 */
                public Address getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' element value.
                 * 
                 * @param address
                 */
                public void setAddress(Address address) {
                    this.address = address;
                }

                /** 
                 * Get the 'Phone' element value.
                 * 
                 * @return value
                 */
                public Phone getPhone() {
                    return phone;
                }

                /** 
                 * Set the 'Phone' element value.
                 * 
                 * @param phone
                 */
                public void setPhone(Phone phone) {
                    this.phone = phone;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="CC"/>
                 *     &lt;xs:enumeration value="CA"/>
                 *     &lt;xs:enumeration value="CK"/>
                 *     &lt;xs:enumeration value="MS"/>
                 *     &lt;xs:enumeration value="GR"/>
                 *     &lt;xs:enumeration value="SGR"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum PaymentType implements Serializable {
                    CC, CA, CK, MS, GR, SGR
                }
                /** 
                 * Used to pass card holder name details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FullCardHolderName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FirstName"/>
                 *       &lt;xs:element type="xs:string" name="LastName"/>
                 *       &lt;xs:element type="xs:string" name="Email" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FullCardHolderName implements Serializable
                {
                    private String title;
                    private String firstName;
                    private String lastName;
                    private String email;

                    /** 
                     * Get the 'Title' element value. The card holder name title.
                     * 
                     * @return value
                     */
                    public String getTitle() {
                        return title;
                    }

                    /** 
                     * Set the 'Title' element value. The card holder name title.
                     * 
                     * @param title
                     */
                    public void setTitle(String title) {
                        this.title = title;
                    }

                    /** 
                     * Get the 'FirstName' element value. The card holder first name.
                     * 
                     * @return value
                     */
                    public String getFirstName() {
                        return firstName;
                    }

                    /** 
                     * Set the 'FirstName' element value. The card holder first name.
                     * 
                     * @param firstName
                     */
                    public void setFirstName(String firstName) {
                        this.firstName = firstName;
                    }

                    /** 
                     * Get the 'LastName' element value. The card holder last name.
                     * 
                     * @return value
                     */
                    public String getLastName() {
                        return lastName;
                    }

                    /** 
                     * Set the 'LastName' element value. The card holder last name.
                     * 
                     * @param lastName
                     */
                    public void setLastName(String lastName) {
                        this.lastName = lastName;
                    }

                    /** 
                     * Get the 'Email' element value. Card holder email address.
                     * 
                     * @return value
                     */
                    public String getEmail() {
                        return email;
                    }

                    /** 
                     * Set the 'Email' element value. Card holder email address.
                     * 
                     * @param email
                     */
                    public void setEmail(String email) {
                        this.email = email;
                    }
                }
                /** 
                 * The card holder address.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="9"/>
                 *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
                 *       &lt;xs:element name="CityCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class CityCodes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StateProvince" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvince -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StateProvinceCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvinceCodes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
                 *       &lt;xs:element name="Country" minOccurs="0">
                 *         &lt;!-- Reference to inner class Country -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CountryCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class CountryCodes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Address implements Serializable
                {
                    private List<String> addressLineList = new ArrayList<String>();
                    private String cityName;
                    private CityCodes cityCodes;
                    private StateProvince stateProvince;
                    private StateProvinceCodes stateProvinceCodes;
                    private String postCode;
                    private Country country;
                    private CountryCodes countryCodes;

                    /** 
                     * Get the list of 'AddressLine' element items. Used to pass the address information of the card holder.
                     * 
                     * @return list
                     */
                    public List<String> getAddressLineList() {
                        return addressLineList;
                    }

                    /** 
                     * Set the list of 'AddressLine' element items. Used to pass the address information of the card holder.
                     * 
                     * @param list
                     */
                    public void setAddressLineList(List<String> list) {
                        addressLineList = list;
                    }

                    /** 
                     * Get the 'CityName' element value. The card holder address city name.
                     * 
                     * @return value
                     */
                    public String getCityName() {
                        return cityName;
                    }

                    /** 
                     * Set the 'CityName' element value. The card holder address city name.
                     * 
                     * @param cityName
                     */
                    public void setCityName(String cityName) {
                        this.cityName = cityName;
                    }

                    /** 
                     * Get the 'CityCodes' element value.
                     * 
                     * @return value
                     */
                    public CityCodes getCityCodes() {
                        return cityCodes;
                    }

                    /** 
                     * Set the 'CityCodes' element value.
                     * 
                     * @param cityCodes
                     */
                    public void setCityCodes(CityCodes cityCodes) {
                        this.cityCodes = cityCodes;
                    }

                    /** 
                     * Get the 'StateProvince' element value.
                     * 
                     * @return value
                     */
                    public StateProvince getStateProvince() {
                        return stateProvince;
                    }

                    /** 
                     * Set the 'StateProvince' element value.
                     * 
                     * @param stateProvince
                     */
                    public void setStateProvince(StateProvince stateProvince) {
                        this.stateProvince = stateProvince;
                    }

                    /** 
                     * Get the 'StateProvinceCodes' element value.
                     * 
                     * @return value
                     */
                    public StateProvinceCodes getStateProvinceCodes() {
                        return stateProvinceCodes;
                    }

                    /** 
                     * Set the 'StateProvinceCodes' element value.
                     * 
                     * @param stateProvinceCodes
                     */
                    public void setStateProvinceCodes(
                            StateProvinceCodes stateProvinceCodes) {
                        this.stateProvinceCodes = stateProvinceCodes;
                    }

                    /** 
                     * Get the 'PostCode' element value. The card holder postal code.
                     * 
                     * @return value
                     */
                    public String getPostCode() {
                        return postCode;
                    }

                    /** 
                     * Set the 'PostCode' element value. The card holder postal code.
                     * 
                     * @param postCode
                     */
                    public void setPostCode(String postCode) {
                        this.postCode = postCode;
                    }

                    /** 
                     * Get the 'Country' element value.
                     * 
                     * @return value
                     */
                    public Country getCountry() {
                        return country;
                    }

                    /** 
                     * Set the 'Country' element value.
                     * 
                     * @param country
                     */
                    public void setCountry(Country country) {
                        this.country = country;
                    }

                    /** 
                     * Get the 'CountryCodes' element value.
                     * 
                     * @return value
                     */
                    public CountryCodes getCountryCodes() {
                        return countryCodes;
                    }

                    /** 
                     * Set the 'CountryCodes' element value.
                     * 
                     * @param countryCodes
                     */
                    public void setCountryCodes(CountryCodes countryCodes) {
                        this.countryCodes = countryCodes;
                    }
                    /** 
                     * The card holder city codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CityCodes implements Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The card holder city code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                    /** 
                     * The card holder state or province information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvince" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvince implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The card holder state or province code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The card holder state or province code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple state or province codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvinceCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvinceCodes implements
                        Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The card holder state or province code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                    /** 
                     * The card holder country information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Country" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Country implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The card holder country code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The card holder country code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple country codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CountryCodes implements Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The card holder country code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                }
                /** 
                 * The card holder phone details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Phone" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="PhoneUseType" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="PhoneCountryCode" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="PhoneNumber"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Phone implements Serializable
                {
                    private String phoneUseType;
                    private String phoneCountryCode;
                    private String phoneNumber;

                    /** 
                     * Get the 'PhoneUseType' element value. The card holder phone use type.
                     * 
                     * @return value
                     */
                    public String getPhoneUseType() {
                        return phoneUseType;
                    }

                    /** 
                     * Set the 'PhoneUseType' element value. The card holder phone use type.
                     * 
                     * @param phoneUseType
                     */
                    public void setPhoneUseType(String phoneUseType) {
                        this.phoneUseType = phoneUseType;
                    }

                    /** 
                     * Get the 'PhoneCountryCode' element value. The card holder phone country code.
                     * 
                     * @return value
                     */
                    public String getPhoneCountryCode() {
                        return phoneCountryCode;
                    }

                    /** 
                     * Set the 'PhoneCountryCode' element value. The card holder phone country code.
                     * 
                     * @param phoneCountryCode
                     */
                    public void setPhoneCountryCode(String phoneCountryCode) {
                        this.phoneCountryCode = phoneCountryCode;
                    }

                    /** 
                     * Get the 'PhoneNumber' element value. The card holder phone number.
                     * 
                     * @return value
                     */
                    public String getPhoneNumber() {
                        return phoneNumber;
                    }

                    /** 
                     * Set the 'PhoneNumber' element value. The card holder phone number.
                     * 
                     * @param phoneNumber
                     */
                    public void setPhoneNumber(String phoneNumber) {
                        this.phoneNumber = phoneNumber;
                    }
                }
            }
            /** 
             * The virtual payment card details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VirtualCard" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CustomerAccountCode"/>
             *       &lt;xs:element name="Agency">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Email"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="HotelInfo">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Fax"/>
             *           &lt;xs:attribute type="xs:string" use="required" name="HotelName"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="RoomDescription" maxOccurs="10">
             *         &lt;!-- Reference to inner class RoomDescription -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RateInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class RateInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecialInstructions">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element type="xs:string" name="SpecialInstruction" maxOccurs="10"/>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VirtualCard implements Serializable
            {
                private String customerAccountCode;
                private String agency;
                private String hotelInfoFax;
                private String hotelInfoHotelName;
                private List<RoomDescription> roomDescriptionList = new ArrayList<RoomDescription>();
                private RateInfo rateInfo;
                private List<String> specialInstructionList = new ArrayList<String>();

                /** 
                 * Get the 'CustomerAccountCode' element value. The customer account code.
                 * 
                 * @return value
                 */
                public String getCustomerAccountCode() {
                    return customerAccountCode;
                }

                /** 
                 * Set the 'CustomerAccountCode' element value. The customer account code.
                 * 
                 * @param customerAccountCode
                 */
                public void setCustomerAccountCode(String customerAccountCode) {
                    this.customerAccountCode = customerAccountCode;
                }

                /** 
                 * Get the 'Email' attribute value.
                 * 
                 * @return value
                 */
                public String getAgency() {
                    return agency;
                }

                /** 
                 * Set the 'Email' attribute value.
                 * 
                 * @param agency
                 */
                public void setAgency(String agency) {
                    this.agency = agency;
                }

                /** 
                 * Get the 'Fax' attribute value.
                 * 
                 * @return value
                 */
                public String getHotelInfoFax() {
                    return hotelInfoFax;
                }

                /** 
                 * Set the 'Fax' attribute value.
                 * 
                 * @param hotelInfoFax
                 */
                public void setHotelInfoFax(String hotelInfoFax) {
                    this.hotelInfoFax = hotelInfoFax;
                }

                /** 
                 * Get the 'HotelName' attribute value.
                 * 
                 * @return value
                 */
                public String getHotelInfoHotelName() {
                    return hotelInfoHotelName;
                }

                /** 
                 * Set the 'HotelName' attribute value.
                 * 
                 * @param hotelInfoHotelName
                 */
                public void setHotelInfoHotelName(String hotelInfoHotelName) {
                    this.hotelInfoHotelName = hotelInfoHotelName;
                }

                /** 
                 * Get the list of 'RoomDescription' element items.
                 * 
                 * @return list
                 */
                public List<RoomDescription> getRoomDescriptionList() {
                    return roomDescriptionList;
                }

                /** 
                 * Set the list of 'RoomDescription' element items.
                 * 
                 * @param list
                 */
                public void setRoomDescriptionList(List<RoomDescription> list) {
                    roomDescriptionList = list;
                }

                /** 
                 * Get the 'RateInfo' element value.
                 * 
                 * @return value
                 */
                public RateInfo getRateInfo() {
                    return rateInfo;
                }

                /** 
                 * Set the 'RateInfo' element value.
                 * 
                 * @param rateInfo
                 */
                public void setRateInfo(RateInfo rateInfo) {
                    this.rateInfo = rateInfo;
                }

                /** 
                 * Get the list of 'SpecialInstruction' element items. 
                                                                                                        Used to inform the hotel about any extra charges that can be covered by the virtual card.
                                                                                                        If the card is used to cover room only please pass "Room Only" value.
                                                                                                    
                 * 
                 * @return list
                 */
                public List<String> getSpecialInstructionList() {
                    return specialInstructionList;
                }

                /** 
                 * Set the list of 'SpecialInstruction' element items. 
                                                                                                        Used to inform the hotel about any extra charges that can be covered by the virtual card.
                                                                                                        If the card is used to cover room only please pass "Room Only" value.
                                                                                                    
                 * 
                 * @param list
                 */
                public void setSpecialInstructionList(List<String> list) {
                    specialInstructionList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomDescription" maxOccurs="10">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RoomDescription implements Serializable
                {
                    private String text;
                    private String name;

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'Name' attribute value.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" name="AmountAfterTax"/>
                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RateInfo implements Serializable
                {
                    private BigDecimal amountAfterTax;
                    private String currencyCode;

                    /** 
                     * Get the 'AmountAfterTax' attribute value. Total amount for the booking. Please pass the value obtained from HotelPriceCheckRS/PriceCheckInfo/HotelRateInfo/RateInfos/RateInfo/@AmountAfterTax
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountAfterTax() {
                        return amountAfterTax;
                    }

                    /** 
                     * Set the 'AmountAfterTax' attribute value. Total amount for the booking. Please pass the value obtained from HotelPriceCheckRS/PriceCheckInfo/HotelRateInfo/RateInfos/RateInfo/@AmountAfterTax
                     * 
                     * @param amountAfterTax
                     */
                    public void setAmountAfterTax(BigDecimal amountAfterTax) {
                        this.amountAfterTax = amountAfterTax;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. Currency code. Please pass the value obtained from HotelPriceCheckRS/PriceCheckInfo/HotelRateInfo/RateInfos/RateInfo/@CurrencyCode
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. Currency code. Please pass the value obtained from HotelPriceCheckRS/PriceCheckInfo/HotelRateInfo/RateInfos/RateInfo/@CurrencyCode
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }
                }
            }
            /** 
             * Used to pass agency form of payment information.
                                                                              There are two options for Agency form of payment:
                                                                              `1.` - Both 'Name' and 'Address'.
                                                                              `2.` - Only the 'IATANumber'.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Agency" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
             *       &lt;xs:element name="Address" minOccurs="0">
             *         &lt;!-- Reference to inner class Address -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="IATANumber" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Agency implements Serializable
            {
                private String name;
                private Address address;
                private String IATANumber;

                /** 
                 * Get the 'Name' element value. The agency name.
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. The agency name.
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'Address' element value.
                 * 
                 * @return value
                 */
                public Address getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' element value.
                 * 
                 * @param address
                 */
                public void setAddress(Address address) {
                    this.address = address;
                }

                /** 
                 * Get the 'IATANumber' element value. The agency IATA number.
                 * 
                 * @return value
                 */
                public String getIATANumber() {
                    return IATANumber;
                }

                /** 
                 * Set the 'IATANumber' element value. The agency IATA number.
                 * 
                 * @param IATANumber
                 */
                public void setIATANumber(String IATANumber) {
                    this.IATANumber = IATANumber;
                }
                /** 
                 * The agency address information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="9"/>
                 *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
                 *       &lt;xs:element name="StateProvince" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvince -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StateProvinceCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvinceCodes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
                 *       &lt;xs:element name="Country" minOccurs="0">
                 *         &lt;!-- Reference to inner class Country -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CountryCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class CountryCodes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Address implements Serializable
                {
                    private List<String> addressLineList = new ArrayList<String>();
                    private String cityName;
                    private StateProvince stateProvince;
                    private StateProvinceCodes stateProvinceCodes;
                    private String postCode;
                    private Country country;
                    private CountryCodes countryCodes;

                    /** 
                     * Get the list of 'AddressLine' element items. The address information of the agency.
                     * 
                     * @return list
                     */
                    public List<String> getAddressLineList() {
                        return addressLineList;
                    }

                    /** 
                     * Set the list of 'AddressLine' element items. The address information of the agency.
                     * 
                     * @param list
                     */
                    public void setAddressLineList(List<String> list) {
                        addressLineList = list;
                    }

                    /** 
                     * Get the 'CityName' element value. The agency address city name.
                     * 
                     * @return value
                     */
                    public String getCityName() {
                        return cityName;
                    }

                    /** 
                     * Set the 'CityName' element value. The agency address city name.
                     * 
                     * @param cityName
                     */
                    public void setCityName(String cityName) {
                        this.cityName = cityName;
                    }

                    /** 
                     * Get the 'StateProvince' element value.
                     * 
                     * @return value
                     */
                    public StateProvince getStateProvince() {
                        return stateProvince;
                    }

                    /** 
                     * Set the 'StateProvince' element value.
                     * 
                     * @param stateProvince
                     */
                    public void setStateProvince(StateProvince stateProvince) {
                        this.stateProvince = stateProvince;
                    }

                    /** 
                     * Get the 'StateProvinceCodes' element value.
                     * 
                     * @return value
                     */
                    public StateProvinceCodes getStateProvinceCodes() {
                        return stateProvinceCodes;
                    }

                    /** 
                     * Set the 'StateProvinceCodes' element value.
                     * 
                     * @param stateProvinceCodes
                     */
                    public void setStateProvinceCodes(
                            StateProvinceCodes stateProvinceCodes) {
                        this.stateProvinceCodes = stateProvinceCodes;
                    }

                    /** 
                     * Get the 'PostCode' element value. The agency postal code.
                     * 
                     * @return value
                     */
                    public String getPostCode() {
                        return postCode;
                    }

                    /** 
                     * Set the 'PostCode' element value. The agency postal code.
                     * 
                     * @param postCode
                     */
                    public void setPostCode(String postCode) {
                        this.postCode = postCode;
                    }

                    /** 
                     * Get the 'Country' element value.
                     * 
                     * @return value
                     */
                    public Country getCountry() {
                        return country;
                    }

                    /** 
                     * Set the 'Country' element value.
                     * 
                     * @param country
                     */
                    public void setCountry(Country country) {
                        this.country = country;
                    }

                    /** 
                     * Get the 'CountryCodes' element value.
                     * 
                     * @return value
                     */
                    public CountryCodes getCountryCodes() {
                        return countryCodes;
                    }

                    /** 
                     * Set the 'CountryCodes' element value.
                     * 
                     * @param countryCodes
                     */
                    public void setCountryCodes(CountryCodes countryCodes) {
                        this.countryCodes = countryCodes;
                    }
                    /** 
                     * The agency state or province information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvince" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvince implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The agency state or province code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The agency state or province code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple state or province codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvinceCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvinceCodes implements
                        Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The agency state or province code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                    /** 
                     * The agency country information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Country" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Country implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The agency country code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The agency country code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple country codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CountryCodes implements Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The agency country code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                }
            }
            /** 
             * The Corporate form of payment details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CorporateId"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Corporate implements Serializable
            {
                private String corporateId;

                /** 
                 * Get the 'CorporateId' element value. The corporate identifier.
                 * 
                 * @return value
                 */
                public String getCorporateId() {
                    return corporateId;
                }

                /** 
                 * Set the 'CorporateId' element value. The corporate identifier.
                 * 
                 * @param corporateId
                 */
                public void setCorporateId(String corporateId) {
                    this.corporateId = corporateId;
                }
            }
            /** 
             * Used to pass the company form of payment details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Company" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
             *       &lt;xs:element name="Address" minOccurs="0">
             *         &lt;!-- Reference to inner class Address -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Company implements Serializable
            {
                private String name;
                private Address address;

                /** 
                 * Get the 'Name' element value. The company name.
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. The company name.
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'Address' element value.
                 * 
                 * @return value
                 */
                public Address getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' element value.
                 * 
                 * @param address
                 */
                public void setAddress(Address address) {
                    this.address = address;
                }
                /** 
                 * The company address.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="9"/>
                 *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
                 *       &lt;xs:element name="CityCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class CityCodes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StateProvince" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvince -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StateProvinceCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class StateProvinceCodes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
                 *       &lt;xs:element name="Country" minOccurs="0">
                 *         &lt;!-- Reference to inner class Country -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CountryCodes" minOccurs="0">
                 *         &lt;!-- Reference to inner class CountryCodes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Address implements Serializable
                {
                    private List<String> addressLineList = new ArrayList<String>();
                    private String cityName;
                    private CityCodes cityCodes;
                    private StateProvince stateProvince;
                    private StateProvinceCodes stateProvinceCodes;
                    private String postCode;
                    private Country country;
                    private CountryCodes countryCodes;

                    /** 
                     * Get the list of 'AddressLine' element items. The address information of the company.
                     * 
                     * @return list
                     */
                    public List<String> getAddressLineList() {
                        return addressLineList;
                    }

                    /** 
                     * Set the list of 'AddressLine' element items. The address information of the company.
                     * 
                     * @param list
                     */
                    public void setAddressLineList(List<String> list) {
                        addressLineList = list;
                    }

                    /** 
                     * Get the 'CityName' element value. The company address city name.
                     * 
                     * @return value
                     */
                    public String getCityName() {
                        return cityName;
                    }

                    /** 
                     * Set the 'CityName' element value. The company address city name.
                     * 
                     * @param cityName
                     */
                    public void setCityName(String cityName) {
                        this.cityName = cityName;
                    }

                    /** 
                     * Get the 'CityCodes' element value.
                     * 
                     * @return value
                     */
                    public CityCodes getCityCodes() {
                        return cityCodes;
                    }

                    /** 
                     * Set the 'CityCodes' element value.
                     * 
                     * @param cityCodes
                     */
                    public void setCityCodes(CityCodes cityCodes) {
                        this.cityCodes = cityCodes;
                    }

                    /** 
                     * Get the 'StateProvince' element value.
                     * 
                     * @return value
                     */
                    public StateProvince getStateProvince() {
                        return stateProvince;
                    }

                    /** 
                     * Set the 'StateProvince' element value.
                     * 
                     * @param stateProvince
                     */
                    public void setStateProvince(StateProvince stateProvince) {
                        this.stateProvince = stateProvince;
                    }

                    /** 
                     * Get the 'StateProvinceCodes' element value.
                     * 
                     * @return value
                     */
                    public StateProvinceCodes getStateProvinceCodes() {
                        return stateProvinceCodes;
                    }

                    /** 
                     * Set the 'StateProvinceCodes' element value.
                     * 
                     * @param stateProvinceCodes
                     */
                    public void setStateProvinceCodes(
                            StateProvinceCodes stateProvinceCodes) {
                        this.stateProvinceCodes = stateProvinceCodes;
                    }

                    /** 
                     * Get the 'PostCode' element value. The company postal code.
                     * 
                     * @return value
                     */
                    public String getPostCode() {
                        return postCode;
                    }

                    /** 
                     * Set the 'PostCode' element value. The company postal code.
                     * 
                     * @param postCode
                     */
                    public void setPostCode(String postCode) {
                        this.postCode = postCode;
                    }

                    /** 
                     * Get the 'Country' element value.
                     * 
                     * @return value
                     */
                    public Country getCountry() {
                        return country;
                    }

                    /** 
                     * Set the 'Country' element value.
                     * 
                     * @param country
                     */
                    public void setCountry(Country country) {
                        this.country = country;
                    }

                    /** 
                     * Get the 'CountryCodes' element value.
                     * 
                     * @return value
                     */
                    public CountryCodes getCountryCodes() {
                        return countryCodes;
                    }

                    /** 
                     * Set the 'CountryCodes' element value.
                     * 
                     * @param countryCodes
                     */
                    public void setCountryCodes(CountryCodes countryCodes) {
                        this.countryCodes = countryCodes;
                    }
                    /** 
                     * The company city codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CityCodes implements Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The company city code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                    /** 
                     * The company state or province information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvince" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvince implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The company state or province code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The company state or province code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple state or province codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvinceCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StateProvinceCodes implements
                        Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The company state or province code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                    /** 
                     * The company country information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Country" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Country implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'code' attribute value. The company country code.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. The company country code.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Used to pass multiple country codes.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Code" maxOccurs="99">
                     *         &lt;!-- Reference to inner class Code -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CountryCodes implements Serializable
                    {
                        private List<Code> codeList = new ArrayList<Code>();

                        /** 
                         * Get the list of 'Code' element items.
                         * 
                         * @return list
                         */
                        public List<Code> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<Code> list) {
                            codeList = list;
                        }
                        /** 
                         * The company country code.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="99">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Code implements Serializable
                        {
                            private String string;
                            private String codeContext;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @return value
                             */
                            public String getCodeContext() {
                                return codeContext;
                            }

                            /** 
                             * Set the 'codeContext' attribute value. Used to pass the source authority of the code.
                                                                                                                                          Usually it is `IATA`.
                             * 
                             * @param codeContext
                             */
                            public void setCodeContext(String codeContext) {
                                this.codeContext = codeContext;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="DEPOSIT"/>
             *     &lt;xs:enumeration value="GUARANTEE"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                DEPOSIT, GUARANTEE
            }
        }
        /** 
         * The point of sale information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="RequestorID">
         *               &lt;xs:complexType>
         *                 &lt;xs:attribute type="xs:int" name="Type"/>
         *                 &lt;xs:attribute type="xs:string" name="Id"/>
         *                 &lt;xs:attribute type="xs:string" name="IdContext"/>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element name="AgencyAddress" minOccurs="0">
         *               &lt;!-- Reference to inner class AgencyAddress -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="AgencyContact" minOccurs="0">
         *               &lt;!-- Reference to inner class AgencyContact -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *           &lt;xs:attribute type="xs:string" name="AgencyName"/>
         *           &lt;xs:attribute type="xs:string" name="ISOCountryCode"/>
         *           &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class POS implements Serializable
        {
            private Integer sourceRequestorIDType;
            private String sourceRequestorIDId;
            private String sourceRequestorIDIdContext;
            private AgencyAddress agencyAddress;
            private AgencyContact agencyContact;
            private String sourceAgencyName;
            private String sourceISOCountryCode;
            private String sourcePseudoCityCode;

            /** 
             * Get the 'Type' attribute value. The IATA identifier type.
                                                                                      Taken from OTA UIT table.
                                                                                      Use value `5` for travel agency.
             * 
             * @return value
             */
            public Integer getSourceRequestorIDType() {
                return sourceRequestorIDType;
            }

            /** 
             * Set the 'Type' attribute value. The IATA identifier type.
                                                                                      Taken from OTA UIT table.
                                                                                      Use value `5` for travel agency.
             * 
             * @param sourceRequestorIDType
             */
            public void setSourceRequestorIDType(Integer sourceRequestorIDType) {
                this.sourceRequestorIDType = sourceRequestorIDType;
            }

            /** 
             * Get the 'Id' attribute value. The agency IATA identifier.
             * 
             * @return value
             */
            public String getSourceRequestorIDId() {
                return sourceRequestorIDId;
            }

            /** 
             * Set the 'Id' attribute value. The agency IATA identifier.
             * 
             * @param sourceRequestorIDId
             */
            public void setSourceRequestorIDId(String sourceRequestorIDId) {
                this.sourceRequestorIDId = sourceRequestorIDId;
            }

            /** 
             * Get the 'IdContext' attribute value. Used to pass the source authority of the code.
                                                                                      Usually it is `IATA`.
             * 
             * @return value
             */
            public String getSourceRequestorIDIdContext() {
                return sourceRequestorIDIdContext;
            }

            /** 
             * Set the 'IdContext' attribute value. Used to pass the source authority of the code.
                                                                                      Usually it is `IATA`.
             * 
             * @param sourceRequestorIDIdContext
             */
            public void setSourceRequestorIDIdContext(
                    String sourceRequestorIDIdContext) {
                this.sourceRequestorIDIdContext = sourceRequestorIDIdContext;
            }

            /** 
             * Get the 'AgencyAddress' element value. The point of sale details.
             * 
             * @return value
             */
            public AgencyAddress getAgencyAddress() {
                return agencyAddress;
            }

            /** 
             * Set the 'AgencyAddress' element value. The point of sale details.
             * 
             * @param agencyAddress
             */
            public void setAgencyAddress(AgencyAddress agencyAddress) {
                this.agencyAddress = agencyAddress;
            }

            /** 
             * Get the 'AgencyContact' element value. The point of sale details.
             * 
             * @return value
             */
            public AgencyContact getAgencyContact() {
                return agencyContact;
            }

            /** 
             * Set the 'AgencyContact' element value. The point of sale details.
             * 
             * @param agencyContact
             */
            public void setAgencyContact(AgencyContact agencyContact) {
                this.agencyContact = agencyContact;
            }

            /** 
             * Get the 'AgencyName' attribute value. The agency name.
             * 
             * @return value
             */
            public String getSourceAgencyName() {
                return sourceAgencyName;
            }

            /** 
             * Set the 'AgencyName' attribute value. The agency name.
             * 
             * @param sourceAgencyName
             */
            public void setSourceAgencyName(String sourceAgencyName) {
                this.sourceAgencyName = sourceAgencyName;
            }

            /** 
             * Get the 'ISOCountryCode' attribute value. The agency ISO country code.
             * 
             * @return value
             */
            public String getSourceISOCountryCode() {
                return sourceISOCountryCode;
            }

            /** 
             * Set the 'ISOCountryCode' attribute value. The agency ISO country code.
             * 
             * @param sourceISOCountryCode
             */
            public void setSourceISOCountryCode(String sourceISOCountryCode) {
                this.sourceISOCountryCode = sourceISOCountryCode;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value. The agency pseudo city code.
             * 
             * @return value
             */
            public String getSourcePseudoCityCode() {
                return sourcePseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value. The agency pseudo city code.
             * 
             * @param sourcePseudoCityCode
             */
            public void setSourcePseudoCityCode(String sourcePseudoCityCode) {
                this.sourcePseudoCityCode = sourcePseudoCityCode;
            }
            /** 
             * Used to pass the agency address information.
                                                                              It is mandatory for GDS booking.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyAddress" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AddressLine1"/>
             *       &lt;xs:element type="xs:string" name="AddressLine2" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="AddressLine3" minOccurs="0"/>
             *       &lt;xs:element name="CityName" minOccurs="0">
             *         &lt;!-- Reference to inner class CityName -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="StateProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="CountryName">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgencyAddress implements Serializable
            {
                private String addressLine1;
                private String addressLine2;
                private String addressLine3;
                private CityName cityName;
                private StateProv stateProv;
                private String postalCode;
                private String countryNameString;
                private String countryNameCode;

                /** 
                 * Get the 'AddressLine1' element value. The first agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine1() {
                    return addressLine1;
                }

                /** 
                 * Set the 'AddressLine1' element value. The first agency address line.
                 * 
                 * @param addressLine1
                 */
                public void setAddressLine1(String addressLine1) {
                    this.addressLine1 = addressLine1;
                }

                /** 
                 * Get the 'AddressLine2' element value. The second agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine2() {
                    return addressLine2;
                }

                /** 
                 * Set the 'AddressLine2' element value. The second agency address line.
                 * 
                 * @param addressLine2
                 */
                public void setAddressLine2(String addressLine2) {
                    this.addressLine2 = addressLine2;
                }

                /** 
                 * Get the 'AddressLine3' element value. The third agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine3() {
                    return addressLine3;
                }

                /** 
                 * Set the 'AddressLine3' element value. The third agency address line.
                 * 
                 * @param addressLine3
                 */
                public void setAddressLine3(String addressLine3) {
                    this.addressLine3 = addressLine3;
                }

                /** 
                 * Get the 'CityName' element value.
                 * 
                 * @return value
                 */
                public CityName getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value.
                 * 
                 * @param cityName
                 */
                public void setCityName(CityName cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'StateProv' element value.
                 * 
                 * @return value
                 */
                public StateProv getStateProv() {
                    return stateProv;
                }

                /** 
                 * Set the 'StateProv' element value.
                 * 
                 * @param stateProv
                 */
                public void setStateProv(StateProv stateProv) {
                    this.stateProv = stateProv;
                }

                /** 
                 * Get the 'PostalCode' element value. The agency postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. The agency postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getCountryNameString() {
                    return countryNameString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param countryNameString
                 */
                public void setCountryNameString(String countryNameString) {
                    this.countryNameString = countryNameString;
                }

                /** 
                 * Get the 'Code' attribute value. The 2-character agency country code.
                 * 
                 * @return value
                 */
                public String getCountryNameCode() {
                    return countryNameCode;
                }

                /** 
                 * Set the 'Code' attribute value. The 2-character agency country code.
                 * 
                 * @param countryNameCode
                 */
                public void setCountryNameCode(String countryNameCode) {
                    this.countryNameCode = countryNameCode;
                }
                /** 
                 * The agency city name.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="CityCode"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CityName implements Serializable
                {
                    private String string;
                    private String cityCode;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'CityCode' attribute value. The agency city code.
                     * 
                     * @return value
                     */
                    public String getCityCode() {
                        return cityCode;
                    }

                    /** 
                     * Set the 'CityCode' attribute value. The agency city code.
                     * 
                     * @param cityCode
                     */
                    public void setCityCode(String cityCode) {
                        this.cityCode = cityCode;
                    }
                }
                /** 
                 * The agency state or province name.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="StateCode"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateProv implements Serializable
                {
                    private String string;
                    private String stateCode;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'StateCode' attribute value. The agency state or province code.
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. The agency state or province code.
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
            }
            /** 
             * The agency contact information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyContact" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Phone"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="Mobile"/>
             *     &lt;xs:attribute type="xs:string" name="Fax"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgencyContact implements Serializable
            {
                private String phone;
                private String mobile;
                private String fax;

                /** 
                 * Get the 'Phone' attribute value. The agency phone number.
                 * 
                 * @return value
                 */
                public String getPhone() {
                    return phone;
                }

                /** 
                 * Set the 'Phone' attribute value. The agency phone number.
                 * 
                 * @param phone
                 */
                public void setPhone(String phone) {
                    this.phone = phone;
                }

                /** 
                 * Get the 'Mobile' attribute value. The agency mobile phone number.
                 * 
                 * @return value
                 */
                public String getMobile() {
                    return mobile;
                }

                /** 
                 * Set the 'Mobile' attribute value. The agency mobile phone number.
                 * 
                 * @param mobile
                 */
                public void setMobile(String mobile) {
                    this.mobile = mobile;
                }

                /** 
                 * Get the 'Fax' attribute value. The agency fax number.
                 * 
                 * @return value
                 */
                public String getFax() {
                    return fax;
                }

                /** 
                 * Set the 'Fax' attribute value. The agency fax number.
                 * 
                 * @param fax
                 */
                public void setFax(String fax) {
                    this.fax = fax;
                }
            }
        }
    }
    /** 
     * This element is used to book vehicles
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleBook" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Customer" minOccurs="0">
     *         &lt;!-- Reference to inner class Customer -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="POS" minOccurs="0">
     *         &lt;!-- Reference to inner class POS -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RatePrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class RatePrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RentalPaymentPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class RentalPaymentPrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CarExtrasPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class CarExtrasPrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialPrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="VehPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class VehPrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="VehRentalCore">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="PickUpLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class PickUpLocation -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="ReturnLocation" minOccurs="0">
     *               &lt;!-- Reference to inner class ReturnLocation -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:integer" name="InsertAfter"/>
     *           &lt;xs:attribute type="xs:date" name="PickUpDate"/>
     *           &lt;xs:attribute type="xs:string" name="PickUpTime"/>
     *           &lt;xs:attribute type="xs:integer" name="Quantity"/>
     *           &lt;xs:attribute type="xs:date" name="ReturnDate"/>
     *           &lt;xs:attribute type="xs:string" name="ReturnTime"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="VendorPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class VendorPrefs -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VehicleBook implements Serializable
    {
        private Customer customer;
        private POS POS1;
        private RatePrefs ratePrefs;
        private RentalPaymentPrefs rentalPaymentPrefs;
        private CarExtrasPrefs carExtrasPrefs;
        private SpecialPrefs specialPrefs;
        private VehPrefs vehPrefs;
        private PickUpLocation pickUpLocation;
        private ReturnLocation returnLocation;
        private BigInteger vehRentalCoreInsertAfter;
        private Date vehRentalCorePickUpDate;
        private String vehRentalCorePickUpTime;
        private BigInteger vehRentalCoreQuantity;
        private Date vehRentalCoreReturnDate;
        private String vehRentalCoreReturnTime;
        private VendorPrefs vendorPrefs;

        /** 
         * Get the 'Customer' element value.
         * 
         * @return value
         */
        public Customer getCustomer() {
            return customer;
        }

        /** 
         * Set the 'Customer' element value.
         * 
         * @param customer
         */
        public void setCustomer(Customer customer) {
            this.customer = customer;
        }

        /** 
         * Get the 'POS' element value.
         * 
         * @return value
         */
        public POS getPOS1() {
            return POS1;
        }

        /** 
         * Set the 'POS' element value.
         * 
         * @param POS1
         */
        public void setPOS1(POS POS1) {
            this.POS1 = POS1;
        }

        /** 
         * Get the 'RatePrefs' element value.
         * 
         * @return value
         */
        public RatePrefs getRatePrefs() {
            return ratePrefs;
        }

        /** 
         * Set the 'RatePrefs' element value.
         * 
         * @param ratePrefs
         */
        public void setRatePrefs(RatePrefs ratePrefs) {
            this.ratePrefs = ratePrefs;
        }

        /** 
         * Get the 'RentalPaymentPrefs' element value.
         * 
         * @return value
         */
        public RentalPaymentPrefs getRentalPaymentPrefs() {
            return rentalPaymentPrefs;
        }

        /** 
         * Set the 'RentalPaymentPrefs' element value.
         * 
         * @param rentalPaymentPrefs
         */
        public void setRentalPaymentPrefs(RentalPaymentPrefs rentalPaymentPrefs) {
            this.rentalPaymentPrefs = rentalPaymentPrefs;
        }

        /** 
         * Get the 'CarExtrasPrefs' element value.
         * 
         * @return value
         */
        public CarExtrasPrefs getCarExtrasPrefs() {
            return carExtrasPrefs;
        }

        /** 
         * Set the 'CarExtrasPrefs' element value.
         * 
         * @param carExtrasPrefs
         */
        public void setCarExtrasPrefs(CarExtrasPrefs carExtrasPrefs) {
            this.carExtrasPrefs = carExtrasPrefs;
        }

        /** 
         * Get the 'SpecialPrefs' element value.
         * 
         * @return value
         */
        public SpecialPrefs getSpecialPrefs() {
            return specialPrefs;
        }

        /** 
         * Set the 'SpecialPrefs' element value.
         * 
         * @param specialPrefs
         */
        public void setSpecialPrefs(SpecialPrefs specialPrefs) {
            this.specialPrefs = specialPrefs;
        }

        /** 
         * Get the 'VehPrefs' element value.
         * 
         * @return value
         */
        public VehPrefs getVehPrefs() {
            return vehPrefs;
        }

        /** 
         * Set the 'VehPrefs' element value.
         * 
         * @param vehPrefs
         */
        public void setVehPrefs(VehPrefs vehPrefs) {
            this.vehPrefs = vehPrefs;
        }

        /** 
         * Get the 'PickUpLocation' element value. Used to pass basic vehicle booking details.
         * 
         * @return value
         */
        public PickUpLocation getPickUpLocation() {
            return pickUpLocation;
        }

        /** 
         * Set the 'PickUpLocation' element value. Used to pass basic vehicle booking details.
         * 
         * @param pickUpLocation
         */
        public void setPickUpLocation(PickUpLocation pickUpLocation) {
            this.pickUpLocation = pickUpLocation;
        }

        /** 
         * Get the 'ReturnLocation' element value. Used to pass basic vehicle booking details.
         * 
         * @return value
         */
        public ReturnLocation getReturnLocation() {
            return returnLocation;
        }

        /** 
         * Set the 'ReturnLocation' element value. Used to pass basic vehicle booking details.
         * 
         * @param returnLocation
         */
        public void setReturnLocation(ReturnLocation returnLocation) {
            this.returnLocation = returnLocation;
        }

        /** 
         * Get the 'InsertAfter' attribute value. Used to specify an existing segment to place the new car segment after.
         * 
         * @return value
         */
        public BigInteger getVehRentalCoreInsertAfter() {
            return vehRentalCoreInsertAfter;
        }

        /** 
         * Set the 'InsertAfter' attribute value. Used to specify an existing segment to place the new car segment after.
         * 
         * @param vehRentalCoreInsertAfter
         */
        public void setVehRentalCoreInsertAfter(
                BigInteger vehRentalCoreInsertAfter) {
            this.vehRentalCoreInsertAfter = vehRentalCoreInsertAfter;
        }

        /** 
         * Get the 'PickUpDate' attribute value. Used to specify the rental pickup date, follows this format: YYYY-MM-DD
         * 
         * @return value
         */
        public Date getVehRentalCorePickUpDate() {
            return vehRentalCorePickUpDate;
        }

        /** 
         * Set the 'PickUpDate' attribute value. Used to specify the rental pickup date, follows this format: YYYY-MM-DD
         * 
         * @param vehRentalCorePickUpDate
         */
        public void setVehRentalCorePickUpDate(Date vehRentalCorePickUpDate) {
            this.vehRentalCorePickUpDate = vehRentalCorePickUpDate;
        }

        /** 
         * Get the 'PickUpTime' attribute value. Used to specify the rental pickup time, follows this format: HH:MM
         * 
         * @return value
         */
        public String getVehRentalCorePickUpTime() {
            return vehRentalCorePickUpTime;
        }

        /** 
         * Set the 'PickUpTime' attribute value. Used to specify the rental pickup time, follows this format: HH:MM
         * 
         * @param vehRentalCorePickUpTime
         */
        public void setVehRentalCorePickUpTime(String vehRentalCorePickUpTime) {
            this.vehRentalCorePickUpTime = vehRentalCorePickUpTime;
        }

        /** 
         * Get the 'Quantity' attribute value. Used to specify the number of vehicles being requested if applicable.
         * 
         * @return value
         */
        public BigInteger getVehRentalCoreQuantity() {
            return vehRentalCoreQuantity;
        }

        /** 
         * Set the 'Quantity' attribute value. Used to specify the number of vehicles being requested if applicable.
         * 
         * @param vehRentalCoreQuantity
         */
        public void setVehRentalCoreQuantity(BigInteger vehRentalCoreQuantity) {
            this.vehRentalCoreQuantity = vehRentalCoreQuantity;
        }

        /** 
         * Get the 'ReturnDate' attribute value. Used to specify the rental return date, follows this format: YYYY-MM-DD
         * 
         * @return value
         */
        public Date getVehRentalCoreReturnDate() {
            return vehRentalCoreReturnDate;
        }

        /** 
         * Set the 'ReturnDate' attribute value. Used to specify the rental return date, follows this format: YYYY-MM-DD
         * 
         * @param vehRentalCoreReturnDate
         */
        public void setVehRentalCoreReturnDate(Date vehRentalCoreReturnDate) {
            this.vehRentalCoreReturnDate = vehRentalCoreReturnDate;
        }

        /** 
         * Get the 'ReturnTime' attribute value. Used to specify the rental return time, follows this format: HH:MM
         * 
         * @return value
         */
        public String getVehRentalCoreReturnTime() {
            return vehRentalCoreReturnTime;
        }

        /** 
         * Set the 'ReturnTime' attribute value. Used to specify the rental return time, follows this format: HH:MM
         * 
         * @param vehRentalCoreReturnTime
         */
        public void setVehRentalCoreReturnTime(String vehRentalCoreReturnTime) {
            this.vehRentalCoreReturnTime = vehRentalCoreReturnTime;
        }

        /** 
         * Get the 'VendorPrefs' element value.
         * 
         * @return value
         */
        public VendorPrefs getVendorPrefs() {
            return vendorPrefs;
        }

        /** 
         * Set the 'VendorPrefs' element value.
         * 
         * @param vendorPrefs
         */
        public void setVendorPrefs(VendorPrefs vendorPrefs) {
            this.vendorPrefs = vendorPrefs;
        }
        /** 
         * Customer
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Address" minOccurs="0">
         *         &lt;!-- Reference to inner class Address -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Billing" minOccurs="0">
         *         &lt;!-- Reference to inner class Billing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CollectionAddress" minOccurs="0">
         *         &lt;!-- Reference to inner class CollectionAddress -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DeliveryAddress" minOccurs="0">
         *         &lt;!-- Reference to inner class DeliveryAddress -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FaxOrEmail" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Customer implements Serializable
        {
            private Address address;
            private Billing billing;
            private CollectionAddress collectionAddress;
            private DeliveryAddress deliveryAddress;
            private String faxOrEmail;
            private String nameNumber;

            /** 
             * Get the 'Address' element value.
             * 
             * @return value
             */
            public Address getAddress() {
                return address;
            }

            /** 
             * Set the 'Address' element value.
             * 
             * @param address
             */
            public void setAddress(Address address) {
                this.address = address;
            }

            /** 
             * Get the 'Billing' element value.
             * 
             * @return value
             */
            public Billing getBilling() {
                return billing;
            }

            /** 
             * Set the 'Billing' element value.
             * 
             * @param billing
             */
            public void setBilling(Billing billing) {
                this.billing = billing;
            }

            /** 
             * Get the 'CollectionAddress' element value.
             * 
             * @return value
             */
            public CollectionAddress getCollectionAddress() {
                return collectionAddress;
            }

            /** 
             * Set the 'CollectionAddress' element value.
             * 
             * @param collectionAddress
             */
            public void setCollectionAddress(CollectionAddress collectionAddress) {
                this.collectionAddress = collectionAddress;
            }

            /** 
             * Get the 'DeliveryAddress' element value.
             * 
             * @return value
             */
            public DeliveryAddress getDeliveryAddress() {
                return deliveryAddress;
            }

            /** 
             * Set the 'DeliveryAddress' element value.
             * 
             * @param deliveryAddress
             */
            public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
                this.deliveryAddress = deliveryAddress;
            }

            /** 
             * Get the 'FaxOrEmail' element value. Used to pass fax number or e-mail address related to the car renter or traveler. The maximum number of characters is 130
             * 
             * @return value
             */
            public String getFaxOrEmail() {
                return faxOrEmail;
            }

            /** 
             * Set the 'FaxOrEmail' element value. Used to pass fax number or e-mail address related to the car renter or traveler. The maximum number of characters is 130
             * 
             * @param faxOrEmail
             */
            public void setFaxOrEmail(String faxOrEmail) {
                this.faxOrEmail = faxOrEmail;
            }

            /** 
             * Get the 'NameNumber' attribute value. Used to specify which passenger in the record to associate the reservation to if applicable.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'NameNumber' attribute value. Used to specify which passenger in the record to associate the reservation to if applicable.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }
            /** 
             * Used to specify customer address information if applicable.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CityName"/>
             *       &lt;xs:element type="xs:string" name="CountryCode"/>
             *       &lt;xs:element type="xs:string" name="PostalCode"/>
             *       &lt;xs:element name="StateCountyProv">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="StateCode"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="StreetNmbr"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Address implements Serializable
            {
                private String cityName;
                private String countryCode;
                private String postalCode;
                private String stateCountyProv;
                private String streetNmbr;

                /** 
                 * Get the 'CityName' element value. Used to specify city name.
                 * 
                 * @return value
                 */
                public String getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value. Used to specify city name.
                 * 
                 * @param cityName
                 */
                public void setCityName(String cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the 'StateCode' attribute value. Used to specify state code.
                 * 
                 * @return value
                 */
                public String getStateCountyProv() {
                    return stateCountyProv;
                }

                /** 
                 * Set the 'StateCode' attribute value. Used to specify state code.
                 * 
                 * @param stateCountyProv
                 */
                public void setStateCountyProv(String stateCountyProv) {
                    this.stateCountyProv = stateCountyProv;
                }

                /** 
                 * Get the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @return value
                 */
                public String getStreetNmbr() {
                    return streetNmbr;
                }

                /** 
                 * Set the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @param streetNmbr
                 */
                public void setStreetNmbr(String streetNmbr) {
                    this.streetNmbr = streetNmbr;
                }
            }
            /** 
             * Used to pass billing details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Billing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Number"/>
             *     &lt;xs:attribute type="xs:string" name="Reference"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Billing implements Serializable
            {
                private String number;
                private String reference;

                /** 
                 * Get the 'Number' attribute value. Used to specify a billing number if applicable.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. Used to specify a billing number if applicable.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Reference' attribute value. Used to specify a billing reference number if applicable.
                 * 
                 * @return value
                 */
                public String getReference() {
                    return reference;
                }

                /** 
                 * Set the 'Reference' attribute value. Used to specify a billing reference number if applicable.
                 * 
                 * @param reference
                 */
                public void setReference(String reference) {
                    this.reference = reference;
                }
            }
            /** 
             * Used to pass vehicle collection address details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionAddress" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="StateCountyProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateCountyProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SiteID"/>
             *     &lt;xs:attribute type="xs:string" name="SiteName"/>
             *     &lt;xs:attribute type="xs:string" name="Phone"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CollectionAddress implements Serializable
            {
                private String cityName;
                private String countryCode;
                private String postalCode;
                private StateCountyProv stateCountyProv;
                private String streetNmbr;
                private String siteID;
                private String siteName;
                private String phone;

                /** 
                 * Get the 'CityName' element value. Used to specify city name.
                 * 
                 * @return value
                 */
                public String getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value. Used to specify city name.
                 * 
                 * @param cityName
                 */
                public void setCityName(String cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the 'StateCountyProv' element value.
                 * 
                 * @return value
                 */
                public StateCountyProv getStateCountyProv() {
                    return stateCountyProv;
                }

                /** 
                 * Set the 'StateCountyProv' element value.
                 * 
                 * @param stateCountyProv
                 */
                public void setStateCountyProv(StateCountyProv stateCountyProv) {
                    this.stateCountyProv = stateCountyProv;
                }

                /** 
                 * Get the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @return value
                 */
                public String getStreetNmbr() {
                    return streetNmbr;
                }

                /** 
                 * Set the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @param streetNmbr
                 */
                public void setStreetNmbr(String streetNmbr) {
                    this.streetNmbr = streetNmbr;
                }

                /** 
                 * Get the 'SiteID' attribute value. Used to specify site ID.
                 * 
                 * @return value
                 */
                public String getSiteID() {
                    return siteID;
                }

                /** 
                 * Set the 'SiteID' attribute value. Used to specify site ID.
                 * 
                 * @param siteID
                 */
                public void setSiteID(String siteID) {
                    this.siteID = siteID;
                }

                /** 
                 * Get the 'SiteName' attribute value. Used to pass site name.
                 * 
                 * @return value
                 */
                public String getSiteName() {
                    return siteName;
                }

                /** 
                 * Set the 'SiteName' attribute value. Used to pass site name.
                 * 
                 * @param siteName
                 */
                public void setSiteName(String siteName) {
                    this.siteName = siteName;
                }

                /** 
                 * Get the 'Phone' attribute value. Used to pass phone number.
                 * 
                 * @return value
                 */
                public String getPhone() {
                    return phone;
                }

                /** 
                 * Set the 'Phone' attribute value. Used to pass phone number.
                 * 
                 * @param phone
                 */
                public void setPhone(String phone) {
                    this.phone = phone;
                }
                /** 
                 * Used to specify state or province details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="StateCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateCountyProv implements Serializable
                {
                    private String stateCode;

                    /** 
                     * Get the 'StateCode' attribute value. Used to specify state code.
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. Used to specify state code.
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
            }
            /** 
             * Used to pass vehicle delivery address details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeliveryAddress" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="StateCountyProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateCountyProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SiteID"/>
             *     &lt;xs:attribute type="xs:string" name="SiteName"/>
             *     &lt;xs:attribute type="xs:string" name="Phone"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DeliveryAddress implements Serializable
            {
                private String cityName;
                private String countryCode;
                private String postalCode;
                private StateCountyProv stateCountyProv;
                private String streetNmbr;
                private String siteID;
                private String siteName;
                private String phone;

                /** 
                 * Get the 'CityName' element value. Used to specify city name.
                 * 
                 * @return value
                 */
                public String getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value. Used to specify city name.
                 * 
                 * @param cityName
                 */
                public void setCityName(String cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. Used to specify country code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. Used to specify postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the 'StateCountyProv' element value.
                 * 
                 * @return value
                 */
                public StateCountyProv getStateCountyProv() {
                    return stateCountyProv;
                }

                /** 
                 * Set the 'StateCountyProv' element value.
                 * 
                 * @param stateCountyProv
                 */
                public void setStateCountyProv(StateCountyProv stateCountyProv) {
                    this.stateCountyProv = stateCountyProv;
                }

                /** 
                 * Get the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @return value
                 */
                public String getStreetNmbr() {
                    return streetNmbr;
                }

                /** 
                 * Set the 'StreetNmbr' element value. Used to specify street number.
                 * 
                 * @param streetNmbr
                 */
                public void setStreetNmbr(String streetNmbr) {
                    this.streetNmbr = streetNmbr;
                }

                /** 
                 * Get the 'SiteID' attribute value. Used to specify site ID.
                 * 
                 * @return value
                 */
                public String getSiteID() {
                    return siteID;
                }

                /** 
                 * Set the 'SiteID' attribute value. Used to specify site ID.
                 * 
                 * @param siteID
                 */
                public void setSiteID(String siteID) {
                    this.siteID = siteID;
                }

                /** 
                 * Get the 'SiteName' attribute value. Used to pass site name.
                 * 
                 * @return value
                 */
                public String getSiteName() {
                    return siteName;
                }

                /** 
                 * Set the 'SiteName' attribute value. Used to pass site name.
                 * 
                 * @param siteName
                 */
                public void setSiteName(String siteName) {
                    this.siteName = siteName;
                }

                /** 
                 * Get the 'Phone' attribute value. Used to pass phone number.
                 * 
                 * @return value
                 */
                public String getPhone() {
                    return phone;
                }

                /** 
                 * Set the 'Phone' attribute value. Used to pass phone number.
                 * 
                 * @param phone
                 */
                public void setPhone(String phone) {
                    this.phone = phone;
                }
                /** 
                 * Used to specify state or province details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="StateCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateCountyProv implements Serializable
                {
                    private String stateCode;

                    /** 
                     * Get the 'StateCode' attribute value. Used to specify state code.
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. Used to specify state code.
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
            }
        }
        /** 
         * Used to pass point of sale details if applicable.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:string" name="RequestorID" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *           &lt;xs:attribute type="xs:string" name="AgentSine"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class POS implements Serializable
        {
            private String sourceRequestorID;
            private String sourceAgentSine;

            /** 
             * Get the 'RequestorID' element value. Used to specify an alternate IATA number.
             * 
             * @return value
             */
            public String getSourceRequestorID() {
                return sourceRequestorID;
            }

            /** 
             * Set the 'RequestorID' element value. Used to specify an alternate IATA number.
             * 
             * @param sourceRequestorID
             */
            public void setSourceRequestorID(String sourceRequestorID) {
                this.sourceRequestorID = sourceRequestorID;
            }

            /** 
             * Get the 'AgentSine' attribute value. Used to specify an agent sine.
             * 
             * @return value
             */
            public String getSourceAgentSine() {
                return sourceAgentSine;
            }

            /** 
             * Set the 'AgentSine' attribute value. Used to specify an agent sine.
             * 
             * @param sourceAgentSine
             */
            public void setSourceAgentSine(String sourceAgentSine) {
                this.sourceAgentSine = sourceAgentSine;
            }
        }
        /** 
         * Used to pass rate related details.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="5">
         *         &lt;!-- Reference to inner class CustLoyalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DropOffCharge" minOccurs="0">
         *         &lt;!-- Reference to inner class DropOffCharge -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RateOverride" minOccurs="0">
         *         &lt;!-- Reference to inner class RateOverride -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="RateCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RatePrefs implements Serializable
        {
            private String confirmationNumber;
            private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
            private DropOffCharge dropOffCharge;
            private RateOverride rateOverride;
            private String rateCode;

            /** 
             * Get the 'ConfirmationNumber' element value. Used to specify a confirmation number if applicable.
             * 
             * @return value
             */
            public String getConfirmationNumber() {
                return confirmationNumber;
            }

            /** 
             * Set the 'ConfirmationNumber' element value. Used to specify a confirmation number if applicable.
             * 
             * @param confirmationNumber
             */
            public void setConfirmationNumber(String confirmationNumber) {
                this.confirmationNumber = confirmationNumber;
            }

            /** 
             * Get the list of 'CustLoyalty' element items.
             * 
             * @return list
             */
            public List<CustLoyalty> getCustLoyaltyList() {
                return custLoyaltyList;
            }

            /** 
             * Set the list of 'CustLoyalty' element items.
             * 
             * @param list
             */
            public void setCustLoyaltyList(List<CustLoyalty> list) {
                custLoyaltyList = list;
            }

            /** 
             * Get the 'DropOffCharge' element value.
             * 
             * @return value
             */
            public DropOffCharge getDropOffCharge() {
                return dropOffCharge;
            }

            /** 
             * Set the 'DropOffCharge' element value.
             * 
             * @param dropOffCharge
             */
            public void setDropOffCharge(DropOffCharge dropOffCharge) {
                this.dropOffCharge = dropOffCharge;
            }

            /** 
             * Get the 'RateOverride' element value.
             * 
             * @return value
             */
            public RateOverride getRateOverride() {
                return rateOverride;
            }

            /** 
             * Set the 'RateOverride' element value.
             * 
             * @param rateOverride
             */
            public void setRateOverride(RateOverride rateOverride) {
                this.rateOverride = rateOverride;
            }

            /** 
             * Get the 'RateCode' attribute value. Used to specify a rate code if applicable.
             * 
             * @return value
             */
            public String getRateCode() {
                return rateCode;
            }

            /** 
             * Set the 'RateCode' attribute value. Used to specify a rate code if applicable.
             * 
             * @param rateCode
             */
            public void setRateCode(String rateCode) {
                this.rateCode = rateCode;
            }
            /** 
             * Used to specify a frequent traveler number if applicable.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute use="required" name="MembershipType">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class MembershipType -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:string" use="required" name="MembershipId"/>
             *     &lt;xs:attribute type="xs:string" name="MembershipCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CustLoyalty implements Serializable
            {
                private MembershipType membershipType;
                private String membershipId;
                private String membershipCode;

                /** 
                 * Get the 'MembershipType' attribute value. Used to pass various rate types. The example values are "CD", "IT", "ID", "PC", "FT".
                 * 
                 * @return value
                 */
                public MembershipType getMembershipType() {
                    return membershipType;
                }

                /** 
                 * Set the 'MembershipType' attribute value. Used to pass various rate types. The example values are "CD", "IT", "ID", "PC", "FT".
                 * 
                 * @param membershipType
                 */
                public void setMembershipType(MembershipType membershipType) {
                    this.membershipType = membershipType;
                }

                /** 
                 * Get the 'MembershipId' attribute value. Used to pass membership ID.
                 * 
                 * @return value
                 */
                public String getMembershipId() {
                    return membershipId;
                }

                /** 
                 * Set the 'MembershipId' attribute value. Used to pass membership ID.
                 * 
                 * @param membershipId
                 */
                public void setMembershipId(String membershipId) {
                    this.membershipId = membershipId;
                }

                /** 
                 * Get the 'MembershipCode' attribute value. Used to pass membership code.
                 * 
                 * @return value
                 */
                public String getMembershipCode() {
                    return membershipCode;
                }

                /** 
                 * Set the 'MembershipCode' attribute value. Used to pass membership code.
                 * 
                 * @param membershipCode
                 */
                public void setMembershipCode(String membershipCode) {
                    this.membershipCode = membershipCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="CD"/>
                 *     &lt;xs:enumeration value="IT"/>
                 *     &lt;xs:enumeration value="ID"/>
                 *     &lt;xs:enumeration value="PC"/>
                 *     &lt;xs:enumeration value="FT"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum MembershipType implements Serializable {
                    CD, IT, ID, PC, FT
                }
            }
            /** 
             * Used to specify a drop off charge if applicable.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DropOffCharge" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DropOffCharge implements Serializable
            {
                private String amount;

                /** 
                 * Get the 'Amount' attribute value. Used to specify a drop off charge amount if applicable.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. Used to specify a drop off charge amount if applicable.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
            }
            /** 
             * Used to override the rate.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateOverride" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="1"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RateOverride implements Serializable
            {
                private String text;

                /** 
                 * Get the 'Text' element value. Used to specify miscellaneous rate override-related information if applicable.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify miscellaneous rate override-related information if applicable.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
            }
        }
        /** 
         * Used to pass vehicle payment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RentalPaymentPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="GuaranteePrepaid" minOccurs="0">
         *         &lt;!-- Reference to inner class GuaranteePrepaid -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Voucher" minOccurs="0">
         *         &lt;!-- Reference to inner class Voucher -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RentalPaymentPrefs implements Serializable
        {
            private GuaranteePrepaid guaranteePrepaid;
            private Voucher voucher;

            /** 
             * Get the 'GuaranteePrepaid' element value.
             * 
             * @return value
             */
            public GuaranteePrepaid getGuaranteePrepaid() {
                return guaranteePrepaid;
            }

            /** 
             * Set the 'GuaranteePrepaid' element value.
             * 
             * @param guaranteePrepaid
             */
            public void setGuaranteePrepaid(GuaranteePrepaid guaranteePrepaid) {
                this.guaranteePrepaid = guaranteePrepaid;
            }

            /** 
             * Get the 'Voucher' element value.
             * 
             * @return value
             */
            public Voucher getVoucher() {
                return voucher;
            }

            /** 
             * Set the 'Voucher' element value.
             * 
             * @param voucher
             */
            public void setVoucher(Voucher voucher) {
                this.voucher = voucher;
            }
            /** 
             * Used to pass form of payment information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteePrepaid" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PaymentCard" minOccurs="0">
             *         &lt;!-- Reference to inner class PaymentCard -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class GuaranteePrepaid implements Serializable
            {
                private PaymentCard paymentCard;
                private String text;
                private String type;

                /** 
                 * Get the 'PaymentCard' element value.
                 * 
                 * @return value
                 */
                public PaymentCard getPaymentCard() {
                    return paymentCard;
                }

                /** 
                 * Set the 'PaymentCard' element value.
                 * 
                 * @param paymentCard
                 */
                public void setPaymentCard(PaymentCard paymentCard) {
                    this.paymentCard = paymentCard;
                }

                /** 
                 * Get the 'Text' element value. Used to specify miscellaneous guarantee-related information if applicable.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify miscellaneous guarantee-related information if applicable.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the guarantee type, i.e. "GUARANTEE", or "DEPOSIT" if applicable.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the guarantee type, i.e. "GUARANTEE", or "DEPOSIT" if applicable.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Used to pass payment card information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="CardCode"/>
                 *       &lt;xs:element type="xs:integer" name="CardNumber"/>
                 *       &lt;xs:element type="xs:integer" name="ExpiryMonth"/>
                 *       &lt;xs:element type="xs:integer" name="ExpiryYear"/>
                 *       &lt;xs:element name="FullCardHolderName" minOccurs="0">
                 *         &lt;!-- Reference to inner class FullCardHolderName -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PaymentCard implements Serializable
                {
                    private String cardCode;
                    private BigInteger cardNumber;
                    private BigInteger expiryMonth;
                    private BigInteger expiryYear;
                    private FullCardHolderName fullCardHolderName;

                    /** 
                     * Get the 'CardCode' element value. The 2 character code of the credit card issuer.
                     * 
                     * @return value
                     */
                    public String getCardCode() {
                        return cardCode;
                    }

                    /** 
                     * Set the 'CardCode' element value. The 2 character code of the credit card issuer.
                     * 
                     * @param cardCode
                     */
                    public void setCardCode(String cardCode) {
                        this.cardCode = cardCode;
                    }

                    /** 
                     * Get the 'CardNumber' element value. Credit card number
                     * 
                     * @return value
                     */
                    public BigInteger getCardNumber() {
                        return cardNumber;
                    }

                    /** 
                     * Set the 'CardNumber' element value. Credit card number
                     * 
                     * @param cardNumber
                     */
                    public void setCardNumber(BigInteger cardNumber) {
                        this.cardNumber = cardNumber;
                    }

                    /** 
                     * Get the 'ExpiryMonth' element value. Month of expiration
                     * 
                     * @return value
                     */
                    public BigInteger getExpiryMonth() {
                        return expiryMonth;
                    }

                    /** 
                     * Set the 'ExpiryMonth' element value. Month of expiration
                     * 
                     * @param expiryMonth
                     */
                    public void setExpiryMonth(BigInteger expiryMonth) {
                        this.expiryMonth = expiryMonth;
                    }

                    /** 
                     * Get the 'ExpiryYear' element value. Year of expiration
                     * 
                     * @return value
                     */
                    public BigInteger getExpiryYear() {
                        return expiryYear;
                    }

                    /** 
                     * Set the 'ExpiryYear' element value. Year of expiration
                     * 
                     * @param expiryYear
                     */
                    public void setExpiryYear(BigInteger expiryYear) {
                        this.expiryYear = expiryYear;
                    }

                    /** 
                     * Get the 'FullCardHolderName' element value.
                     * 
                     * @return value
                     */
                    public FullCardHolderName getFullCardHolderName() {
                        return fullCardHolderName;
                    }

                    /** 
                     * Set the 'FullCardHolderName' element value.
                     * 
                     * @param fullCardHolderName
                     */
                    public void setFullCardHolderName(
                            FullCardHolderName fullCardHolderName) {
                        this.fullCardHolderName = fullCardHolderName;
                    }
                    /** 
                     * Cardholder details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FullCardHolderName" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="LastName"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FullCardHolderName implements
                        Serializable
                    {
                        private String lastName;

                        /** 
                         * Get the 'LastName' element value. Cardholder last name.
                         * 
                         * @return value
                         */
                        public String getLastName() {
                            return lastName;
                        }

                        /** 
                         * Set the 'LastName' element value. Cardholder last name.
                         * 
                         * @param lastName
                         */
                        public void setLastName(String lastName) {
                            this.lastName = lastName;
                        }
                    }
                }
            }
            /** 
             * Used to pass voucher information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="BillingNumber"/>
             *     &lt;xs:attribute type="xs:string" name="Format"/>
             *     &lt;xs:attribute type="xs:string" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Voucher implements Serializable
            {
                private String billingNumber;
                private String format;
                private String type;

                /** 
                 * Get the 'BillingNumber' attribute value. Used to pass the billing number.
                 * 
                 * @return value
                 */
                public String getBillingNumber() {
                    return billingNumber;
                }

                /** 
                 * Set the 'BillingNumber' attribute value. Used to pass the billing number.
                 * 
                 * @param billingNumber
                 */
                public void setBillingNumber(String billingNumber) {
                    this.billingNumber = billingNumber;
                }

                /** 
                 * Get the 'Format' attribute value. Used to pass the voucher format.
                 * 
                 * @return value
                 */
                public String getFormat() {
                    return format;
                }

                /** 
                 * Set the 'Format' attribute value. Used to pass the voucher format.
                 * 
                 * @param format
                 */
                public void setFormat(String format) {
                    this.format = format;
                }

                /** 
                 * Get the 'Type' attribute value. Used to pass the voucher type.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to pass the voucher type.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
        }
        /** 
         * Used to pass vehicle extras information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarExtrasPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CarExtrasPref" maxOccurs="10">
         *         &lt;!-- Reference to inner class CarExtrasPref -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CarExtrasPrefs implements Serializable
        {
            private List<CarExtrasPref> carExtrasPrefList = new ArrayList<CarExtrasPref>();

            /** 
             * Get the list of 'CarExtrasPref' element items.
             * 
             * @return list
             */
            public List<CarExtrasPref> getCarExtrasPrefList() {
                return carExtrasPrefList;
            }

            /** 
             * Set the list of 'CarExtrasPref' element items.
             * 
             * @param list
             */
            public void setCarExtrasPrefList(List<CarExtrasPref> list) {
                carExtrasPrefList = list;
            }
            /** 
             * Used to pass a single vehicle extra information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarExtrasPref" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CarExtrasPref implements Serializable
            {
                private String type;

                /** 
                 * Get the 'Type' attribute value. Used to specify special equipment if applicable.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify special equipment if applicable.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
        }
        /** 
         * Used to send special requests to the vendor.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="InvoiceRemarks" minOccurs="0">
         *         &lt;!-- Reference to inner class InvoiceRemarks -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="WrittenConfirmation"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialPrefs implements Serializable
        {
            private InvoiceRemarks invoiceRemarks;
            private String text;
            private Boolean writtenConfirmation;

            /** 
             * Get the 'InvoiceRemarks' element value.
             * 
             * @return value
             */
            public InvoiceRemarks getInvoiceRemarks() {
                return invoiceRemarks;
            }

            /** 
             * Set the 'InvoiceRemarks' element value.
             * 
             * @param invoiceRemarks
             */
            public void setInvoiceRemarks(InvoiceRemarks invoiceRemarks) {
                this.invoiceRemarks = invoiceRemarks;
            }

            /** 
             * Get the 'Text' element value. Used to pass miscellaneous special preference-related information if applicable.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value. Used to pass miscellaneous special preference-related information if applicable.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'WrittenConfirmation' attribute value. Used to request written rental confirmation from the vendor.
             * 
             * @return value
             */
            public Boolean getWrittenConfirmation() {
                return writtenConfirmation;
            }

            /** 
             * Set the 'WrittenConfirmation' attribute value. Used to request written rental confirmation from the vendor.
             * 
             * @param writtenConfirmation
             */
            public void setWrittenConfirmation(Boolean writtenConfirmation) {
                this.writtenConfirmation = writtenConfirmation;
            }
            /** 
             * Used to pass miscellaneous invoice remark.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceRemarks" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class InvoiceRemarks implements Serializable
            {
                private String text;

                /** 
                 * Get the 'Text' element value. Used to pass miscellaneous invoice remark information if applicable.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to pass miscellaneous invoice remark information if applicable.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
            }
        }
        /** 
         * Used to request vehicle category.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VehPref">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:string" name="VehType"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VehPrefs implements Serializable
        {
            private String vehPref;

            /** 
             * Get the 'VehType' element value. Used to specify the vehicle category if applicable.
             * 
             * @return value
             */
            public String getVehPref() {
                return vehPref;
            }

            /** 
             * Set the 'VehType' element value. Used to specify the vehicle category if applicable.
             * 
             * @param vehPref
             */
            public void setVehPref(String vehPref) {
                this.vehPref = vehPref;
            }
        }
        /** 
         * Used to specify the vehicle pick up location.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PickUpLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ArrivalFlightInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class ArrivalFlightInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="LocationCode"/>
         *     &lt;xs:attribute type="xs:string" name="ExtendedLocationCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PickUpLocation implements Serializable
        {
            private ArrivalFlightInfo arrivalFlightInfo;
            private String locationCode;
            private String extendedLocationCode;

            /** 
             * Get the 'ArrivalFlightInfo' element value.
             * 
             * @return value
             */
            public ArrivalFlightInfo getArrivalFlightInfo() {
                return arrivalFlightInfo;
            }

            /** 
             * Set the 'ArrivalFlightInfo' element value.
             * 
             * @param arrivalFlightInfo
             */
            public void setArrivalFlightInfo(ArrivalFlightInfo arrivalFlightInfo) {
                this.arrivalFlightInfo = arrivalFlightInfo;
            }

            /** 
             * Get the 'LocationCode' attribute value. The three-letter IATA airport code associated with the vehicle pick up location.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value. The three-letter IATA airport code associated with the vehicle pick up location.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'ExtendedLocationCode' attribute value. An identifier used when a car supplier has a rental location that is not present at an airport. If the extended location code is used, then it is displayed in 3 alpha, followed by 1 additional alpha and 2 numeric format. The additional 1 alpha value can be:  `N` - North, `S` - South, `E` - East, `W` - West, `R` - Resort, `C` - City, `P` - Port, `X` - Rail. Note: when  "ExtendedLocationCode" is specified, "LocationCode" also needs to be specified.
             * 
             * @return value
             */
            public String getExtendedLocationCode() {
                return extendedLocationCode;
            }

            /** 
             * Set the 'ExtendedLocationCode' attribute value. An identifier used when a car supplier has a rental location that is not present at an airport. If the extended location code is used, then it is displayed in 3 alpha, followed by 1 additional alpha and 2 numeric format. The additional 1 alpha value can be:  `N` - North, `S` - South, `E` - East, `W` - West, `R` - Resort, `C` - City, `P` - Port, `X` - Rail. Note: when  "ExtendedLocationCode" is specified, "LocationCode" also needs to be specified.
             * 
             * @param extendedLocationCode
             */
            public void setExtendedLocationCode(String extendedLocationCode) {
                this.extendedLocationCode = extendedLocationCode;
            }
            /** 
             * Used to inform the vendor of the arrival flight number.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalFlightInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MarketingAirline">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *           &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ArrivalFlightInfo implements Serializable
            {
                private String marketingAirlineCode;
                private String marketingAirlineFlightNumber;

                /** 
                 * Get the 'Code' attribute value. Carrier code
                 * 
                 * @return value
                 */
                public String getMarketingAirlineCode() {
                    return marketingAirlineCode;
                }

                /** 
                 * Set the 'Code' attribute value. Carrier code
                 * 
                 * @param marketingAirlineCode
                 */
                public void setMarketingAirlineCode(String marketingAirlineCode) {
                    this.marketingAirlineCode = marketingAirlineCode;
                }

                /** 
                 * Get the 'FlightNumber' attribute value. The flight number
                 * 
                 * @return value
                 */
                public String getMarketingAirlineFlightNumber() {
                    return marketingAirlineFlightNumber;
                }

                /** 
                 * Set the 'FlightNumber' attribute value. The flight number
                 * 
                 * @param marketingAirlineFlightNumber
                 */
                public void setMarketingAirlineFlightNumber(
                        String marketingAirlineFlightNumber) {
                    this.marketingAirlineFlightNumber = marketingAirlineFlightNumber;
                }
            }
        }
        /** 
         * Contains an alternate drop-off location, if applicable.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReturnLocation implements Serializable
        {
            private String locationCode;

            /** 
             * Get the 'LocationCode' attribute value. Used to specify an alternate drop-off location code, which can be a three-letter IATA city/airport location (eg. LON) or a 6 alpha-numeric for non-airport locations (eg. LONC18). When specifying a non-airport drop-off location the format is 6 alpha-numeric, constructed as: 3 alpha, followed by 1 additional alpha and 2 numeric format. The additional 1 alpha value can be: `N` - North, `S` - South, `E` - East, `W` - West, `R` - Resort, `C` - City, `P` - Port, `X` - Rail
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value. Used to specify an alternate drop-off location code, which can be a three-letter IATA city/airport location (eg. LON) or a 6 alpha-numeric for non-airport locations (eg. LONC18). When specifying a non-airport drop-off location the format is 6 alpha-numeric, constructed as: 3 alpha, followed by 1 additional alpha and 2 numeric format. The additional 1 alpha value can be: `N` - North, `S` - South, `E` - East, `W` - West, `R` - Resort, `C` - City, `P` - Port, `X` - Rail
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }
        }
        /** 
         * Used to specify vehicle vendor preferences.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VendorPref">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *           &lt;xs:attribute type="xs:string" name="Phone"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPrefs implements Serializable
        {
            private String vendorPrefCode;
            private String vendorPrefPhone;

            /** 
             * Get the 'Code' attribute value. Used to specify a vendor code.
             * 
             * @return value
             */
            public String getVendorPrefCode() {
                return vendorPrefCode;
            }

            /** 
             * Set the 'Code' attribute value. Used to specify a vendor code.
             * 
             * @param vendorPrefCode
             */
            public void setVendorPrefCode(String vendorPrefCode) {
                this.vendorPrefCode = vendorPrefCode;
            }

            /** 
             * Get the 'Phone' attribute value. Used to specify vendor phone number information if applicable.
             * 
             * @return value
             */
            public String getVendorPrefPhone() {
                return vendorPrefPhone;
            }

            /** 
             * Set the 'Phone' attribute value. Used to specify vendor phone number information if applicable.
             * 
             * @param vendorPrefPhone
             */
            public void setVendorPrefPhone(String vendorPrefPhone) {
                this.vendorPrefPhone = vendorPrefPhone;
            }
        }
    }
    /** 
     * Used to book miscellaneous segments such as Miscellaneous Charge Orders, Insurance Segments, Other product segments
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscSegment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OriginLocation">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Text"/>
     *       &lt;xs:element name="VendorPrefs">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="Airline">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="Code"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="DepartureDateTime"/>
     *     &lt;xs:attribute type="xs:integer" name="InsertAfter"/>
     *     &lt;xs:attribute type="xs:integer" use="required" name="NumberInParty"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Status"/>
     *     &lt;xs:attribute use="required" name="Type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MiscSegment implements Serializable
    {
        private String originLocation;
        private String text;
        private String vendorPrefs;
        private String departureDateTime;
        private BigInteger insertAfter;
        private BigInteger numberInParty;
        private String status;
        private Type type;

        /** 
         * Get the 'LocationCode' attribute value. Location Code
         * 
         * @return value
         */
        public String getOriginLocation() {
            return originLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value. Location Code
         * 
         * @param originLocation
         */
        public void setOriginLocation(String originLocation) {
            this.originLocation = originLocation;
        }

        /** 
         * Get the 'Text' element value. Used to specify free text information to be associated with the miscellaneous segment.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Used to specify free text information to be associated with the miscellaneous segment.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Code' attribute value. Used to specify a particular vendor code.
         * 
         * @return value
         */
        public String getVendorPrefs() {
            return vendorPrefs;
        }

        /** 
         * Set the 'Code' attribute value. Used to specify a particular vendor code.
         * 
         * @param vendorPrefs
         */
        public void setVendorPrefs(String vendorPrefs) {
            this.vendorPrefs = vendorPrefs;
        }

        /** 
         * Get the 'DepartureDateTime' attribute value. Used to specify the date associated with the miscellaneous segment.
         * 
         * @return value
         */
        public String getDepartureDateTime() {
            return departureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' attribute value. Used to specify the date associated with the miscellaneous segment.
         * 
         * @param departureDateTime
         */
        public void setDepartureDateTime(String departureDateTime) {
            this.departureDateTime = departureDateTime;
        }

        /** 
         * Get the 'InsertAfter' attribute value. Used to denote a segment after which the miscellaneous segment needs to be placed.
         * 
         * @return value
         */
        public BigInteger getInsertAfter() {
            return insertAfter;
        }

        /** 
         * Set the 'InsertAfter' attribute value. Used to denote a segment after which the miscellaneous segment needs to be placed.
         * 
         * @param insertAfter
         */
        public void setInsertAfter(BigInteger insertAfter) {
            this.insertAfter = insertAfter;
        }

        /** 
         * Get the 'NumberInParty' attribute value. Used to specify the number of parties associated with the miscellaneous segment.
         * 
         * @return value
         */
        public BigInteger getNumberInParty() {
            return numberInParty;
        }

        /** 
         * Set the 'NumberInParty' attribute value. Used to specify the number of parties associated with the miscellaneous segment.
         * 
         * @param numberInParty
         */
        public void setNumberInParty(BigInteger numberInParty) {
            this.numberInParty = numberInParty;
        }

        /** 
         * Get the 'Status' attribute value. Used to specify the action code to be used to sell the segment. Example: "GK"
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' attribute value. Used to specify the action code to be used to sell the segment. Example: "GK"
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }

        /** 
         * Get the 'Type' attribute value. Used to specify the type of miscellaneous segment, i.e. OTH, MCO, PTA, or INS.
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. Used to specify the type of miscellaneous segment, i.e. OTH, MCO, PTA, or INS.
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="INS"/>
         *     &lt;xs:enumeration value="MCO"/>
         *     &lt;xs:enumeration value="OTH"/>
         *     &lt;xs:enumeration value="PTA"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            INS, MCO, OTH, PTA
        }
    }
    /** 
     * Used to add additional special requests such as seats, remarks, SSRs
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialReqDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AddRemark" minOccurs="0">
     *         &lt;!-- Reference to inner class AddRemark -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirSeat" minOccurs="0">
     *         &lt;!-- Reference to inner class AirSeat -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialService" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialService -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialReqDetails implements Serializable
    {
        private AddRemark addRemark;
        private AirSeat airSeat;
        private SpecialService specialService;

        /** 
         * Get the 'AddRemark' element value.
         * 
         * @return value
         */
        public AddRemark getAddRemark() {
            return addRemark;
        }

        /** 
         * Set the 'AddRemark' element value.
         * 
         * @param addRemark
         */
        public void setAddRemark(AddRemark addRemark) {
            this.addRemark = addRemark;
        }

        /** 
         * Get the 'AirSeat' element value.
         * 
         * @return value
         */
        public AirSeat getAirSeat() {
            return airSeat;
        }

        /** 
         * Set the 'AirSeat' element value.
         * 
         * @param airSeat
         */
        public void setAirSeat(AirSeat airSeat) {
            this.airSeat = airSeat;
        }

        /** 
         * Get the 'SpecialService' element value.
         * 
         * @return value
         */
        public SpecialService getSpecialService() {
            return specialService;
        }

        /** 
         * Set the 'SpecialService' element value.
         * 
         * @param specialService
         */
        public void setSpecialService(SpecialService specialService) {
            this.specialService = specialService;
        }
        /** 
         * Used to add remarks
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddRemark" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RemarkInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="FOP_Remark" minOccurs="0">
         *               &lt;!-- Reference to inner class FOPRemark -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="FutureQueuePlaceRemark" minOccurs="0">
         *               &lt;!-- Reference to inner class FutureQueuePlaceRemark -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Remark" minOccurs="0" maxOccurs="98">
         *               &lt;!-- Reference to inner class Remark -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AddRemark implements Serializable
        {
            private FOPRemark FOPRemark1;
            private FutureQueuePlaceRemark futureQueuePlaceRemark;
            private List<Remark> remarkList = new ArrayList<Remark>();

            /** 
             * Get the 'FOP_Remark' element value. Details of the remark
             * 
             * @return value
             */
            public FOPRemark getFOPRemark1() {
                return FOPRemark1;
            }

            /** 
             * Set the 'FOP_Remark' element value. Details of the remark
             * 
             * @param FOPRemark1
             */
            public void setFOPRemark1(FOPRemark FOPRemark1) {
                this.FOPRemark1 = FOPRemark1;
            }

            /** 
             * Get the 'FutureQueuePlaceRemark' element value. Details of the remark
             * 
             * @return value
             */
            public FutureQueuePlaceRemark getFutureQueuePlaceRemark() {
                return futureQueuePlaceRemark;
            }

            /** 
             * Set the 'FutureQueuePlaceRemark' element value. Details of the remark
             * 
             * @param futureQueuePlaceRemark
             */
            public void setFutureQueuePlaceRemark(
                    FutureQueuePlaceRemark futureQueuePlaceRemark) {
                this.futureQueuePlaceRemark = futureQueuePlaceRemark;
            }

            /** 
             * Get the list of 'Remark' element items. Details of the remark
             * 
             * @return list
             */
            public List<Remark> getRemarkList() {
                return remarkList;
            }

            /** 
             * Set the list of 'Remark' element items. Details of the remark
             * 
             * @param list
             */
            public void setRemarkList(List<Remark> list) {
                remarkList = list;
            }
            /** 
             * Form of payment remark
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Remark" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CC_Info" minOccurs="0">
             *         &lt;!-- Reference to inner class CCInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FOPRemark implements Serializable
            {
                private CCInfo CCInfo1;
                private String type;

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCInfo1() {
                    return CCInfo1;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCInfo1
                 */
                public void setCCInfo1(CCInfo CCInfo1) {
                    this.CCInfo1 = CCInfo1;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the form of payment type.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the form of payment type.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Credit card details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" name="AirlineCode"/>
                 *           &lt;xs:attribute type="xs:string" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:string" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *           &lt;xs:attribute type="xs:boolean" name="SuppressApprovalCode"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardAirlineCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardCode;
                    private String paymentCardExpireDate;
                    private String paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardNumber;
                    private Boolean paymentCardSuppressApprovalCode;
                    private Boolean suppress;

                    /** 
                     * Get the 'AirlineCode' attribute value. Used to specify an airline code to be used in conjunction with a credit card security code
                     * 
                     * @return value
                     */
                    public String getPaymentCardAirlineCode() {
                        return paymentCardAirlineCode;
                    }

                    /** 
                     * Set the 'AirlineCode' attribute value. Used to specify an airline code to be used in conjunction with a credit card security code
                     * 
                     * @param paymentCardAirlineCode
                     */
                    public void setPaymentCardAirlineCode(
                            String paymentCardAirlineCode) {
                        this.paymentCardAirlineCode = paymentCardAirlineCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value. Used to specify a credit card security code
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'Code' attribute value. Used to specify a credit card vendor code
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. Used to specify a credit card vendor code
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value. Used to define number of months for extended payment
                     * 
                     * @return value
                     */
                    public String getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value. Used to define number of months for extended payment
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            String paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. Used to specify a manual credit card if applicable
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify a credit card number
                     * 
                     * @return value
                     */
                    public String getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify a credit card number
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(String paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'SuppressApprovalCode' attribute value. Used to specify to prevent the Sabre system from generating an approval code when the credit card number is input into the system.
                     * 
                     * @return value
                     */
                    public Boolean getPaymentCardSuppressApprovalCode() {
                        return paymentCardSuppressApprovalCode;
                    }

                    /** 
                     * Set the 'SuppressApprovalCode' attribute value. Used to specify to prevent the Sabre system from generating an approval code when the credit card number is input into the system.
                     * 
                     * @param paymentCardSuppressApprovalCode
                     */
                    public void setPaymentCardSuppressApprovalCode(
                            Boolean paymentCardSuppressApprovalCode) {
                        this.paymentCardSuppressApprovalCode = paymentCardSuppressApprovalCode;
                    }

                    /** 
                     * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Used for future queue place remark
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureQueuePlaceRemark" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Date"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
             *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="QueueIdentifier"/>
             *     &lt;xs:attribute type="xs:string" name="Time"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FutureQueuePlaceRemark implements Serializable
            {
                private String date;
                private String prefatoryInstructionCode;
                private String pseudoCityCode;
                private String queueIdentifier;
                private String time;

                /** 
                 * Get the 'Date' attribute value. Used to specify a queue placement date
                 * 
                 * @return value
                 */
                public String getDate() {
                    return date;
                }

                /** 
                 * Set the 'Date' attribute value. Used to specify a queue placement date
                 * 
                 * @param date
                 */
                public void setDate(String date) {
                    this.date = date;
                }

                /** 
                 * Get the 'PrefatoryInstructionCode' attribute value. Used to specify the prefatory instruction code
                 * 
                 * @return value
                 */
                public String getPrefatoryInstructionCode() {
                    return prefatoryInstructionCode;
                }

                /** 
                 * Set the 'PrefatoryInstructionCode' attribute value. Used to specify the prefatory instruction code
                 * 
                 * @param prefatoryInstructionCode
                 */
                public void setPrefatoryInstructionCode(
                        String prefatoryInstructionCode) {
                    this.prefatoryInstructionCode = prefatoryInstructionCode;
                }

                /** 
                 * Get the 'PseudoCityCode' attribute value. Used to specify a pseudo city code
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value. Used to specify a pseudo city code
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'QueueIdentifier' attribute value. Used to specify a queue name/number
                 * 
                 * @return value
                 */
                public String getQueueIdentifier() {
                    return queueIdentifier;
                }

                /** 
                 * Set the 'QueueIdentifier' attribute value. Used to specify a queue name/number
                 * 
                 * @param queueIdentifier
                 */
                public void setQueueIdentifier(String queueIdentifier) {
                    this.queueIdentifier = queueIdentifier;
                }

                /** 
                 * Get the 'Time' attribute value. Used to specify a queue placement time.  Please note that only whole hours can be specified, i.e. 12:00
                 * 
                 * @return value
                 */
                public String getTime() {
                    return time;
                }

                /** 
                 * Set the 'Time' attribute value. Used to specify a queue placement time.  Please note that only whole hours can be specified, i.e. 12:00
                 * 
                 * @param time
                 */
                public void setTime(String time) {
                    this.time = time;
                }
            }
            /** 
             * Used for multiple remark types
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="98">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Code"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute use="required" name="Type">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Type -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remark implements Serializable
            {
                private String text;
                private String code;
                private String segmentNumber;
                private Type type;

                /** 
                 * Get the 'Text' element value. Used to specify remark-related text.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify remark-related text.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Code' attribute value. Used to specify an alpha sorting character such as: "H"
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Used to specify an alpha sorting character such as: "H"
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify a segment number
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify a segment number
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the type of remark.  Acceptable values are: Alpha-Coded, Client Address, Corporate, Delivery Address, General, Group Name, Hidden, Historical, Invoice, or Itinerary.
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the type of remark.  Acceptable values are: Alpha-Coded, Client Address, Corporate, Delivery Address, General, Group Name, Hidden, Historical, Invoice, or Itinerary.
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Alpha-Coded"/>
                 *     &lt;xs:enumeration value="Client Address"/>
                 *     &lt;xs:enumeration value="Corporate"/>
                 *     &lt;xs:enumeration value="Delivery Address"/>
                 *     &lt;xs:enumeration value="General"/>
                 *     &lt;xs:enumeration value="Group Name"/>
                 *     &lt;xs:enumeration value="Hidden"/>
                 *     &lt;xs:enumeration value="Historical"/>
                 *     &lt;xs:enumeration value="Invoice"/>
                 *     &lt;xs:enumeration value="Itinerary"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    ALPHA_CODED("Alpha-Coded"), CLIENT_ADDRESS("Client Address"), CORPORATE(
                            "Corporate"), DELIVERY_ADDRESS("Delivery Address"), GENERAL(
                            "General"), GROUP_NAME("Group Name"), HIDDEN(
                            "Hidden"), HISTORICAL("Historical"), INVOICE(
                            "Invoice"), ITINERARY("Itinerary");
                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Type convert(String value) {
                        for (Type inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
        }
        /** 
         * Used to book seats
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirSeat" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Seats">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="Seat" maxOccurs="98">
         *               &lt;!-- Reference to inner class Seat -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirSeat implements Serializable
        {
            private List<Seat> seatList = new ArrayList<Seat>();

            /** 
             * Get the list of 'Seat' element items. Seat details
             * 
             * @return list
             */
            public List<Seat> getSeatList() {
                return seatList;
            }

            /** 
             * Set the list of 'Seat' element items. Seat details
             * 
             * @param list
             */
            public void setSeatList(List<Seat> list) {
                seatList = list;
            }
            /** 
             * Single seat request
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" maxOccurs="98">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" name="BoardingPass"/>
             *     &lt;xs:attribute type="xs:boolean" name="ChangeOfGauge"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="Number"/>
             *     &lt;xs:attribute type="xs:string" name="Preference"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Seat implements Serializable
            {
                private Boolean boardingPass;
                private Boolean changeOfGauge;
                private String nameNumber;
                private String number;
                private String preference;
                private String segmentNumber;

                /** 
                 * Get the 'BoardingPass' attribute value. Used to specify for the system to assign a seat and issue a boarding pass
                 * 
                 * @return value
                 */
                public Boolean getBoardingPass() {
                    return boardingPass;
                }

                /** 
                 * Set the 'BoardingPass' attribute value. Used to specify for the system to assign a seat and issue a boarding pass
                 * 
                 * @param boardingPass
                 */
                public void setBoardingPass(Boolean boardingPass) {
                    this.boardingPass = boardingPass;
                }

                /** 
                 * Get the 'ChangeOfGauge' attribute value. Used to specify a change of gauge of flight.
                 * 
                 * @return value
                 */
                public Boolean getChangeOfGauge() {
                    return changeOfGauge;
                }

                /** 
                 * Set the 'ChangeOfGauge' attribute value. Used to specify a change of gauge of flight.
                 * 
                 * @param changeOfGauge
                 */
                public void setChangeOfGauge(Boolean changeOfGauge) {
                    this.changeOfGauge = changeOfGauge;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'Number' attribute value. Used to specify a seat number
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. Used to specify a seat number
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Preference' attribute value. Used to specify a seat preference. Preference cannot combine with Number.
                 * 
                 * @return value
                 */
                public String getPreference() {
                    return preference;
                }

                /** 
                 * Set the 'Preference' attribute value. Used to specify a seat preference. Preference cannot combine with Number.
                 * 
                 * @param preference
                 */
                public void setPreference(String preference) {
                    this.preference = preference;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify a segment number
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify a segment number
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
            }
        }
        /** 
         * Used to add SSRs
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialService" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SpecialServiceInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class AdvancePassenger -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class SecureFlight -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Service" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class Service -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialService implements Serializable
        {
            private List<AdvancePassenger> advancePassengerList = new ArrayList<AdvancePassenger>();
            private List<SecureFlight> secureFlightList = new ArrayList<SecureFlight>();
            private List<Service> serviceList = new ArrayList<Service>();

            /** 
             * Get the list of 'AdvancePassenger' element items. SSR details
             * 
             * @return list
             */
            public List<AdvancePassenger> getAdvancePassengerList() {
                return advancePassengerList;
            }

            /** 
             * Set the list of 'AdvancePassenger' element items. SSR details
             * 
             * @param list
             */
            public void setAdvancePassengerList(List<AdvancePassenger> list) {
                advancePassengerList = list;
            }

            /** 
             * Get the list of 'SecureFlight' element items. SSR details
             * 
             * @return list
             */
            public List<SecureFlight> getSecureFlightList() {
                return secureFlightList;
            }

            /** 
             * Set the list of 'SecureFlight' element items. SSR details
             * 
             * @param list
             */
            public void setSecureFlightList(List<SecureFlight> list) {
                secureFlightList = list;
            }

            /** 
             * Get the list of 'Service' element items. SSR details
             * 
             * @return list
             */
            public List<Service> getServiceList() {
                return serviceList;
            }

            /** 
             * Set the list of 'Service' element items. SSR details
             * 
             * @param list
             */
            public void setServiceList(List<Service> list) {
                serviceList = list;
            }
            /** 
             * Used to specify the APIS (Advance Passenger Information)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Document" minOccurs="0">
             *         &lt;!-- Reference to inner class Document -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ResidentDestinationAddress" minOccurs="0">
             *         &lt;!-- Reference to inner class ResidentDestinationAddress -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AdvancePassenger implements Serializable
            {
                private Document document;
                private PersonName personName;
                private ResidentDestinationAddress residentDestinationAddress;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;

                /** 
                 * Get the 'Document' element value.
                 * 
                 * @return value
                 */
                public Document getDocument() {
                    return document;
                }

                /** 
                 * Set the 'Document' element value.
                 * 
                 * @param document
                 */
                public void setDocument(Document document) {
                    this.document = document;
                }

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'ResidentDestinationAddress' element value.
                 * 
                 * @return value
                 */
                public ResidentDestinationAddress getResidentDestinationAddress() {
                    return residentDestinationAddress;
                }

                /** 
                 * Set the 'ResidentDestinationAddress' element value.
                 * 
                 * @param residentDestinationAddress
                 */
                public void setResidentDestinationAddress(
                        ResidentDestinationAddress residentDestinationAddress) {
                    this.residentDestinationAddress = residentDestinationAddress;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.  "A" can be specified to associate the SSR to all segments.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.  "A" can be specified to associate the SSR to all segments.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
                /** 
                 * Document details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NationalityCountry" minOccurs="0"/>
                 *       &lt;xs:element name="Visa" minOccurs="0">
                 *         &lt;!-- Reference to inner class Visa -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:date" name="ExpirationDate"/>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Document implements Serializable
                {
                    private String issueCountry;
                    private String nationalityCountry;
                    private Visa visa;
                    private Date expirationDate;
                    private String number;
                    private String type;

                    /** 
                     * Get the 'IssueCountry' element value. Issue country
                     * 
                     * @return value
                     */
                    public String getIssueCountry() {
                        return issueCountry;
                    }

                    /** 
                     * Set the 'IssueCountry' element value. Issue country
                     * 
                     * @param issueCountry
                     */
                    public void setIssueCountry(String issueCountry) {
                        this.issueCountry = issueCountry;
                    }

                    /** 
                     * Get the 'NationalityCountry' element value. Nationality country
                     * 
                     * @return value
                     */
                    public String getNationalityCountry() {
                        return nationalityCountry;
                    }

                    /** 
                     * Set the 'NationalityCountry' element value. Nationality country
                     * 
                     * @param nationalityCountry
                     */
                    public void setNationalityCountry(String nationalityCountry) {
                        this.nationalityCountry = nationalityCountry;
                    }

                    /** 
                     * Get the 'Visa' element value.
                     * 
                     * @return value
                     */
                    public Visa getVisa() {
                        return visa;
                    }

                    /** 
                     * Set the 'Visa' element value.
                     * 
                     * @param visa
                     */
                    public void setVisa(Visa visa) {
                        this.visa = visa;
                    }

                    /** 
                     * Get the 'ExpirationDate' attribute value. Used to specify the document expiration date
                     * 
                     * @return value
                     */
                    public Date getExpirationDate() {
                        return expirationDate;
                    }

                    /** 
                     * Set the 'ExpirationDate' attribute value. Used to specify the document expiration date
                     * 
                     * @param expirationDate
                     */
                    public void setExpirationDate(Date expirationDate) {
                        this.expirationDate = expirationDate;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify the document number.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify the document number.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Type' attribute value. Used to specify the document type. Acceptable values include: "A" - Alien resident card, "C" - Permanent resident card, "F" - Facilitation document, "I" - National ID card, "IN" - Nexus Card. Also: "M" - Military, "N" - Naturalization certificate, "P" - Passport, "T" - Refugee travel document and re-entry permit, US Travel document, "V" - Border crossing card
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify the document type. Acceptable values include: "A" - Alien resident card, "C" - Permanent resident card, "F" - Facilitation document, "I" - National ID card, "IN" - Nexus Card. Also: "M" - Military, "N" - Naturalization certificate, "P" - Passport, "T" - Refugee travel document and re-entry permit, US Travel document, "V" - Border crossing card
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Visa document details
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Visa" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ApplicableCountry" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="PlaceOfBirth" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="PlaceOfIssue" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:date" name="IssueDate"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Visa implements Serializable
                    {
                        private String applicableCountry;
                        private String placeOfBirth;
                        private String placeOfIssue;
                        private Date issueDate;

                        /** 
                         * Get the 'ApplicableCountry' element value. You must use a valid 2 or 3 character country code (alpha characters only)
                         * 
                         * @return value
                         */
                        public String getApplicableCountry() {
                            return applicableCountry;
                        }

                        /** 
                         * Set the 'ApplicableCountry' element value. You must use a valid 2 or 3 character country code (alpha characters only)
                         * 
                         * @param applicableCountry
                         */
                        public void setApplicableCountry(
                                String applicableCountry) {
                            this.applicableCountry = applicableCountry;
                        }

                        /** 
                         * Get the 'PlaceOfBirth' element value. Place of birth
                         * 
                         * @return value
                         */
                        public String getPlaceOfBirth() {
                            return placeOfBirth;
                        }

                        /** 
                         * Set the 'PlaceOfBirth' element value. Place of birth
                         * 
                         * @param placeOfBirth
                         */
                        public void setPlaceOfBirth(String placeOfBirth) {
                            this.placeOfBirth = placeOfBirth;
                        }

                        /** 
                         * Get the 'PlaceOfIssue' element value. Place of issue
                         * 
                         * @return value
                         */
                        public String getPlaceOfIssue() {
                            return placeOfIssue;
                        }

                        /** 
                         * Set the 'PlaceOfIssue' element value. Place of issue
                         * 
                         * @param placeOfIssue
                         */
                        public void setPlaceOfIssue(String placeOfIssue) {
                            this.placeOfIssue = placeOfIssue;
                        }

                        /** 
                         * Get the 'IssueDate' attribute value. Issue date
                         * 
                         * @return value
                         */
                        public Date getIssueDate() {
                            return issueDate;
                        }

                        /** 
                         * Set the 'IssueDate' attribute value. Issue date
                         * 
                         * @param issueDate
                         */
                        public void setIssueDate(Date issueDate) {
                            this.issueDate = issueDate;
                        }
                    }
                }
                /** 
                 * Personal details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:date" name="DateOfBirth"/>
                 *     &lt;xs:attribute type="xs:boolean" name="DocumentHolder"/>
                 *     &lt;xs:attribute name="Gender">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class Gender -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *     &lt;xs:attribute type="xs:boolean" name="LapChild"/>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String givenName;
                    private String middleName;
                    private String surname;
                    private Date dateOfBirth;
                    private Boolean documentHolder;
                    private Gender gender;
                    private Boolean lapChild;
                    private String nameNumber;

                    /** 
                     * Get the 'GivenName' element value. First name
                     * 
                     * @return value
                     */
                    public String getGivenName() {
                        return givenName;
                    }

                    /** 
                     * Set the 'GivenName' element value. First name
                     * 
                     * @param givenName
                     */
                    public void setGivenName(String givenName) {
                        this.givenName = givenName;
                    }

                    /** 
                     * Get the 'MiddleName' element value. Middle name
                     * 
                     * @return value
                     */
                    public String getMiddleName() {
                        return middleName;
                    }

                    /** 
                     * Set the 'MiddleName' element value. Middle name
                     * 
                     * @param middleName
                     */
                    public void setMiddleName(String middleName) {
                        this.middleName = middleName;
                    }

                    /** 
                     * Get the 'Surname' element value. Surname
                     * 
                     * @return value
                     */
                    public String getSurname() {
                        return surname;
                    }

                    /** 
                     * Set the 'Surname' element value. Surname
                     * 
                     * @param surname
                     */
                    public void setSurname(String surname) {
                        this.surname = surname;
                    }

                    /** 
                     * Get the 'DateOfBirth' attribute value. Date of birth
                     * 
                     * @return value
                     */
                    public Date getDateOfBirth() {
                        return dateOfBirth;
                    }

                    /** 
                     * Set the 'DateOfBirth' attribute value. Date of birth
                     * 
                     * @param dateOfBirth
                     */
                    public void setDateOfBirth(Date dateOfBirth) {
                        this.dateOfBirth = dateOfBirth;
                    }

                    /** 
                     * Get the 'DocumentHolder' attribute value. Used to identify the primary passport holder when the passport document is issued for multiple passengers
                     * 
                     * @return value
                     */
                    public Boolean getDocumentHolder() {
                        return documentHolder;
                    }

                    /** 
                     * Set the 'DocumentHolder' attribute value. Used to identify the primary passport holder when the passport document is issued for multiple passengers
                     * 
                     * @param documentHolder
                     */
                    public void setDocumentHolder(Boolean documentHolder) {
                        this.documentHolder = documentHolder;
                    }

                    /** 
                     * Get the 'Gender' attribute value. Gender
                     * 
                     * @return value
                     */
                    public Gender getGender() {
                        return gender;
                    }

                    /** 
                     * Set the 'Gender' attribute value. Gender
                     * 
                     * @param gender
                     */
                    public void setGender(Gender gender) {
                        this.gender = gender;
                    }

                    /** 
                     * Get the 'LapChild' attribute value. Used to identify information associated with a lap child.
                                                                                                      It can only be used together with .../SpecialServiceInfo/AdvancePassenger/Document/Visa and .../SpecialServiceInfo/AdvancePassenger/ResidentDestinationAddress
                     * 
                     * @return value
                     */
                    public Boolean getLapChild() {
                        return lapChild;
                    }

                    /** 
                     * Set the 'LapChild' attribute value. Used to identify information associated with a lap child.
                                                                                                      It can only be used together with .../SpecialServiceInfo/AdvancePassenger/Document/Visa and .../SpecialServiceInfo/AdvancePassenger/ResidentDestinationAddress
                     * 
                     * @param lapChild
                     */
                    public void setLapChild(Boolean lapChild) {
                        this.lapChild = lapChild;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Name number: 1.1, 2.1. etc
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number: 1.1, 2.1. etc
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="F"/>
                     *     &lt;xs:enumeration value="M"/>
                     *     &lt;xs:enumeration value="FI"/>
                     *     &lt;xs:enumeration value="MI"/>
                     *     &lt;xs:enumeration value="U"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum Gender implements Serializable {
                        F, M, FI, MI, U
                    }
                }
                /** 
                 * Used to pass residence or destination address
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResidentDestinationAddress" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Country"/>
                 *       &lt;xs:element type="xs:string" name="Street" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Zip" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ResidentDestinationAddress implements
                    Serializable
                {
                    private String city;
                    private String country;
                    private String street;
                    private String state;
                    private String zip;
                    private String type;

                    /** 
                     * Get the 'City' element value. City name
                     * 
                     * @return value
                     */
                    public String getCity() {
                        return city;
                    }

                    /** 
                     * Set the 'City' element value. City name
                     * 
                     * @param city
                     */
                    public void setCity(String city) {
                        this.city = city;
                    }

                    /** 
                     * Get the 'Country' element value. Country code
                     * 
                     * @return value
                     */
                    public String getCountry() {
                        return country;
                    }

                    /** 
                     * Set the 'Country' element value. Country code
                     * 
                     * @param country
                     */
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    /** 
                     * Get the 'Street' element value. Street address
                     * 
                     * @return value
                     */
                    public String getStreet() {
                        return street;
                    }

                    /** 
                     * Set the 'Street' element value. Street address
                     * 
                     * @param street
                     */
                    public void setStreet(String street) {
                        this.street = street;
                    }

                    /** 
                     * Get the 'State' element value. State
                     * 
                     * @return value
                     */
                    public String getState() {
                        return state;
                    }

                    /** 
                     * Set the 'State' element value. State
                     * 
                     * @param state
                     */
                    public void setState(String state) {
                        this.state = state;
                    }

                    /** 
                     * Get the 'Zip' element value. Zip or postal code
                     * 
                     * @return value
                     */
                    public String getZip() {
                        return zip;
                    }

                    /** 
                     * Set the 'Zip' element value. Zip or postal code
                     * 
                     * @param zip
                     */
                    public void setZip(String zip) {
                        this.zip = zip;
                    }

                    /** 
                     * Get the 'Type' attribute value. Used to specify the address type. Acceptable values are "R" - residence address, "D" - destination address
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify the address type. Acceptable values are "R" - residence address, "D" - destination address
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
                /** 
                 * Airline preferences
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private Boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @return value
                     */
                    public Boolean getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @param airline
                     */
                    public void setAirline(Boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to specify Secure Flight Passenger Data (SFPD)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="KnownTravelerNumber" minOccurs="0"/>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="RedressNumber" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SecureFlight implements Serializable
            {
                private String issueCountry;
                private String knownTravelerNumber;
                private PersonName personName;
                private String redressNumber;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;

                /** 
                 * Get the 'IssueCountry' element value. Used to pass country of issue for "KnownTravelerNumber" or "RedressNumber"
                 * 
                 * @return value
                 */
                public String getIssueCountry() {
                    return issueCountry;
                }

                /** 
                 * Set the 'IssueCountry' element value. Used to pass country of issue for "KnownTravelerNumber" or "RedressNumber"
                 * 
                 * @param issueCountry
                 */
                public void setIssueCountry(String issueCountry) {
                    this.issueCountry = issueCountry;
                }

                /** 
                 * Get the 'KnownTravelerNumber' element value. "KnownTravelerNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "RedressNumber"
                 * 
                 * @return value
                 */
                public String getKnownTravelerNumber() {
                    return knownTravelerNumber;
                }

                /** 
                 * Set the 'KnownTravelerNumber' element value. "KnownTravelerNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "RedressNumber"
                 * 
                 * @param knownTravelerNumber
                 */
                public void setKnownTravelerNumber(String knownTravelerNumber) {
                    this.knownTravelerNumber = knownTravelerNumber;
                }

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'RedressNumber' element value. "RedressNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender"
                 * 
                 * @return value
                 */
                public String getRedressNumber() {
                    return redressNumber;
                }

                /** 
                 * Set the 'RedressNumber' element value. "RedressNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender"
                 * 
                 * @param redressNumber
                 */
                public void setRedressNumber(String redressNumber) {
                    this.redressNumber = redressNumber;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.  "A" can be specified to associate the SSR to all segments
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.  "A" can be specified to associate the SSR to all segments
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
                /** 
                 * Personal details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="DateOfBirth"/>
                 *     &lt;xs:attribute name="Gender">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class Gender -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String givenName;
                    private String surname;
                    private String dateOfBirth;
                    private Gender gender;
                    private String nameNumber;

                    /** 
                     * Get the 'GivenName' element value. First name
                     * 
                     * @return value
                     */
                    public String getGivenName() {
                        return givenName;
                    }

                    /** 
                     * Set the 'GivenName' element value. First name
                     * 
                     * @param givenName
                     */
                    public void setGivenName(String givenName) {
                        this.givenName = givenName;
                    }

                    /** 
                     * Get the 'Surname' element value. Surname
                     * 
                     * @return value
                     */
                    public String getSurname() {
                        return surname;
                    }

                    /** 
                     * Set the 'Surname' element value. Surname
                     * 
                     * @param surname
                     */
                    public void setSurname(String surname) {
                        this.surname = surname;
                    }

                    /** 
                     * Get the 'DateOfBirth' attribute value. "DateOfBirth" and "Gender" cannot combine with "RedressNumber" and "KnownTravelerNumber"
                     * 
                     * @return value
                     */
                    public String getDateOfBirth() {
                        return dateOfBirth;
                    }

                    /** 
                     * Set the 'DateOfBirth' attribute value. "DateOfBirth" and "Gender" cannot combine with "RedressNumber" and "KnownTravelerNumber"
                     * 
                     * @param dateOfBirth
                     */
                    public void setDateOfBirth(String dateOfBirth) {
                        this.dateOfBirth = dateOfBirth;
                    }

                    /** 
                     * Get the 'Gender' attribute value. Gender
                     * 
                     * @return value
                     */
                    public Gender getGender() {
                        return gender;
                    }

                    /** 
                     * Set the 'Gender' attribute value. Gender
                     * 
                     * @param gender
                     */
                    public void setGender(Gender gender) {
                        this.gender = gender;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Name number: 1.1, 2.1. etc
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number: 1.1, 2.1. etc
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="F"/>
                     *     &lt;xs:enumeration value="M"/>
                     *     &lt;xs:enumeration value="FI"/>
                     *     &lt;xs:enumeration value="MI"/>
                     *     &lt;xs:enumeration value="U"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum Gender implements Serializable {
                        F, M, FI, MI, U
                    }
                }
                /** 
                 * Airline preferences
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private Boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @return value
                     */
                    public Boolean getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @param airline
                     */
                    public void setAirline(Boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to specify Special Service Request (SSR)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="SSR_Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Service implements Serializable
            {
                private PersonName personName;
                private String text;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;
                private String SSRCode;

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'Text' element value. Used to specify miscellaneous free text information
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify miscellaneous free text information
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to. If SSR_Code="OSI"  @SegmentNumber cannot be utilized.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to. If SSR_Code="OSI"  @SegmentNumber cannot be utilized.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'SSR_Code' attribute value. Used to specify an SSR code such as "WCHR", "WGML", etc. 
                 * 
                 * @return value
                 */
                public String getSSRCode() {
                    return SSRCode;
                }

                /** 
                 * Set the 'SSR_Code' attribute value. Used to specify an SSR code such as "WCHR", "WGML", etc. 
                 * 
                 * @param SSRCode
                 */
                public void setSSRCode(String SSRCode) {
                    this.SSRCode = SSRCode;
                }
                /** 
                 * Personal details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String nameNumber;

                    /** 
                     * Get the 'NameNumber' attribute value. Used to specify a passenger name number
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to specify a passenger name number
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
                /** 
                 * Airline preferences
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" name="Code"/>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private String airlineCode;
                    private Boolean airlineHosted;

                    /** 
                     * Get the 'Code' attribute value. Applicable to the "OSI" SSRCode, and is used to specify the airline that the SSR needs to be sent to.
                     * 
                     * @return value
                     */
                    public String getAirlineCode() {
                        return airlineCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. Applicable to the "OSI" SSRCode, and is used to specify the airline that the SSR needs to be sent to.
                     * 
                     * @param airlineCode
                     */
                    public void setAirlineCode(String airlineCode) {
                        this.airlineCode = airlineCode;
                    }

                    /** 
                     * Get the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @return value
                     */
                    public Boolean getAirlineHosted() {
                        return airlineHosted;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Defines if the receiving airline is Sabre hosted carrier
                     * 
                     * @param airlineHosted
                     */
                    public void setAirlineHosted(Boolean airlineHosted) {
                        this.airlineHosted = airlineHosted;
                    }
                }
            }
        }
    }
    /** 
     * Additional variables used to finalize the PNR creation
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostProcessing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ARUNK" minOccurs="0">
     *         &lt;!-- Reference to inner class ARUNK -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="QueuePlace" minOccurs="0">
     *         &lt;!-- Reference to inner class QueuePlace -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="EndTransaction">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="Source">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="ReceivedFrom"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="Email" minOccurs="0">
     *               &lt;!-- Reference to inner class Email -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="ScheduleChange" minOccurs="0">
     *               &lt;!-- Reference to inner class ScheduleChange -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="PostBookingHKValidation" minOccurs="0">
     *         &lt;!-- Reference to inner class PostBookingHKValidation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="WaitForAirlineRecLoc" minOccurs="0">
     *         &lt;!-- Reference to inner class WaitForAirlineRecLoc -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RedisplayReservation" minOccurs="0">
     *         &lt;!-- Reference to inner class RedisplayReservation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="unmaskCreditCard"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PostProcessing implements Serializable
    {
        private ARUNK ARUNK1;
        private QueuePlace queuePlace;
        private String endTransactionSource;
        private Email email;
        private ScheduleChange scheduleChange;
        private PostBookingHKValidation postBookingHKValidation;
        private WaitForAirlineRecLoc waitForAirlineRecLoc;
        private RedisplayReservation redisplayReservation;
        private Boolean unmaskCreditCard;

        /** 
         * Get the 'ARUNK' element value.
         * 
         * @return value
         */
        public ARUNK getARUNK1() {
            return ARUNK1;
        }

        /** 
         * Set the 'ARUNK' element value.
         * 
         * @param ARUNK1
         */
        public void setARUNK1(ARUNK ARUNK1) {
            this.ARUNK1 = ARUNK1;
        }

        /** 
         * Get the 'QueuePlace' element value.
         * 
         * @return value
         */
        public QueuePlace getQueuePlace() {
            return queuePlace;
        }

        /** 
         * Set the 'QueuePlace' element value.
         * 
         * @param queuePlace
         */
        public void setQueuePlace(QueuePlace queuePlace) {
            this.queuePlace = queuePlace;
        }

        /** 
         * Get the 'ReceivedFrom' attribute value. Source name
         * 
         * @return value
         */
        public String getEndTransactionSource() {
            return endTransactionSource;
        }

        /** 
         * Set the 'ReceivedFrom' attribute value. Source name
         * 
         * @param endTransactionSource
         */
        public void setEndTransactionSource(String endTransactionSource) {
            this.endTransactionSource = endTransactionSource;
        }

        /** 
         * Get the 'Email' element value. Used to finalize the transaction and commit the record
         * 
         * @return value
         */
        public Email getEmail() {
            return email;
        }

        /** 
         * Set the 'Email' element value. Used to finalize the transaction and commit the record
         * 
         * @param email
         */
        public void setEmail(Email email) {
            this.email = email;
        }

        /** 
         * Get the 'ScheduleChange' element value. Used to finalize the transaction and commit the record
         * 
         * @return value
         */
        public ScheduleChange getScheduleChange() {
            return scheduleChange;
        }

        /** 
         * Set the 'ScheduleChange' element value. Used to finalize the transaction and commit the record
         * 
         * @param scheduleChange
         */
        public void setScheduleChange(ScheduleChange scheduleChange) {
            this.scheduleChange = scheduleChange;
        }

        /** 
         * Get the 'PostBookingHKValidation' element value.
         * 
         * @return value
         */
        public PostBookingHKValidation getPostBookingHKValidation() {
            return postBookingHKValidation;
        }

        /** 
         * Set the 'PostBookingHKValidation' element value.
         * 
         * @param postBookingHKValidation
         */
        public void setPostBookingHKValidation(
                PostBookingHKValidation postBookingHKValidation) {
            this.postBookingHKValidation = postBookingHKValidation;
        }

        /** 
         * Get the 'WaitForAirlineRecLoc' element value.
         * 
         * @return value
         */
        public WaitForAirlineRecLoc getWaitForAirlineRecLoc() {
            return waitForAirlineRecLoc;
        }

        /** 
         * Set the 'WaitForAirlineRecLoc' element value.
         * 
         * @param waitForAirlineRecLoc
         */
        public void setWaitForAirlineRecLoc(
                WaitForAirlineRecLoc waitForAirlineRecLoc) {
            this.waitForAirlineRecLoc = waitForAirlineRecLoc;
        }

        /** 
         * Get the 'RedisplayReservation' element value.
         * 
         * @return value
         */
        public RedisplayReservation getRedisplayReservation() {
            return redisplayReservation;
        }

        /** 
         * Set the 'RedisplayReservation' element value.
         * 
         * @param redisplayReservation
         */
        public void setRedisplayReservation(
                RedisplayReservation redisplayReservation) {
            this.redisplayReservation = redisplayReservation;
        }

        /** 
         * Get the 'unmaskCreditCard' attribute value. Used to unmask credit card information in the TIR response. Please note that this attribute has effect only if a user has EPR keyword CCVIEW
         * 
         * @return value
         */
        public Boolean getUnmaskCreditCard() {
            return unmaskCreditCard;
        }

        /** 
         * Set the 'unmaskCreditCard' attribute value. Used to unmask credit card information in the TIR response. Please note that this attribute has effect only if a user has EPR keyword CCVIEW
         * 
         * @param unmaskCreditCard
         */
        public void setUnmaskCreditCard(Boolean unmaskCreditCard) {
            this.unmaskCreditCard = unmaskCreditCard;
        }
        /** 
         * Used to add arrival unknown segments into a passenger name record.  The system will properly apply them so there is no need to segment select, etc...
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ARUNK" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="priorPricing"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ARUNK implements Serializable
        {
            private Boolean priorPricing;

            /** 
             * Get the 'priorPricing' attribute value. Used to add arrival unknown segments into a passenger name record after air segment sell but prior to pricing.
             * 
             * @return value
             */
            public Boolean getPriorPricing() {
                return priorPricing;
            }

            /** 
             * Set the 'priorPricing' attribute value. Used to add arrival unknown segments into a passenger name record after air segment sell but prior to pricing.
             * 
             * @param priorPricing
             */
            public void setPriorPricing(Boolean priorPricing) {
                this.priorPricing = priorPricing;
            }
        }
        /** 
         * Used to request to place the newly created PNR on a queue
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueuePlace" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MultiQueuePlace" minOccurs="0">
         *         &lt;!-- Reference to inner class MultiQueuePlace -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="QueueInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class QueueInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueuePlace implements Serializable
        {
            private MultiQueuePlace multiQueuePlace;
            private QueueInfo queueInfo;

            /** 
             * Get the 'MultiQueuePlace' element value.
             * 
             * @return value
             */
            public MultiQueuePlace getMultiQueuePlace() {
                return multiQueuePlace;
            }

            /** 
             * Set the 'MultiQueuePlace' element value.
             * 
             * @param multiQueuePlace
             */
            public void setMultiQueuePlace(MultiQueuePlace multiQueuePlace) {
                this.multiQueuePlace = multiQueuePlace;
            }

            /** 
             * Get the 'QueueInfo' element value.
             * 
             * @return value
             */
            public QueueInfo getQueueInfo() {
                return queueInfo;
            }

            /** 
             * Set the 'QueueInfo' element value.
             * 
             * @param queueInfo
             */
            public void setQueueInfo(QueueInfo queueInfo) {
                this.queueInfo = queueInfo;
            }
            /** 
             * Place on multiple queues
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiQueuePlace" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="QueueIdentifier" maxOccurs="20">
             *         &lt;!-- Reference to inner class QueueIdentifier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultiQueuePlace implements Serializable
            {
                private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();

                /** 
                 * Get the list of 'QueueIdentifier' element items.
                 * 
                 * @return list
                 */
                public List<QueueIdentifier> getQueueIdentifierList() {
                    return queueIdentifierList;
                }

                /** 
                 * Set the list of 'QueueIdentifier' element items.
                 * 
                 * @param list
                 */
                public void setQueueIdentifierList(List<QueueIdentifier> list) {
                    queueIdentifierList = list;
                }
                /** 
                 * Single queue details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="20">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PseudoCityCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QueueIdentifier implements Serializable
                {
                    private String number;
                    private String prefatoryInstructionCode;
                    private String pseudoCityCode;

                    /** 
                     * Get the 'Number' attribute value. Queue number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Queue number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'PrefatoryInstructionCode' attribute value. PIC code
                     * 
                     * @return value
                     */
                    public String getPrefatoryInstructionCode() {
                        return prefatoryInstructionCode;
                    }

                    /** 
                     * Set the 'PrefatoryInstructionCode' attribute value. PIC code
                     * 
                     * @param prefatoryInstructionCode
                     */
                    public void setPrefatoryInstructionCode(
                            String prefatoryInstructionCode) {
                        this.prefatoryInstructionCode = prefatoryInstructionCode;
                    }

                    /** 
                     * Get the 'PseudoCityCode' attribute value. PCC 
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value. PCC 
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }
                }
            }
            /** 
             * Place on a single queue
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="QueueIdentifier" maxOccurs="3">
             *         &lt;!-- Reference to inner class QueueIdentifier -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="UniqueID" minOccurs="0" maxOccurs="6">
             *         &lt;!-- Reference to inner class UniqueID -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class QueueInfo implements Serializable
            {
                private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();
                private List<UniqueID> uniqueIDList = new ArrayList<UniqueID>();

                /** 
                 * Get the list of 'QueueIdentifier' element items.
                 * 
                 * @return list
                 */
                public List<QueueIdentifier> getQueueIdentifierList() {
                    return queueIdentifierList;
                }

                /** 
                 * Set the list of 'QueueIdentifier' element items.
                 * 
                 * @param list
                 */
                public void setQueueIdentifierList(List<QueueIdentifier> list) {
                    queueIdentifierList = list;
                }

                /** 
                 * Get the list of 'UniqueID' element items.
                 * 
                 * @return list
                 */
                public List<UniqueID> getUniqueIDList() {
                    return uniqueIDList;
                }

                /** 
                 * Set the list of 'UniqueID' element items.
                 * 
                 * @param list
                 */
                public void setUniqueIDList(List<UniqueID> list) {
                    uniqueIDList = list;
                }
                /** 
                 * Single queue details
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="3">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Name"/>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
                 *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QueueIdentifier implements Serializable
                {
                    private String name;
                    private String number;
                    private String prefatoryInstructionCode;
                    private String pseudoCityCode;

                    /** 
                     * Get the 'Name' attribute value. Queue name
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. Queue name
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'Number' attribute value. Queue number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Queue number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'PrefatoryInstructionCode' attribute value. PIC code
                     * 
                     * @return value
                     */
                    public String getPrefatoryInstructionCode() {
                        return prefatoryInstructionCode;
                    }

                    /** 
                     * Set the 'PrefatoryInstructionCode' attribute value. PIC code
                     * 
                     * @param prefatoryInstructionCode
                     */
                    public void setPrefatoryInstructionCode(
                            String prefatoryInstructionCode) {
                        this.prefatoryInstructionCode = prefatoryInstructionCode;
                    }

                    /** 
                     * Get the 'PseudoCityCode' attribute value. PCC
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value. PCC
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }
                }
                /** 
                 * This element is not in use
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0" maxOccurs="6">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class UniqueID implements Serializable
                {
                    private String ID;

                    /** 
                     * Get the 'ID' attribute value. This attribute is not in use
                     * 
                     * @return value
                     */
                    public String getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' attribute value. This attribute is not in use
                     * 
                     * @param ID
                     */
                    public void setID(String ID) {
                        this.ID = ID;
                    }
                }
            }
        }
        /** 
         * Used to request e-mail notifications after ending the record
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="eTicket" minOccurs="0">
         *         &lt;!-- Reference to inner class ETicket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Invoice" minOccurs="0">
         *         &lt;!-- Reference to inner class Invoice -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Itinerary" minOccurs="0">
         *         &lt;!-- Reference to inner class Itinerary -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Email implements Serializable
        {
            private ETicket ETicket;
            private Invoice invoice;
            private Itinerary itinerary;
            private PersonName personName;
            private boolean ind;

            /** 
             * Get the 'eTicket' element value.
             * 
             * @return value
             */
            public ETicket getETicket() {
                return ETicket;
            }

            /** 
             * Set the 'eTicket' element value.
             * 
             * @param eTicket
             */
            public void setETicket(ETicket eTicket) {
                ETicket = eTicket;
            }

            /** 
             * Get the 'Invoice' element value.
             * 
             * @return value
             */
            public Invoice getInvoice() {
                return invoice;
            }

            /** 
             * Set the 'Invoice' element value.
             * 
             * @param invoice
             */
            public void setInvoice(Invoice invoice) {
                this.invoice = invoice;
            }

            /** 
             * Get the 'Itinerary' element value.
             * 
             * @return value
             */
            public Itinerary getItinerary() {
                return itinerary;
            }

            /** 
             * Set the 'Itinerary' element value.
             * 
             * @param itinerary
             */
            public void setItinerary(Itinerary itinerary) {
                this.itinerary = itinerary;
            }

            /** 
             * Get the 'PersonName' element value.
             * 
             * @return value
             */
            public PersonName getPersonName() {
                return personName;
            }

            /** 
             * Set the 'PersonName' element value.
             * 
             * @param personName
             */
            public void setPersonName(PersonName personName) {
                this.personName = personName;
            }

            /** 
             * Get the 'Ind' attribute value. Used to send an email notification upon end transaction to any email addresses contained within the particular record
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Used to send an email notification upon end transaction to any email addresses contained within the particular record
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
            /** 
             * eTicket related e-mail request
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PDF" minOccurs="0">
             *         &lt;!-- Reference to inner class PDF -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ETicket implements Serializable
            {
                private PDF PDF1;
                private boolean ind;

                /** 
                 * Get the 'PDF' element value.
                 * 
                 * @return value
                 */
                public PDF getPDF1() {
                    return PDF1;
                }

                /** 
                 * Set the 'PDF' element value.
                 * 
                 * @param PDF1
                 */
                public void setPDF1(PDF PDF1) {
                    this.PDF1 = PDF1;
                }

                /** 
                 * Get the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the eTicket
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the eTicket
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * PDF request
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PDF implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the eTicket
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the eTicket
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
            /** 
             * Invoice related e-mail request
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Invoice implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the invoice
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the invoice
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Itinerary related e-mail request
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Itinerary" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PDF" minOccurs="0">
             *         &lt;!-- Reference to inner class PDF -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Itinerary implements Serializable
            {
                private PDF PDF1;
                private List<Segment> segmentList = new ArrayList<Segment>();
                private boolean ind;

                /** 
                 * Get the 'PDF' element value.
                 * 
                 * @return value
                 */
                public PDF getPDF1() {
                    return PDF1;
                }

                /** 
                 * Set the 'PDF' element value.
                 * 
                 * @param PDF1
                 */
                public void setPDF1(PDF PDF1) {
                    this.PDF1 = PDF1;
                }

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the itinerary
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the itinerary
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * PDF request
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PDF implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the itinerary
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the itinerary
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value. Used to specify an ending segment in the range to include in the email message
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. Used to specify an ending segment in the range to include in the email message
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Used to specify a particular passenger name number to send the email notification to.  Please note that the email address in the PNR's email field must be name associated to the specified name number
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String nameNumber;

                /** 
                 * Get the 'NameNumber' attribute value. Name number
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Name number
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
        }
        /** 
         * ''ScheduleChange'' is used to update schedule changes.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ScheduleChange" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ScheduleChange implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. ''Ind'' is the schedule change indicator.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. ''Ind'' is the schedule change indicator.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Used to specify wait interval to validate whether after booking is ended code share flights keep the holding confirmed status. If the "HK" status changes for any of the flight segments the service will pass corresponding warning message. The maximum time that can be set is 60 seconds. "PostBookingHKValidation" must be combined with .../PostProcessing/RedisplayReservation
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostBookingHKValidation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="waitInterval"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="numAttempts"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PostBookingHKValidation implements Serializable
        {
            private BigInteger waitInterval;
            private BigInteger numAttempts;

            /** 
             * Get the 'waitInterval' attribute value. The maximum time that can be set is 60 seconds. This applies to PostBookingHKValidation, WaitForAirlineRecLoc or both
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value. The maximum time that can be set is 60 seconds. This applies to PostBookingHKValidation, WaitForAirlineRecLoc or both
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }

            /** 
             * Get the 'numAttempts' attribute value. Used to request a redisplay reservation number of attempts
             * 
             * @return value
             */
            public BigInteger getNumAttempts() {
                return numAttempts;
            }

            /** 
             * Set the 'numAttempts' attribute value. Used to request a redisplay reservation number of attempts
             * 
             * @param numAttempts
             */
            public void setNumAttempts(BigInteger numAttempts) {
                this.numAttempts = numAttempts;
            }
        }
        /** 
         * Used to specify wait interval to wait for airline record locators to be returned. If the locators are not returned after the specified interval and number of attempts service will pass corresponding warning message. "WaitForAirlineRecLoc" must be combined with .../PostProcessing/RedisplayReservation
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WaitForAirlineRecLoc" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="waitInterval"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="numAttempts"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class WaitForAirlineRecLoc implements Serializable
        {
            private BigInteger waitInterval;
            private BigInteger numAttempts;

            /** 
             * Get the 'waitInterval' attribute value. The maximum time that can be set is 60 seconds. This applies to PostBookingHKValidation, WaitForAirlineRecLoc or both
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value. The maximum time that can be set is 60 seconds. This applies to PostBookingHKValidation, WaitForAirlineRecLoc or both
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }

            /** 
             * Get the 'numAttempts' attribute value. Used to request a redisplay reservation number of attempts
             * 
             * @return value
             */
            public BigInteger getNumAttempts() {
                return numAttempts;
            }

            /** 
             * Set the 'numAttempts' attribute value. Used to request a redisplay reservation number of attempts
             * 
             * @param numAttempts
             */
            public void setNumAttempts(BigInteger numAttempts) {
                this.numAttempts = numAttempts;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedisplayReservation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="waitInterval"/>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="returnExtendedPriceQuote"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RedisplayReservation implements Serializable
        {
            private BigInteger waitInterval;
            private Boolean returnExtendedPriceQuote;

            /** 
             * Get the 'waitInterval' attribute value. 
                                                              "waitInterval" is used to specify an interval that the system should wait in milliseconds before making redisplay service calls.
                                                          
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value. 
                                                              "waitInterval" is used to specify an interval that the system should wait in milliseconds before making redisplay service calls.
                                                          
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }

            /** 
             * Get the 'returnExtendedPriceQuote' attribute value. Used to request extended price quote display in the service response. The extended content will be passed at .../TravelItineraryRead/PriceQuote.
             * 
             * @return value
             */
            public Boolean getReturnExtendedPriceQuote() {
                return returnExtendedPriceQuote;
            }

            /** 
             * Set the 'returnExtendedPriceQuote' attribute value. Used to request extended price quote display in the service response. The extended content will be passed at .../TravelItineraryRead/PriceQuote.
             * 
             * @param returnExtendedPriceQuote
             */
            public void setReturnExtendedPriceQuote(
                    Boolean returnExtendedPriceQuote) {
                this.returnExtendedPriceQuote = returnExtendedPriceQuote;
            }
        }
    }
}
