
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;

/** 
 * Used to specify a preference level for ValidatingCarrier. For adding new enums see PreferLevelType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrierPreferLevelType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Unacceptable"/>
 *     &lt;xs:enumeration value="Preferred"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ValidatingCarrierPreferLevelType implements Serializable {
    UNACCEPTABLE("Unacceptable"), PREFERRED("Preferred");
    private final String value;

    private ValidatingCarrierPreferLevelType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ValidatingCarrierPreferLevelType convert(String value) {
        for (ValidatingCarrierPreferLevelType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
