
package com.sabre.services.stl.v01;

import java.io.Serializable;

/** 
 * All message roots should be created as an extension of this base type. Global message elements
 must declare they are a member of the STL_Payload substitution group. This type may be used when an empty payload is
 needed for error handling. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STL_Payload">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:ApplicationResults" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="version"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class STLPayload1 implements Serializable
{
    private ApplicationResults applicationResults;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'version' attribute value. Version of the payload message.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Version of the payload message.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
