
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Building" name="Building" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:Street" name="Street" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:City" name="City" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="County" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:State" name="StateProv" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:Country" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *   &lt;xs:attribute type="ns:Enum_AddressRole_Base" name="role"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Address1 implements Serializable
{
    private List<Building> buildingList = new ArrayList<Building>();
    private Street street;
    private City city;
    private String county;
    private State stateProv;
    private Country country;
    private String postalCode;
    private ExtensionPointSummary extensionPointSummary;
    private String id;
    private EnumAddressRoleBase role;

    /** 
     * Get the list of 'Building' element items. Building name, room, apartment, or suite number.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}Building
                      
     * 
     * @return list
     */
    public List<Building> getBuildingList() {
        return buildingList;
    }

    /** 
     * Set the list of 'Building' element items. Building name, room, apartment, or suite number.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}Building
                      
     * 
     * @param list
     */
    public void setBuildingList(List<Building> list) {
        buildingList = list;
    }

    /** 
     * Get the 'Street' element value. May contain the street number and street name.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}Street
                      
     * 
     * @return value
     */
    public Street getStreet() {
        return street;
    }

    /** 
     * Set the 'Street' element value. May contain the street number and street name.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}Street
                      
     * 
     * @param street
     */
    public void setStreet(Street street) {
        this.street = street;
    }

    /** 
     * Get the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a
                          postal service territory, often used in a military address).
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @return value
     */
    public City getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a
                          postal service territory, often used in a military address).
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @param city
     */
    public void setCity(City city) {
        this.city = city;
    }

    /** 
     * Get the 'County' element value. County or Region Name (e.g., Fairfax).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to32
                      
     * 
     * @return value
     */
    public String getCounty() {
        return county;
    }

    /** 
     * Set the 'County' element value. County or Region Name (e.g., Fairfax).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to32
                      
     * 
     * @param county
     */
    public void setCounty(String county) {
        this.county = county;
    }

    /** 
     * Get the 'StateProv' element value. State or Province name (e.g., Texas).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @return value
     */
    public State getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State or Province name (e.g., Texas).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @param stateProv
     */
    public void setStateProv(State stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'Country' element value. Country name (e.g., Ireland).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @return value
     */
    public Country getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Country name (e.g., Ireland).Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to64
                      
     * 
     * @param country
     */
    public void setCountry(Country country) {
        this.country = country;
    }

    /** 
     * Get the 'PostalCode' element value. Post Office Code number.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to16
                      
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Post Office Code number.Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to16
                      
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }

    /** 
     * Get the 'id' attribute value. Used elsewhere in the message to reference this
                      specific address.
                  Assigned XSD Type:
                      {http://services.sabre.com/STL/v01}ComponentIndex
                  
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. Used elsewhere in the message to reference this
                      specific address.
                  Assigned XSD Type:
                      {http://services.sabre.com/STL/v01}ComponentIndex
                  
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'role' attribute value.
     * 
     * @return value
     */
    public EnumAddressRoleBase getRole() {
        return role;
    }

    /** 
     * Set the 'role' attribute value.
     * 
     * @param role
     */
    public void setRole(EnumAddressRoleBase role) {
        this.role = role;
    }
}
