
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Standard code for an airport.Assigned XSD Type:
 {http://services.sabre.com/STL/v01}UpperCaseAlphaNumericLength3to5

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airport">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="name"/>
 *       &lt;xs:attribute type="ns:Enum_IATA_OrICAO" use="optional" name="codeContext"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="terminal"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="gate"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Airport implements Serializable
{
    private String string;
    private String name;
    private EnumIATAOrICAO codeContext;
    private String terminal;
    private String gate;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'name' attribute value. Full or display name of the airport.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'name' attribute value. Full or display name of the airport.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'codeContext' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to32
                          
     * 
     * @return value
     */
    public EnumIATAOrICAO getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'codeContext' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to32
                          
     * 
     * @param codeContext
     */
    public void setCodeContext(EnumIATAOrICAO codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'terminal' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @return value
     */
    public String getTerminal() {
        return terminal;
    }

    /** 
     * Set the 'terminal' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @param terminal
     */
    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    /** 
     * Get the 'gate' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @return value
     */
    public String getGate() {
        return gate;
    }

    /** 
     * Set the 'gate' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @param gate
     */
    public void setGate(String gate) {
        this.gate = gate;
    }
}
