
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

/** 
 * Customer Value Score.Assigned XSD Type:
 {http://services.sabre.com/STL/v01}Score

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CV_Score">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:decimal">
 *       &lt;xs:attribute type="xs:decimal" use="optional" name="tDW"/>
 *       &lt;xs:attribute type="xs:decimal" use="optional" name="airline"/>
 *       &lt;xs:attribute type="xs:decimal" use="optional" name="override"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="overriideEffectiveDate"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="overrideDiscontinueDate"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="airlineEffectiveDate"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="airlineDiscontinueDate"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="tDWEffectiveDate"/>
 *       &lt;xs:attribute type="xs:date" use="optional" name="tDWDiscintinueDate"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CVScore implements Serializable
{
    private BigDecimal decimal;
    private BigDecimal TDW;
    private BigDecimal airline;
    private BigDecimal override;
    private Date overriideEffectiveDate;
    private Date overrideDiscontinueDate;
    private Date airlineEffectiveDate;
    private Date airlineDiscontinueDate;
    private Date TDWEffectiveDate;
    private Date TDWDiscintinueDate;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigDecimal getDecimal() {
        return decimal;
    }

    /** 
     * Set the extension value.
     * 
     * @param decimal
     */
    public void setDecimal(BigDecimal decimal) {
        this.decimal = decimal;
    }

    /** 
     * Get the 'tDW' attribute value. Customer Value Calculator computed value computed by
                              TDW
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @return value
     */
    public BigDecimal getTDW() {
        return TDW;
    }

    /** 
     * Set the 'tDW' attribute value. Customer Value Calculator computed value computed by
                              TDW
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @param tDW
     */
    public void setTDW(BigDecimal tDW) {
        TDW = tDW;
    }

    /** 
     * Get the 'airline' attribute value. A score provided by the airlineAssigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @return value
     */
    public BigDecimal getAirline() {
        return airline;
    }

    /** 
     * Set the 'airline' attribute value. A score provided by the airlineAssigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @param airline
     */
    public void setAirline(BigDecimal airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'override' attribute value. A score entered by manual override representing a
                              minimum customer value score for the customer
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @return value
     */
    public BigDecimal getOverride() {
        return override;
    }

    /** 
     * Set the 'override' attribute value. A score entered by manual override representing a
                              minimum customer value score for the customer
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}Score
                          
     * 
     * @param override
     */
    public void setOverride(BigDecimal override) {
        this.override = override;
    }

    /** 
     * Get the 'overriideEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getOverriideEffectiveDate() {
        return overriideEffectiveDate;
    }

    /** 
     * Set the 'overriideEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param overriideEffectiveDate
     */
    public void setOverriideEffectiveDate(Date overriideEffectiveDate) {
        this.overriideEffectiveDate = overriideEffectiveDate;
    }

    /** 
     * Get the 'overrideDiscontinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getOverrideDiscontinueDate() {
        return overrideDiscontinueDate;
    }

    /** 
     * Set the 'overrideDiscontinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param overrideDiscontinueDate
     */
    public void setOverrideDiscontinueDate(Date overrideDiscontinueDate) {
        this.overrideDiscontinueDate = overrideDiscontinueDate;
    }

    /** 
     * Get the 'airlineEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getAirlineEffectiveDate() {
        return airlineEffectiveDate;
    }

    /** 
     * Set the 'airlineEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param airlineEffectiveDate
     */
    public void setAirlineEffectiveDate(Date airlineEffectiveDate) {
        this.airlineEffectiveDate = airlineEffectiveDate;
    }

    /** 
     * Get the 'airlineDiscontinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getAirlineDiscontinueDate() {
        return airlineDiscontinueDate;
    }

    /** 
     * Set the 'airlineDiscontinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param airlineDiscontinueDate
     */
    public void setAirlineDiscontinueDate(Date airlineDiscontinueDate) {
        this.airlineDiscontinueDate = airlineDiscontinueDate;
    }

    /** 
     * Get the 'tDWEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getTDWEffectiveDate() {
        return TDWEffectiveDate;
    }

    /** 
     * Set the 'tDWEffectiveDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param tDWEffectiveDate
     */
    public void setTDWEffectiveDate(Date tDWEffectiveDate) {
        TDWEffectiveDate = tDWEffectiveDate;
    }

    /** 
     * Get the 'tDWDiscintinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @return value
     */
    public Date getTDWDiscintinueDate() {
        return TDWDiscintinueDate;
    }

    /** 
     * Set the 'tDWDiscintinueDate' attribute value. Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
                          
     * 
     * @param tDWDiscintinueDate
     */
    public void setTDWDiscintinueDate(Date tDWDiscintinueDate) {
        TDWDiscintinueDate = tDWDiscintinueDate;
    }
}
