
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Date_DayOfWeek">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Mon"/>
 *     &lt;xs:enumeration value="Tue"/>
 *     &lt;xs:enumeration value="Wed"/>
 *     &lt;xs:enumeration value="Thu"/>
 *     &lt;xs:enumeration value="Fri"/>
 *     &lt;xs:enumeration value="Sat"/>
 *     &lt;xs:enumeration value="Sun"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DateDayOfWeek implements Serializable {
    MON("Mon"), TUE("Tue"), WED("Wed"), THU("Thu"), FRI("Fri"), SAT("Sat"), SUN(
            "Sun");
    private final String value;

    private DateDayOfWeek(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DateDayOfWeek convert(String value) {
        for (DateDayOfWeek inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
