
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Used to indicate the type of address e.g. home
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_AddressType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="HOME"/>
 *     &lt;xs:enumeration value="WORK"/>
 *     &lt;xs:enumeration value="INVOICE"/>
 *     &lt;xs:enumeration value="OTHER"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumAddressType implements Serializable {
    /** 
     * Home address
     */
    HOME, /** 
           * Work address
           */
    WORK, /** 
           * Address where invoices should be sent
           */
    INVOICE, /** 
              * Other type of address
              */
    OTHER
}
