
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * An identifier for the category or use of an address.This is a string list of enumerations with an "Other_"
 literal to support an open enumeration list. Use the "Other_" value
 in combination with the @extension attribute to exchange a literal
 that is not in the list and is known to your trading partners.
 Table name(s): Address Use Type (AUT)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_AddressUse_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Billing"/>
 *     &lt;xs:enumeration value="Chain"/>
 *     &lt;xs:enumeration value="Collection"/>
 *     &lt;xs:enumeration value="Contact"/>
 *     &lt;xs:enumeration value="CreditCard"/>
 *     &lt;xs:enumeration value="Delivery"/>
 *     &lt;xs:enumeration value="Deposit"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="Mailing"/>
 *     &lt;xs:enumeration value="OtherUse"/>
 *     &lt;xs:enumeration value="Permanent"/>
 *     &lt;xs:enumeration value="Physical"/>
 *     &lt;xs:enumeration value="PreOpeningOffice"/>
 *     &lt;xs:enumeration value="Home"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumAddressUseBase implements Serializable {
    BILLING("Billing"), CHAIN("Chain"), COLLECTION("Collection"), CONTACT(
            "Contact"), CREDIT_CARD("CreditCard"), DELIVERY("Delivery"), DEPOSIT(
            "Deposit"), HOTEL("Hotel"), MAILING("Mailing"), OTHER_USE(
            "OtherUse"), PERMANENT("Permanent"), PHYSICAL("Physical"), PRE_OPENING_OFFICE(
            "PreOpeningOffice"), HOME("Home"), BUSINESS("Business"), OTHER_(
            "Other_");
    private final String value;

    private EnumAddressUseBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumAddressUseBase convert(String value) {
        for (EnumAddressUseBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
