
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_MembershipLevelTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="2L"/>
 *     &lt;xs:enumeration value="3L"/>
 *     &lt;xs:enumeration value="BN"/>
 *     &lt;xs:enumeration value="TI"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumMembershipLevelTypes implements Serializable {
    _2_L("2L"), _3_L("3L"), BN("BN"), TI("TI");
    private final String value;

    private EnumMembershipLevelTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumMembershipLevelTypes convert(String value) {
        for (EnumMembershipLevelTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
