
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Defines possible types of phone numbers e.g. mobile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_PhoneType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="MOBILE"/>
 *     &lt;xs:enumeration value="WORK"/>
 *     &lt;xs:enumeration value="HOME"/>
 *     &lt;xs:enumeration value="FAX"/>
 *     &lt;xs:enumeration value="OTHER"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumPhoneType implements Serializable {
    /** 
     * Mobile number
     */
    MOBILE, /** 
             * Work number
             */
    WORK, /** 
           * Home number
           */
    HOME, /** 
           * Fax number
           */
    FAX, /** 
          * Other - not listed
          */
    OTHER
}
