
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_PricingUnit">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Per stay"/>
 *     &lt;xs:enumeration value="Per person"/>
 *     &lt;xs:enumeration value="Per night"/>
 *     &lt;xs:enumeration value="Per person per night"/>
 *     &lt;xs:enumeration value="Per use"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumPricingUnit implements Serializable {
    PERSTAY("Per stay"), PERPERSON("Per person"), PERNIGHT("Per night"), PERPERSONPERNIGHT(
            "Per person per night"), PERUSE("Per use");
    private final String value;

    private EnumPricingUnit(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumPricingUnit convert(String value) {
        for (EnumPricingUnit inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
