
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * An identifier for seat preferences, typically used by air and rail.This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Seat Preference (STP)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatPreference">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="None"/>
 *     &lt;xs:enumeration value="Together"/>
 *     &lt;xs:enumeration value="Aisle"/>
 *     &lt;xs:enumeration value="Center"/>
 *     &lt;xs:enumeration value="Window"/>
 *     &lt;xs:enumeration value="Specific"/>
 *     &lt;xs:enumeration value="Exit"/>
 *     &lt;xs:enumeration value="NonsmokingAisle"/>
 *     &lt;xs:enumeration value="NonsmokingWindow"/>
 *     &lt;xs:enumeration value="NonsmokingBulkhead"/>
 *     &lt;xs:enumeration value="NonsmokingAny"/>
 *     &lt;xs:enumeration value="SmokingAisle"/>
 *     &lt;xs:enumeration value="SmokingWindow"/>
 *     &lt;xs:enumeration value="SmokingBulkhead"/>
 *     &lt;xs:enumeration value="SmokingAny"/>
 *     &lt;xs:enumeration value="AdjacentAisleSeat"/>
 *     &lt;xs:enumeration value="PremiumSeat"/>
 *     &lt;xs:enumeration value="BlockedSeat"/>
 *     &lt;xs:enumeration value="PermanentlyBlockedSeat"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatPreference implements Serializable {
    NONE("None"), TOGETHER("Together"), AISLE("Aisle"), CENTER("Center"), WINDOW(
            "Window"), SPECIFIC("Specific"), EXIT("Exit"), NONSMOKING_AISLE(
            "NonsmokingAisle"), NONSMOKING_WINDOW("NonsmokingWindow"), NONSMOKING_BULKHEAD(
            "NonsmokingBulkhead"), NONSMOKING_ANY("NonsmokingAny"), SMOKING_AISLE(
            "SmokingAisle"), SMOKING_WINDOW("SmokingWindow"), SMOKING_BULKHEAD(
            "SmokingBulkhead"), SMOKING_ANY("SmokingAny"), ADJACENT_AISLE_SEAT(
            "AdjacentAisleSeat"), PREMIUM_SEAT("PremiumSeat"), BLOCKED_SEAT(
            "BlockedSeat"), PERMANENTLY_BLOCKED_SEAT("PermanentlyBlockedSeat");
    private final String value;

    private EnumSeatPreference(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatPreference convert(String value) {
        for (EnumSeatPreference inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
