
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_ShareIndicator">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Yes"/>
 *     &lt;xs:enumeration value="No"/>
 *     &lt;xs:enumeration value="Inherit"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumShareIndicator implements Serializable {
    YES("Yes"), NO("No"), INHERIT("Inherit");
    private final String value;

    private EnumShareIndicator(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumShareIndicator convert(String value) {
        for (EnumShareIndicator inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
