
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_TravelSector">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Air"/>
 *     &lt;xs:enumeration value="Car"/>
 *     &lt;xs:enumeration value="Cruise"/>
 *     &lt;xs:enumeration value="Excursion"/>
 *     &lt;xs:enumeration value="Ferry"/>
 *     &lt;xs:enumeration value="Golf"/>
 *     &lt;xs:enumeration value="GroundTransport"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="Insurance"/>
 *     &lt;xs:enumeration value="Rail"/>
 *     &lt;xs:enumeration value="Tour"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumTravelSector implements Serializable {
    AIR("Air"), CAR("Car"), CRUISE("Cruise"), EXCURSION("Excursion"), FERRY(
            "Ferry"), GOLF("Golf"), GROUND_TRANSPORT("GroundTransport"), HOTEL(
            "Hotel"), INSURANCE("Insurance"), RAIL("Rail"), TOUR("Tour");
    private final String value;

    private EnumTravelSector(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumTravelSector convert(String value) {
        for (EnumTravelSector inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
