
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * This is the pricing units applied - codes:L=Pounds,
 K=Kilos, P=Pieces

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_WeightCode">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="L"/>
 *     &lt;xs:enumeration value="K"/>
 *     &lt;xs:enumeration value="P"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumWeightCode implements Serializable {
    /** 
     * Pounds
     */
    L, /** 
        * Kilograms
        */
    K, /** 
        * Pieces
        */
    P
}
