
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyalty_Level">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="atpco"/>
 *       &lt;xs:attribute type="ns:Enum_MembershipLevelTypes" use="optional" name="sabre"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="vendor"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyLevel implements Serializable
{
    private String string;
    private String atpco;
    private EnumMembershipLevelTypes sabre;
    private String vendor;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'atpco' attribute value. ATPCO level value between 1 and 9.
     * 
     * @return value
     */
    public String getAtpco() {
        return atpco;
    }

    /** 
     * Set the 'atpco' attribute value. ATPCO level value between 1 and 9.
     * 
     * @param atpco
     */
    public void setAtpco(String atpco) {
        this.atpco = atpco;
    }

    /** 
     * Get the 'sabre' attribute value.
     * 
     * @return value
     */
    public EnumMembershipLevelTypes getSabre() {
        return sabre;
    }

    /** 
     * Set the 'sabre' attribute value.
     * 
     * @param sabre
     */
    public void setSabre(EnumMembershipLevelTypes sabre) {
        this.sabre = sabre;
    }

    /** 
     * Get the 'vendor' attribute value. The level described by the loyalty program. The value domain of level is
                              completely under control of the airline or provider; do not make non-provider specfic assumptions about its
                              value range.
                          
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'vendor' attribute value. The level described by the loyalty program. The value domain of level is
                              completely under control of the airline or provider; do not make non-provider specfic assumptions about its
                              value range.
                          
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }
}
