
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Locations:
 Psuedo - Agency PCC or Agent AAA
 Actual ? where the transaction is initiated
 Home ? assigned to the agent account

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:POS_Location" name="Actual" minOccurs="0"/>
 *     &lt;xs:element type="ns:POS_Location" name="Home" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Pcc" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Enum_CodeDuty" use="optional" name="duty"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="lniata"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="sine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="multiHost"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="company"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POS implements Serializable
{
    private POSLocation actual;
    private POSLocation home;
    private String pcc;
    private EnumCodeDuty duty;
    private String lniata;
    private String sine;
    private String multiHost;
    private String company;

    /** 
     * Get the 'Actual' element value. Actual is where the transaction is initiated.
     * 
     * @return value
     */
    public POSLocation getActual() {
        return actual;
    }

    /** 
     * Set the 'Actual' element value. Actual is where the transaction is initiated.
     * 
     * @param actual
     */
    public void setActual(POSLocation actual) {
        this.actual = actual;
    }

    /** 
     * Get the 'Home' element value. Home is assigned to the agent account.
     * 
     * @return value
     */
    public POSLocation getHome() {
        return home;
    }

    /** 
     * Set the 'Home' element value. Home is assigned to the agent account.
     * 
     * @param home
     */
    public void setHome(POSLocation home) {
        this.home = home;
    }

    /** 
     * Get the 'Pcc' element value. Psuedo is either Agency PCC or Agent AAA. Required for
                          most source code is provided.
                      
     * 
     * @return value
     */
    public String getPcc() {
        return pcc;
    }

    /** 
     * Set the 'Pcc' element value. Psuedo is either Agency PCC or Agent AAA. Required for
                          most source code is provided.
                      
     * 
     * @param pcc
     */
    public void setPcc(String pcc) {
        this.pcc = pcc;
    }

    /** 
     * Get the 'duty' attribute value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public EnumCodeDuty getDuty() {
        return duty;
    }

    /** 
     * Set the 'duty' attribute value. An authority code assigned to a requestor.
     * 
     * @param duty
     */
    public void setDuty(EnumCodeDuty duty) {
        this.duty = duty;
    }

    /** 
     * Get the 'lniata' attribute value. LNIATA of the Console the agent signed into.
     * 
     * @return value
     */
    public String getLniata() {
        return lniata;
    }

    /** 
     * Set the 'lniata' attribute value. LNIATA of the Console the agent signed into.
     * 
     * @param lniata
     */
    public void setLniata(String lniata) {
        this.lniata = lniata;
    }

    /** 
     * Get the 'sine' attribute value. Identifies the agent or party within the requesting entity.
     * 
     * @return value
     */
    public String getSine() {
        return sine;
    }

    /** 
     * Set the 'sine' attribute value. Identifies the agent or party within the requesting entity.
     * 
     * @param sine
     */
    public void setSine(String sine) {
        this.sine = sine;
    }

    /** 
     * Get the 'multiHost' attribute value. Airline partition for multi-host source locations.
     * 
     * @return value
     */
    public String getMultiHost() {
        return multiHost;
    }

    /** 
     * Set the 'multiHost' attribute value. Airline partition for multi-host source locations.
     * 
     * @param multiHost
     */
    public void setMultiHost(String multiHost) {
        this.multiHost = multiHost;
    }

    /** 
     * Get the 'company' attribute value. The IATA assigned code for the Agency or Airine
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'company' attribute value. The IATA assigned code for the Agency or Airine
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }
}
