
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * A location for an airline or agency agent. Can be used
 to describe the actual, pseudo or home location.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS_Location">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="country"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="province"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="city"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="number"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POSLocation implements Serializable
{
    private String string;
    private String country;
    private String province;
    private String city;
    private String number;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'country' attribute value.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'country' attribute value.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'province' attribute value.
     * 
     * @return value
     */
    public String getProvince() {
        return province;
    }

    /** 
     * Set the 'province' attribute value.
     * 
     * @param province
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /** 
     * Get the 'city' attribute value.
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'city' attribute value.
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'number' attribute value. agent station number or agency iata number
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. agent station number or agency iata number
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }
}
