
package com.sabre.services.stlheader.v120;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProblemSummary">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Identifier.System" name="Source" minOccurs="0"/>
 *     &lt;xs:element type="ns:Identifier.System" name="ReportingSystem"/>
 *     &lt;xs:element type="ns:Message.Condition" name="Message" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:ErrorType" use="required" name="type"/>
 *   &lt;xs:attribute type="ns:CompletionCodes" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProblemSummary implements Serializable
{
    private IdentifierSystem source;
    private IdentifierSystem reportingSystem;
    private MessageCondition message;
    private String shortText;
    private ErrorType type;
    private CompletionCodes status;
    private Date timeStamp;

    /** 
     * Get the 'Source' element value. 
    					The system that the reporting system deemed to be the cause of the problem. If omitted, the
    					reporting system is also the source of the problem. For application errors, the element may
    					identify a system the application is dependent upon that failed to respond. For validation
    					errors this may identify the service consumer.
    				
     * 
     * @return value
     */
    public IdentifierSystem getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. 
    					The system that the reporting system deemed to be the cause of the problem. If omitted, the
    					reporting system is also the source of the problem. For application errors, the element may
    					identify a system the application is dependent upon that failed to respond. For validation
    					errors this may identify the service consumer.
    				
     * 
     * @param source
     */
    public void setSource(IdentifierSystem source) {
        this.source = source;
    }

    /** 
     * Get the 'ReportingSystem' element value. 
    					The system that created the results record. If the Source system identifier is omitted, the
    					system identified here both was the cause of the problem and created the result record.
    				
     * 
     * @return value
     */
    public IdentifierSystem getReportingSystem() {
        return reportingSystem;
    }

    /** 
     * Set the 'ReportingSystem' element value. 
    					The system that created the results record. If the Source system identifier is omitted, the
    					system identified here both was the cause of the problem and created the result record.
    				
     * 
     * @param reportingSystem
     */
    public void setReportingSystem(IdentifierSystem reportingSystem) {
        this.reportingSystem = reportingSystem;
    }

    /** 
     * Get the 'Message' element value. 
    					An informative code and message that describes the results. Note: the message code and text must
    					NOT be required to process to understand retry/compensate status.
    					This value should be the same as in the SystemSpecificResults in the body.
    				
     * 
     * @return value
     */
    public MessageCondition getMessage() {
        return message;
    }

    /** 
     * Set the 'Message' element value. 
    					An informative code and message that describes the results. Note: the message code and text must
    					NOT be required to process to understand retry/compensate status.
    					This value should be the same as in the SystemSpecificResults in the body.
    				
     * 
     * @param message
     */
    public void setMessage(MessageCondition message) {
        this.message = message;
    }

    /** 
     * Get the 'ShortText' element value. 
    					An abbreviated version of the error in textual format.
    					This value should be the same as in the SystemSpecificResults in the body.
    				
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' element value. 
    					An abbreviated version of the error in textual format.
    					This value should be the same as in the SystemSpecificResults in the body.
    				
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    /** 
     * Get the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @return value
     */
    public ErrorType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @param type
     */
    public void setType(ErrorType type) {
        this.type = type;
    }

    /** 
     * Get the 'status' attribute value. Impact of the error on process completion.
     * 
     * @return value
     */
    public CompletionCodes getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. Impact of the error on process completion.
     * 
     * @param status
     */
    public void setStatus(CompletionCodes status) {
        this.status = status;
    }

    /** 
     * Get the 'timeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
