
package com.sabre.services.stlheader.v120;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResultSummary">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="Success"/>
 *     &lt;xs:element type="ns:ProblemSummary" name="Error"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResultSummary implements Serializable
{
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERROR_CHOICE = 1;
    private String success;
    private ProblemSummary error;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. Success indicates that the request was
    					processed successfully.
    				
     * 
     * @return value
     */
    public String getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. Success indicates that the request was
    					processed successfully.
    				
     * 
     * @param success
     */
    public void setSuccess(String success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Check if Error is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifError() {
        return choiceSelect == ERROR_CHOICE;
    }

    /** 
     * Get the 'Error' element value.
     * 
     * @return value
     */
    public ProblemSummary getError() {
        return error;
    }

    /** 
     * Set the 'Error' element value.
     * 
     * @param error
     */
    public void setError(ProblemSummary error) {
        setChoiceSelect(ERROR_CHOICE);
        this.error = error;
    }
}
