
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenity_Detail">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:Amenity">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:Code" name="SecondaryCode" minOccurs="0"/>
 *         &lt;xs:element type="ns:Code" name="SupplierCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Taxes" minOccurs="0" maxOccurs="15"/>
 *         &lt;xs:element type="xs:string" name="URI" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PriceTypeRef" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AmenityDetail extends Amenity implements Serializable
{
    private Code secondaryCode;
    private Code supplierCode;
    private List<Taxes> taxeList = new ArrayList<Taxes>();
    private String URI;
    private String priceTypeRef;

    /** 
     * Get the 'SecondaryCode' element value. sub-code or additional code
     * 
     * @return value
     */
    public Code getSecondaryCode() {
        return secondaryCode;
    }

    /** 
     * Set the 'SecondaryCode' element value. sub-code or additional code
     * 
     * @param secondaryCode
     */
    public void setSecondaryCode(Code secondaryCode) {
        this.secondaryCode = secondaryCode;
    }

    /** 
     * Get the 'SupplierCode' element value. Supplier specific product code.
     * 
     * @return value
     */
    public Code getSupplierCode() {
        return supplierCode;
    }

    /** 
     * Set the 'SupplierCode' element value. Supplier specific product code.
     * 
     * @param supplierCode
     */
    public void setSupplierCode(Code supplierCode) {
        this.supplierCode = supplierCode;
    }

    /** 
     * Get the list of 'Taxes' element items. Tax applicable to this price
     * 
     * @return list
     */
    public List<Taxes> getTaxeList() {
        return taxeList;
    }

    /** 
     * Set the list of 'Taxes' element items. Tax applicable to this price
     * 
     * @param list
     */
    public void setTaxeList(List<Taxes> list) {
        taxeList = list;
    }

    /** 
     * Get the 'URI' element value. Link to description of the Amenity
     * 
     * @return value
     */
    public String getURI() {
        return URI;
    }

    /** 
     * Set the 'URI' element value. Link to description of the Amenity
     * 
     * @param URI
     */
    public void setURI(String URI) {
        this.URI = URI;
    }

    /** 
     * Get the 'PriceTypeRef' element value. List of price types applicable
     * 
     * @return value
     */
    public String getPriceTypeRef() {
        return priceTypeRef;
    }

    /** 
     * Set the 'PriceTypeRef' element value. List of price types applicable
     * 
     * @param priceTypeRef
     */
    public void setPriceTypeRef(String priceTypeRef) {
        this.priceTypeRef = priceTypeRef;
    }
}
