
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:CabinClass" minOccurs="1"/>
 *     &lt;xs:element ref="ns:Price" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element ref="ns:Row" minOccurs="0" maxOccurs="999"/>
 *     &lt;xs:element ref="ns:Wing" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Column" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:CabinFacility" minOccurs="0" maxOccurs="4999"/>
 *     &lt;xs:element ref="ns:Section" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="AmenityRef" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="capacity"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="firstRow"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="lastRow"/>
 *   &lt;xs:attribute type="ns:Enum_CabinClassLocation" use="optional" name="classLocation"/>
 *   &lt;xs:attribute type="ns:Enum_SeatOccupationCabinDefault" use="optional" name="seatOccupationDefault"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="rowQty"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Cabin implements Serializable
{
    private CabinClass cabinClass;
    private List<Price> priceList = new ArrayList<Price>();
    private List<Row> rowList = new ArrayList<Row>();
    private Wing wing;
    private List<Column> columnList = new ArrayList<Column>();
    private List<CabinFacility> cabinFacilityList = new ArrayList<CabinFacility>();
    private List<Section> sectionList = new ArrayList<Section>();
    private String amenityRef;
    private String capacity;
    private String firstRow;
    private String lastRow;
    private EnumCabinClassLocation classLocation;
    private EnumSeatOccupationCabinDefault seatOccupationDefault;
    private String rowQty;

    /** 
     * Get the 'CabinClass' element value. Cabin class/type/marketing name information
     * 
     * @return value
     */
    public CabinClass getCabinClass() {
        return cabinClass;
    }

    /** 
     * Set the 'CabinClass' element value. Cabin class/type/marketing name information
     * 
     * @param cabinClass
     */
    public void setCabinClass(CabinClass cabinClass) {
        this.cabinClass = cabinClass;
    }

    /** 
     * Get the list of 'Price' element items. Default cabin level seat price with qualifiers and rules.
     * 
     * @return list
     */
    public List<Price> getPriceList() {
        return priceList;
    }

    /** 
     * Set the list of 'Price' element items. Default cabin level seat price with qualifiers and rules.
     * 
     * @param list
     */
    public void setPriceList(List<Price> list) {
        priceList = list;
    }

    /** 
     * Get the list of 'Row' element items. Row and Seat Data
     * 
     * @return list
     */
    public List<Row> getRowList() {
        return rowList;
    }

    /** 
     * Set the list of 'Row' element items. Row and Seat Data
     * 
     * @param list
     */
    public void setRowList(List<Row> list) {
        rowList = list;
    }

    /** 
     * Get the 'Wing' element value. overwing row definition
     * 
     * @return value
     */
    public Wing getWing() {
        return wing;
    }

    /** 
     * Set the 'Wing' element value. overwing row definition
     * 
     * @param wing
     */
    public void setWing(Wing wing) {
        this.wing = wing;
    }

    /** 
     * Get the list of 'Column' element items. Column descriptors
     * 
     * @return list
     */
    public List<Column> getColumnList() {
        return columnList;
    }

    /** 
     * Set the list of 'Column' element items. Column descriptors
     * 
     * @param list
     */
    public void setColumnList(List<Column> list) {
        columnList = list;
    }

    /** 
     * Get the list of 'CabinFacility' element items. cabin facilities relative to cabin and first and last row
     * 
     * @return list
     */
    public List<CabinFacility> getCabinFacilityList() {
        return cabinFacilityList;
    }

    /** 
     * Set the list of 'CabinFacility' element items. cabin facilities relative to cabin and first and last row
     * 
     * @param list
     */
    public void setCabinFacilityList(List<CabinFacility> list) {
        cabinFacilityList = list;
    }

    /** 
     * Get the list of 'Section' element items. Separation of sections in a single cabin
     * 
     * @return list
     */
    public List<Section> getSectionList() {
        return sectionList;
    }

    /** 
     * Set the list of 'Section' element items. Separation of sections in a single cabin
     * 
     * @param list
     */
    public void setSectionList(List<Section> list) {
        sectionList = list;
    }

    /** 
     * Get the 'AmenityRef' element value.
     * 
     * @return value
     */
    public String getAmenityRef() {
        return amenityRef;
    }

    /** 
     * Set the 'AmenityRef' element value.
     * 
     * @param amenityRef
     */
    public void setAmenityRef(String amenityRef) {
        this.amenityRef = amenityRef;
    }

    /** 
     * Get the 'capacity' attribute value. The total quantity of physical seats in the cabin.
     * 
     * @return value
     */
    public String getCapacity() {
        return capacity;
    }

    /** 
     * Set the 'capacity' attribute value. The total quantity of physical seats in the cabin.
     * 
     * @param capacity
     */
    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    /** 
     * Get the 'firstRow' attribute value. number of first row in this cabin
     * 
     * @return value
     */
    public String getFirstRow() {
        return firstRow;
    }

    /** 
     * Set the 'firstRow' attribute value. number of first row in this cabin
     * 
     * @param firstRow
     */
    public void setFirstRow(String firstRow) {
        this.firstRow = firstRow;
    }

    /** 
     * Get the 'lastRow' attribute value. number of last row in this cabin
     * 
     * @return value
     */
    public String getLastRow() {
        return lastRow;
    }

    /** 
     * Set the 'lastRow' attribute value. number of last row in this cabin
     * 
     * @param lastRow
     */
    public void setLastRow(String lastRow) {
        this.lastRow = lastRow;
    }

    /** 
     * Get the 'classLocation' attribute value. Class location in cabin Lowerdeck,Maindeck or Upperdeck
     * 
     * @return value
     */
    public EnumCabinClassLocation getClassLocation() {
        return classLocation;
    }

    /** 
     * Set the 'classLocation' attribute value. Class location in cabin Lowerdeck,Maindeck or Upperdeck
     * 
     * @param classLocation
     */
    public void setClassLocation(EnumCabinClassLocation classLocation) {
        this.classLocation = classLocation;
    }

    /** 
     * Get the 'seatOccupationDefault' attribute value. default occupation for all seats
     * 
     * @return value
     */
    public EnumSeatOccupationCabinDefault getSeatOccupationDefault() {
        return seatOccupationDefault;
    }

    /** 
     * Set the 'seatOccupationDefault' attribute value. default occupation for all seats
     * 
     * @param seatOccupationDefault
     */
    public void setSeatOccupationDefault(
            EnumSeatOccupationCabinDefault seatOccupationDefault) {
        this.seatOccupationDefault = seatOccupationDefault;
    }

    /** 
     * Get the 'rowQty' attribute value. Total number of Rows this cabin
     * 
     * @return value
     */
    public String getRowQty() {
        return rowQty;
    }

    /** 
     * Set the 'rowQty' attribute value. Total number of Rows this cabin
     * 
     * @param rowQty
     */
    public void setRowQty(String rowQty) {
        this.rowQty = rowQty;
    }
}
