
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CabinType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RBD" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingDescription" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CabinType1 implements Serializable
{
    private String cabinType;
    private String RBD;
    private String marketingName;
    private List<String> marketingDescriptionList = new ArrayList<String>();

    /** 
     * Get the 'CabinType' element value. Cabin Type for RQ/RS eq. First , Business, Economy
     * 
     * @return value
     */
    public String getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value. Cabin Type for RQ/RS eq. First , Business, Economy
     * 
     * @param cabinType
     */
    public void setCabinType(String cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the 'RBD' element value. Reservation Booking Designator to apply to seatmap cabin request
                      
     * 
     * @return value
     */
    public String getRBD() {
        return RBD;
    }

    /** 
     * Set the 'RBD' element value. Reservation Booking Designator to apply to seatmap cabin request
                      
     * 
     * @param RBD
     */
    public void setRBD(String RBD) {
        this.RBD = RBD;
    }

    /** 
     * Get the 'MarketingName' element value. Any Marketing Name to be displayed instead of just First or Economy
                      
     * 
     * @return value
     */
    public String getMarketingName() {
        return marketingName;
    }

    /** 
     * Set the 'MarketingName' element value. Any Marketing Name to be displayed instead of just First or Economy
                      
     * 
     * @param marketingName
     */
    public void setMarketingName(String marketingName) {
        this.marketingName = marketingName;
    }

    /** 
     * Get the list of 'MarketingDescription' element items. Any free text description or banner applicable to the cabin
     * 
     * @return list
     */
    public List<String> getMarketingDescriptionList() {
        return marketingDescriptionList;
    }

    /** 
     * Set the list of 'MarketingDescription' element items. Any free text description or banner applicable to the cabin
     * 
     * @param list
     */
    public void setMarketingDescriptionList(List<String> list) {
        marketingDescriptionList = list;
    }
}
