
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ColumnDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Column" minOccurs="0"/>
 *     &lt;xs:element type="ns:Enum_ColumnDescription" name="Characteristics" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element ref="ns:Price" minOccurs="0" maxOccurs="9"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ColumnDetail1 implements Serializable
{
    private String column;
    private List<EnumColumnDescription> characteristicList = new ArrayList<EnumColumnDescription>();
    private List<Price> priceList = new ArrayList<Price>();

    /** 
     * Get the 'Column' element value. Seat Column A-Z
     * 
     * @return value
     */
    public String getColumn() {
        return column;
    }

    /** 
     * Set the 'Column' element value. Seat Column A-Z
     * 
     * @param column
     */
    public void setColumn(String column) {
        this.column = column;
    }

    /** 
     * Get the list of 'Characteristics' element items. Column characteristcis applicable to whole column
     * 
     * @return list
     */
    public List<EnumColumnDescription> getCharacteristicList() {
        return characteristicList;
    }

    /** 
     * Set the list of 'Characteristics' element items. Column characteristcis applicable to whole column
     * 
     * @param list
     */
    public void setCharacteristicList(List<EnumColumnDescription> list) {
        characteristicList = list;
    }

    /** 
     * Get the list of 'Price' element items. Price and taxes applicable to seats in this column
     * 
     * @return list
     */
    public List<Price> getPriceList() {
        return priceList;
    }

    /** 
     * Set the list of 'Price' element items. Price and taxes applicable to seats in this column
     * 
     * @param list
     */
    public void setPriceList(List<Price> list) {
        priceList = list;
    }
}
