
package com.sabre.stl.merchandising.v6;

import com.sabre.services.stlpayload.v0200.STLPayload1;
import java.io.Serializable;
import org.opentravel.common.message.v02.ExtensionPoint;

/** 
 * Used to request a seatmap from another system
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_00" xmlns:ns2="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnhancedSeatMapRQ">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns1:STL_Payload">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:SeatMapQueryEnhanced" minOccurs="0"/>
 *         &lt;xs:element ref="ns:PriceQuoteCriteria" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" default="false" name="CalculateDiscount" minOccurs="0" maxOccurs="1"/>
 *         &lt;xs:element ref="ns2:ExtensionPoint" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EnhancedSeatMapRQ extends STLPayload1 implements Serializable
{
    private SeatMapQueryEnhanced seatMapQueryEnhanced;
    private PriceQuoteCriteria priceQuoteCriteria;
    private Boolean calculateDiscount;
    private ExtensionPoint extensionPoint;

    /** 
     * Get the 'SeatMapQueryEnhanced' element value.
     * 
     * @return value
     */
    public SeatMapQueryEnhanced getSeatMapQueryEnhanced() {
        return seatMapQueryEnhanced;
    }

    /** 
     * Set the 'SeatMapQueryEnhanced' element value.
     * 
     * @param seatMapQueryEnhanced
     */
    public void setSeatMapQueryEnhanced(
            SeatMapQueryEnhanced seatMapQueryEnhanced) {
        this.seatMapQueryEnhanced = seatMapQueryEnhanced;
    }

    /** 
     * Get the 'PriceQuoteCriteria' element value.
     * 
     * @return value
     */
    public PriceQuoteCriteria getPriceQuoteCriteria() {
        return priceQuoteCriteria;
    }

    /** 
     * Set the 'PriceQuoteCriteria' element value.
     * 
     * @param priceQuoteCriteria
     */
    public void setPriceQuoteCriteria(PriceQuoteCriteria priceQuoteCriteria) {
        this.priceQuoteCriteria = priceQuoteCriteria;
    }

    /** 
     * Get the 'CalculateDiscount' element value. Calculate Discount in ANCS.
     * 
     * @return value
     */
    public Boolean getCalculateDiscount() {
        return calculateDiscount;
    }

    /** 
     * Set the 'CalculateDiscount' element value. Calculate Discount in ANCS.
     * 
     * @param calculateDiscount
     */
    public void setCalculateDiscount(Boolean calculateDiscount) {
        this.calculateDiscount = calculateDiscount;
    }

    /** 
     * Get the 'ExtensionPoint' element value.
     * 
     * @return value
     */
    public ExtensionPoint getExtensionPoint() {
        return extensionPoint;
    }

    /** 
     * Set the 'ExtensionPoint' element value.
     * 
     * @param extensionPoint
     */
    public void setExtensionPoint(ExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }
}
