
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_CabinFacilitiesLocation_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CenterSection"/>
 *     &lt;xs:enumeration value="LeftSideSection"/>
 *     &lt;xs:enumeration value="LeftCenterSection"/>
 *     &lt;xs:enumeration value="RightSideSection"/>
 *     &lt;xs:enumeration value="RightCenterSection"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumCabinFacilitiesLocationBase implements Serializable {
    /** 
     * Center Section Padis 3227 - C
     */
    CENTER_SECTION("CenterSection"), /** 
                                      * Left Side Section - Padis 3227 - L
                                      */
    LEFT_SIDE_SECTION("LeftSideSection"), /** 
                                           * Left Center Section - Padis 3227 - LC
                                           */
    LEFT_CENTER_SECTION("LeftCenterSection"), /** 
                                               * Right Side Section - Padis 3227 - R
                                               */
    RIGHT_SIDE_SECTION("RightSideSection"), /** 
                                             * Right Center Section - Padis 3227 - RC
                                             */
    RIGHT_CENTER_SECTION("RightCenterSection"), OTHER_("Other_");
    private final String value;

    private EnumCabinFacilitiesLocationBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumCabinFacilitiesLocationBase convert(String value) {
        for (EnumCabinFacilitiesLocationBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
