
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for a type or category of a seat, typically on an airplane or train.
 This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Air Seat Type (AST)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatLimitationsType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CrewSeat"/>
 *     &lt;xs:enumeration value="Deportee"/>
 *     &lt;xs:enumeration value="GroupSeat-OfferedToTravelersBelongingToAGroup"/>
 *     &lt;xs:enumeration value="JumpSeat"/>
 *     &lt;xs:enumeration value="LimitedComfort"/>
 *     &lt;xs:enumeration value="NotAllowedForInfants"/>
 *     &lt;xs:enumeration value="NotAllowedForMedical"/>
 *     &lt;xs:enumeration value="NotAllowedForUnaccompaniedMinors"/>
 *     &lt;xs:enumeration value="RearFacingSeat"/>
 *     &lt;xs:enumeration value="RestrictedGeneral"/>
 *     &lt;xs:enumeration value="RestrictedRecline"/>
 *     &lt;xs:enumeration value="RestrictedSeat-OfferedOnLong-HaulSegments"/>
 *     &lt;xs:enumeration value="SeatNotSuitableForChild"/>
 *     &lt;xs:enumeration value="SeatToBeLeftVacant/OfferedLast"/>
 *     &lt;xs:enumeration value="SeatWithoutMovieView"/>
 *     &lt;xs:enumeration value="WindowSeatWithoutWindow"/>
 *     &lt;xs:enumeration value="NotFitted"/>
 *     &lt;xs:enumeration value="NoSeatAirphone"/>
 *     &lt;xs:enumeration value="NoSeatBar"/>
 *     &lt;xs:enumeration value="NoSeatCloset"/>
 *     &lt;xs:enumeration value="ConditionalSeatContactAirline"/>
 *     &lt;xs:enumeration value="NoSeatExitDoor"/>
 *     &lt;xs:enumeration value="NoSeatEmergencyExit"/>
 *     &lt;xs:enumeration value="NoSeat Galley"/>
 *     &lt;xs:enumeration value="BulkheadNoSeat"/>
 *     &lt;xs:enumeration value="NoSeatLavatory"/>
 *     &lt;xs:enumeration value="NoSeatLuggageStorage"/>
 *     &lt;xs:enumeration value="NoSeatStorageSpace"/>
 *     &lt;xs:enumeration value="NoSeatStairsToUpperDeck"/>
 *     &lt;xs:enumeration value="NoSeatTable"/>
 *     &lt;xs:enumeration value="BufferZoneSeat"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatLimitationsTypeBase implements Serializable {
    /** 
     * Padis 9825 - C
     */
    CREW_SEAT("CrewSeat"), /** 
                            * Padis 9825 - DE
                            */
    DEPORTEE("Deportee"), /** 
                           * Padis 9825 - GR
                           */
    GROUP_SEAT_OFFERED_TO_TRAVELERS_BELONGING_TO_A_GROUP(
            "GroupSeat-OfferedToTravelersBelongingToAGroup"), /** 
                                                               * Padis 9825 - C see crew seat
                                                               */
    JUMP_SEAT("JumpSeat"), /** 
                            * OTA only
                            */
    LIMITED_COMFORT("LimitedComfort"), /** 
                                        * Padis 9825 - 1A
                                        */
    NOT_ALLOWED_FOR_INFANTS("NotAllowedForInfants"), /** 
                                                      * Padis 9825 - 1B
                                                      */
    NOT_ALLOWED_FOR_MEDICAL("NotAllowedForMedical"), /** 
                                                      * Padis 9825 - 1C
                                                      */
    NOT_ALLOWED_FOR_UNACCOMPANIED_MINORS("NotAllowedForUnaccompaniedMinors"), /** 
                                                                               * Padis 9825 - J
                                                                               */
    REAR_FACING_SEAT("RearFacingSeat"), /** 
                                         * Padis 9825 - 1 -UA sends this value
                                         */
    RESTRICTED_GENERAL("RestrictedGeneral"), /** 
                                              * Padis 9825 - 1D
                                              */
    RESTRICTED_RECLINE("RestrictedRecline"), /** 
                                              * Padis 9825 - LH
                                              */
    RESTRICTED_SEAT_OFFERED_ON_LONG_HAUL_SEGMENTS(
            "RestrictedSeat-OfferedOnLong-HaulSegments"), /** 
                                                           * Padis 9825 - IE
                                                           */
    SEAT_NOT_SUITABLE_FOR_CHILD("SeatNotSuitableForChild"), /** 
                                                             * Padis 9825 - V
                                                             */
    SEAT_TO_BE_LEFT_VACANT_OFFERED_LAST("SeatToBeLeftVacant/OfferedLast"), /** 
                                                                            * Padis 9825 - M
                                                                            */
    SEAT_WITHOUT_MOVIE_VIEW("SeatWithoutMovieView"), /** 
                                                      * Padis 9825 - 1W
                                                      */
    WINDOW_SEAT_WITHOUT_WINDOW("WindowSeatWithoutWindow"), /** 
                                                            * Padis 9825 - 28
                                                            */
    NOT_FITTED("NotFitted"), /** 
                              * Padis 9825 - AR
                              */
    NO_SEAT_AIRPHONE("NoSeatAirphone"), /** 
                                         * Padis 9825 - BA
                                         */
    NO_SEAT_BAR("NoSeatBar"), /** 
                               * Padis 9825 - CL
                               */
    NO_SEAT_CLOSET("NoSeatCloset"), /** 
                                     * Padis 9825 - CS
                                     */
    CONDITIONAL_SEAT_CONTACT_AIRLINE("ConditionalSeatContactAirline"), /** 
                                                                        * Padis 9825 - D
                                                                        */
    NO_SEAT_EXIT_DOOR("NoSeatExitDoor"), /** 
                                          * Padis 9825 - EX
                                          */
    NO_SEAT_EMERGENCY_EXIT("NoSeatEmergencyExit"), /** 
                                                    * Padis 9825 - GN
                                                    */
    NO_SEAT_GALLEY("NoSeat Galley"), /** 
                                      * Padis 9825 - KN
                                      */
    BULKHEAD_NO_SEAT("BulkheadNoSeat"), /** 
                                         * Padis 9825 - LA
                                         */
    NO_SEAT_LAVATORY("NoSeatLavatory"), /** 
                                         * Padis 9825 - LG
                                         */
    NO_SEAT_LUGGAGE_STORAGE("NoSeatLuggageStorage"), /** 
                                                      * Padis 9825 - SO
                                                      */
    NO_SEAT_STORAGE_SPACE("NoSeatStorageSpace"), /** 
                                                  * Padis 9825 - ST
                                                  */
    NO_SEAT_STAIRS_TO_UPPER_DECK("NoSeatStairsToUpperDeck"), /** 
                                                              * Padis 9825 - TA
                                                              */
    NO_SEAT_TABLE("NoSeatTable"), /** 
                                   * Padis 9825 - Z
                                   */
    BUFFER_ZONE_SEAT("BufferZoneSeat"), OTHER_("Other_");
    private final String value;

    private EnumSeatLimitationsTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatLimitationsTypeBase convert(String value) {
        for (EnumSeatLimitationsTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
