
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for a seat location TypeThis is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Air Seat Type (AST)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatLocationType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AddedSeat"/>
 *     &lt;xs:enumeration value="AisleSeat"/>
 *     &lt;xs:enumeration value="BehindGalleySeat"/>
 *     &lt;xs:enumeration value="BehindToiletSeat"/>
 *     &lt;xs:enumeration value="BulkheadSeat"/>
 *     &lt;xs:enumeration value="CenterSectionSeat(S)"/>
 *     &lt;xs:enumeration value="InFrontOfGalleySeat"/>
 *     &lt;xs:enumeration value="InFrontOfToiletSeat"/>
 *     &lt;xs:enumeration value="LeftSideOfAircraft"/>
 *     &lt;xs:enumeration value="NearGalleySeat"/>
 *     &lt;xs:enumeration value="NearToiletSeat"/>
 *     &lt;xs:enumeration value="NoSeatAtThisLocation"/>
 *     &lt;xs:enumeration value="CenterSeat"/>
 *     &lt;xs:enumeration value="NoSeat-AccessToHandicappedLavatory"/>
 *     &lt;xs:enumeration value="OverWingSeat(S)"/>
 *     &lt;xs:enumeration value="SeatAdjacentToBar"/>
 *     &lt;xs:enumeration value="SeatAdjacentToCloset"/>
 *     &lt;xs:enumeration value="SeatAdjacentToGalley"/>
 *     &lt;xs:enumeration value="SeatAdjacentToLavatory"/>
 *     &lt;xs:enumeration value="SeatAdjacentToStairsToUpperDeck"/>
 *     &lt;xs:enumeration value="SeatAdjacentToTable"/>
 *     &lt;xs:enumeration value="RightSideOf Aircraft"/>
 *     &lt;xs:enumeration value="UpperDeck"/>
 *     &lt;xs:enumeration value="Window"/>
 *     &lt;xs:enumeration value="WindowAndAisleTogether"/>
 *     &lt;xs:enumeration value="TailSectionOfAircraft"/>
 *     &lt;xs:enumeration value="ExitRowSeat"/>
 *     &lt;xs:enumeration value="AdjacentAisleSeat"/>
 *     &lt;xs:enumeration value="AllAvailbaleAisleSeats"/>
 *     &lt;xs:enumeration value="AllAvailableWindowSeats"/>
 *     &lt;xs:enumeration value="NonSmokingAisle"/>
 *     &lt;xs:enumeration value="NonSmokingWindow"/>
 *     &lt;xs:enumeration value="NonSmokingBulkhead"/>
 *     &lt;xs:enumeration value="AisleBulkhead"/>
 *     &lt;xs:enumeration value="OnlyAvailableSeats"/>
 *     &lt;xs:enumeration value="Oxygen"/>
 *     &lt;xs:enumeration value="UnaccompaniedMinor"/>
 *     &lt;xs:enumeration value="LapChild"/>
 *     &lt;xs:enumeration value="ServiceAnimal"/>
 *     &lt;xs:enumeration value="PetInCabin"/>
 *     &lt;xs:enumeration value="ForwardEndOfCabin"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatLocationTypeBase implements Serializable {
    /** 
     * Padis 9825 - F
     */
    ADDED_SEAT("AddedSeat"), /** 
                              * Padis 9825 - A
                              */
    AISLE_SEAT("AisleSeat"), /** 
                              * Padis 9825 - 6B
                              */
    BEHIND_GALLEY_SEAT("BehindGalleySeat"), /** 
                                             * Padis 9825 - 7B
                                             */
    BEHIND_TOILET_SEAT("BehindToiletSeat"), /** 
                                             * Padis 9825 - K
                                             */
    BULKHEAD_SEAT("BulkheadSeat"), /** 
                                    * Padis 9825 - CC
                                    */
    CENTER_SECTION_SEAT_S("CenterSectionSeat(S)"), /** 
                                                    * Padis 9825 - 6A
                                                    */
    IN_FRONT_OF_GALLEY_SEAT("InFrontOfGalleySeat"), /** 
                                                     * Padis 9825 - 7A
                                                     */
    IN_FRONT_OF_TOILET_SEAT("InFrontOfToiletSeat"), /** 
                                                     * Padis 9825 - LS
                                                     */
    LEFT_SIDE_OF_AIRCRAFT("LeftSideOfAircraft"), /** 
                                                  * Padis 9825 -6
                                                  */
    NEAR_GALLEY_SEAT("NearGalleySeat"), /** 
                                         * Padis 9825 - 7
                                         */
    NEAR_TOILET_SEAT("NearToiletSeat"), /** 
                                         * Padis 9825 - 8
                                         */
    NO_SEAT_AT_THIS_LOCATION("NoSeatAtThisLocation"), /** 
                                                       * Padis 9825 - 9
                                                       */
    CENTER_SEAT("CenterSeat"), /** 
                                * Padis 9825 - 701
                                */
    NO_SEAT_ACCESS_TO_HANDICAPPED_LAVATORY("NoSeat-AccessToHandicappedLavatory"), /** 
                                                                                   * Padis 9825 - OW
                                                                                   */
    OVER_WING_SEAT_S("OverWingSeat(S)"), /** 
                                          * Padis 9825 - AB
                                          */
    SEAT_ADJACENT_TO_BAR("SeatAdjacentToBar"), /** 
                                                * Padis 9825 - AC
                                                */
    SEAT_ADJACENT_TO_CLOSET("SeatAdjacentToCloset"), /** 
                                                      * Padis 9825 - AG
                                                      */
    SEAT_ADJACENT_TO_GALLEY("SeatAdjacentToGalley"), /** 
                                                      * Padis 9825 - AL
                                                      */
    SEAT_ADJACENT_TO_LAVATORY("SeatAdjacentToLavatory"), /** 
                                                          * Padis 9825 - AU
                                                          */
    SEAT_ADJACENT_TO_STAIRS_TO_UPPER_DECK("SeatAdjacentToStairsToUpperDeck"), /** 
                                                                               * Padis 9825 - AT
                                                                               */
    SEAT_ADJACENT_TO_TABLE("SeatAdjacentToTable"), /** 
                                                    * Padis 9825 - RS
                                                    */
    RIGHT_SIDE_OF_AIRCRAFT("RightSideOf Aircraft"), /** 
                                                     * Padis 9825 - UP
                                                     */
    UPPER_DECK("UpperDeck"), /** 
                              * Padis 9825 - W
                              */
    WINDOW("Window"), /** 
                       * Padis 9825 - WA
                       */
    WINDOW_AND_AISLE_TOGETHER("WindowAndAisleTogether"), /** 
                                                          * Padis 9825 - T
                                                          */
    TAIL_SECTION_OF_AIRCRAFT("TailSectionOfAircraft"), /** 
                                                        * Padis 9825 E
                                                        */
    EXIT_ROW_SEAT("ExitRowSeat"), /** 
                                   * Padis 9825 AJ
                                   */
    ADJACENT_AISLE_SEAT("AdjacentAisleSeat"), /** 
                                               * Padis 9825 AA
                                               */
    ALL_AVAILBALE_AISLE_SEATS("AllAvailbaleAisleSeats"), /** 
                                                          * Padis 9825 AW
                                                          */
    ALL_AVAILABLE_WINDOW_SEATS("AllAvailableWindowSeats"), /** 
                                                            * Padis 9825 NA
                                                            */
    NON_SMOKING_AISLE("NonSmokingAisle"), /** 
                                           * Padis 9825 NW
                                           */
    NON_SMOKING_WINDOW("NonSmokingWindow"), /** 
                                             * Padis 9825 NK
                                             */
    NON_SMOKING_BULKHEAD("NonSmokingBulkhead"), /** 
                                                 * Padis 9825 AK
                                                 */
    AISLE_BULKHEAD("AisleBulkhead"), /** 
                                      * Padis 9825 AV
                                      */
    ONLY_AVAILABLE_SEATS("OnlyAvailableSeats"), /** 
                                                 * UA-Bilateral
                                                 */
    OXYGEN("Oxygen"), /** 
                       * UA-Bilateral Padis 9825 U
                       */
    UNACCOMPANIED_MINOR("UnaccompaniedMinor"), /** 
                                                * UA-Bilateral
                                                */
    LAP_CHILD("LapChild"), /** 
                            * UA-Bilateral
                            */
    SERVICE_ANIMAL("ServiceAnimal"), /** 
                                      * Padis 9825 PC
                                      */
    PET_IN_CABIN("PetInCabin"), /** 
                                 * Padis 9825 - G
                                 */
    FORWARD_END_OF_CABIN("ForwardEndOfCabin"), OTHER_("Other_");
    private final String value;

    private EnumSeatLocationTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatLocationTypeBase convert(String value) {
        for (EnumSeatLocationTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
