
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatOccupation">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Available"/>
 *     &lt;xs:enumeration value="Protected"/>
 *     &lt;xs:enumeration value="Occupied"/>
 *     &lt;xs:enumeration value="Blocked"/>
 *     &lt;xs:enumeration value="NoSeat"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatOccupation implements Serializable {
    /** 
     * Seat is available maps to Padis 9865 F
     */
    AVAILABLE("Available"), /** 
                             * Seat is protected Padis 9865 P, U, V
                             */
    PROTECTED("Protected"), /** 
                             * Seat is occupied
                             */
    OCCUPIED("Occupied"), /** 
                           * Seat blocked - Padis 9865 D, Z , Q
                           */
    BLOCKED("Blocked"), /** 
                         * Seat not fitted
                         */
    NO_SEAT("NoSeat");
    private final String value;

    private EnumSeatOccupation(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatOccupation convert(String value) {
        for (EnumSeatOccupation inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
