
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for seat availability, typically used by air and rail. Extends IATA seat
 occupation single letter code.
 This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Seat Availability (SAV)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatOccupationType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AdvancedBoardingPassSeat"/>
 *     &lt;xs:enumeration value="AdvancedSeatSelectionSeat"/>
 *     &lt;xs:enumeration value="Check-InReservedSeat"/>
 *     &lt;xs:enumeration value="CourtesyReservedSeat"/>
 *     &lt;xs:enumeration value="DownlineProtectedSeats"/>
 *     &lt;xs:enumeration value="ExtraSeat"/>
 *     &lt;xs:enumeration value="NoSeatHere"/>
 *     &lt;xs:enumeration value="ProtectedSeat"/>
 *     &lt;xs:enumeration value="ReservedSeatGeneric"/>
 *     &lt;xs:enumeration value="SeatBlockedForAirportUse"/>
 *     &lt;xs:enumeration value="SeatBlockedForOtherReason"/>
 *     &lt;xs:enumeration value="SeatBlockedForThroughPassengerBoarded"/>
 *     &lt;xs:enumeration value="SeatBlockedFor/WithDeadload"/>
 *     &lt;xs:enumeration value="SeatForGroupPre-Allocation"/>
 *     &lt;xs:enumeration value="SeatIsFree"/>
 *     &lt;xs:enumeration value="SeatIsNotAvailableForInterlineThroughCheck-In"/>
 *     &lt;xs:enumeration value="SeatIsNotAvailableForPartnerAirlinesUse"/>
 *     &lt;xs:enumeration value="SeatIsOccupied"/>
 *     &lt;xs:enumeration value="SeatOccupiedForMedicalReasons"/>
 *     &lt;xs:enumeration value="SeatProtectedForCodeSharing"/>
 *     &lt;xs:enumeration value="TransitPassenger-SeatOccupiedByATransitPassengerOrLoad"/>
 *     &lt;xs:enumeration value="UplineProtectedSeat"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatOccupationTypeBase implements Serializable {
    /** 
     * Padis 9865 - B
     */
    ADVANCED_BOARDING_PASS_SEAT("AdvancedBoardingPassSeat"), /** 
                                                              * Padis 9865 - Y
                                                              */
    ADVANCED_SEAT_SELECTION_SEAT("AdvancedSeatSelectionSeat"), /** 
                                                                * Padis 9865 - C
                                                                */
    CHECK_IN_RESERVED_SEAT("Check-InReservedSeat"), /** 
                                                     * Padis 9865 - H
                                                     */
    COURTESY_RESERVED_SEAT("CourtesyReservedSeat"), /** 
                                                     * Padis 9865 - V
                                                     */
    DOWNLINE_PROTECTED_SEATS("DownlineProtectedSeats"), /** 
                                                         * Padis 9865 - E
                                                         */
    EXTRA_SEAT("ExtraSeat"), /** 
                              * Padis 9865 - Q
                              */
    NO_SEAT_HERE("NoSeatHere"), /** 
                                 * Padis 9865 - P
                                 */
    PROTECTED_SEAT("ProtectedSeat"), /** 
                                      * Padis 9865 - R
                                      */
    RESERVED_SEAT_GENERIC("ReservedSeatGeneric"), /** 
                                                   * Padis 9865 - Z refer seat blocked for other reasons
                                                   */
    SEAT_BLOCKED_FOR_AIRPORT_USE("SeatBlockedForAirportUse"), /** 
                                                               * Padis 9865 - Z
                                                               */
    SEAT_BLOCKED_FOR_OTHER_REASON("SeatBlockedForOtherReason"), /** 
                                                                 * Padis 9865 - T see TransitPassenger
                                                                 */
    SEAT_BLOCKED_FOR_THROUGH_PASSENGER_BOARDED(
            "SeatBlockedForThroughPassengerBoarded"), /** 
                                                       * Padis 9865 - D
                                                       */
    SEAT_BLOCKED_FOR_WITH_DEADLOAD("SeatBlockedFor/WithDeadload"), /** 
                                                                    * Padis 9865- G
                                                                    */
    SEAT_FOR_GROUP_PRE_ALLOCATION("SeatForGroupPre-Allocation"), /** 
                                                                  * Padis 9865 - F
                                                                  */
    SEAT_IS_FREE("SeatIsFree"), /** 
                                 * Padis 9865 - I
                                 */
    SEAT_IS_NOT_AVAILABLE_FOR_INTERLINE_THROUGH_CHECK_IN(
            "SeatIsNotAvailableForInterlineThroughCheck-In"), /** 
                                                               * Padis 9865 - X
                                                               */
    SEAT_IS_NOT_AVAILABLE_FOR_PARTNER_AIRLINES_USE(
            "SeatIsNotAvailableForPartnerAirlinesUse"), /** 
                                                         * Padis 9865 - O
                                                         */
    SEAT_IS_OCCUPIED("SeatIsOccupied"), /** 
                                         * Padis 9865 - M
                                         */
    SEAT_OCCUPIED_FOR_MEDICAL_REASONS("SeatOccupiedForMedicalReasons"), /** 
                                                                         * Padis 9865 - S
                                                                         */
    SEAT_PROTECTED_FOR_CODE_SHARING("SeatProtectedForCodeSharing"), /** 
                                                                     * Padis 9865 - T
                                                                     */
    TRANSIT_PASSENGER_SEAT_OCCUPIED_BY_A_TRANSIT_PASSENGER_OR_LOAD(
            "TransitPassenger-SeatOccupiedByATransitPassengerOrLoad"), /** 
                                                                        * Padis 9865 - U
                                                                        */
    UPLINE_PROTECTED_SEAT("UplineProtectedSeat"), OTHER_("Other_");
    private final String value;

    private EnumSeatOccupationTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatOccupationTypeBase convert(String value) {
        for (EnumSeatOccupationTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
