
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Flight Number
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight_Identifier">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="required" name="carrier"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="suffix"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightIdentifier implements Serializable
{
    private String string;
    private String carrier;
    private String suffix;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'carrier' attribute value. By default, the carrier is assumed from the transaction context
                          
     * 
     * @return value
     */
    public String getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'carrier' attribute value. By default, the carrier is assumed from the transaction context
                          
     * 
     * @param carrier
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'suffix' attribute value. Flight Identifier Suffix is used by operations to differentiate flights with
                              same flight number operating on the same date
                          
     * 
     * @return value
     */
    public String getSuffix() {
        return suffix;
    }

    /** 
     * Set the 'suffix' attribute value. Flight Identifier Suffix is used by operations to differentiate flights with
                              same flight number operating on the same date
                          
     * 
     * @param suffix
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}
