
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryPart">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enum_ItineraryPartType" name="Type"/>
 *     &lt;xs:element type="ns:SegmentReference" name="SegmentReferences" minOccurs="1" maxOccurs="10"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItineraryPart implements Serializable
{
    private EnumItineraryPartType type;
    private List<SegmentReference> segmentReferenceList = new ArrayList<SegmentReference>();

    /** 
     * Get the 'Type' element value. Indicates the type of the segments contained in this Itinerary Part
     * 
     * @return value
     */
    public EnumItineraryPartType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Indicates the type of the segments contained in this Itinerary Part
     * 
     * @param type
     */
    public void setType(EnumItineraryPartType type) {
        this.type = type;
    }

    /** 
     * Get the list of 'SegmentReferences' element items.
     * 
     * @return list
     */
    public List<SegmentReference> getSegmentReferenceList() {
        return segmentReferenceList;
    }

    /** 
     * Set the list of 'SegmentReferences' element items.
     * 
     * @param list
     */
    public void setSegmentReferenceList(List<SegmentReference> list) {
        segmentReferenceList = list;
    }
}
