
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price_Seat">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="TotalAmount" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Source" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Taxes" minOccurs="0" maxOccurs="15"/>
 *     &lt;xs:element type="xs:string" name="PriceTypeRef" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceSeat1 implements Serializable
{
    private Amount totalAmount;
    private String source;
    private List<Taxes> taxeList = new ArrayList<Taxes>();
    private String priceTypeRef;

    /** 
     * Get the 'TotalAmount' element value. Total price including taxes if any
     * 
     * @return value
     */
    public Amount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total price including taxes if any
     * 
     * @param totalAmount
     */
    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'Source' element value. Source of pricing
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. Source of pricing
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the list of 'Taxes' element items. Tax applicable to this price
     * 
     * @return list
     */
    public List<Taxes> getTaxeList() {
        return taxeList;
    }

    /** 
     * Set the list of 'Taxes' element items. Tax applicable to this price
     * 
     * @param list
     */
    public void setTaxeList(List<Taxes> list) {
        taxeList = list;
    }

    /** 
     * Get the 'PriceTypeRef' element value.
     * 
     * @return value
     */
    public String getPriceTypeRef() {
        return priceTypeRef;
    }

    /** 
     * Set the 'PriceTypeRef' element value.
     * 
     * @param priceTypeRef
     */
    public void setPriceTypeRef(String priceTypeRef) {
        this.priceTypeRef = priceTypeRef;
    }
}
