
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMap">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:SeatMap_ID">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:Request" name="RequestType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Currency" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Flight" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FareAvailQualifiers" minOccurs="0" maxOccurs="99"/>
 *         &lt;xs:element ref="ns:Cabin" minOccurs="1" maxOccurs="9"/>
 *         &lt;xs:element type="xs:string" name="OfferId" minOccurs="0" maxOccurs="1"/>
 *         &lt;xs:element ref="ns:AmenityTable" minOccurs="0" maxOccurs="4999"/>
 *         &lt;xs:element ref="ns:PriceList" minOccurs="0"/>
 *         &lt;xs:element ref="ns:TaxTable" minOccurs="0" maxOccurs="1000"/>
 *         &lt;xs:element ref="ns:POS" minOccurs="0"/>
 *         &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="correlationID"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="changeOfGaugeInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMap extends SeatMapID implements Serializable
{
    private Request requestType;
    private String currency;
    private Flight flight;
    private List<FareAvailQualifiers> fareAvailQualifierList = new ArrayList<FareAvailQualifiers>();
    private List<Cabin> cabinList = new ArrayList<Cabin>();
    private String offerId;
    private List<AmenityTable> amenityTableList = new ArrayList<AmenityTable>();
    private PriceList priceList;
    private List<TaxTable> taxTableList = new ArrayList<TaxTable>();
    private POS POS;
    private ExtensionPointSummary extensionPointSummary;
    private String correlationID;
    private Boolean changeOfGaugeInd;

    /** 
     * Get the 'RequestType' element value. Stateful, Stateless, Payload
     * 
     * @return value
     */
    public Request getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' element value. Stateful, Stateless, Payload
     * 
     * @param requestType
     */
    public void setRequestType(Request requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'Currency' element value. Default Currency for the map
     * 
     * @return value
     */
    public String getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value. Default Currency for the map
     * 
     * @param currency
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'Flight' element value. Flight date and time
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Flight date and time
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the list of 'FareAvailQualifiers' element items. Seat map prices and availabity are based on traveller charactistics.
                              
     * 
     * @return list
     */
    public List<FareAvailQualifiers> getFareAvailQualifierList() {
        return fareAvailQualifierList;
    }

    /** 
     * Set the list of 'FareAvailQualifiers' element items. Seat map prices and availabity are based on traveller charactistics.
                              
     * 
     * @param list
     */
    public void setFareAvailQualifierList(List<FareAvailQualifiers> list) {
        fareAvailQualifierList = list;
    }

    /** 
     * Get the list of 'Cabin' element items. Seatmap details for cabin and Row and Seat
     * 
     * @return list
     */
    public List<Cabin> getCabinList() {
        return cabinList;
    }

    /** 
     * Set the list of 'Cabin' element items. Seatmap details for cabin and Row and Seat
     * 
     * @param list
     */
    public void setCabinList(List<Cabin> list) {
        cabinList = list;
    }

    /** 
     * Get the 'OfferId' element value. 
                                  OfferId as defined by NDC. Use this ID when selling seats based on the prices offered here.
                              
     * 
     * @return value
     */
    public String getOfferId() {
        return offerId;
    }

    /** 
     * Set the 'OfferId' element value. 
                                  OfferId as defined by NDC. Use this ID when selling seats based on the prices offered here.
                              
     * 
     * @param offerId
     */
    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    /** 
     * Get the list of 'AmenityTable' element items. Amenities referenced by ID applicable to complete request
                              
     * 
     * @return list
     */
    public List<AmenityTable> getAmenityTableList() {
        return amenityTableList;
    }

    /** 
     * Set the list of 'AmenityTable' element items. Amenities referenced by ID applicable to complete request
                              
     * 
     * @param list
     */
    public void setAmenityTableList(List<AmenityTable> list) {
        amenityTableList = list;
    }

    /** 
     * Get the 'PriceList' element value.
     * 
     * @return value
     */
    public PriceList getPriceList() {
        return priceList;
    }

    /** 
     * Set the 'PriceList' element value.
     * 
     * @param priceList
     */
    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    /** 
     * Get the list of 'TaxTable' element items. List of descriptions of taxes applied to seat prices.
                              
     * 
     * @return list
     */
    public List<TaxTable> getTaxTableList() {
        return taxTableList;
    }

    /** 
     * Set the list of 'TaxTable' element items. List of descriptions of taxes applied to seat prices.
                              
     * 
     * @param list
     */
    public void setTaxTableList(List<TaxTable> list) {
        taxTableList = list;
    }

    /** 
     * Get the 'POS' element value. Booking agency POS information
     * 
     * @return value
     */
    public POS getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Booking agency POS information
     * 
     * @param POS
     */
    public void setPOS(POS POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }

    /** 
     * Get the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web
                              service message throughout the processing of the Web service message.
                          
     * 
     * @return value
     */
    public String getCorrelationID() {
        return correlationID;
    }

    /** 
     * Set the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web
                              service message throughout the processing of the Web service message.
                          
     * 
     * @param correlationID
     */
    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    /** 
     * Get the 'changeOfGaugeInd' attribute value. if indicator is present the flight undergoes a change of guage on its path
                          
     * 
     * @return value
     */
    public Boolean getChangeOfGaugeInd() {
        return changeOfGaugeInd;
    }

    /** 
     * Set the 'changeOfGaugeInd' attribute value. if indicator is present the flight undergoes a change of guage on its path
                          
     * 
     * @param changeOfGaugeInd
     */
    public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
        this.changeOfGaugeInd = changeOfGaugeInd;
    }
}
