
package com.sabre.stl.merchandising.v6;

import com.sabre.services.stl.v02.TicketNumber;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:ns1="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMap_FareAvailabilityQualifiers">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TravellerID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
 *     &lt;xs:element type="ns:CustomerLoyalty" name="Loyalty" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element type="xs:string" name="SSR" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element ref="ns:SeatReq" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravellerCharacteristics" minOccurs="0"/>
 *     &lt;xs:element type="ns1:Ticket_Number" name="TicketNumber" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareBreakCriteria" minOccurs="0" maxOccurs="9"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="quantity"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RBD"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="birthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PNR_Loc"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="fareBasisCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="tourCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="passengerType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="fareComponentID"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="accompaniedByInfantInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMapFareAvailabilityQualifiers1 implements Serializable
{
    private String travellerID;
    private String givenName;
    private String surname;
    private List<CustomerLoyalty> loyaltyList = new ArrayList<CustomerLoyalty>();
    private List<String> SSRList = new ArrayList<String>();
    private SeatReq seatReq;
    private String travellerCharacteristics;
    private TicketNumber ticketNumber;
    private List<FareBreakCriteria> fareBreakCriteriaList = new ArrayList<FareBreakCriteria>();
    private String quantity;
    private String RBD;
    private Date birthDate;
    private String PNRLoc;
    private String fareBasisCode;
    private String tourCode;
    private String passengerType;
    private String fareComponentID;
    private Boolean accompaniedByInfantInd;

    /** 
     * Get the 'TravellerID' element value. Traveler Profile Identifier.
     * 
     * @return value
     */
    public String getTravellerID() {
        return travellerID;
    }

    /** 
     * Set the 'TravellerID' element value. Traveler Profile Identifier.
     * 
     * @param travellerID
     */
    public void setTravellerID(String travellerID) {
        this.travellerID = travellerID;
    }

    /** 
     * Get the 'GivenName' element value. Firt or Given Name
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Firt or Given Name
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'Surname' element value. Last or Surname
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Last or Surname
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the list of 'Loyalty' element items. Loyalty program information in event it affects seatmap selection
                      
     * 
     * @return list
     */
    public List<CustomerLoyalty> getLoyaltyList() {
        return loyaltyList;
    }

    /** 
     * Set the list of 'Loyalty' element items. Loyalty program information in event it affects seatmap selection
                      
     * 
     * @param list
     */
    public void setLoyaltyList(List<CustomerLoyalty> list) {
        loyaltyList = list;
    }

    /** 
     * Get the list of 'SSR' element items. SSR Details
     * 
     * @return list
     */
    public List<String> getSSRList() {
        return SSRList;
    }

    /** 
     * Set the list of 'SSR' element items. SSR Details
     * 
     * @param list
     */
    public void setSSRList(List<String> list) {
        SSRList = list;
    }

    /** 
     * Get the 'SeatReq' element value.
     * 
     * @return value
     */
    public SeatReq getSeatReq() {
        return seatReq;
    }

    /** 
     * Set the 'SeatReq' element value.
     * 
     * @param seatReq
     */
    public void setSeatReq(SeatReq seatReq) {
        this.seatReq = seatReq;
    }

    /** 
     * Get the 'TravellerCharacteristics' element value. TODO - Use Open Enumeration from OTA - Traveller Characteristics or
                          restrictions, pet allergies so no near a pet etc
                      
     * 
     * @return value
     */
    public String getTravellerCharacteristics() {
        return travellerCharacteristics;
    }

    /** 
     * Set the 'TravellerCharacteristics' element value. TODO - Use Open Enumeration from OTA - Traveller Characteristics or
                          restrictions, pet allergies so no near a pet etc
                      
     * 
     * @param travellerCharacteristics
     */
    public void setTravellerCharacteristics(String travellerCharacteristics) {
        this.travellerCharacteristics = travellerCharacteristics;
    }

    /** 
     * Get the 'TicketNumber' element value.
     * 
     * @return value
     */
    public TicketNumber getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value.
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(TicketNumber ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    /** 
     * Get the list of 'FareBreakCriteria' element items. Fare break criteria
     * 
     * @return list
     */
    public List<FareBreakCriteria> getFareBreakCriteriaList() {
        return fareBreakCriteriaList;
    }

    /** 
     * Set the list of 'FareBreakCriteria' element items. Fare break criteria
     * 
     * @param list
     */
    public void setFareBreakCriteriaList(List<FareBreakCriteria> list) {
        fareBreakCriteriaList = list;
    }

    /** 
     * Get the 'quantity' attribute value. Specifies the number of travelers of a given passenger type (e.g., Adult, Child)
                  Assigned XSD Type: PassengerTypeQuantityType
     * 
     * @return value
     */
    public String getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' attribute value. Specifies the number of travelers of a given passenger type (e.g., Adult, Child)
                  Assigned XSD Type: PassengerTypeQuantityType
     * 
     * @param quantity
     */
    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the 'RBD' attribute value. Reservation Booking Designator - actual booking class code or F/J/Y for unbooked
                      travelers.
                  
     * 
     * @return value
     */
    public String getRBD() {
        return RBD;
    }

    /** 
     * Set the 'RBD' attribute value. Reservation Booking Designator - actual booking class code or F/J/Y for unbooked
                      travelers.
                  
     * 
     * @param RBD
     */
    public void setRBD(String RBD) {
        this.RBD = RBD;
    }

    /** 
     * Get the 'birthDate' attribute value. Traveler's date of birth. Can be used for minumum age requirements for certain seat
                      selection
                  Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'birthDate' attribute value. Traveler's date of birth. Can be used for minumum age requirements for certain seat
                      selection
                  Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}date
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'PNR_Loc' attribute value. PNR record Locator of passenger or group
     * 
     * @return value
     */
    public String getPNRLoc() {
        return PNRLoc;
    }

    /** 
     * Set the 'PNR_Loc' attribute value. PNR record Locator of passenger or group
     * 
     * @param PNRLoc
     */
    public void setPNRLoc(String PNRLoc) {
        this.PNRLoc = PNRLoc;
    }

    /** 
     * Get the 'fareBasisCode' attribute value. Fare Basis Code for the filed fare.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'fareBasisCode' attribute value. Fare Basis Code for the filed fare.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'tourCode' attribute value. Fare tour code
     * 
     * @return value
     */
    public String getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'tourCode' attribute value. Fare tour code
     * 
     * @param tourCode
     */
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'passengerType' attribute value. Pricing Passenger Type, for instance "GOV", "MIL", "ADT", "CNN"
     * 
     * @return value
     */
    public String getPassengerType() {
        return passengerType;
    }

    /** 
     * Set the 'passengerType' attribute value. Pricing Passenger Type, for instance "GOV", "MIL", "ADT", "CNN"
     * 
     * @param passengerType
     */
    public void setPassengerType(String passengerType) {
        this.passengerType = passengerType;
    }

    /** 
     * Get the 'fareComponentID' attribute value. Fare component ID
     * 
     * @return value
     */
    public String getFareComponentID() {
        return fareComponentID;
    }

    /** 
     * Set the 'fareComponentID' attribute value. Fare component ID
     * 
     * @param fareComponentID
     */
    public void setFareComponentID(String fareComponentID) {
        this.fareComponentID = fareComponentID;
    }

    /** 
     * Get the 'accompaniedByInfantInd' attribute value. If indicator is present and true the passenger is travelling with an infant that is
                      not occupying a seat
                      Restrictions as to where the passenger may sit on the aircraft may apply due to exit row restrictions or the availbility
                      of oxygen masks.
                  
     * 
     * @return value
     */
    public Boolean getAccompaniedByInfantInd() {
        return accompaniedByInfantInd;
    }

    /** 
     * Set the 'accompaniedByInfantInd' attribute value. If indicator is present and true the passenger is travelling with an infant that is
                      not occupying a seat
                      Restrictions as to where the passenger may sit on the aircraft may apply due to exit row restrictions or the availbility
                      of oxygen masks.
                  
     * 
     * @param accompaniedByInfantInd
     */
    public void setAccompaniedByInfantInd(Boolean accompaniedByInfantInd) {
        this.accompaniedByInfantInd = accompaniedByInfantInd;
    }
}
