
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Agency address restrictions:

 * minimum 1 line, max
 6 ones * each line has a max of 50
 chars

 Client address restrictions:

 * minimum 1 line, max 6 lines * each line has a max of
 50 chars

 Delivery address restrictions

 * minimum 1 line, max 6 lines * each
 line has a max of
 39 chars

 Formats for addresses:

 * add agency address

 W-(agency name)‡(street address)‡(city/state or
 country/zip or postal
 code)
 W-ABC TRAVEL‡123 MAIN ST‡DALLAS TX 75201

 * add agency address
 when more
 than 50 chars

 W-(agency name)‡(street address) W-(address
 line # to
 insert after)/(city/state or country/zip or postal code)
 W-ABC
 TRAVEL‡123 MAIN ST W-2/DALLAS TX 75201

 * insert agency address
 line
 W-(address line # to insert
 after)/(address)
 W-3/LANGENBERHEIMERSTR.
 21

 * delete entire address field W-¤

 * delete
 specific address line

 W-(line #)¤ W-1¤

 * entry customer address into
 remarks for printing
 on
 invoice/itinerary

 5/(name)§5/(address)§5/(city),(state code or
 country
 code if not
 US)(postal code)) 5/T KHOSROVI§5/123 MAIN
 ST§5/DALLAS, TX 76101)

 *
 modify the client address within the remarks
 field

 5(line #)¤/(new
 text) 53¤/65073 DIESBURG

 * add delivery address
 5DL-(address info)
 5DL-DELIVER TO
 KIRK HADEO 5DL-ESTERHAZY #106
 5DL-KOENJI MINAMI 5-4-12
 5DL-SUGINAMI-KU, TOKYO 166 5DL-JAPAN

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumberAndStreet" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateProvince" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddressLines.PNRB" name="AddressLines" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:AddressType.ACD.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressPNRB implements Serializable
{
    private String name;
    private String numberAndStreet;
    private String city;
    private String stateProvince;
    private String country;
    private String postCode;
    private AddressLinesPNRB addressLines;
    private String id;
    private AddressTypeACDPNRB type;
    private OperationTypePNRB op;

    /** 
     * Get the 'Name' element value.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'NumberAndStreet' element value.
     * 
     * @return value
     */
    public String getNumberAndStreet() {
        return numberAndStreet;
    }

    /** 
     * Set the 'NumberAndStreet' element value.
     * 
     * @param numberAndStreet
     */
    public void setNumberAndStreet(String numberAndStreet) {
        this.numberAndStreet = numberAndStreet;
    }

    /** 
     * Get the 'City' element value.
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value.
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'StateProvince' element value.
     * 
     * @return value
     */
    public String getStateProvince() {
        return stateProvince;
    }

    /** 
     * Set the 'StateProvince' element value.
     * 
     * @param stateProvince
     */
    public void setStateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
    }

    /** 
     * Get the 'Country' element value.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'PostCode' element value.
     * 
     * @return value
     */
    public String getPostCode() {
        return postCode;
    }

    /** 
     * Set the 'PostCode' element value.
     * 
     * @param postCode
     */
    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    /** 
     * Get the 'AddressLines' element value.
     * 
     * @return value
     */
    public AddressLinesPNRB getAddressLines() {
        return addressLines;
    }

    /** 
     * Set the 'AddressLines' element value.
     * 
     * @param addressLines
     */
    public void setAddressLines(AddressLinesPNRB addressLines) {
        this.addressLines = addressLines;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. can be A = agency, C = client, D = delivery
     * 
     * @return value
     */
    public AddressTypeACDPNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. can be A = agency, C = client, D = delivery
     * 
     * @param type
     */
    public void setType(AddressTypeACDPNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
