
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirSegmentChoiceGroup">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AirSegmentBundledSell.PNRB" name="AirSegmentBundledSell" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirSegment.PNRB" name="AirSegment" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirSegmentMultiLeg.PNRB" name="AirSegmentMultiLeg" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirSegmentOpen.PNRB" name="AirSegmentOpen" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirSegmentARNK.PNRB" name="AirSegmentARNK" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirSegmentSellFromBSGInventory.PNRB" name="AirSegmentSellFromBSGInventory" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class AirSegmentChoiceGroup implements Serializable
{
    private int choiceSelect = -1;
    private static final int AIR_SEGMENT_BUNDLED_SELL_CHOICE = 0;
    private static final int AIR_SEGMENT_CHOICE = 1;
    private static final int AIR_SEGMENT_MULTI_LEG_CHOICE = 2;
    private static final int AIR_SEGMENT_OPEN_CHOICE = 3;
    private static final int AIR_SEGMENT_ARNK_CHOICE = 4;
    private static final int AIR_SEGMENT_SELL_FROM_BSG_INVENTORY_CHOICE = 5;
    private AirSegmentBundledSellPNRB airSegmentBundledSell;
    private AirSegmentPNRB airSegment;
    private AirSegmentMultiLegPNRB airSegmentMultiLeg;
    private AirSegmentOpenPNRB airSegmentOpen;
    private AirSegmentARNKPNRB airSegmentARNK;
    private AirSegmentSellFromBSGInventoryPNRB airSegmentSellFromBSGInventory;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AirSegmentBundledSell is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentBundledSell() {
        return choiceSelect == AIR_SEGMENT_BUNDLED_SELL_CHOICE;
    }

    /** 
     * Get the 'AirSegmentBundledSell' element value.
     * 
     * @return value
     */
    public AirSegmentBundledSellPNRB getAirSegmentBundledSell() {
        return airSegmentBundledSell;
    }

    /** 
     * Set the 'AirSegmentBundledSell' element value.
     * 
     * @param airSegmentBundledSell
     */
    public void setAirSegmentBundledSell(
            AirSegmentBundledSellPNRB airSegmentBundledSell) {
        setChoiceSelect(AIR_SEGMENT_BUNDLED_SELL_CHOICE);
        this.airSegmentBundledSell = airSegmentBundledSell;
    }

    /** 
     * Check if AirSegment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegment() {
        return choiceSelect == AIR_SEGMENT_CHOICE;
    }

    /** 
     * Get the 'AirSegment' element value.
     * 
     * @return value
     */
    public AirSegmentPNRB getAirSegment() {
        return airSegment;
    }

    /** 
     * Set the 'AirSegment' element value.
     * 
     * @param airSegment
     */
    public void setAirSegment(AirSegmentPNRB airSegment) {
        setChoiceSelect(AIR_SEGMENT_CHOICE);
        this.airSegment = airSegment;
    }

    /** 
     * Check if AirSegmentMultiLeg is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentMultiLeg() {
        return choiceSelect == AIR_SEGMENT_MULTI_LEG_CHOICE;
    }

    /** 
     * Get the 'AirSegmentMultiLeg' element value.
     * 
     * @return value
     */
    public AirSegmentMultiLegPNRB getAirSegmentMultiLeg() {
        return airSegmentMultiLeg;
    }

    /** 
     * Set the 'AirSegmentMultiLeg' element value.
     * 
     * @param airSegmentMultiLeg
     */
    public void setAirSegmentMultiLeg(AirSegmentMultiLegPNRB airSegmentMultiLeg) {
        setChoiceSelect(AIR_SEGMENT_MULTI_LEG_CHOICE);
        this.airSegmentMultiLeg = airSegmentMultiLeg;
    }

    /** 
     * Check if AirSegmentOpen is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentOpen() {
        return choiceSelect == AIR_SEGMENT_OPEN_CHOICE;
    }

    /** 
     * Get the 'AirSegmentOpen' element value.
     * 
     * @return value
     */
    public AirSegmentOpenPNRB getAirSegmentOpen() {
        return airSegmentOpen;
    }

    /** 
     * Set the 'AirSegmentOpen' element value.
     * 
     * @param airSegmentOpen
     */
    public void setAirSegmentOpen(AirSegmentOpenPNRB airSegmentOpen) {
        setChoiceSelect(AIR_SEGMENT_OPEN_CHOICE);
        this.airSegmentOpen = airSegmentOpen;
    }

    /** 
     * Check if AirSegmentARNK is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentARNK() {
        return choiceSelect == AIR_SEGMENT_ARNK_CHOICE;
    }

    /** 
     * Get the 'AirSegmentARNK' element value.
     * 
     * @return value
     */
    public AirSegmentARNKPNRB getAirSegmentARNK() {
        return airSegmentARNK;
    }

    /** 
     * Set the 'AirSegmentARNK' element value.
     * 
     * @param airSegmentARNK
     */
    public void setAirSegmentARNK(AirSegmentARNKPNRB airSegmentARNK) {
        setChoiceSelect(AIR_SEGMENT_ARNK_CHOICE);
        this.airSegmentARNK = airSegmentARNK;
    }

    /** 
     * Check if AirSegmentSellFromBSGInventory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentSellFromBSGInventory() {
        return choiceSelect == AIR_SEGMENT_SELL_FROM_BSG_INVENTORY_CHOICE;
    }

    /** 
     * Get the 'AirSegmentSellFromBSGInventory' element value.
     * 
     * @return value
     */
    public AirSegmentSellFromBSGInventoryPNRB getAirSegmentSellFromBSGInventory() {
        return airSegmentSellFromBSGInventory;
    }

    /** 
     * Set the 'AirSegmentSellFromBSGInventory' element value.
     * 
     * @param airSegmentSellFromBSGInventory
     */
    public void setAirSegmentSellFromBSGInventory(
            AirSegmentSellFromBSGInventoryPNRB airSegmentSellFromBSGInventory) {
        setChoiceSelect(AIR_SEGMENT_SELL_FROM_BSG_INVENTORY_CHOICE);
        this.airSegmentSellFromBSGInventory = airSegmentSellFromBSGInventory;
    }
}
