
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServicesDataGroup.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:group ref="ns:BasicAncillaryServicesDataGroup.PNRB"/>
 *     &lt;xs:group ref="ns:OptionalAncillaryServicesInformationDataGroup.PNRB"/>
 *     &lt;xs:element type="xs:integer" name="StatusIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumberOfItems" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SegmentIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FrequentFlyerTier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RefundFormIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareGuaranteedIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceChargeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AdvancePurchaseIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BookingSource" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TaxIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketingIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeWaiveReason" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FulfillmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AaPayOriginalSeat" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PdcSeat" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EquipmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AaPayOptionalStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FirstTravelDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastTravelDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TTYConfirmationTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="PurchaseTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BrandedFareId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GroupCode"/>
 *     &lt;xs:element type="xs:string" name="TourCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EmdPaperIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatRequestTransactionID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketUsedForEMDPricing" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndicatorType" name="TaxExemption" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="ACSCount" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="NetAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="PriceQuoteDesignator" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceMismatchActionType" name="PriceMismatchAction" minOccurs="0"/>
 *     &lt;xs:element type="ns:AutomatedRebookType" name="AutomatedRebook" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:SegmentOrTravelPortionType" name="Segment" minOccurs="0"/>
 *       &lt;xs:element name="TravelPortions" minOccurs="0">
 *         &lt;!-- Reference to inner class TravelPortions -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class AncillaryServicesDataGroupPNRB implements Serializable
{
    private BasicAncillaryServicesDataGroupPNRB basicAncillaryServicesDataGroupPNRB;
    private OptionalAncillaryServicesInformationDataGroupPNRB optionalAncillaryServicesInformationDataGroupPNRB;
    private BigInteger statusIndicator;
    private String numberOfItems;
    private String actionCode;
    private String segmentIndicator;
    private String frequentFlyerTier;
    private String refundFormIndicator;
    private String fareGuaranteedIndicator;
    private String serviceChargeIndicator;
    private String advancePurchaseIndicator;
    private String bookingSource;
    private String taxIndicator;
    private String ticketingIndicator;
    private String feeWaiveReason;
    private String fulfillmentType;
    private String aaPayOriginalSeat;
    private String pdcSeat;
    private String equipmentType;
    private String aaPayOptionalStatus;
    private String firstTravelDate;
    private String lastTravelDate;
    private Date TTYConfirmationTimestamp;
    private Date purchaseTimestamp;
    private String brandedFareId;
    private String groupCode;
    private String tourCode;
    private String emdPaperIndicator;
    private String seatRequestTransactionID;
    private String ticketUsedForEMDPricing;
    private IndicatorType taxExemption;
    private BigInteger ACSCount;
    private AncillaryPricePNRB netAmount;
    private BigInteger priceQuoteDesignator;
    private PriceMismatchActionType priceMismatchAction;
    private AutomatedRebookType automatedRebook;
    private int choiceSelect = -1;
    private static final int SEGMENT_CHOICE = 0;
    private static final int TRAVEL_PORTIONS_CHOICE = 1;
    private SegmentOrTravelPortionType segment;
    private TravelPortions travelPortions;

    /** 
     * Get the 'BasicAncillaryServicesDataGroup.PNRB' group value.
     * 
     * @return value
     */
    public BasicAncillaryServicesDataGroupPNRB getBasicAncillaryServicesDataGroupPNRB() {
        return basicAncillaryServicesDataGroupPNRB;
    }

    /** 
     * Set the 'BasicAncillaryServicesDataGroup.PNRB' group value.
     * 
     * @param basicAncillaryServicesDataGroupPNRB
     */
    public void setBasicAncillaryServicesDataGroupPNRB(
            BasicAncillaryServicesDataGroupPNRB basicAncillaryServicesDataGroupPNRB) {
        this.basicAncillaryServicesDataGroupPNRB = basicAncillaryServicesDataGroupPNRB;
    }

    /** 
     * Get the 'OptionalAncillaryServicesInformationDataGroup.PNRB' group value.
     * 
     * @return value
     */
    public OptionalAncillaryServicesInformationDataGroupPNRB getOptionalAncillaryServicesInformationDataGroupPNRB() {
        return optionalAncillaryServicesInformationDataGroupPNRB;
    }

    /** 
     * Set the 'OptionalAncillaryServicesInformationDataGroup.PNRB' group value.
     * 
     * @param optionalAncillaryServicesInformationDataGroupPNRB
     */
    public void setOptionalAncillaryServicesInformationDataGroupPNRB(
            OptionalAncillaryServicesInformationDataGroupPNRB optionalAncillaryServicesInformationDataGroupPNRB) {
        this.optionalAncillaryServicesInformationDataGroupPNRB = optionalAncillaryServicesInformationDataGroupPNRB;
    }

    /** 
     * Get the 'StatusIndicator' element value. Status indicator. Example: New, Modified, Cancelled, Item from history,
                          Indirect CANX, NONREINSTATABLE ITM, MODIFIED/NO HISTORY
                      
     * 
     * @return value
     */
    public BigInteger getStatusIndicator() {
        return statusIndicator;
    }

    /** 
     * Set the 'StatusIndicator' element value. Status indicator. Example: New, Modified, Cancelled, Item from history,
                          Indirect CANX, NONREINSTATABLE ITM, MODIFIED/NO HISTORY
                      
     * 
     * @param statusIndicator
     */
    public void setStatusIndicator(BigInteger statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    /** 
     * Get the 'NumberOfItems' element value. Number of items being requested/sold.
     * 
     * @return value
     */
    public String getNumberOfItems() {
        return numberOfItems;
    }

    /** 
     * Set the 'NumberOfItems' element value. Number of items being requested/sold.
     * 
     * @param numberOfItems
     */
    public void setNumberOfItems(String numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    /** 
     * Get the 'ActionCode' element value. Request status. Ex."HD"
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Request status. Ex."HD"
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'SegmentIndicator' element value. Indicates if ancillary service is associated with
                          particular segment or more than one segment. Ex."S"
                      
     * 
     * @return value
     */
    public String getSegmentIndicator() {
        return segmentIndicator;
    }

    /** 
     * Set the 'SegmentIndicator' element value. Indicates if ancillary service is associated with
                          particular segment or more than one segment. Ex."S"
                      
     * 
     * @param segmentIndicator
     */
    public void setSegmentIndicator(String segmentIndicator) {
        this.segmentIndicator = segmentIndicator;
    }

    /** 
     * Get the 'FrequentFlyerTier' element value. FQTV carrier filed tier level.
     * 
     * @return value
     */
    public String getFrequentFlyerTier() {
        return frequentFlyerTier;
    }

    /** 
     * Set the 'FrequentFlyerTier' element value. FQTV carrier filed tier level.
     * 
     * @param frequentFlyerTier
     */
    public void setFrequentFlyerTier(String frequentFlyerTier) {
        this.frequentFlyerTier = frequentFlyerTier;
    }

    /** 
     * Get the 'RefundFormIndicator' element value. Indicates how the fee may be refunded in case refund is required.
                      
     * 
     * @return value
     */
    public String getRefundFormIndicator() {
        return refundFormIndicator;
    }

    /** 
     * Set the 'RefundFormIndicator' element value. Indicates how the fee may be refunded in case refund is required.
                      
     * 
     * @param refundFormIndicator
     */
    public void setRefundFormIndicator(String refundFormIndicator) {
        this.refundFormIndicator = refundFormIndicator;
    }

    /** 
     * Get the 'FareGuaranteedIndicator' element value. Is the fee guaranteed.
     * 
     * @return value
     */
    public String getFareGuaranteedIndicator() {
        return fareGuaranteedIndicator;
    }

    /** 
     * Set the 'FareGuaranteedIndicator' element value. Is the fee guaranteed.
     * 
     * @param fareGuaranteedIndicator
     */
    public void setFareGuaranteedIndicator(String fareGuaranteedIndicator) {
        this.fareGuaranteedIndicator = fareGuaranteedIndicator;
    }

    /** 
     * Get the 'ServiceChargeIndicator' element value. Not Available / No Charge: indicates that the service
                          in this record is not available or that there is no charge for the service.
                      
     * 
     * @return value
     */
    public String getServiceChargeIndicator() {
        return serviceChargeIndicator;
    }

    /** 
     * Set the 'ServiceChargeIndicator' element value. Not Available / No Charge: indicates that the service
                          in this record is not available or that there is no charge for the service.
                      
     * 
     * @param serviceChargeIndicator
     */
    public void setServiceChargeIndicator(String serviceChargeIndicator) {
        this.serviceChargeIndicator = serviceChargeIndicator;
    }

    /** 
     * Get the 'AdvancePurchaseIndicator' element value. Advance Purchase – Ticket Issue: Specifies that the data in the record only
                          applies
                          when the service is purchased at the same time as the passenger’s (travel) ticket is issued.
                      
     * 
     * @return value
     */
    public String getAdvancePurchaseIndicator() {
        return advancePurchaseIndicator;
    }

    /** 
     * Set the 'AdvancePurchaseIndicator' element value. Advance Purchase – Ticket Issue: Specifies that the data in the record only
                          applies
                          when the service is purchased at the same time as the passenger’s (travel) ticket is issued.
                      
     * 
     * @param advancePurchaseIndicator
     */
    public void setAdvancePurchaseIndicator(String advancePurchaseIndicator) {
        this.advancePurchaseIndicator = advancePurchaseIndicator;
    }

    /** 
     * Get the 'BookingSource' element value. indicates source of ancillary service request
                          e.g. 01=TTY GDS,02=TTY OA,03=SSW,04=Kiosk,05/06=Interact, 07=Arline Direct Channel, 08=PRS
                      
     * 
     * @return value
     */
    public String getBookingSource() {
        return bookingSource;
    }

    /** 
     * Set the 'BookingSource' element value. indicates source of ancillary service request
                          e.g. 01=TTY GDS,02=TTY OA,03=SSW,04=Kiosk,05/06=Interact, 07=Arline Direct Channel, 08=PRS
                      
     * 
     * @param bookingSource
     */
    public void setBookingSource(String bookingSource) {
        this.bookingSource = bookingSource;
    }

    /** 
     * Get the 'TaxIndicator' element value. Are there taxes for the service
     * 
     * @return value
     */
    public String getTaxIndicator() {
        return taxIndicator;
    }

    /** 
     * Set the 'TaxIndicator' element value. Are there taxes for the service
     * 
     * @param taxIndicator
     */
    public void setTaxIndicator(String taxIndicator) {
        this.taxIndicator = taxIndicator;
    }

    /** 
     * Get the 'TicketingIndicator' element value. Ticketing indicator.
     * 
     * @return value
     */
    public String getTicketingIndicator() {
        return ticketingIndicator;
    }

    /** 
     * Set the 'TicketingIndicator' element value. Ticketing indicator.
     * 
     * @param ticketingIndicator
     */
    public void setTicketingIndicator(String ticketingIndicator) {
        this.ticketingIndicator = ticketingIndicator;
    }

    /** 
     * Get the 'FeeWaiveReason' element value. Reason for fee waive/override.
     * 
     * @return value
     */
    public String getFeeWaiveReason() {
        return feeWaiveReason;
    }

    /** 
     * Set the 'FeeWaiveReason' element value. Reason for fee waive/override.
     * 
     * @param feeWaiveReason
     */
    public void setFeeWaiveReason(String feeWaiveReason) {
        this.feeWaiveReason = feeWaiveReason;
    }

    /** 
     * Get the 'FulfillmentType' element value. SSR to be sent for fulfillment.
     * 
     * @return value
     */
    public String getFulfillmentType() {
        return fulfillmentType;
    }

    /** 
     * Set the 'FulfillmentType' element value. SSR to be sent for fulfillment.
     * 
     * @param fulfillmentType
     */
    public void setFulfillmentType(String fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
    }

    /** 
     * Get the 'AaPayOriginalSeat' element value. Support for AA Pay for seats - original seat
                          assigned - will not be updated if seat is changed
                      
     * 
     * @return value
     */
    public String getAaPayOriginalSeat() {
        return aaPayOriginalSeat;
    }

    /** 
     * Set the 'AaPayOriginalSeat' element value. Support for AA Pay for seats - original seat
                          assigned - will not be updated if seat is changed
                      
     * 
     * @param aaPayOriginalSeat
     */
    public void setAaPayOriginalSeat(String aaPayOriginalSeat) {
        this.aaPayOriginalSeat = aaPayOriginalSeat;
    }

    /** 
     * Get the 'PdcSeat' element value. Pdc seat number.
     * 
     * @return value
     */
    public String getPdcSeat() {
        return pdcSeat;
    }

    /** 
     * Set the 'PdcSeat' element value. Pdc seat number.
     * 
     * @param pdcSeat
     */
    public void setPdcSeat(String pdcSeat) {
        this.pdcSeat = pdcSeat;
    }

    /** 
     * Get the 'EquipmentType' element value.
     * 
     * @return value
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /** 
     * Set the 'EquipmentType' element value.
     * 
     * @param equipmentType
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    /** 
     * Get the 'AaPayOptionalStatus' element value. Support for AA Pay for seats.
     * 
     * @return value
     */
    public String getAaPayOptionalStatus() {
        return aaPayOptionalStatus;
    }

    /** 
     * Set the 'AaPayOptionalStatus' element value. Support for AA Pay for seats.
     * 
     * @param aaPayOptionalStatus
     */
    public void setAaPayOptionalStatus(String aaPayOptionalStatus) {
        this.aaPayOptionalStatus = aaPayOptionalStatus;
    }

    /** 
     * Get the 'FirstTravelDate' element value. First: specifies the earliest travel date permitted
                          for the service being processed.
                      
     * 
     * @return value
     */
    public String getFirstTravelDate() {
        return firstTravelDate;
    }

    /** 
     * Set the 'FirstTravelDate' element value. First: specifies the earliest travel date permitted
                          for the service being processed.
                      
     * 
     * @param firstTravelDate
     */
    public void setFirstTravelDate(String firstTravelDate) {
        this.firstTravelDate = firstTravelDate;
    }

    /** 
     * Get the 'LastTravelDate' element value. Last: specifies the last travel date
                          permitted for the service being processed.
                      
     * 
     * @return value
     */
    public String getLastTravelDate() {
        return lastTravelDate;
    }

    /** 
     * Set the 'LastTravelDate' element value. Last: specifies the last travel date
                          permitted for the service being processed.
                      
     * 
     * @param lastTravelDate
     */
    public void setLastTravelDate(String lastTravelDate) {
        this.lastTravelDate = lastTravelDate;
    }

    /** 
     * Get the 'TTYConfirmationTimestamp' element value. Time stamp (when AE teletype confirmation received from airline)
                          (PARS date and system time)
                      
     * 
     * @return value
     */
    public Date getTTYConfirmationTimestamp() {
        return TTYConfirmationTimestamp;
    }

    /** 
     * Set the 'TTYConfirmationTimestamp' element value. Time stamp (when AE teletype confirmation received from airline)
                          (PARS date and system time)
                      
     * 
     * @param TTYConfirmationTimestamp
     */
    public void setTTYConfirmationTimestamp(Date TTYConfirmationTimestamp) {
        this.TTYConfirmationTimestamp = TTYConfirmationTimestamp;
    }

    /** 
     * Get the 'PurchaseTimestamp' element value. Purchase by field (PARS date and system time).
     * 
     * @return value
     */
    public Date getPurchaseTimestamp() {
        return purchaseTimestamp;
    }

    /** 
     * Set the 'PurchaseTimestamp' element value. Purchase by field (PARS date and system time).
     * 
     * @param purchaseTimestamp
     */
    public void setPurchaseTimestamp(Date purchaseTimestamp) {
        this.purchaseTimestamp = purchaseTimestamp;
    }

    /** 
     * Get the 'BrandedFareId' element value. Branded fare ID.
     * 
     * @return value
     */
    public String getBrandedFareId() {
        return brandedFareId;
    }

    /** 
     * Set the 'BrandedFareId' element value. Branded fare ID.
     * 
     * @param brandedFareId
     */
    public void setBrandedFareId(String brandedFareId) {
        this.brandedFareId = brandedFareId;
    }

    /** 
     * Get the 'GroupCode' element value. Type of ancillary service as per IATA standard
                          (2 letter code defined in ARIMP manual.
                      
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value. Type of ancillary service as per IATA standard
                          (2 letter code defined in ARIMP manual.
                      
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the 'TourCode' element value. This is the tour code used for matching the OC Fee.
     * 
     * @return value
     */
    public String getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value. This is the tour code used for matching the OC Fee.
     * 
     * @param tourCode
     */
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'EmdPaperIndicator' element value. EMD or paper doc.
     * 
     * @return value
     */
    public String getEmdPaperIndicator() {
        return emdPaperIndicator;
    }

    /** 
     * Set the 'EmdPaperIndicator' element value. EMD or paper doc.
     * 
     * @param emdPaperIndicator
     */
    public void setEmdPaperIndicator(String emdPaperIndicator) {
        this.emdPaperIndicator = emdPaperIndicator;
    }

    /** 
     * Get the 'SeatRequestTransactionID' element value. Transaction ID received from airlines regarding seat request.
     * 
     * @return value
     */
    public String getSeatRequestTransactionID() {
        return seatRequestTransactionID;
    }

    /** 
     * Set the 'SeatRequestTransactionID' element value. Transaction ID received from airlines regarding seat request.
     * 
     * @param seatRequestTransactionID
     */
    public void setSeatRequestTransactionID(String seatRequestTransactionID) {
        this.seatRequestTransactionID = seatRequestTransactionID;
    }

    /** 
     * Get the 'TicketUsedForEMDPricing' element value. Ticket used for EMD pricing.
     * 
     * @return value
     */
    public String getTicketUsedForEMDPricing() {
        return ticketUsedForEMDPricing;
    }

    /** 
     * Set the 'TicketUsedForEMDPricing' element value. Ticket used for EMD pricing.
     * 
     * @param ticketUsedForEMDPricing
     */
    public void setTicketUsedForEMDPricing(String ticketUsedForEMDPricing) {
        this.ticketUsedForEMDPricing = ticketUsedForEMDPricing;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public IndicatorType getTaxExemption() {
        return taxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param taxExemption
     */
    public void setTaxExemption(IndicatorType taxExemption) {
        this.taxExemption = taxExemption;
    }

    /** 
     * Get the 'ACSCount' element value.
     * 
     * @return value
     */
    public BigInteger getACSCount() {
        return ACSCount;
    }

    /** 
     * Set the 'ACSCount' element value.
     * 
     * @param ACSCount
     */
    public void setACSCount(BigInteger ACSCount) {
        this.ACSCount = ACSCount;
    }

    /** 
     * Get the 'NetAmount' element value. Net Remit Payment amount, EX “250”
     * 
     * @return value
     */
    public AncillaryPricePNRB getNetAmount() {
        return netAmount;
    }

    /** 
     * Set the 'NetAmount' element value. Net Remit Payment amount, EX “250”
     * 
     * @param netAmount
     */
    public void setNetAmount(AncillaryPricePNRB netAmount) {
        this.netAmount = netAmount;
    }

    /** 
     * Get the 'PriceQuoteDesignator' element value.
     * 
     * @return value
     */
    public BigInteger getPriceQuoteDesignator() {
        return priceQuoteDesignator;
    }

    /** 
     * Set the 'PriceQuoteDesignator' element value.
     * 
     * @param priceQuoteDesignator
     */
    public void setPriceQuoteDesignator(BigInteger priceQuoteDesignator) {
        this.priceQuoteDesignator = priceQuoteDesignator;
    }

    /** 
     * Get the 'PriceMismatchAction' element value.
     * 
     * @return value
     */
    public PriceMismatchActionType getPriceMismatchAction() {
        return priceMismatchAction;
    }

    /** 
     * Set the 'PriceMismatchAction' element value.
     * 
     * @param priceMismatchAction
     */
    public void setPriceMismatchAction(
            PriceMismatchActionType priceMismatchAction) {
        this.priceMismatchAction = priceMismatchAction;
    }

    /** 
     * Get the 'AutomatedRebook' element value. 
                          0 = Not rebooked
                          1 = Retained, same number of segments, same flight,  journey (RBD change only)
                          2 = Retained, same number of segments, journey
                          3 = Retained, same number of segments, different journey (a board, offpoint, or carrier was
                          changed in one of the associated segments)
                          4 = Retained, different number of segments (so journey has also changed)
                          5 = Retained, Involuntary Exchange
                      
     * 
     * @return value
     */
    public AutomatedRebookType getAutomatedRebook() {
        return automatedRebook;
    }

    /** 
     * Set the 'AutomatedRebook' element value. 
                          0 = Not rebooked
                          1 = Retained, same number of segments, same flight,  journey (RBD change only)
                          2 = Retained, same number of segments, journey
                          3 = Retained, same number of segments, different journey (a board, offpoint, or carrier was
                          changed in one of the associated segments)
                          4 = Retained, different number of segments (so journey has also changed)
                          5 = Retained, Involuntary Exchange
                      
     * 
     * @param automatedRebook
     */
    public void setAutomatedRebook(AutomatedRebookType automatedRebook) {
        this.automatedRebook = automatedRebook;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Segment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSegment() {
        return choiceSelect == SEGMENT_CHOICE;
    }

    /** 
     * Get the 'Segment' element value.
     * 
     * @return value
     */
    public SegmentOrTravelPortionType getSegment() {
        return segment;
    }

    /** 
     * Set the 'Segment' element value.
     * 
     * @param segment
     */
    public void setSegment(SegmentOrTravelPortionType segment) {
        setChoiceSelect(SEGMENT_CHOICE);
        this.segment = segment;
    }

    /** 
     * Check if TravelPortions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelPortions() {
        return choiceSelect == TRAVEL_PORTIONS_CHOICE;
    }

    /** 
     * Get the 'TravelPortions' element value.
     * 
     * @return value
     */
    public TravelPortions getTravelPortions() {
        return travelPortions;
    }

    /** 
     * Set the 'TravelPortions' element value.
     * 
     * @param travelPortions
     */
    public void setTravelPortions(TravelPortions travelPortions) {
        setChoiceSelect(TRAVEL_PORTIONS_CHOICE);
        this.travelPortions = travelPortions;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPortions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:SegmentOrTravelPortionType" name="TravelPortion" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelPortions implements Serializable
    {
        private List<SegmentOrTravelPortionType> travelPortionList = new ArrayList<SegmentOrTravelPortionType>();

        /** 
         * Get the list of 'TravelPortion' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortionType> getTravelPortionList() {
            return travelPortionList;
        }

        /** 
         * Set the list of 'TravelPortion' element items.
         * 
         * @param list
         */
        public void setTravelPortionList(List<SegmentOrTravelPortionType> list) {
            travelPortionList = list;
        }
    }
}
